/*
 * Decompiled with CFR 0.152.
 */
package testsX.detailed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.network.CefCookieManager;
import testsX.detailed.BrowserFrame;
import testsX.detailed.dialog.DownloadDialog;
import testsX.detailed.handler.AppHandler;
import testsX.detailed.handler.ContextMenuHandler;
import testsX.detailed.handler.DragHandler;
import testsX.detailed.handler.JSDialogHandler;
import testsX.detailed.handler.KeyboardHandler;
import testsX.detailed.handler.MessageRouterHandler;
import testsX.detailed.handler.MessageRouterHandlerEx;
import testsX.detailed.handler.RequestHandler;
import testsX.detailed.ui.ControlPanel;
import testsX.detailed.ui.MenuBar;
import testsX.detailed.ui.StatusPanel;

public class MainFrame
extends BrowserFrame {
    private static final long serialVersionUID = -2295538706810864538L;
    private final CefClient client_;
    private String errorMsg_ = "";
    private ControlPanel control_pane_;
    private StatusPanel status_panel_;
    private boolean browserFocus_ = true;

    public static void main(String[] args) {
        if (!CefApp.startup()) {
            System.out.println("Startup initialization failed!");
            return;
        }
        boolean osrEnabledArg = false;
        boolean transparentPaintingEnabledArg = false;
        boolean createImmediately = false;
        for (String arg : args) {
            if ((arg = arg.toLowerCase()).equals("--off-screen-rendering-enabled")) {
                osrEnabledArg = true;
                continue;
            }
            if (arg.equals("--transparent-painting-enabled")) {
                transparentPaintingEnabledArg = true;
                continue;
            }
            if (!arg.equals("--create-immediately")) continue;
            createImmediately = true;
        }
        System.out.println("Offscreen rendering " + (osrEnabledArg ? "enabled" : "disabled"));
        MainFrame frame = new MainFrame(osrEnabledArg, transparentPaintingEnabledArg, createImmediately, args);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public MainFrame(boolean osrEnabled, boolean transparentPaintingEnabled, boolean createImmediately, String[] args) {
        CefApp myApp;
        if (CefApp.getState() != CefApp.CefAppState.INITIALIZED) {
            CefSettings settings = new CefSettings();
            settings.windowless_rendering_enabled = osrEnabled;
            CefSettings cefSettings = settings;
            cefSettings.getClass();
            settings.background_color = new CefSettings.ColorType(cefSettings, 100, 255, 242, 211);
            myApp = CefApp.getInstance((String[])args, (CefSettings)settings);
            CefApp.CefVersion version = myApp.getVersion();
            System.out.println("Using:\n" + version);
            CefApp.addAppHandler((CefAppHandler)new AppHandler(args));
        } else {
            myApp = CefApp.getInstance();
        }
        this.client_ = myApp.createClient();
        DownloadDialog downloadDialog = new DownloadDialog(this);
        this.client_.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(this));
        this.client_.addDownloadHandler((CefDownloadHandler)downloadDialog);
        this.client_.addDragHandler((CefDragHandler)new DragHandler());
        this.client_.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        this.client_.addKeyboardHandler((CefKeyboardHandler)new KeyboardHandler());
        this.client_.addRequestHandler((CefRequestHandler)new RequestHandler(this));
        CefMessageRouter msgRouter = CefMessageRouter.create();
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(), true);
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandlerEx(this.client_), false);
        this.client_.addMessageRouter(msgRouter);
        this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                MainFrame.this.control_pane_.setAddress(browser, url);
            }

            public void onTitleChange(CefBrowser browser, String title) {
                MainFrame.this.setTitle(title);
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                MainFrame.this.status_panel_.setStatusText(value);
            }
        });
        this.client_.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                MainFrame.this.control_pane_.update(browser, isLoading, canGoBack, canGoForward);
                MainFrame.this.status_panel_.setIsInProgress(isLoading);
                if (!isLoading && !MainFrame.this.errorMsg_.isEmpty()) {
                    browser.loadString(MainFrame.this.errorMsg_, MainFrame.this.control_pane_.getAddress());
                    MainFrame.this.errorMsg_ = "";
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED) {
                    MainFrame.this.errorMsg_ = "<html><head>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<title>Error while loading</title>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</head><body>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h1>" + errorCode + "</h1>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<h3>Failed to load " + failedUrl + "</h3>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "<p>" + (errorText == null ? "" : errorText) + "</p>";
                    MainFrame.this.errorMsg_ = MainFrame.this.errorMsg_ + "</body></html>";
                    browser.stopLoad();
                }
            }
        });
        CefBrowser browser = this.client_.createBrowser("http://www.google.com", osrEnabled, transparentPaintingEnabled, null);
        this.setBrowser(browser);
        JPanel contentPanel = this.createContentPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        this.control_pane_.getAddressField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = false;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                MainFrame.this.control_pane_.getAddressField().requestFocus();
            }
        });
        this.client_.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser browser) {
                if (MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                browser.setFocus(true);
            }

            public void onTakeFocus(CefBrowser browser, boolean next) {
                MainFrame.this.browserFocus_ = false;
            }
        });
        if (createImmediately) {
            browser.createImmediately();
        }
        contentPanel.add(this.getBrowser().getUIComponent(), "Center");
        MenuBar menuBar = new MenuBar(this, browser, this.control_pane_, downloadDialog, CefCookieManager.getGlobalManager());
        menuBar.addBookmark("Binding Test", "client://tests/binding_test.html");
        menuBar.addBookmark("Binding Test 2", "client://tests/binding_test2.html");
        menuBar.addBookmark("Download Test", "http://opensource.spotify.com/cefbuilds/index.html");
        menuBar.addBookmark("Login Test (username:pumpkin, password:pie)", "http://www.colostate.edu/~ric/protect/your.html");
        menuBar.addBookmark("Certificate-error Test", "https://www.k2go.de");
        menuBar.addBookmark("Resource-Handler Test", "http://www.foo.bar/");
        menuBar.addBookmark("Resource-Handler Set Error Test", "http://seterror.test/");
        menuBar.addBookmark("Scheme-Handler Test 1: (scheme \"client\")", "client://tests/handler.html");
        menuBar.addBookmark("Scheme-Handler Test 2: (scheme \"search\")", "search://do a barrel roll/");
        menuBar.addBookmark("Spellcheck Test", "client://tests/spellcheck.html");
        menuBar.addBookmark("LocalStorage Test", "client://tests/localstorage.html");
        menuBar.addBookmark("Transparency Test", "client://tests/transparency.html");
        menuBar.addBookmarkSeparator();
        menuBar.addBookmark("javachromiumembedded", "https://bitbucket.org/chromiumembedded/java-cef");
        menuBar.addBookmark("chromiumembedded", "https://bitbucket.org/chromiumembedded/cef");
        this.setJMenuBar(menuBar);
    }

    private JPanel createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.control_pane_ = new ControlPanel(this.getBrowser());
        this.status_panel_ = new StatusPanel();
        contentPanel.add((Component)this.control_pane_, "North");
        contentPanel.add((Component)this.status_panel_, "South");
        return contentPanel;
    }
}

