/*
 * Decompiled with CFR 0.152.
 */
package testsX.simple;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -5570653778104813836L;
    private final JTextField address_;
    private final CefApp cefApp_;
    private final CefClient client_;
    private final CefBrowser browser_;
    private final Component browerUI_;
    private boolean browserFocus_ = true;

    private MainFrame(String startURL, boolean useOSR, boolean isTransparent) {
        CefApp.addAppHandler((CefAppHandler)new CefAppHandlerAdapter(null){

            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.TERMINATED) {
                    System.exit(0);
                }
            }
        });
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = useOSR;
        this.cefApp_ = CefApp.getInstance((CefSettings)settings);
        this.client_ = this.cefApp_.createClient();
        this.browser_ = this.client_.createBrowser(startURL, useOSR, isTransparent);
        this.browerUI_ = this.browser_.getUIComponent();
        this.address_ = new JTextField(startURL, 100);
        this.address_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.browser_.loadURL("about:blank");
                MainFrame.this.browser_.loadString("<html>ciao</html>", "code_url");
            }
        });
        this.client_.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                MainFrame.this.address_.setText(url);
            }
        });
        this.address_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = false;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                MainFrame.this.address_.requestFocus();
            }
        });
        this.client_.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser browser) {
                if (MainFrame.this.browserFocus_) {
                    return;
                }
                MainFrame.this.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                browser.setFocus(true);
            }

            public void onTakeFocus(CefBrowser browser, boolean next) {
                MainFrame.this.browserFocus_ = false;
            }
        });
        this.getContentPane().add((Component)this.address_, "North");
        this.getContentPane().add(this.browerUI_, "Center");
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
        this.browser_.loadURL("about:blank");
        this.browser_.loadString("<html>ciao</html>", "code_url");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CefApp.getInstance().dispose();
                MainFrame.this.dispose();
            }
        });
    }

    public static void main(String[] args) {
        if (!CefApp.startup()) {
            System.out.println("Startup initialization failed!");
            return;
        }
        boolean useOsr = false;
        new MainFrame("http://server.invoicex.it/tinymce/", useOsr, false);
    }
}

