/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import tnxbeans.tnxDbGrid;

class CurrencyEditor
extends DefaultCellEditor {
    JFormattedTextField ftf;
    NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;
    tnxDbGrid grid = null;

    public CurrencyEditor(tnxDbGrid grid) {
        super(new JFormattedTextField());
        this.grid = grid;
        this.ftf = (JFormattedTextField)this.getComponent();
        this.integerFormat = NumberFormat.getInstance(Locale.ITALIAN);
        this.integerFormat.setMaximumFractionDigits(5);
        this.integerFormat.setMinimumFractionDigits(2);
        NumberFormatter intFormatter = new NumberFormatter(this.integerFormat);
        intFormatter.setFormat(this.integerFormat);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(intFormatter));
        this.ftf.setValue(new Double(0.0));
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFocusLostBehavior(3);
        this.ftf.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.ftf.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CurrencyEditor.this.ftf.isEditValid()) {
                    CurrencyEditor.this.ftf.postActionEvent();
                } else {
                    try {
                        CurrencyEditor.this.ftf.commitEdit();
                        CurrencyEditor.this.ftf.postActionEvent();
                        CurrencyEditor.this.grid.saveDataEntry(CurrencyEditor.this.grid.getSelectedRow());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (tnxDbGrid.getDoubleEng(String.valueOf(value)) > 0.0) {
            Double d = new Double(tnxDbGrid.getDoubleEng(String.valueOf(value)));
            ftf.setValue(d);
        } else {
            ftf.setValue(new Double(0.0));
        }
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Number) {
            return o;
        }
        if (this.DEBUG) {
            System.out.println("getCellEditorValue: o isn't a Number");
        }
        try {
            return this.integerFormat.parseObject(o.toString());
        }
        catch (ParseException exc) {
            System.err.println("getCellEditorValue: can't parse o: " + o);
            return null;
        }
    }
}

