/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import tnxbeans.SortButtonRenderer2;
import tnxbeans.SortableTableModel;

public class HeaderListener2
extends MouseAdapter {
    public JTableHeader header;
    public SortButtonRenderer2 renderer;
    public int oldSortedColumn = -1;
    public boolean oldIsAscent = false;

    public HeaderListener2(JTableHeader header, SortButtonRenderer2 renderer) {
        this.header = header;
        this.renderer = renderer;
    }

    public void resort() {
        if (this.oldSortedColumn >= 0) {
            System.out.println("resort: column:" + this.oldSortedColumn);
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            ((SortableTableModel)this.header.getTable().getModel()).sortByColumn(this.oldSortedColumn, this.oldIsAscent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int col = this.header.columnAtPoint(e.getPoint());
            boolean isAscent = 1 == this.renderer.getState(col);
            this.sort(col, isAscent);
        }
    }

    public void sort(int col, boolean isAscent) {
        int sortCol;
        this.oldSortedColumn = sortCol = this.header.getTable().convertColumnIndexToModel(col);
        this.renderer.setPressedColumn(col);
        this.renderer.setSelectedColumn(col);
        if (this.header.getTable().isEditing()) {
            this.header.getTable().getCellEditor().stopCellEditing();
        }
        this.oldIsAscent = isAscent;
        System.out.println("resort: column:" + sortCol);
        ((SortableTableModel)this.header.getTable().getModel()).sortByColumn(sortCol, isAscent);
        this.header.repaint();
    }
}

