/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.util.Date;
import tnxbeans.SortableTableModel;

public class TableSorter {
    SortableTableModel model;
    boolean ignoreNulls = false;
    Integer column;
    Boolean ascent;

    public TableSorter(SortableTableModel model) {
        this.model = model;
    }

    public TableSorter(SortableTableModel model, boolean ignoreNulls) {
        this.model = model;
        this.ignoreNulls = ignoreNulls;
    }

    public void sort(int column, boolean isAscent) {
        this.column = column;
        this.ascent = isAscent;
        int n = this.model.getRowCount();
        int[] indexes = this.model.getIndexes();
        for (int i = 0; i < n - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < n; ++j) {
                if (isAscent) {
                    if (this.compare(column, j, k, isAscent) >= 0) continue;
                    k = j;
                    continue;
                }
                if (this.compare(column, j, k, isAscent) <= 0) continue;
                k = j;
            }
            int tmp = indexes[i];
            indexes[i] = indexes[k];
            indexes[k] = tmp;
        }
    }

    public int compare(int column, int row1, int row2, boolean isAscent) {
        Object o1 = this.model.getValueAt(row1, column);
        Object o2 = this.model.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            if (isAscent && this.ignoreNulls) {
                return 1;
            }
            return -1;
        }
        if (o2 == null) {
            if (isAscent && this.ignoreNulls) {
                return -1;
            }
            return 1;
        }
        try {
            Class type = this.model.getColumnClassSql(column);
            if (type.getSuperclass() == Number.class) {
                return this.compare((Number)o1, (Number)o2);
            }
            if (type == Long.class) {
                return this.compare((Number)o1, (Number)o2);
            }
            if (type == Double.class) {
                return this.compare((Double)o1, (Double)o2);
            }
            if (type == String.class) {
                return ((String)o1).compareTo((String)o2);
            }
            if (type == Date.class) {
                return this.compare((Date)o1, (Date)o2);
            }
            if (type == java.sql.Date.class) {
                return this.compare((Date)o1, (Date)o2);
            }
            if (type == Boolean.class) {
                return this.compare((Boolean)o1, (Boolean)o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
        catch (Exception e) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    public int compare(Number o1, Number o2) {
        double n2;
        double n1 = o1.doubleValue();
        if (n1 < (n2 = o2.doubleValue())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public int compare(Date o1, Date o2) {
        long n2;
        long n1 = o1.getTime();
        if (n1 < (n2 = o2.getTime())) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }
}

