/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import it.tnx.invoicex.InvoicexUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tnxbeans.BasicField;
import tnxbeans.tnxDbPanel;
import tnxbeans.util;

public class tnxMemoFieldLang
extends JPanel
implements BasicField {
    private List<String> lang = null;
    private List<JScrollPane> scroll;
    private List<JTextArea> textarea;
    private Map<String, JTextArea> lang_area = null;
    private List<JButton> buttons;
    public String dbNomeCampo;
    public String dbTipoCampo;
    public boolean dbRiempire = true;
    public boolean dbSalvare = true;
    private boolean dbModificato = false;
    int margin = 1;
    tnxDbPanel parentPanel = null;

    public tnxMemoFieldLang() {
        this.initComponents();
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(50, 20);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(50, 20);
            }

            @Override
            public void layoutContainer(Container parent) {
                tnxMemoFieldLang.this.layoutComps();
            }
        });
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public List<String> getLang() {
        return this.lang;
    }

    public void setLang(List<String> lang) {
        this.lang = lang;
        this.removeAll();
        this.setTextarea(new ArrayList<JTextArea>());
        this.setScroll(new ArrayList<JScrollPane>());
        this.setLang_area(new HashMap<String, JTextArea>());
        for (String l : lang) {
            JScrollPane s = new JScrollPane();
            s.setHorizontalScrollBarPolicy(31);
            s.setVerticalScrollBarPolicy(20);
            LangJTextArea a = new LangJTextArea();
            a.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    for (FocusListener f : tnxMemoFieldLang.this.getFocusListeners()) {
                        f.focusGained(e);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    for (FocusListener f : tnxMemoFieldLang.this.getFocusListeners()) {
                        f.focusLost(e);
                    }
                }
            });
            a.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.change();
                }

                public void change() {
                    tnxMemoFieldLang.this.setDbModificato(true);
                    util.checkModificati(tnxMemoFieldLang.this);
                }
            });
            a.lang = l;
            s.setViewportView(a);
            this.getScroll().add(s);
            this.getTextarea().add(a);
            this.add(s);
            this.getLang_area().put(l, a);
        }
        this.layoutComps();
    }

    private void layoutComps() {
        if (this.getLang() != null) {
            int langs = this.getLang().size();
            int w = this.getWidth();
            int h = this.getHeight();
            int ws = w / langs;
            int i = 0;
            for (String l : this.getLang()) {
                JScrollPane s = this.getScroll().get(i);
                if (i == this.getLang().size() - 1) {
                    s.setBounds(ws * i + this.margin, this.margin, ws - this.margin * 2, h - this.margin * 2);
                } else {
                    s.setBounds(ws * i + this.margin, this.margin, ws - this.margin, h - this.margin * 2);
                }
                ++i;
            }
        }
    }

    public Map<String, JTextArea> getLang_area() {
        return this.lang_area;
    }

    public void setLang_area(Map<String, JTextArea> lang_area) {
        this.lang_area = lang_area;
    }

    @Override
    public tnxDbPanel getParentPanel() {
        return this.parentPanel;
    }

    @Override
    public void setParentPanel(tnxDbPanel parent) {
        this.parentPanel = parent;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout(2, 2));
        tnxMemoFieldLang t = new tnxMemoFieldLang();
        t.setBorder(new LineBorder(Color.red));
        f.getContentPane().add((Component)t, "Center");
        t.setLang(Arrays.asList("it", "en", "fr"));
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public List<JScrollPane> getScroll() {
        return this.scroll;
    }

    public void setScroll(List<JScrollPane> scroll) {
        this.scroll = scroll;
    }

    public List<JTextArea> getTextarea() {
        return this.textarea;
    }

    public void setTextarea(List<JTextArea> textarea) {
        this.textarea = textarea;
    }

    public List<JButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<JButton> buttons) {
        this.buttons = buttons;
    }

    @Override
    public String getDbNomeCampo() {
        return this.dbNomeCampo;
    }

    @Override
    public void setDbNomeCampo(String dbNomeCampo) {
        this.dbNomeCampo = dbNomeCampo;
    }

    @Override
    public String getDbTipoCampo() {
        return this.dbTipoCampo;
    }

    @Override
    public void setDbTipoCampo(String dbTipoCampo) {
        this.dbTipoCampo = dbTipoCampo;
    }

    @Override
    public boolean isDbRiempire() {
        return this.dbRiempire;
    }

    @Override
    public void setDbRiempire(boolean dbRiempire) {
        this.dbRiempire = dbRiempire;
    }

    @Override
    public boolean isDbSalvare() {
        return this.dbSalvare;
    }

    @Override
    public void setDbSalvare(boolean dbSalvare) {
        this.dbSalvare = dbSalvare;
    }

    @Override
    public boolean isDbModificato() {
        return this.dbModificato;
    }

    @Override
    public void setDbModificato(boolean dbModificato) {
        if (!InvoicexUtil.isDbPanelRefreshing(this)) {
            this.dbModificato = dbModificato;
        }
    }

    public String getText(String lang) {
        return this.getLang_area().get(lang).getText();
    }

    public void setText(String text) {
        for (String l : this.getLang()) {
            JTextArea a = this.getLang_area().get(l);
            a.setText(text);
        }
    }

    public void setText(String lang, String text) {
        JTextArea a = this.getLang_area().get(lang);
        a.setText(text);
    }

    public HashMap<String, String> getTextLang() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String l : this.getLang()) {
            JTextArea a = this.getLang_area().get(l);
            ret.put(l, a.getText());
        }
        return ret;
    }

    public static class LangJTextArea
    extends JTextArea {
        public String lang = null;
        Locale locsel = null;
        String locsel_country = null;

        public LangJTextArea() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Color old_color = g2.getColor();
            Font old_font = g2.getFont();
            Composite old_comp = g2.getComposite();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int xrif = (int)(((JViewport)this.getParent()).getViewRect().getWidth() + ((JViewport)this.getParent()).getViewRect().getX());
            int yrif = (int)(((JViewport)this.getParent()).getViewRect().getHeight() + ((JViewport)this.getParent()).getViewRect().getY());
            if (this.locsel == null) {
                String lang2 = this.lang;
                if (lang2.equalsIgnoreCase("en")) {
                    this.locsel_country = "Great Britain";
                } else {
                    this.locsel = new Locale(this.lang.toLowerCase(), lang2.toUpperCase());
                    System.out.println(this.locsel);
                    this.locsel_country = this.locsel.getDisplayCountry(Locale.ENGLISH);
                    System.out.println(this.locsel_country);
                }
            }
            g2.setColor(new Color(old_color.getRed(), old_color.getGreen(), old_color.getBlue(), 50));
            g2.setFont(old_font.deriveFont(10.0f));
            g2.drawString(this.lang.toUpperCase(), xrif - 45, yrif - 10);
            try {
                ImageIcon flag = new ImageIcon(this.getClass().getResource("/flags/24/" + this.locsel_country + ".png"));
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2.drawImage(flag.getImage(), xrif - 30, yrif - 26, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            g2.setColor(old_color);
            g2.setFont(old_font);
            g2.setComposite(old_comp);
            super.paintComponent(g2);
        }
    }
}

