<?
require './php/Mustache/Autoloader.php';
Mustache_Autoloader::register();

$db = java_class("it.tnx.Db");
$dbu = java_class("it.tnx.commons.dbu");

$m = new Mustache_Engine;
$tpl = file_get_contents("php/templates/regiva.html");
$tpl_header = file_get_contents("php/templates/regiva_header.html");
$tpl_footer = file_get_contents("php/templates/regiva_footer.html");

$data[dal] = $_SERVER[dal];
$data[al] = $_SERVER[al];
$tipo = $_SERVER["tipo"];

$altri_filtri = "";
if ($_SERVER["filtro_cliente"]) {
	$altri_filtri = "cliente: " . $_SERVER["filtro_cliente"];
}
if ($_SERVER["filtro_articolo"]) {
	$altri_filtri .= ($altri_filtri ? ", " : "") . "articolo: " . $_SERVER["filtro_articolo"];
}
if ($_SERVER["filtro_agente"]) {
	$altri_filtri .= ($altri_filtri ? ", " : "") . "agente: " . $_SERVER["filtro_agente"];
}
if ($_SERVER["filtro_paese"]) {
	$altri_filtri .= ($altri_filtri ? ", " : "") . "paese: " . $_SERVER["filtro_paese"];
}
$data["altri_filtri"] = $altri_filtri;
$data["azienda"] = $_SERVER["azienda"];
$data["dal-ita"] = $_SERVER["dal-ita"];
$data["al-ita"] = $_SERVER["al-ita"];
$data["tipo"] = $_SERVER["tipo"];

if ($_SERVER["data"] == "1") {
	$campodata = "data_doc";
	$orderby = " order by data_doc, id";
} else {
	$campodata = "data";
	$orderby = " order by data, serie, numero";
}

//acquisti

$sql = "select 
tf.id
, tf.serie, tf.numero, tf.anno, tf.data, tf.numero_doc, tf.serie_doc, tf.data_doc, tf.fornitore, tf.tipo_fattura
, tf.importo, cf.ragione_sociale, iva.codice_iva, iva.perc_deducibile, iva.imponibile, iva.iva
, civa.descrizione as descrizione_iva
from test_fatt_acquisto tf
left join test_fatt_acquisto_iva_ded iva on tf.id = iva.id_padre
left join clie_forn cf on tf.fornitore = cf.codice
left join codici_iva civa on iva.codice_iva = civa.codice
where $campodata >= '$_SERVER[dal]' and $campodata <= '$_SERVER[al]'
$orderby";


$list = $dbu->getListMap($db->getConn(), $sql);
calcola_indetraibile($list);

$oldid = null;
$i = 0;
$tot_imp = (double)0;
$tot_iva = (double)0;
$tot_ind = (double)0;

foreach($list as $k=>$v) {
	$list_tot[$v["codice_iva"]]["descrizione"] = $v["descrizione_iva"];
	$list_tot[$v["codice_iva"]]["imponibile"] += (double)$v["imponibile"];
	$list_tot[$v["codice_iva"]]["iva"] += (double)$v["iva"];
	$list_tot[$v["codice_iva"]]["iva_detraibile"] += (double)$v["iva_detraibile"];
	$list_tot[$v["codice_iva"]]["iva_indetraibile"] += (double)$v["iva_indetraibile"];
	
	if (($v["id"] != $oldid && $i != 0)) {
		add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);
		$tot_imp = (double)0;
		$tot_iva = (double)0;
		$tot_det = (double)0;
		$tot_ind = (double)0;
	}
	
	$tot_imp += (double)$v["imponibile"];
	$tot_iva += (double)$v["iva"];
	$tot_det += (double)$v["iva_detraibile"];
	$tot_ind += (double)$v["iva_indetraibile"];
	
	if ($v["id"] == $oldid) {
		$v["tipo_doc"] = "";
		$v["serie"] = "";
		$v["numero"] = "";
		$v["data"] = "";
		$v["serie_doc"] = "";
		$v["numero_doc"] = "";
		$v["data_doc"] = "";
		$v["ragione_sociale"] = "";
		$list[$i-1]["style_cella"] = "border-bottom: 0;";
	} else {
	}
	
	$oldid = $v["id"];
	$i++;
}

add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);

formatta_array($list, "data", "data_ita");
formatta_array($list, "data_doc", "data_ita");
formatta_array($list, "importo", "euro_ita", "importo_f");
formatta_array($list, "imponibile", "euro_ita", "imponibile_f");
formatta_array($list, "iva", "euro_ita", "iva_f");
formatta_array($list, "iva_detraibile", "euro_ita", "iva_detraibile_f");
formatta_array($list, "iva_indetraibile", "euro_ita", "iva_indetraibile_f");

$data[fatture_acquisto] = $list;

foreach($list as $k=>$v) {
	if (($v["id"] != $oldid && $i != 0)) {
		add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);
		$tot_imp = 0;
	}
}


foreach($list_tot as $k=>$v) {
	$v["codice_iva"] = $k . " - " . $v["descrizione"];
	$list_tot2[] = $v;
}

$tot2_imponibile = 0;
$tot2_iva = 0;
$tot2_ind = 0;
$tot2_det = 0;
foreach($list_tot2 as $k=>$v) {
	$list_tot2[$k]["tot_imponibile_f"] = formatta($v["imponibile"], "euro_ita");
	$list_tot2[$k]["tot_iva_f"] = formatta($v["iva"], "euro_ita");
	$list_tot2[$k]["tot_iva_detraibile_f"] = formatta($v["iva_detraibile"], "euro_ita");
	$list_tot2[$k]["tot_iva_indetraibile_f"] = formatta($v["iva_indetraibile"], "euro_ita");
	
	$tot2_imponibile += $v["imponibile"];
	$tot2_iva += $v["iva"];
	$tot2_ind += $v["iva_indetraibile"];
	$tot2_det += $v["iva_detraibile"];
}

$data[totali_fatture_acquisto] = $list_tot2;
$data[totali_fatture_acquisto_tot2_imponibile] = formatta($tot2_imponibile, "euro_ita");
$data[totali_fatture_acquisto_tot2_iva] = formatta($tot2_iva, "euro_ita");
$data[totali_fatture_acquisto_tot2_ind] = formatta($tot2_ind, "euro_ita");
$data[totali_fatture_acquisto_tot2_det] = formatta($tot2_det, "euro_ita");

$totale_iva_acquisti = $tot2_det;


//vendita

$sql = "select 
t.id
, t.serie, t.numero, t.anno, t.data, t.cliente, t.tipo_fattura, tfx.split_payment
, t.totale, cf.ragione_sociale, iva.codice_iva, iva.imponibile, iva.iva
, civa.descrizione as descrizione_iva
from test_fatt t
left join tipi_fatture tf on t.tipo_fattura = tf.tipo
left join test_fatt_xmlpa tfx on t.id = tfx.id_fattura
left join test_fatt_iva iva on t.id = iva.id_padre
left join clie_forn cf on t.cliente = cf.codice
left join codici_iva civa on iva.codice_iva = civa.codice
where data >= '$_SERVER[dal]' and data <= '$_SERVER[al]'
and tf.descrizione_breve != 'FP'
and t.tipo_fattura != 7
order by data, serie, numero";

$list = $dbu->getListMap($db->getConn(), $sql);

$oldid = null;
$i = 0;
$tot_imp = (double)0;
$tot_iva = (double)0;

$iva_split = 0;
foreach($list as $k=>$v) {
	$segno = 1;
	$v["tipo_doc"] = "Fattura";
	if ($v["tipo_fattura"] == 3) {
		$segno = -1;
		$v["tipo_doc"] = "Nota di credito";
	}
	$v["imponibile"] *= $segno; 
	$v["iva"] *= $segno;
	
	if ($v["split_payment"] == "S") {
		$v["codice_iva"] .= " - Split Payment";
		$iva_split += $v["iva"];
	}
}

unset($list_tot);

foreach($list as $k=>$v) {
	$key_iva = $v["codice_iva"];
	$list_tot[$key_iva]["descrizione"] = $v["descrizione_iva"];
	$list_tot[$key_iva]["imponibile"] += (double)$v["imponibile"];
	$list_tot[$key_iva]["iva"] += (double)$v["iva"];
	
	if (($v["id"] != $oldid && $i != 0)) {
		add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);
		$tot_imp = (double)0;
		$tot_iva = (double)0;
	}
	
	$tot_imp += (double)$v["imponibile"];
	$tot_iva += (double)$v["iva"];
	
	if ($v["id"] == $oldid) {
		$v["tipo_doc"] = "";
		$v["serie"] = "";
		$v["numero"] = "";
		$v["data"] = "";
		$v["ragione_sociale"] = "";
		$list[$i-1]["style_cella"] = "border-bottom: 0;";
	} else {
	}
	
	$oldid = $v["id"];
	$i++;
}

add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);

formatta_array($list, "data", "data_ita");
formatta_array($list, "data_doc", "data_ita");
formatta_array($list, "importo", "euro_ita", "importo_f");
formatta_array($list, "imponibile", "euro_ita", "imponibile_f");
formatta_array($list, "iva", "euro_ita", "iva_f");

$data[fatture_vendita] = $list;

foreach($list as $k=>$v) {
	if (($v["id"] != $oldid && $i != 0)) {
		add_totale(&$list, &$i, $tot_imp, $tot_iva, $tot_det, $tot_ind);
		$tot_imp = 0;
	}
}


foreach($list_tot as $k=>$v) {
	$v["codice_iva"] = $k . " - " . $v["descrizione"];
	$list_tot2v[] = $v;
}

$tot2_imponibile = 0;
$tot2_iva = 0;
foreach($list_tot2v as $k=>$v) {
	$list_tot2v[$k]["tot_imponibile_f"] = formatta($v["imponibile"], "euro_ita");
	$list_tot2v[$k]["tot_iva_f"] = formatta($v["iva"], "euro_ita");
	
	$tot2_imponibile += $v["imponibile"];
	$tot2_iva += $v["iva"];
}

$data[totali_fatture_vendita] = $list_tot2v;
$data[totali_fatture_vendita_tot2_imponibile] = formatta($tot2_imponibile, "euro_ita");
$data[totali_fatture_vendita_tot2_iva] = formatta($tot2_iva, "euro_ita");
$totale_iva_vendite = $tot2_iva;




$data[liquidazione_iva_vendite] = formatta($totale_iva_vendite, "euro_ita");
$data[liquidazione_iva_acquisti] = formatta($totale_iva_acquisti, "euro_ita");

$totale_iva_vendite = $totale_iva_vendite - $iva_split;

if ($totale_iva_vendite > $totale_iva_acquisti) {
	$come = "Totale Iva a debito";
	$come_debito = $totale_iva_vendite - $totale_iva_acquisti;
	$data[liquidazione_come_debito] = formatta($come_debito, "euro_ita");
} else {
	$come = "Totale Iva a credito";
	$come_credito = $totale_iva_acquisti - $totale_iva_vendite;
	$data[liquidazione_come_credito] = formatta($come_credito, "euro_ita");
}
$data[liquidazione_come] = $come;

$credito_prec = 0;
if ($_SERVER["ivaACreditoPeriodoPrec"] != 0) {
	$data[liquidazione_come_credito_prec] = "Iva a credito da periodo precedente";
	$credito_prec = floatval($_SERVER["ivaACreditoPeriodoPrec"]);
	$data[liquidazione_come_credito_prec_credito] = formatta($credito_prec, "euro_ita");
}


if ($totale_iva_vendite > $totale_iva_acquisti) {
	if ($come_debito > $credito_prec) {
		$debito = true;
		$debito_finale = $come_debito - $credito_prec;
	} else {
		$debito = false;
		$credito_finale = $credito_prec - $come_debito;
	}
} else {
	$debito = false;
	$credito_finale = $credito_prec + $come_credito;
}

if ($debito) {
	$data[liquidazione_totale_imposta_come] = "Imposta da versare";
	$data[liquidazione_totale_imposta_come_debito] = formatta($debito_finale, "euro_ita");
} else {
	$data[liquidazione_totale_imposta_come] = "Imposta a credito";
	$data[liquidazione_totale_imposta_come_credito] = formatta($credito_finale, "euro_ita");
}
if ($iva_split != 0) {
	$data[liquidazione_iva_vendite_iva_split] = formatta(-$iva_split, "euro_ita");
} else {
	$data[liquidazione_iva_vendite_iva_split] = "";
}






echo $m->render($tpl, $data);























function add_totale($list, $i, $tot_imp, $tot_iva, $tot_det, $tot_ind) {
	$tot["ragione_sociale"] = "Totale";
	$tot["imponibile"] = $tot_imp;
	$tot["imponibile_f"] = formatta($tot_imp, "euro_ita");
	$tot["iva"] = $tot_iva;
	$tot["iva_f"] = formatta($tot_iva, "euro_ita");
	$tot["iva_detraibile"] = $tot_det;
	$tot["iva_detraibile_f"] = formatta($tot_det, "euro_ita");
	$tot["iva_indetraibile"] = $tot_ind;
	$tot["iva_indetraibile_f"] = formatta($tot_ind, "euro_ita");
	$tot["style_cella"] = "text-align: right; font-weight: bold;";
	$list2[] = $tot;
	array_splice($list, $i, 0, $list2);	
	$list[$i-1]["style_cella"] .= "border-bottom: 1px dotted #e0e0e0;";
	$i++;
}

function calcola_indetraibile($list) {
	foreach($list as $k=>$v) {
		$v["iva_detraibile"] = $v["iva"] / 100 * $v["perc_deducibile"];
		$v["iva_indetraibile"] = $v["iva"] - $v["iva_detraibile"];
		
		$segno = 1;
		$v["tipo_doc"] = "Fattura";
		if ($v["tipo_fattura"] == 9) {
			$segno = -1;
			$v["tipo_doc"] = "Nota di credito";
		}
		$v["imponibile"] *= $segno; 
		$v["iva"] *= $segno; 
		$v["iva_detraibile"] *= $segno; 
		$v["iva_indetraibile"] *= $segno; 
	}
}

function filtra($list, $campo) {
	$group = array();
	foreach($list as $k=>$v) {
		//echo print_r($v,true)."<br>----<br>";
		$vcampo = $v[$campo];
		if (!array_key_exists($vcampo, $group)) {
			$group[$vcampo] = array();
		}
		$group[$vcampo][] = $v;
	}
	return $group;
}

function formatta($valore, $formato) {
	if ($formato == "data_ita") {
		//2015-04-01
		//0123456789
		if ($valore == "") return "";
		$ret = substr($valore, 8, 2) . "/" . substr($valore, 5, 2) . "/" . substr($valore, 0, 4);
	} else if ($formato == "euro_ita") {
		$ret = number_format((double)$valore, 2, ",", ".");
		if ($ret == "-0,00") {
			$ret = "0,00";
		}
	} else if ($formato == "euro_ita_0vuoto") {
		if ((double)$valore == 0) {
			$ret = "";
		} else {
			$ret = number_format((double)$valore, 2, ",", ".");		
		}
	} else if ($formato == "numero_ita") {
		$ret = number_format((double)$valore, 2, ",", ".");		
		if (substr($ret, -1) == "0") $ret = substr($ret, 0, strlen($ret) - 1);
		if (substr($ret, -1) == "0") $ret = substr($ret, 0, strlen($ret) - 2);
	}
	return $ret;
}

function formatta_array($arr, $campo, $formato, $campo_dest = null) {
	foreach($arr as $k=>$v) {
		$tmp = $v[$campo];
		if (!$campo_dest) $campo_dest = $campo;
		$v[$campo_dest] = formatta($tmp, $formato);
	}
}

function totale($list, $campo) {
	$ret = 0;
	foreach($list as $k=>$v) {
		$ret += (double)$v[$campo];
	}
	return $ret;
}
?>