/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.domain.DJQuery;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.constants.Page;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJJRDesignHelper {
    private static final Log log = LogFactory.getLog(DJJRDesignHelper.class);

    public static DynamicJasperDesign getNewDesign(DynamicReport dr) {
        log.info((Object)"obtaining DynamicJasperDesign instance");
        DynamicJasperDesign des = new DynamicJasperDesign();
        DynamicReportOptions options = dr.getOptions();
        Page page = options.getPage();
        des.setPrintOrder((byte)1);
        byte orientation = page.isOrientationPortrait() ? (byte)1 : 2;
        des.setOrientation(orientation);
        des.setPageWidth(page.getWidth());
        des.setPageHeight(page.getHeight());
        des.setColumnWidth(options.getColumnWidth());
        des.setColumnSpacing(options.getColumnSpace());
        des.setLeftMargin(options.getLeftMargin());
        des.setRightMargin(options.getRightMargin());
        des.setTopMargin(options.getTopMargin());
        des.setBottomMargin(options.getBottomMargin());
        if (dr.getLanguage() != null) {
            des.setLanguage(dr.getLanguage().toLowerCase());
        }
        des.setDetail((JRBand)new JRDesignBand());
        des.setPageHeader((JRBand)new JRDesignBand());
        des.setPageFooter((JRBand)new JRDesignBand());
        des.setSummary((JRBand)new JRDesignBand());
        DJJRDesignHelper.populateBehavioralOptions(dr, des);
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            des.setQuery(query);
        }
        for (String name : dr.getProperties().keySet()) {
            des.setProperty(name, (String)dr.getProperties().get(name));
        }
        des.setName(dr.getReportName() != null ? dr.getReportName() : "DJR");
        return des;
    }

    protected static void populateBehavioralOptions(DynamicReport dr, DynamicJasperDesign des) {
        DynamicReportOptions options = dr.getOptions();
        des.setColumnCount(options.getColumnsPerPage());
        des.setWhenNoDataType(dr.getWhenNoDataType());
        des.setWhenResourceMissingType(dr.getWhenResourceMissing());
        des.setTitleNewPage(options.isTitleNewPage());
        des.setIgnorePagination(options.isIgnorePagination());
        des.getDetail().setSplitAllowed(dr.isAllowDetailSplit());
        des.setSummaryNewPage(options.isSummaryNewPage());
    }

    protected static JRDesignQuery getJRDesignQuery(DynamicReport dr) {
        JRDesignQuery query = new JRDesignQuery();
        query.setText(dr.getQuery().getText());
        query.setLanguage(dr.getQuery().getLanguage());
        return query;
    }

    public static DynamicJasperDesign downCast(JasperDesign jd, DynamicReport dr) throws CoreException {
        DynamicJasperDesign djd = new DynamicJasperDesign();
        log.info((Object)"downcasting JasperDesign");
        try {
            BeanUtils.copyProperties((Object)((Object)djd), (Object)jd);
            if (dr.isTemplateImportParameters()) {
                for (JRParameter element : jd.getParametersList()) {
                    try {
                        djd.addParameter(element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportFields()) {
                for (JRParameter element : jd.getFieldsList()) {
                    try {
                        djd.addField((JRField)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportVariables()) {
                for (JRParameter element : jd.getVariablesList()) {
                    try {
                        if (!(element instanceof JRDesignVariable)) continue;
                        djd.addVariable((JRDesignVariable)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportDatasets()) {
                JRQuery query = jd.getQuery();
                if (query instanceof JRDesignQuery) {
                    djd.setQuery((JRDesignQuery)query);
                    dr.setQuery(new DJQuery(query.getText(), query.getLanguage()));
                }
                for (JRDesignDataset dataset : jd.getDatasetsList()) {
                    try {
                        djd.addDataset(dataset);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            String[] properties = jd.getPropertyNames();
            for (int i = 0; i < properties.length; ++i) {
                String propName = properties[i];
                String propValue = jd.getProperty(propName);
                djd.setProperty(propName, propValue);
            }
            for (JRStyle style : jd.getStylesList()) {
                try {
                    djd.addStyle(style);
                }
                catch (JRException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.warn((Object)("Duplicated style (style name \"" + style.getName() + "\") when loading design: " + e.getMessage()), (Throwable)e);
                }
            }
            JRReportTemplate[] templates = jd.getTemplates();
            if (templates != null) {
                for (int i = 0; i < templates.length; ++i) {
                    djd.addTemplate(templates[i]);
                }
            }
            DJJRDesignHelper.populateBehavioralOptions(dr, djd);
        }
        catch (IllegalAccessException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return djd;
    }

    protected static void populateReportOptionsFromDesign(DynamicJasperDesign jd, DynamicReport dr) {
        DynamicReportOptions options = dr.getOptions();
        options.setBottomMargin(new Integer(jd.getBottomMargin()));
        options.setTopMargin(new Integer(jd.getTopMargin()));
        options.setLeftMargin(new Integer(jd.getLeftMargin()));
        options.setRightMargin(new Integer(jd.getRightMargin()));
        options.setColumnSpace(new Integer(jd.getColumnSpacing()));
        options.setColumnsPerPage(new Integer(jd.getColumnCount()));
        options.setPage(new Page(jd.getPageHeight(), jd.getPageWidth()));
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            jd.setQuery(query);
        }
        if (dr.getReportName() != null) {
            jd.setName(dr.getReportName());
        }
    }
}

