/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.DJVariableResetType;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.awt.Color;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class FastReportBuilder
extends DynamicReportBuilder {
    Style currencyStyle = new Style("currencyStyle");
    Style numberStyle;
    Style subtitleStyle;
    protected int groupCount = 0;

    public FastReportBuilder() {
        this.currencyStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        this.numberStyle = new Style("numberStyle");
        this.numberStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        Style defaultHeaderStyle = this.options.getDefaultHeaderStyle();
        defaultHeaderStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        defaultHeaderStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        defaultHeaderStyle.setBorderBottom(Border.THIN);
        defaultHeaderStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        defaultHeaderStyle.setBackgroundColor(new Color(230, 230, 230));
        defaultHeaderStyle.setTransparency(Transparency.OPAQUE);
        Style titleStyle2 = this.report.getTitleStyle();
        titleStyle2.setFont(Font.ARIAL_BIG_BOLD);
        titleStyle2.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle2.setVerticalAlign(VerticalAlign.TOP);
    }

    @Override
    public DynamicReport build() {
        return super.build();
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).build();
        column.setStyle(style);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, Style style) throws ColumnBuilderException, ClassNotFoundException {
        this.addColumn(title, property, clazz.getName(), width, style);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, Style style, Style headerStyle) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).build();
        if (style != null) {
            column.setStyle(style);
        }
        if (headerStyle != null) {
            column.setHeaderStyle(headerStyle);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, Style style, Style headerStyle) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width, style, headerStyle);
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width);
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, boolean fixedWidth) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, Style style, Style headerStyle, boolean fixedWidth) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setStyle(style).build();
        if (style != null) {
            column.setStyle(style);
        } else {
            this.guessStyle(className, column);
        }
        if (headerStyle != null) {
            column.setHeaderStyle(headerStyle);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, boolean fixedWidth) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width, fixedWidth);
    }

    public FastReportBuilder addImageColumn(String title, String property, int width, boolean fixedWidth, ImageScaleMode imageScaleMode) throws ColumnBuilderException, ClassNotFoundException {
        String className = InputStream.class.getName();
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(1).setImageScaleMode(imageScaleMode).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addImageColumn(String title, String property, int width, boolean fixedWidth, ImageScaleMode imageScaleMode, Style style) throws ColumnBuilderException, ClassNotFoundException {
        String className = InputStream.class.getName();
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(1).setImageScaleMode(imageScaleMode).setStyle(style).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addImageColumn(String title, CustomExpression expression, int width, boolean fixedWidth, ImageScaleMode imageScaleMode, Style style) throws ColumnBuilderException, ClassNotFoundException {
        String className = InputStream.class.getName();
        AbstractColumn column = ColumnBuilder.getNew().setCustomExpression(expression).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(1).setImageScaleMode(imageScaleMode).setStyle(style).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addImageColumn(String title, String property, String className, int width, boolean fixedWidth, ImageScaleMode imageScaleMode, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(1).setStyle(style).build();
        if (style == null) {
            this.guessStyle(className, column);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addBarcodeColumn(String title, String property, String className, int barcodeType, boolean showText, int width, boolean fixedWidth, ImageScaleMode imageScaleMode) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(2).setImageScaleMode(imageScaleMode).setBarcodeType(barcodeType).setShowText(showText).build();
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addBarcodeColumn(String title, String property, String className, int barcodeType, boolean showText, int width, boolean fixedWidth, ImageScaleMode imageScaleMode, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(2).setStyle(style).setBarcodeType(barcodeType).setShowText(showText).build();
        if (style == null) {
            this.guessStyle(className, column);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addBarcodeColumn(String title, String property, String className, int barcodeType, boolean showText, boolean checkSum, String applicationIdentifier, int width, boolean fixedWidth, ImageScaleMode imageScaleMode, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property, className).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setColumnType(2).setBarcodeType(barcodeType).setApplicationIdentifier(applicationIdentifier).setStyle(style).setShowText(showText).setCheckSum(checkSum).build();
        if (applicationIdentifier != null) {
            this.addField(applicationIdentifier, Object.class.getName());
        }
        if (style == null) {
            this.guessStyle(className, column);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, boolean fixedWidth, String pattern) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setPattern(pattern).build();
        this.guessStyle(className, column);
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, boolean fixedWidth, String pattern) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width, fixedWidth, pattern);
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, boolean fixedWidth, String pattern, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setPattern(pattern).setStyle(style).build();
        if (style == null) {
            this.guessStyle(className, column);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, boolean fixedWidth, String pattern, Style style) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width, fixedWidth, pattern, style);
    }

    public FastReportBuilder addColumn(String title, String property, String className, int width, boolean fixedWidth, String pattern, Style style, String fieldDescription) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(new ColumnProperty(property, className)).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setPattern(pattern).setStyle(style).setFieldDescription(fieldDescription).build();
        if (style == null) {
            this.guessStyle(className, column);
        }
        this.addColumn(column);
        return this;
    }

    public FastReportBuilder addColumn(String title, String property, Class clazz, int width, boolean fixedWidth, String pattern, Style style, String fieldDescription) throws ColumnBuilderException, ClassNotFoundException {
        return this.addColumn(title, property, clazz.getName(), width, fixedWidth, pattern, style, fieldDescription);
    }

    public FastReportBuilder addColumn(String title, CustomExpression expression, int width, boolean fixedWidth, String pattern, Style style) throws ColumnBuilderException, ClassNotFoundException {
        AbstractColumn column = ColumnBuilder.getNew().setCustomExpression(expression).setWidth(new Integer(width)).setTitle(title).setFixedWidth((Boolean)fixedWidth).setPattern(pattern).setStyle(style).build();
        if (style == null) {
            this.guessStyle(expression.getClassName(), column);
        }
        this.addColumn(column);
        return this;
    }

    protected void guessStyle(Class clazz, AbstractColumn column) throws ClassNotFoundException {
        this.guessStyle(clazz.getName(), column);
    }

    protected void guessStyle(String className, AbstractColumn column) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        if (BigDecimal.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            if (column.getPattern() == null) {
                column.setPattern("#.00");
            }
            column.setStyle(this.currencyStyle);
        }
        if (Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
            column.setStyle(this.numberStyle);
        }
        if (Date.class.isAssignableFrom(clazz) && column.getPattern() == null) {
            column.setPattern("dd/MM/yy");
        }
        if (Timestamp.class.isAssignableFrom(clazz) && column.getPattern() == null) {
            column.setPattern("dd/MM/yy hh:mm:ss");
        }
    }

    public FastReportBuilder addGroups(int numgroups) {
        this.groupCount = numgroups;
        for (int i = 0; i < this.groupCount; ++i) {
            GroupBuilder gb = new GroupBuilder();
            PropertyColumn col = (PropertyColumn)this.report.getColumns().get(i);
            gb.setCriteriaColumn(col);
            this.report.getColumnsGroups().add(gb.build());
        }
        return this;
    }

    public FastReportBuilder addGroups(int numgroups, GroupLayout gLayout) {
        this.groupCount = numgroups;
        for (int i = 0; i < this.groupCount; ++i) {
            GroupBuilder gb = new GroupBuilder();
            PropertyColumn col = (PropertyColumn)this.report.getColumns().get(i);
            gb.setCriteriaColumn(col);
            gb.setGroupLayout(gLayout);
            this.report.getColumnsGroups().add(gb.build());
        }
        return this;
    }

    public FastReportBuilder setGroupLayout(int groupNumber, GroupLayout layout) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNumber);
        group.setLayout(layout);
        return this;
    }

    public FastReportBuilder addGlobalHeaderVariable(int colNumber, DJCalculation op, Style style) {
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable((AbstractColumn)column, op, style));
        return this;
    }

    public FastReportBuilder addHeaderVariable(int groupNum, int colNumber, DJCalculation op, Style style) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNum);
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        DJGroupVariable columnsGroupVariable = new DJGroupVariable((AbstractColumn)column, op, style);
        group.addHeaderVariable(columnsGroupVariable);
        return this;
    }

    public FastReportBuilder addHeaderVariable(int groupNum, int colNumber, DJCalculation op, Style style, DJValueFormatter valueFormatter) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNum);
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        DJGroupVariable columnsGroupVariable = new DJGroupVariable(column, op, style, valueFormatter);
        group.addHeaderVariable(columnsGroupVariable);
        return this;
    }

    private DJGroup getGroupByNumber(int groupNum) throws BuilderException {
        DJGroup group;
        try {
            group = (DJGroup)this.report.getColumnsGroups().get(groupNum - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BuilderException("No such group, use addGroups(int) first");
        }
        return group;
    }

    public FastReportBuilder addGlobalFooterVariable(int colNumber, DJCalculation op, Style style) {
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable((AbstractColumn)column, op, style));
        return this;
    }

    public FastReportBuilder addFooterVariable(int groupNum, int colNumber, DJCalculation op, Style style) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNum);
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        DJGroupVariable columnsGroupVariable = new DJGroupVariable((AbstractColumn)column, op, style);
        group.addFooterVariable(columnsGroupVariable);
        return this;
    }

    public FastReportBuilder addGroupVariable(String position, int groupNum, int colNumber, DJCalculation op, Style style) throws BuilderException {
        if ("footer".equals(position)) {
            this.addFooterVariable(groupNum, colNumber, op, style);
        } else {
            this.addHeaderVariable(groupNum, colNumber, op, style);
        }
        return this;
    }

    public FastReportBuilder addFooterVariable(int groupNum, int colNumber, DJCalculation op, Style style, DJValueFormatter valueFormatter) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNum);
        PropertyColumn column = (PropertyColumn)this.report.getColumns().get(colNumber - 1);
        if (style == null) {
            style = this.numberStyle;
        }
        DJGroupVariable columnsGroupVariable = new DJGroupVariable(column, op, style, valueFormatter);
        group.addFooterVariable(columnsGroupVariable);
        return this;
    }

    public FastReportBuilder addGroupVariable(String position, int groupNum, int colNumber, DJCalculation op, Style style, DJValueFormatter valueFormatter) throws BuilderException {
        if ("footer".equals(position)) {
            this.addFooterVariable(groupNum, colNumber, op, style, valueFormatter);
        } else {
            this.addHeaderVariable(groupNum, colNumber, op, style, valueFormatter);
        }
        return this;
    }

    public FastReportBuilder addHeaderCrosstab(int groupNumber, DJCrosstab djcross) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNumber);
        group.getHeaderCrosstabs().add(djcross);
        return this;
    }

    public FastReportBuilder addFooterCrosstab(int groupNumber, DJCrosstab djcross) throws BuilderException {
        DJGroup group = this.getGroupByNumber(groupNumber);
        group.getFooterCrosstabs().add(djcross);
        return this;
    }

    public FastReportBuilder addVariable(String name, DJCalculation calculation, CustomExpression expression) {
        DJVariable var = new DJVariable(name, expression.getClassName(), calculation, expression);
        super.addVariable(var);
        return this;
    }

    public FastReportBuilder addVariable(String name, DJCalculation calculation, CustomExpression expression, CustomExpression initialValueExpression, DJVariableResetType resetType, int resetGroup) throws BuilderException {
        DJVariable var = new DJVariable(name, expression.getClassName(), calculation, expression);
        var.setInitialValueExpression(initialValueExpression);
        var.setResetType(resetType);
        if (DJVariableResetType.GROUP.equals(resetType) && (resetGroup < 1 || resetGroup > this.report.getColumnsGroups().size())) {
            throw new BuilderException("Invalid parameter [resetGroup = " + resetGroup + "], must be >= 1 and <= group count ");
        }
        DJGroup group = this.getGroup(resetGroup - 1);
        var.setResetGroup(group);
        super.addVariable(var);
        return this;
    }
}

