/*
 * Decompiled with CFR 0.152.
 */
package com.webbyit.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ModalityInternalFrame
extends JInternalFrame {
    protected JDesktopPane desktopPane;
    protected JComponent parent;
    protected ModalityInternalFrame childFrame;
    protected JComponent focusOwner;
    private boolean wasCloseable;

    public ModalityInternalFrame() {
        this(null, null);
    }

    public ModalityInternalFrame(JComponent parent) {
        this(parent, null);
    }

    public ModalityInternalFrame(JComponent parent, String title) {
        this(parent, title, false);
    }

    public ModalityInternalFrame(JComponent parent, String title, boolean resizable) {
        this(parent, title, resizable, false);
    }

    public ModalityInternalFrame(JComponent parent, String title, boolean resizable, boolean closeable) {
        this(parent, title, resizable, closeable, false);
    }

    public ModalityInternalFrame(JComponent parent, String title, boolean resizable, boolean closeable, boolean maximizable) {
        this(parent, title, resizable, closeable, maximizable, false);
    }

    public ModalityInternalFrame(JComponent parent, String title, boolean resizable, boolean closeable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closeable, maximizable, iconifiable);
        this.setParentFrame(parent);
        this.setFocusTraversalKeysEnabled(false);
        if (parent != null && parent instanceof ModalityInternalFrame) {
            ((ModalityInternalFrame)parent).setChildFrame(this);
        }
        ModalityInternalGlassPane glassPane = new ModalityInternalGlassPane(this);
        this.setGlassPane(glassPane);
        this.addFrameListener();
        this.addFrameVetoListener();
        this.init();
    }

    private void setParentFrame(JComponent parent) {
        this.desktopPane = JOptionPane.getDesktopPaneForComponent(parent);
        this.parent = parent == null ? JOptionPane.getDesktopPaneForComponent(parent) : parent;
    }

    public JComponent getParentFrame() {
        return this.parent;
    }

    public void setChildFrame(ModalityInternalFrame childFrame) {
        this.childFrame = childFrame;
    }

    public ModalityInternalFrame getChildFrame() {
        return this.childFrame;
    }

    public boolean hasChildFrame() {
        return this.childFrame != null;
    }

    protected void addFrameVetoListener() {
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (evt.getPropertyName().equals("selected") && evt.getNewValue().equals(Boolean.TRUE) && ModalityInternalFrame.this.hasChildFrame()) {
                    ModalityInternalFrame.this.childFrame.setSelected(true);
                    if (ModalityInternalFrame.this.childFrame.isIcon()) {
                        ModalityInternalFrame.this.childFrame.setIcon(false);
                    }
                    throw new PropertyVetoException("no!", evt);
                }
            }
        });
    }

    protected void addFrameListener() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                if (ModalityInternalFrame.this.hasChildFrame()) {
                    ModalityInternalFrame.this.getGlassPane().setVisible(true);
                    ModalityInternalFrame.this.grabFocus();
                } else {
                    ModalityInternalFrame.this.getGlassPane().setVisible(false);
                }
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (ModalityInternalFrame.this.hasChildFrame()) {
                    ModalityInternalFrame.this.getGlassPane().setVisible(true);
                    ModalityInternalFrame.this.grabFocus();
                } else {
                    ModalityInternalFrame.this.getGlassPane().setVisible(false);
                }
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                ModalityInternalFrame.this.getGlassPane().setVisible(false);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                if (ModalityInternalFrame.this.parent != null && ModalityInternalFrame.this.parent instanceof ModalityInternalFrame) {
                    ((ModalityInternalFrame)ModalityInternalFrame.this.parent).childClosing();
                }
            }
        });
    }

    protected void childClosing() {
        this.setClosable(this.wasCloseable);
        this.getGlassPane().setVisible(false);
        if (this.focusOwner != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModalityInternalFrame.this.moveToFront();
                        ModalityInternalFrame.this.setSelected(true);
                        ModalityInternalFrame.this.focusOwner.grabFocus();
                    }
                    catch (PropertyVetoException ex) {
                        Logger.getLogger(ModalityInternalFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this.focusOwner.grabFocus();
        }
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        this.setChildFrame(null);
    }

    protected void childOpening() {
        this.wasCloseable = this.isClosable();
        this.setClosable(false);
        this.focusOwner = (JComponent)this.getFocusOwner();
        this.grabFocus();
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void show() {
        if (this.parent != null && this.parent instanceof ModalityInternalFrame) {
            ((ModalityInternalFrame)this.parent).childOpening();
            this.calculateBounds();
        }
        super.show();
    }

    protected void init() {
    }

    public void calculateBounds() {
        Dimension frameSize = this.getPreferredSize();
        Dimension parentSize = new Dimension();
        Dimension rootSize = new Dimension();
        Point frameCoord = new Point();
        if (this.desktopPane != null) {
            rootSize = this.desktopPane.getSize();
            frameCoord = SwingUtilities.convertPoint(this.parent, 0, 0, this.desktopPane);
            parentSize = this.parent.getSize();
        }
        int x = (parentSize.width - frameSize.width) / 2 + frameCoord.x;
        int y = (parentSize.height - frameSize.height) / 2 + frameCoord.y;
        int ovrx = x + frameSize.width - rootSize.width;
        int ovry = y + frameSize.height - rootSize.height;
        x = Math.max(ovrx > 0 ? x - ovrx : x, 0);
        y = Math.max(ovry > 0 ? y - ovry : y, 0);
        this.setBounds(x, y, frameSize.width, frameSize.height);
    }

    class ModalityInternalGlassPane
    extends JComponent {
        private ModalityInternalFrame modalFrame;

        public ModalityInternalGlassPane(ModalityInternalFrame frame) {
            this.modalFrame = frame;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!ModalityInternalGlassPane.this.modalFrame.isSelected()) {
                        try {
                            ModalityInternalGlassPane.this.modalFrame.setSelected(true);
                            if (!ModalityInternalGlassPane.this.modalFrame.hasChildFrame()) {
                                ModalityInternalGlassPane.this.setVisible(false);
                            }
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(new Color(255, 255, 255, 100));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

