/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import gestioneFatture.Util;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.JDialogMessage;
import it.tnx.JFrameMessage;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.shell.CurrentDir;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DumpThread
extends Thread {
    JTextArea text;
    JButton chiudi;
    JProgressBar bar;
    JScrollPane scroll;
    public String nomeFileDump;
    public String nomeFileDump2;
    boolean sendOnline = false;
    JFrameMessage frame = null;
    JDialogMessage dialog = null;

    public DumpThread(JFrameMessage frame) {
        this.text = frame.getTextArea();
        this.chiudi = frame.getPulsanteChiudi();
        this.bar = frame.getAvanzamento();
        this.scroll = frame.getTextAreaScrollPane();
        frame.setTitle("Creazione copia di sicurezza dei dati");
        this.frame = frame;
    }

    public DumpThread(JDialogMessage dialog) {
        this.text = dialog.getTextArea();
        this.chiudi = dialog.getPulsanteChiudi();
        this.bar = dialog.getAvanzamento();
        this.scroll = dialog.getTextAreaScrollPane();
        dialog.setTitle("Creazione copia di sicurezza dei dati");
        this.dialog = dialog;
    }

    @Override
    public synchronized void run() {
        int i;
        Exception error1 = null;
        this.chiudi.setEnabled(false);
        this.bar.setIndeterminate(true);
        this.text.setAutoscrolls(true);
        this.text.append("Inizio backup database\n");
        this.text.append("Controllo cartella 'backup'");
        File dirBackup = new File(main.wd + "backup");
        if (!dirBackup.exists()) {
            dirBackup.mkdir();
        }
        this.text.append("...ok\n");
        try {
            this.nomeFileDump = CurrentDir.getCurrentDir() + "/backup/dump";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
            Date d = new Date();
            this.nomeFileDump = this.nomeFileDump + "_" + sdf.format(d) + ".txt";
            if (this.nomeFileDump2 != null) {
                this.nomeFileDump = CurrentDir.getCurrentDir() + "/backup/" + this.nomeFileDump2;
                File test = new File(this.nomeFileDump);
                if (test.exists()) {
                    test.delete();
                }
            }
            FileOutputStream fos = new FileOutputStream(this.nomeFileDump, false);
            PrintStream o = new PrintStream((OutputStream)fos, true, "UTF8");
            o.println("SET foreign_key_checks = 0;");
            o.println("SET storage_engine = MYISAM;");
            Vector tables = new Vector();
            Statement s = Db.getConn().createStatement();
            ResultSet r = s.executeQuery("show full tables");
            String errori = "";
            while (r.next()) {
                String tab = r.getString(1);
                String tipo = r.getString(2);
                this.text.append("backup " + tipo + " '" + tab + "'");
                if (!it.tnx.Util.dumpTable(tab, Db.getConn(), fos, tipo)) {
                    errori = errori + "\n" + tab;
                    System.out.println(tab + " : ERRORE");
                    this.text.append("...KO\n");
                    this.text.setCaretPosition(this.text.getText().length());
                    continue;
                }
                System.out.println(tab + " : dumped");
                this.text.append("...ok\n");
                this.text.setCaretPosition(this.text.getText().length());
            }
            if (StringUtils.isNotBlank((String)errori) && !main.isBatch) {
                SwingUtils.showErrorMessage((Component)this.text.getTopLevelAncestor(), (String)("Errore sul backup delle seguenti tabelle:" + errori), (boolean)true);
            }
            o.println("SET foreign_key_checks = 1;");
            s.close();
            r.close();
            File fnomeFileDump = new File(this.nomeFileDump);
            fos.flush();
            fos.close();
            try {
                JButton bopen;
                String copiaStandard = SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "backup" + File.separator;
                String copia = null;
                File fileCopia = null;
                try {
                    URL[] url = new URL[]{new URL("file:plugins/InvoicexPluginInvoicex.jar")};
                    URLClassLoader classloader = new URLClassLoader(url);
                    Object obj = classloader.loadClass("invoicexplugininvoicex.backup.MainBackup").newInstance();
                    Method m = obj.getClass().getDeclaredMethod("getNomeFileDump", new Class[0]);
                    Object ret = m.invoke(obj, new Object[0]);
                    System.out.println("ret = " + ret);
                    if (ret instanceof String) {
                        copia = (String)ret;
                    }
                    if (!(fileCopia = new File(copia)).getParentFile().exists()) {
                        copia = null;
                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("La cartella impostata come backup " + fileCopia.getParentFile().getAbsolutePath() + " non esiste.\nVerr\u00e0 utilizzata la cartella standard " + copiaStandard + "\nPer impostarla correttamente puoi farlo da Utilit\u00e0->Impostazioni->Backup"), (boolean)true);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (copia == null) {
                    copia = copiaStandard;
                    File nomeFileDumpFile = new File(this.nomeFileDump);
                    copia = copia + nomeFileDumpFile.getName();
                }
                fileCopia = new File(copia);
                boolean errore_cartella = false;
                if (!fileCopia.getParentFile().isDirectory()) {
                    File cartellaCopia = fileCopia.getParentFile();
                    boolean retdir = cartellaCopia.mkdirs();
                    System.out.println("creazione cartella backup in documenti:" + retdir);
                    if (!retdir) {
                        error1 = new Exception("Errore nella creazione della cartella '" + cartellaCopia.getAbsolutePath() + "'");
                        this.text.append("\nErrore nella creazione della cartella per il backup\n\n");
                        this.text.append("Cartella: '" + cartellaCopia.getAbsolutePath() + "'\n\n");
                        errore_cartella = true;
                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore nella creazione della cartella:\n" + cartellaCopia.getAbsolutePath()), (boolean)true);
                    }
                }
                final File ffileCopia = fileCopia;
                if (!errore_cartella) {
                    if (!fnomeFileDump.getAbsolutePath().equals(ffileCopia.getAbsolutePath())) {
                        FileUtils.copyFile((File)fnomeFileDump, (File)ffileCopia);
                    }
                    this.text.append("\nIl backup si trova nel file\n'" + ffileCopia.getAbsolutePath() + "'\n\n");
                }
                if (this.frame != null) {
                    bopen = new JButton("Apri cartella backup");
                    bopen.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Util.start2(ffileCopia.getParentFile().getAbsolutePath());
                        }
                    });
                    this.frame.panbasso.add(bopen);
                    this.frame.validate();
                }
                if (this.dialog != null) {
                    bopen = new JButton("Apri cartella backup");
                    bopen.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Util.start2(ffileCopia.getParentFile().getAbsolutePath());
                        }
                    });
                    this.dialog.panbasso.add(bopen);
                    this.dialog.validate();
                }
            }
            catch (Exception e) {
                error1 = e;
                this.text.append("\nErrore:\n'" + e.toString() + "'\n\n");
                this.text.append("Debug, User Folder = '" + SystemUtils.getUserDocumentsFolder() + "'\n\n");
                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        Comparator filecomp = new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                if (f1.lastModified() > f2.lastModified()) {
                    return -1;
                }
                if (f1.lastModified() < f2.lastModified()) {
                    return 1;
                }
                return 0;
            }
        };
        File dir = new File(CurrentDir.getCurrentDir() + "/backup");
        Object[] lista = dir.listFiles();
        Vector listav = it.tnx.Util.getVectorFromArray(lista);
        Collections.sort(listav, filecomp);
        for (i = 0; i < listav.size(); ++i) {
            System.out.println("files[" + i + "]:" + ((File)listav.get(i)).getName() + "\t\t" + ((File)listav.get(i)).lastModified());
            if (i <= 20) continue;
            try {
                System.out.println("delete file:" + ((File)listav.get(i)).getCanonicalFile() + "\t deleteed:" + ((File)listav.get(i)).delete());
                continue;
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        }
        try {
            dir = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "backup");
            if (dir.exists()) {
                lista = dir.listFiles();
                listav = it.tnx.Util.getVectorFromArray(lista);
                Collections.sort(listav, filecomp);
                for (i = 0; i < listav.size(); ++i) {
                    System.out.println("files[" + i + "]:" + ((File)listav.get(i)).getName() + "\t\t" + ((File)listav.get(i)).lastModified());
                    if (i <= 20) continue;
                    try {
                        System.out.println("delete file:" + ((File)listav.get(i)).getCanonicalFile() + "\t deleteed:" + ((File)listav.get(i)).delete());
                        continue;
                    }
                    catch (IOException err) {
                        err.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bar.setIndeterminate(false);
        this.bar.setStringPainted(true);
        this.bar.setValue(100);
        if (error1 == null) {
            this.text.append("\nBackup completato.\n\n");
        }
        this.text.setCaretPosition(this.text.getText().length());
        this.chiudi.setEnabled(true);
        this.notify();
        try {
            StackTraceElement[] trace;
            for (StackTraceElement s : trace = Thread.currentThread().getStackTrace()) {
                System.out.println("s: " + s);
                if (!s.getMethodName().equalsIgnoreCase("exitMain")) continue;
                System.out.println("!!!!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

