/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import gestioneFatture.main;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.ImgUtils;
import it.tnx.commons.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JPanel;
import uk.co.jaimon.test.SimpleImageInfo;

public class ImagePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private int width;
    private int height;
    private BufferedImage image;
    String name = null;
    private static final int ACCSIZE = 155;
    private Color bg;

    public ImagePreviewPanel() {
        this.setPreferredSize(new Dimension(155, -1));
        this.bg = this.getBackground();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            File selection = (File)e.getNewValue();
            if (selection == null) {
                return;
            }
            String name = selection.getAbsolutePath();
            if (name != null && name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".bmp") || name.toLowerCase().endsWith(".png")) {
                this.name = name;
                try {
                    this.image = null;
                    System.out.println("ImagePreviewPanel memoria 1");
                    DebugUtils.dumpMem();
                    SimpleImageInfo sii = new SimpleImageInfo(new File(name));
                    System.out.println("img w: " + sii.getWidth() + " h: " + sii.getHeight() + " mime: " + sii.getMimeType());
                    if (!main.debug && sii.getWidth() * sii.getHeight() > 6000000) {
                        SwingUtils.showWarningMessage((Component)this, (String)"Il file \u00e8 troppo grande (il limite \u00e8 3000 * 2000 px)");
                        this.image = null;
                        return;
                    }
                    this.image = ImgUtils.getImage((String)name, (int)this.getWidth(), (int)0, (String)"Q", (boolean)false, (double)0.85, (String)main.getCacheImgDir());
                    this.width = this.image.getWidth();
                    this.height = this.image.getHeight();
                    System.out.println("ImagePreviewPanel memoria 2");
                    DebugUtils.dumpMem();
                }
                catch (OutOfMemoryError mem) {
                    System.out.println("ImagePreviewPanel errore memoria");
                    DebugUtils.dumpMem();
                    SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Immagine troppo grande, memoria disponibile insufficiente!");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)ex.getMessage(), (boolean)true);
                }
                this.repaint();
                System.out.println("ImagePreviewPanel memoria fine");
                DebugUtils.dumpMem();
            }
        }
    }

    private void scaleImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        double ratio = 1.0;
        if (this.width >= this.height) {
            ratio = 150.0 / (double)this.width;
            this.width = 150;
            this.height = (int)((double)this.height * ratio);
        } else if (this.getHeight() > 150) {
            ratio = 150.0 / (double)this.height;
            this.height = 150;
            this.width = (int)((double)this.width * ratio);
        } else {
            ratio = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * ratio);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.bg);
        g.fillRect(0, 0, 155, this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2 - this.width / 2 + 5, this.getHeight() / 2 - this.height / 2, this);
        }
    }
}

