/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import gestioneFatture.Storico;
import gestioneFatture.frmTestFatt;
import gestioneFatture.frmTestFattAcquisto;
import gestioneFatture.logic.provvigioni.ProvvigioniFattura;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.ReflectUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex2.fe.Sdi;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class Scadenze {
    public String documento_tipo;
    public Integer documento_id;
    public Date documento_data;
    private String pagamento_tipo;
    private boolean flag_pagata;
    private double documento_importo;
    private double documento_imponibile;
    private double documento_iva;
    private double totale_scadenze;
    public int numero;
    double quadratura = 0.0;
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    Connection conn = null;
    public Double acconto = null;
    public Double sconto_bonus = null;
    double totale_doc_2d = 0.0;
    double totale_sca_2d = 0.0;

    public Scadenze(String documento_tipo, Integer documento_id, String pagamento_tipo, Object parent) {
        this(null, documento_tipo, documento_id, pagamento_tipo, null, parent);
    }

    public Scadenze(Connection conn, String documento_tipo, Integer documento_id, String pagamento_tipo, Object parent) {
        this(conn, documento_tipo, documento_id, pagamento_tipo, null, parent);
    }

    public Scadenze(String documento_tipo, Integer documento_id, String pagamento_tipo, Date documento_data, Object parent) {
        this(null, documento_tipo, documento_id, pagamento_tipo, documento_data, parent);
    }

    public Scadenze(Connection conn, String documento_tipo, Integer documento_id, String pagamento_tipo, Date documento_data, Object parent) {
        this(null, documento_tipo, documento_id, pagamento_tipo, documento_data, true, null, parent);
    }

    public Scadenze(Connection conn, String documento_tipo, Integer documento_id, String pagamento_tipo, Date documento_data, boolean genera, Double totale, Object parent) {
        if (conn == null && this.conn == null) {
            conn = Db.getConn();
        }
        this.conn = conn;
        this.documento_tipo = documento_tipo;
        this.documento_id = documento_id;
        this.pagamento_tipo = pagamento_tipo;
        this.documento_data = documento_data;
        String sql = "";
        if (documento_id != null && documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = "Select tipo_fattura from test_fatt";
            sql = sql + " where id = " + documento_id;
            try {
                Integer tipo_fattura = cu.i((Object)dbu.getObject((Connection)conn, (String)sql));
                if (tipo_fattura != null && tipo_fattura == 8) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (documento_id != null && (pagamento_tipo == null || this.acconto == null)) {
            if (documento_tipo.equals(Db.TIPO_DOCUMENTO_DDT)) {
                sql = "Select pagamento, acconto from test_ddt";
            } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                sql = "Select pagamento, acconto, sconto_ecobonus from test_fatt";
            } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                sql = "Select pagamento, acconto from test_fatt_acquisto";
            } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                sql = "Select pagamento, acconto from test_ordi";
            } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                sql = "Select pagamento, acconto from test_ordi_acquisto";
            }
            sql = sql + " where id = " + documento_id;
            ResultSet tempDocuPagamento = Db.openResultSet(conn, sql);
            try {
                tempDocuPagamento.next();
                if (pagamento_tipo == null) {
                    pagamento_tipo = tempDocuPagamento.getString(1);
                }
                this.acconto = tempDocuPagamento.getDouble(2);
                if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                    this.sconto_bonus = tempDocuPagamento.getDouble(3);
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (pagamento_tipo.length() > 0) {
            block48: {
                sql = "";
                if (documento_id != null) {
                    if (documento_tipo.equals(Db.TIPO_DOCUMENTO_DDT)) {
                        sql = "Select * from test_ddt";
                    } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                        sql = "Select * from test_fatt";
                    } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                        sql = "Select * from test_fatt_acquisto";
                    } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                        sql = "Select * from test_ordi";
                    } else if (documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                        sql = "Select * from test_ordi_acquisto";
                    }
                    sql = sql + " where id = " + documento_id;
                    System.out.println("sql importo scadenze = " + sql);
                    ResultSet tempDocu = Db.openResultSet(conn, sql);
                    try {
                        tempDocu.next();
                        if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                            this.documento_importo = tempDocu.getDouble("importo");
                            this.documento_imponibile = tempDocu.getDouble("imponibile");
                            this.documento_iva = tempDocu.getDouble("iva");
                            try {
                                if (tempDocu.getDouble("totale_da_pagare") != 0.0) {
                                    this.documento_importo = tempDocu.getDouble("totale_da_pagare");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (tempDocu.getDouble("totale_da_pagare_finale") != 0.0 || cu.d0((Object)this.acconto) != 0.0 || cu.d0((Object)this.sconto_bonus) != 0.0) {
                                    this.documento_importo = tempDocu.getDouble("totale_da_pagare_finale");
                                }
                                break block48;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block48;
                        }
                        this.documento_importo = tempDocu.getDouble("totale");
                        this.documento_imponibile = tempDocu.getDouble("totale_imponibile");
                        this.documento_iva = tempDocu.getDouble("totale_iva");
                        if (documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA) && tempDocu.getDouble("totale_da_pagare") > 0.0) {
                            this.documento_importo = tempDocu.getDouble("totale_da_pagare");
                        }
                        try {
                            if (tempDocu.getDouble("totale_da_pagare_finale") != 0.0 || cu.d0((Object)this.acconto) != 0.0 || cu.d0((Object)this.sconto_bonus) != 0.0) {
                                this.documento_importo = documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA) ? tempDocu.getDouble("totale_da_pagare_finale") : tempDocu.getDouble("totale") - cu.d0((Object)this.acconto);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                        System.out.println("sql:" + sql);
                    }
                } else {
                    this.documento_importo = totale;
                }
            }
            if (genera) {
                sql = "Select * from scadenze";
                sql = sql + " where documento_tipo = " + Db.pc((Object)documento_tipo, 12);
                sql = sql + " and id_doc = " + documento_id;
                ResultSet tempScad = Db.openResultSet(conn, sql);
                try {
                    if (!tempScad.next()) {
                        this.generaScadenze(conn, true, parent);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean totaliDiversi() {
        System.err.println("documento_importo = " + this.documento_importo);
        String sql = "Select sum(importo) as tot from scadenze";
        sql = sql + " where documento_tipo = " + Db.pc((Object)this.documento_tipo, 12);
        sql = sql + " and id_doc = " + this.documento_id;
        sql = sql + " and IFNULL(flag_acconto,'') != 'S'";
        ResultSet tempScad = null;
        this.totale_scadenze = 0.0;
        try {
            System.out.println("sql = " + sql);
            tempScad = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sql);
            if (tempScad.next()) {
                this.totale_scadenze = tempScad.getDouble(1);
                System.err.println("totale_scadenze = " + this.totale_scadenze);
                if (this.totale_scadenze == 0.0) {
                    boolean pag_ha_scadenze;
                    boolean bl = pag_ha_scadenze = cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)("select INSTR(CONCAT(`IMMEDIATO`,`30`,`60`,`90`,`120`,`150`,`180`,`210`,`240`,`270`,`300`,`330`,`360`), 'S') from pagamenti where codice = " + dbu.sql((Object)this.pagamento_tipo)))) > 0;
                    if (!pag_ha_scadenze) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                tempScad.close();
            }
            catch (Exception exception) {}
        }
        this.totale_doc_2d = FormatUtils.round((double)this.documento_importo, (int)2);
        System.err.println("totale_doc_2d = " + this.totale_doc_2d);
        this.totale_sca_2d = FormatUtils.round((double)this.totale_scadenze, (int)2);
        System.err.println("totale_sca_2d = " + this.totale_sca_2d);
        return this.totale_doc_2d != this.totale_sca_2d;
    }

    public void generaProvvigioni() {
        this.generaProvvigioni(null, null, null, null, null, null, null);
    }

    public void generaProvvigioni(Date oldDataScadenza, Date nuovaDataScadenza, Double oldImporto, Double nuovoImporto, Boolean genera_solo_se_necessario, String oldStato, String newStato) {
        boolean continuare = true;
        if (genera_solo_se_necessario != null && genera_solo_se_necessario.booleanValue() && oldDataScadenza.equals(nuovaDataScadenza) && nuovoImporto.equals(oldImporto)) {
            System.out.println("non genero le provvigioni perch\u00e8 non necessario: " + oldDataScadenza + "=" + nuovaDataScadenza + " e " + oldImporto + "=" + nuovoImporto);
            if (oldStato != null && newStato != null && oldStato.equals("S") && (newStato.equals("P") || newStato.equals("N"))) {
                String sql = "select * from provvigioni";
                sql = sql + " where documento_tipo = " + Db.pc((Object)this.documento_tipo, 12);
                sql = sql + " and id_doc = " + this.documento_id;
                sql = sql + " and data_scadenza = " + Db.pc(nuovaDataScadenza, 91);
                sql = sql + " and pagata = 'S'";
                String newStatoDescr = "";
                if (newStato.equals("P")) {
                    newStatoDescr = "Pagata parzialmente";
                }
                if (newStato.equals("N")) {
                    newStatoDescr = "NON Pagata";
                }
                try {
                    if (DbUtils.containRows((Connection)Db.getConn(), (String)sql)) {
                        SwingUtils.showInfoMessage((Component)main.getPadreWindow(), (String)("Attenzione hai messo come '" + newStatoDescr + "' una scadenza per la quale la provvigione \u00e8 segnata come pagata !"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            continuare = false;
        }
        if (continuare) {
            try {
                String tab = "";
                if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                    int agente_codice = CastUtils.toInteger((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("select agente_codice from test_fatt where id = " + this.documento_id)));
                    double agente_perc = CastUtils.toDouble((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("select agente_percentuale from test_fatt where id = " + this.documento_id)));
                    ProvvigioniFattura provvigioni = new ProvvigioniFattura(this.documento_id, agente_codice, agente_perc);
                    boolean ret = provvigioni.generaProvvigioni();
                    System.out.println("esito genera provvigioni da scadenze:" + ret + " : " + provvigioni.ret);
                } else {
                    System.out.println("Non genero le provvigioni perch\u00e8 non fattura: " + this.documento_tipo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean generaScadenze() {
        return this.generaScadenze(null);
    }

    public boolean generaScadenze(Connection conn) {
        return this.generaScadenze(conn, true, null);
    }

    public boolean generaScadenze(Connection conn, boolean avvisi, Object parent) {
        if (conn == null) {
            conn = Db.getConn();
        }
        Object giornoMese = null;
        Integer clifor = null;
        Object escl_mese_1 = null;
        Object escl_mese_2 = null;
        Object escl_giorno = null;
        String sql = "";
        if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_DDT)) {
            sql = "Select pagamento, acconto, cliente as clifor from test_ddt";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = "Select pagamento, acconto, cliente as clifor from test_fatt";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = "Select pagamento, acconto, fornitore as clifor from test_fatt_acquisto";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = "Select pagamento, acconto, cliente as clifor from test_ordi";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = "Select pagamento, acconto, fornitore as clifor from test_ordi_acquisto";
        }
        sql = sql + " where id = " + this.documento_id;
        if (this.pagamento_tipo == null) {
            ResultSet tempDocuPagamento = Db.openResultSet(conn, sql);
            try {
                tempDocuPagamento.next();
                this.pagamento_tipo = tempDocuPagamento.getString(1);
                this.acconto = tempDocuPagamento.getDouble(2);
                clifor = tempDocuPagamento.getInt(3);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (this.pagamento_tipo == null) {
            if (avvisi) {
                SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)"Scadenze di pagamento non generate perch\u00e8 vuoto il tipo di pagamento");
            }
            return false;
        }
        if (!this.pagamento_tipo.equals(Db.PAGAMENTO_LIBERO)) {
            sql = "select * from pagamenti";
            sql = sql + " where codice = " + Db.pc((Object)this.pagamento_tipo, 12);
            ResultSet tempPaga = Db.openResultSet(conn, sql);
            try {
                if (tempPaga.next()) {
                    this.flag_pagata = Db.nz(tempPaga.getString("flag_pagata"), "").equalsIgnoreCase("S");
                    Statement stat = conn != null ? conn.createStatement() : Db.getConn().createStatement();
                    sql = "select id, data_scadenza, importo, distinta from scadenze";
                    sql = sql + " where documento_tipo = " + Db.pc((Object)this.documento_tipo, 12);
                    sql = sql + " and id_doc = " + this.documento_id;
                    ResultSet resu = stat.executeQuery(sql = sql + " and distinta is not null");
                    if (resu.next()) {
                        Map m = InvoicexUtil.getSerieNumeroAnno(this.documento_tipo, this.documento_id);
                        Storico.scrivi("Genera Scadenze Controllo", "Documento = " + this.documento_tipo + "/" + m.get("serie") + "/" + m.get("numero") + "/" + m.get("anno") + ", Pagamento = " + this.pagamento_tipo + ", Importo documento = " + this.documento_importo + " CI SONO DELLE SCADENZE GIA IN DISTINTA!!!");
                        try {
                            int ret;
                            resu.previous();
                            String msg = "Le seguenti scadenze sono gia' state incluse nella distinta per la banca:";
                            while (resu.next()) {
                                msg = msg + "\n" + resu.getString("id") + " al " + this.dateFormat.format(resu.getDate("data_scadenza")) + " di \u20ac" + Db.formatValuta(resu.getDouble("importo")) + " distinta " + resu.getString("distinta");
                            }
                            msg = msg + "\nSicuro di continuare e rigenerarle ?";
                            if (avvisi && (ret = JOptionPane.showConfirmDialog(null, msg, "Attenzione", 0)) == 1) {
                                return false;
                            }
                        }
                        catch (Exception err) {
                            err.printStackTrace();
                        }
                    }
                    Integer vercontab = cu.i0((Object)dbu.getObject((Connection)conn, (String)"select versione from db_version where modulo = 'pluginContabilita'", (boolean)false));
                    if (main.pluginContabilita && vercontab >= 7 && main.isPluginContabilitaAttivo()) {
                        Scadenze.eliminaRegistrazioneScadenze(conn, this.documento_tipo, this.documento_id);
                    }
                    sql = "delete from scadenze";
                    sql = sql + " where documento_tipo = " + Db.pc((Object)this.documento_tipo, 12);
                    sql = sql + " and id_doc = " + this.documento_id;
                    Db.executeSql(conn, sql);
                    Map scadenze = this.generaScadenzeGetScadenze(conn);
                    this.numero = 1;
                    if (scadenze.size() > 0) {
                        for (Map.Entry s : scadenze.entrySet()) {
                            Map ms = (Map)s.getValue();
                            if (cu.b(ms.get("acconto")).booleanValue()) {
                                this.inserisciScadenza(conn, cu.d(ms.get("importo")), cu.toDate(ms.get("data")), "acconto", true);
                                continue;
                            }
                            this.inserisciScadenza(conn, cu.d(ms.get("importo")), cu.toDate(ms.get("data")));
                        }
                    }
                    InvoicexUtil.aggiornaScadenze(this.documento_tipo, this.documento_id);
                    if ((this.flag_pagata || this.acconto != null && this.acconto != 0.0) && !(parent instanceof frmTestFatt) && !(parent instanceof frmTestFattAcquisto) && !(parent instanceof Sdi)) {
                        try {
                            if (main.pluginContabilita && vercontab >= 7 && main.isPluginContabilitaAttivo()) {
                                sql = "select id from scadenze";
                                sql = sql + " where documento_tipo = " + Db.pc((Object)this.documento_tipo, 12);
                                sql = sql + " and id_doc = " + this.documento_id;
                                ArrayList id_scadenze = dbu.getListInt((Connection)conn, (String)sql);
                                ReflectUtils.runMethod((String)"it.tnx.invoicex.pnota.PNUtil", (String)"generaPrimaNotaScadenze", (Object[])new Object[]{id_scadenze});
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return true;
                }
                if (avvisi) {
                    JOptionPane.showMessageDialog(InvoicexUtil.getActiveJInternalFrame(), "Impossibile trovare il tipo di pagamento");
                }
                Map m = InvoicexUtil.getSerieNumeroAnno(this.documento_tipo, this.documento_id);
                Storico.scrivi("Genera Scadenze Errore Pagamento", "Documento = " + this.documento_tipo + "/" + m.get("serie") + "/" + m.get("numero") + "/" + m.get("anno") + ", Pagamento = " + this.pagamento_tipo + ", Importo documento = " + this.documento_importo);
                return false;
            }
            catch (Exception err) {
                err.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void eliminaRegistrazioneScadenze(Connection conn, String documento_tipo, Integer documento_id) throws Exception {
        String sql = "select id from scadenze";
        sql = sql + " where documento_tipo = " + Db.pc((Object)documento_tipo, 12);
        sql = sql + " and id_doc = " + documento_id;
        ArrayList id_scadenze = dbu.getListInt((Connection)conn, (String)sql);
        for (Integer id_scadenza : id_scadenze) {
            sql = "DELETE t,r FROM pn_registrazioni t INNER JOIN    pn_registrazioni_righe r ON t.id = r.id_padre  WHERE    t.id_scadenza = " + id_scadenza;
            System.out.println("sql = " + sql);
            try {
                dbu.tryExecQuery((Connection)conn, (String)sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map generaScadenzeGetScadenze(Connection conn) {
        Byte giornoMese = null;
        Integer clifor = null;
        Integer escl_mese_1 = null;
        Integer escl_mese_2 = null;
        Integer escl_giorno = null;
        String sql = "";
        if (this.documento_id != null) {
            if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_DDT)) {
                sql = "Select pagamento, acconto, cliente as clifor from test_ddt";
            } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
                sql = "Select pagamento, acconto, cliente as clifor from test_fatt";
            } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                sql = "Select pagamento, acconto, fornitore as clifor from test_fatt_acquisto";
            } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
                sql = "Select pagamento, acconto, cliente as clifor from test_ordi";
            } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
                sql = "Select pagamento, acconto, fornitore as clifor from test_ordi_acquisto";
            }
            sql = sql + " where id = " + this.documento_id;
            if (this.pagamento_tipo == null) {
                ResultSet tempDocuPagamento = Db.openResultSet(conn, sql);
                try {
                    tempDocuPagamento.next();
                    this.pagamento_tipo = tempDocuPagamento.getString(1);
                    this.acconto = tempDocuPagamento.getDouble(2);
                    clifor = tempDocuPagamento.getInt(3);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            if (this.pagamento_tipo == null) {
                return null;
            }
            try {
                if (conn == null) {
                    conn = Db.getConn();
                }
                if (clifor == null) {
                    ArrayList doc = dbu.getListMap((Connection)conn, (String)sql);
                    clifor = cu.i(((Map)doc.get(0)).get("clifor"));
                }
                sql = "select escl_scad_mese_1, escl_scad_mese_2, giorno_pagamento_rimandato from clie_forn where codice = " + dbu.sql(clifor);
                ArrayList mclifor = dbu.getListMap((Connection)conn, (String)sql);
                try {
                    escl_mese_1 = cu.i(((Map)mclifor.get(0)).get("escl_scad_mese_1"));
                    escl_mese_2 = cu.i(((Map)mclifor.get(0)).get("escl_scad_mese_2"));
                    escl_giorno = cu.i(((Map)mclifor.get(0)).get("giorno_pagamento_rimandato"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)e);
            }
        }
        sql = "select * from pagamenti";
        sql = sql + " where codice = " + Db.pc((Object)this.pagamento_tipo, 12);
        ResultSet tempPaga = Db.openResultSet(conn, sql);
        try {
            if (tempPaga.next()) {
                this.flag_pagata = Db.nz(tempPaga.getString("flag_pagata"), "").equalsIgnoreCase("S");
                ResultSet tempDocu = this.getResultSetDocumento();
                if (this.documento_data == null) {
                    if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                        this.documento_data = tempDocu.getDate("data_doc");
                        if (this.documento_data == null) {
                            this.documento_data = tempDocu.getDate("data");
                        }
                    } else {
                        this.documento_data = tempDocu.getDate("data");
                    }
                }
                Date dataInizio = this.documento_data;
                Calendar tempCale = GregorianCalendar.getInstance();
                boolean iva30gg = false;
                if (CastUtils.toString((Object)tempPaga.getString("iva30gg")).equalsIgnoreCase("S")) {
                    iva30gg = true;
                }
                int contaScadenze = 0;
                if ("S".equalsIgnoreCase(tempPaga.getString("IMMEDIATO"))) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("30").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("60").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("90").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("120").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("150").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("180").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("210").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("240").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("270").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("300").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("330").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                if (tempPaga.getString("360").equalsIgnoreCase("S")) {
                    ++contaScadenze;
                }
                String q_auto = tempPaga.getString("q_auto");
                boolean quoteAuto = cu.toBoolean((Object)q_auto);
                Double importoScadenza = null;
                Double totaleScadenze = null;
                Double totaleDoc = null;
                if (!quoteAuto) {
                    totaleScadenze = 0.0;
                    totaleDoc = this.documento_importo;
                    if (iva30gg) {
                        totaleScadenze = totaleScadenze + Util.round(this.documento_iva, 2);
                        totaleDoc = this.documento_importo - this.documento_iva;
                    }
                    if ("S".equalsIgnoreCase(tempPaga.getString("IMMEDIATO"))) {
                        double q_immediata = tempPaga.getDouble("q_immediata");
                        totaleScadenze = totaleScadenze + Util.round(totaleDoc / 100.0 * q_immediata, 2);
                    }
                    for (int i = 1; i <= 12; ++i) {
                        if (!tempPaga.getString(cu.s((Object)(30 * i))).equalsIgnoreCase("S")) continue;
                        String campo = "q_" + 30 * i;
                        double q_immediata = tempPaga.getDouble(campo);
                        totaleScadenze = totaleScadenze + Util.round(totaleDoc / 100.0 * q_immediata, 2);
                    }
                    this.quadratura = Util.round(this.documento_importo - totaleScadenze, 2);
                } else {
                    importoScadenza = this.documento_importo / (double)contaScadenze;
                    if (iva30gg) {
                        importoScadenza = (this.documento_importo - this.documento_iva) / (double)contaScadenze;
                    }
                    double importoScadenzaApprossimato = Util.round(importoScadenza, 2);
                    importoScadenza = importoScadenzaApprossimato;
                    this.quadratura = iva30gg ? Util.round(this.documento_importo - this.documento_iva - importoScadenzaApprossimato * (double)contaScadenze, 2) : Util.round(this.documento_importo - importoScadenzaApprossimato * (double)contaScadenze, 2);
                }
                boolean fineMese = tempPaga.getString("FINEMESE").equalsIgnoreCase("S");
                boolean specificaGiorno = false;
                if (tempPaga.getString("flag_richiedi_giorno").equalsIgnoreCase("S")) {
                    specificaGiorno = true;
                    giornoMese = new Byte(tempDocu.getByte("giorno_pagamento"));
                } else {
                    giornoMese = null;
                }
                LinkedHashMap scadenze = new LinkedHashMap();
                if (this.acconto != null && this.acconto != 0.0) {
                    tempCale = Scadenze.calcolaData(dataInizio, 0, false, null, escl_mese_1, escl_mese_2, escl_giorno);
                    boolean flag_pagata_old = this.flag_pagata;
                    this.flag_pagata = true;
                    this.inserisciScadenzaPre(scadenze, this.acconto, tempCale.getTime(), true, this.flag_pagata);
                    this.flag_pagata = flag_pagata_old;
                }
                for (int i = 0; i <= 12; ++i) {
                    String campo = null;
                    campo = i == 0 ? "IMMEDIATO" : cu.s((Object)(i * 30));
                    if ("S".equalsIgnoreCase(tempPaga.getString(campo))) {
                        tempCale = Scadenze.calcolaData(dataInizio, i, fineMese, giornoMese, escl_mese_1, escl_mese_2, escl_giorno);
                        Double importo = null;
                        if (quoteAuto) {
                            importo = importoScadenza;
                        } else {
                            campo = "q_" + 30 * i;
                            if (i == 0) {
                                campo = "q_immediata";
                            }
                            double q_immediata = tempPaga.getDouble(campo);
                            importo = Util.round(totaleDoc / 100.0 * q_immediata, 2);
                        }
                        this.inserisciScadenzaPre(scadenze, importo, tempCale.getTime(), false, this.flag_pagata);
                    }
                    if (i != 1 || !iva30gg) continue;
                    tempCale = Scadenze.calcolaData(dataInizio, i, fineMese, giornoMese, escl_mese_1, escl_mese_2, escl_giorno);
                    this.inserisciScadenzaPre(scadenze, this.documento_iva, tempCale.getTime(), false, this.flag_pagata);
                }
                if (scadenze.size() > 0) {
                    for (Map.Entry s : scadenze.entrySet()) {
                        Map ms = (Map)s.getValue();
                        if (cu.b(ms.get("acconto")).booleanValue()) continue;
                        double importo = Util.round(cu.d(ms.get("importo")) + this.quadratura, 2);
                        ms.put("importo", importo);
                        this.quadratura = 0.0;
                        break;
                    }
                }
                return scadenze;
            }
            return null;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public static GregorianCalendar calcolaData(Date dataInizio, int mesi, boolean fineMese) {
        return Scadenze.calcolaData(dataInizio, mesi, fineMese, null);
    }

    public static GregorianCalendar calcolaData(Date dataInizio, int mesi, boolean fineMese, Byte giornoMese) {
        return Scadenze.calcolaData(dataInizio, mesi, fineMese, giornoMese, null, null, null);
    }

    public static GregorianCalendar calcolaData(Date dataInizio, int mesi, boolean fineMese, Byte giornoMese, Integer escl_mese_1, Integer escl_mese_2, Integer escl_giorno) {
        Calendar tempCale = GregorianCalendar.getInstance();
        tempCale.setTime(dataInizio);
        if (!fineMese && giornoMese == null) {
            tempCale.add(2, mesi);
        } else if (giornoMese != null) {
            if (fineMese) {
                tempCale.add(2, mesi + 1);
            } else if (tempCale.get(5) > giornoMese) {
                tempCale.add(2, mesi + 1);
            } else {
                tempCale.add(2, mesi);
            }
            int maxday = tempCale.getActualMaximum(5);
            if (giornoMese > maxday) {
                giornoMese = (byte)maxday;
            }
            tempCale.set(5, giornoMese.byteValue());
        } else {
            tempCale.add(2, mesi);
            int giorniMese = tempCale.getActualMaximum(5);
            tempCale.set(5, giorniMese);
        }
        if ((escl_mese_1 != null || escl_mese_2 != null) && (escl_mese_1 != null && tempCale.get(2) + 1 == escl_mese_1 || escl_mese_2 != null && tempCale.get(2) + 1 == escl_mese_2)) {
            tempCale.add(2, 1);
            if (escl_giorno != null && escl_giorno > 0 && escl_giorno < 31) {
                tempCale.set(5, escl_giorno);
            }
        }
        return (GregorianCalendar)tempCale;
    }

    public void inserisciScadenza(double importo, Date scadenza) {
        this.inserisciScadenza(null, importo, scadenza);
    }

    public void inserisciScadenza(Connection conn, double importo, Date scadenza) {
        this.inserisciScadenza(conn, importo, scadenza, null, false);
    }

    public void inserisciScadenza(Connection conn, double importo, Date scadenza, String note, boolean flag_acconto) {
        if (!flag_acconto) {
            importo = Util.round(importo + this.quadratura, 2);
            this.quadratura = 0.0;
        } else {
            importo = Util.round(importo, 2);
        }
        String sql = "";
        try {
            sql = "insert into scadenze (documento_tipo";
            sql = sql + ",id_doc";
            sql = sql + ",data_scadenza";
            sql = sql + ",pagata";
            sql = sql + ",importo";
            sql = sql + ",numero, note_pagamento, flag_acconto) values (";
            sql = sql + Db.pc((Object)this.documento_tipo, 12);
            sql = sql + "," + Db.pc(this.documento_id, 4);
            sql = sql + "," + Db.pc((Object)Db.formatDataMysql(scadenza), 91);
            sql = this.flag_pagata || flag_acconto ? sql + "," + Db.pc((Object)"S", 12) : sql + "," + Db.pc((Object)"N", 12);
            sql = sql + "," + Db.pc(importo, 8);
            sql = sql + "," + Db.pc(flag_acconto ? null : Integer.valueOf(this.numero), 4);
            sql = sql + "," + Db.pc((Object)note, 12);
            sql = sql + "," + Db.pc((Object)(flag_acconto ? "S" : "N"), 12);
            sql = sql + ")";
            Map m = InvoicexUtil.getSerieNumeroAnno(this.documento_tipo, this.documento_id);
            Storico.scrivi(conn, "Genera Scadenze Inserisci", "Documento = " + this.documento_tipo + "/" + m.get("serie") + "/" + m.get("numero") + "/" + m.get("anno") + ", Importo = " + importo + ", Numero = " + this.numero + ", Data = " + scadenza);
            Db.executeSql(conn, sql);
            if (!flag_acconto) {
                ++this.numero;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    ResultSet getResultSetDocumento() {
        String sql = "";
        if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_DDT)) {
            sql = "Select * from test_ddt";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = "Select * from test_fatt";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = "Select * from test_fatt_acquisto";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = "Select * from test_ordi";
        } else if (this.documento_tipo.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = "Select * from test_ordi_acquisto";
        }
        sql = sql + " where id = " + this.documento_id;
        ResultSet tempDocu = Db.openResultSet(this.conn, sql);
        try {
            tempDocu.next();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return tempDocu;
    }

    private void inserisciScadenzaPre(Map scadenze, double importoScadenza, Date time, boolean acconto, boolean flag_pagata) {
        HashMap<String, Comparable<Date>> s = new HashMap<String, Comparable<Date>>();
        double importo = 0.0;
        if (!acconto && scadenze.keySet().contains(time) && !cu.b(((Map)scadenze.get(time)).get("acconto")).booleanValue()) {
            importo = cu.d0(((Map)scadenze.get(time)).get("importo"));
        }
        s.put("data", time);
        s.put("acconto", Boolean.valueOf(acconto));
        s.put("flag_pagata", Boolean.valueOf(flag_pagata));
        TempoPagataAcconto k = new TempoPagataAcconto(time, flag_pagata, acconto);
        if (scadenze.containsKey(k)) {
            s.put("importo", Double.valueOf(importoScadenza + importo + cu.d0(((Map)scadenze.get(k)).get("importo"))));
        } else {
            s.put("importo", Double.valueOf(importoScadenza + importo));
        }
        scadenze.put(k, s);
    }

    public static class TempoPagataAcconto {
        Date data;
        Boolean pagata;
        Boolean acconto;

        public TempoPagataAcconto(Date data, Boolean pagata, Boolean acconto) {
            this.data = data;
            this.pagata = pagata;
            this.acconto = acconto;
        }

        public boolean equals(Object arg0) {
            String sarg0 = cu.s((Object)arg0);
            return sarg0.equals(this.toString());
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.data != null ? this.data.hashCode() : 0);
            hash = 97 * hash + (this.pagata != null ? this.pagata.hashCode() : 0);
            hash = 97 * hash + (this.acconto != null ? this.acconto.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "TempoPagataAcconto{data=" + this.data.getTime() + ", pagata=" + this.pagata + ", acconto=" + this.acconto + '}';
        }
    }
}

