/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.DbUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.invoicex.InvoicexUtil;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public class Storico {
    private static void aggiungidatiextra(Map m) {
        m.put("hostname", SystemUtils.getHostname());
        m.put("login_so", main.login);
        m.put("username_id", main.utente.getIdUtente());
        m.put("username", main.utente.getNomeUtente());
    }

    public static void scrivi(String titolo, String nota) {
        Storico.scrivi(Db.getConn(), titolo, nota, false);
    }

    public static String scrivi(String titolo, String nota, boolean return_sql) {
        return Storico.scrivi(Db.getConn(), titolo, nota, return_sql);
    }

    public static void scrivi(Connection conn, String titolo, String nota) {
        Storico.scrivi(conn, titolo, nota, false);
    }

    public static String scrivi(Connection conn, String titolo, String nota, boolean return_sql) {
        try {
            String note = titolo + "|" + nota;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("nota", note);
            Storico.aggiungidatiextra(m);
            String sql = "insert into storico set " + DbUtils.prepareSqlFromMap(m);
            System.out.println("sql = " + sql);
            if (return_sql) {
                return sql;
            }
            if (conn == null) {
                conn = Db.getConn();
            }
            Db.executeSql(conn, sql);
            System.out.println("storico:" + titolo);
        }
        catch (Exception e) {
            System.err.println("errore durante la scrittura dello storico: " + e.getMessage());
        }
        return null;
    }

    public static void scriviSeparati(String titolo, String nota) {
        Storico.scriviSeparati(Db.getConn(), titolo, nota);
    }

    public static void scriviSeparati(Connection conn, String titolo, String nota) {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("nota", titolo);
            m.put("dati", nota);
            Storico.aggiungidatiextra(m);
            String sql = "insert into storico set " + DbUtils.prepareSqlFromMap(m);
            System.out.println("sql = " + sql);
            Db.executeSql(conn, sql);
            System.out.println("scriviSeparati:" + titolo);
        }
        catch (Exception e) {
            System.err.println("errore durante la scrittura dello scriviSeparati: " + e.getMessage());
        }
    }

    public static String scriviCambioDispReale(String articolo, double qta) {
        return Storico.scriviCambioDispReale(articolo, qta, null, false);
    }

    public static String scriviCambioDispReale(String articolo, double qta, String nota) {
        return Storico.scriviCambioDispReale(articolo, qta, nota, false);
    }

    public static String scriviCambioDispReale(String articolo, double qta, String nota, boolean return_sql) {
        return Storico.scriviCambioDispReale(articolo, qta, nota, return_sql, null);
    }

    public static String scriviCambioDispReale(String articolo, double qta, String nota, boolean return_sql, Connection conn) {
        return Storico.scrivi(conn, "update disponibilita_reale" + (nota != null ? " " + nota : ""), "qta=" + qta + " articolo=" + articolo + " stack=" + InvoicexUtil.getStackInvoicex(), return_sql);
    }
}

