/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import gestioneFatture.UnZip;
import gestioneFatture.main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class Update
extends Thread {
    private String host;
    private String login;
    private String pwd;
    private String file;
    private String path;
    private JProgressBar progress;
    private JLabel label;

    public Update(String host, String login, String pwd, String file, String path, JProgressBar progress, JLabel label) {
        this.host = host;
        this.login = login;
        this.pwd = pwd;
        this.file = file;
        this.path = path;
        this.progress = progress;
        this.label = label;
        this.start();
    }

    @Override
    public void run() {
        block13: {
            this.setPriority(5);
            boolean ret = false;
            FTPClient ftp = new FTPClient();
            try {
                FTPFile[] files;
                this.label.setText("aggiornamento : collegamento in corso");
                System.out.println("Connecting to " + this.host);
                ftp.connect(this.host);
                System.out.println("Connected to " + this.host);
                System.out.print(ftp.getReplyString());
                int reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    ftp.disconnect();
                    this.label.setText("aggiornamento : ERRORE, connessione impossibile");
                    System.err.println("FTP server refused connection.");
                    JWindow frame = (JWindow)this.progress.getTopLevelAncestor();
                    frame.dispose();
                    JOptionPane.showMessageDialog(this.progress.getTopLevelAncestor(), "ERRORE, Aggiornamento non riuscito");
                    this.stop();
                }
                ftp.login(this.login, this.pwd);
                String[] names = ftp.listNames();
                if (this.path.length() > 0) {
                    ret = ftp.changeWorkingDirectory(this.path);
                    System.out.println("change dir:" + ret);
                }
                if ((files = ftp.listFiles(this.file)) == null) {
                    JWindow frame = (JWindow)this.progress.getTopLevelAncestor();
                    frame.dispose();
                    JOptionPane.showMessageDialog(this.progress.getTopLevelAncestor(), "Non ci sono aggioranmenti da scaricare");
                    this.stop();
                }
                System.out.println("list file:" + files.length);
                boolean faccioDownload = true;
                File fileLocale = new File(this.file);
                if (fileLocale.exists()) {
                    System.out.println("da finire controllo data");
                }
                if (!faccioDownload) break block13;
                ftp.setFileType(2);
                this.label.setText("aggiornamento : scaricamento file '" + files[0].getName() + "'");
                System.out.println("inizio dowload del file:" + files[0].getName() + " - " + files[0].getTimestamp());
                InputStream inFtp = ftp.retrieveFileStream(this.file);
                this.progress.setMinimum(0);
                this.progress.setMaximum((int)(files[0].getSize() / 512L));
                this.progress.setMaximum(this.progress.getMaximum() + this.progress.getMaximum() / 100 * 25);
                File out = new File(this.file);
                FileOutputStream outFile = new FileOutputStream(out);
                try {
                    int bytesRead;
                    int chunkSize = 512;
                    byte[] ba = new byte[chunkSize];
                    int conta = 0;
                    while ((bytesRead = this.readBlocking(inFtp, ba, 0L, chunkSize)) > 0) {
                        this.progress.setValue(++conta);
                        outFile.write(ba, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outFile.flush();
                outFile.close();
                this.label.setText("aggiornamento : scaricamento completato del file '" + files[0].getName() + "'");
                System.out.println("fine dowload del file");
                this.label.setText("aggiornamento : in corso, decompressione dei files");
                UnZip unzip = new UnZip();
                String[] args = new String[]{this.file};
                UnZip.main(args);
                this.label.setText("aggiornamento : completato");
                JWindow frame = (JWindow)this.progress.getTopLevelAncestor();
                frame.dispose();
                int ret2 = JOptionPane.showConfirmDialog(this.progress.getTopLevelAncestor(), "Aggiornamento completato, le modifiche saranno apportate\n al prossimo avvio dell'applicazione.\nPremere OK per uscire.", "Attenzione", 2);
                if (ret2 == 0) {
                    main.exitMain();
                }
            }
            catch (IOException err) {
                this.label.setText("aggiornamento : ERRORE, " + err.toString());
                System.err.println("Errore");
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException names) {
                        // empty catch block
                    }
                }
                System.err.println("Errore");
                err.printStackTrace();
                JWindow frame = (JWindow)this.progress.getTopLevelAncestor();
                frame.dispose();
                JOptionPane.showMessageDialog(this.progress.getTopLevelAncestor(), "ERRORE, Aggiornamento non riuscito\nControllare di essere collegati ad internet");
                this.stop();
            }
        }
    }

    public final int readBlocking(InputStream in, byte[] b, long off, int len) throws IOException {
        int totalBytesRead;
        int bytesRead;
        for (totalBytesRead = 0; totalBytesRead < len && (bytesRead = in.read(b, (int)(off + (long)totalBytesRead), len - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
        }
        return totalBytesRead;
    }
}

