/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.logic.documenti;

import gestioneFatture.Db;
import gestioneFatture.logic.Iva;
import gestioneFatture.logic.clienti.Cliente;
import gestioneFatture.logic.documenti.DettaglioIva;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.logic.documenti.IvaDed;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;

public class DocumentoOkOld {
    private String sqlPerSconti = null;
    private String sqlPerDettagli = null;
    private String sqlPerDettagliIva = null;
    public Vector dettagliIva = new Vector();
    public Map<IvaDed, DettaglioIva> dettagliIvaDedMap = new LinkedHashMap<IvaDed, DettaglioIva>();
    private Vector dettagliDocumento = new Vector();
    private Map<IvaDed, Double> proporzioniIva = new HashMap<IvaDed, Double>();
    private Map<IvaDed, Double> proporzioniIvaSconto = new HashMap<IvaDed, Double>();
    private Db db = null;
    private double totaImpo = 0.0;
    private double totaIva = 0.0;
    private double tota = 0.0;
    private double totaleQuantita = 0.0;
    public double totalePeso = 0.0;
    private double tempSconto1 = 0.0;
    private double tempSconto2 = 0.0;
    private double tempSconto3 = 0.0;
    private double tempSpeseVarie = 0.0;
    private double tempSpeseTrasportoIva = 0.0;
    private double tempSpeseIncassoIva = 0.0;
    private String rivalsa_inps_descrizione;
    private Double rivalsa_inps_perc;
    private Cliente cliente;
    private double scontoTestata1;
    private double scontoTestata2;
    private double scontoTestata3;
    private double totale;
    private double totaleIva;
    private double totaleImponibileParziale;
    private double totaleImponibilePerRivalsa;
    private double totaleImponibile;
    private double totaleImponibilePerRitenuta;
    private double totaleIvatoParziale;
    private double totaleIvato;
    private double totaleIvatoPerRitenuta;
    private double speseTrasporto;
    private double speseVarieImponibili;
    private double speseIncasso;
    public Double speseBollo = null;
    public boolean speseBolloSiNo = false;
    private long codiceCliente;
    private long codiceFornitore;
    private int ritenuta;
    private String ritenuta_descrizione;
    private Integer rivalsa_codice;
    private double ritenuta_perc;
    private double totale_ritenuta;
    private double acconto;
    private double totale_da_pagare;
    private double totale_da_pagare_finale;
    private boolean rivalsa_inps;
    private double totale_rivalsa;
    private double totale_imponibile2;
    private double totaleSconti;
    private Date data;
    private double parametroArrotondamento = 0.0;
    private boolean perDifetto = true;
    private boolean prezziIvati = false;
    private String tipoDocumento = "";
    private double sconto;
    public double totaleImponibilePreSconto = 0.0;
    public double totaleIvatoPreSconto = 0.0;
    double imponibile = 0.0;
    double imposta = 0.0;
    double imposta_noarr = 0.0;
    double ivato = 0.0;
    double totaleImponibilePositivo = 0.0;
    double totaleIvatoPositivo = 0.0;
    double totaleImposta = 0.0;
    double speseImponibili = 0.0;
    double speseIvate = 0.0;
    public List<DettaglioIva> speseTrasportoDettagli = null;
    public List<DettaglioIva> speseIncassoDettagli = null;
    public Integer id_documento = null;
    public String table_righe_temp;
    Integer numero = null;
    String serie = null;
    Integer anno = null;
    Integer id = null;

    public DocumentoOkOld() {
        System.out.println("new DocumentoOkOld " + this);
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento) {
        return this.load(db, numero, serie, anno, tipoDocumento, null);
    }

    public boolean load(Db db, String tipoDocumento, Integer id) {
        return this.load(db, -1, null, -1, tipoDocumento, id);
    }

    public boolean load(Db db, int numero, String serie, int anno, String tipoDocumento, Integer id) {
        String sqlrit;
        this.db = db;
        this.numero = numero;
        this.serie = serie;
        this.anno = anno;
        this.id = id;
        this.tipoDocumento = tipoDocumento;
        String sql = "select sconto1,sconto2,sconto3, spese_varie, spese_trasporto, spese_incasso, prezzi_ivati, sconto, acconto";
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + ", data, cliente from test_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + ", data, fornitore from test_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            sql = sql + ", data, cliente from test_fatt";
            if (id == null) {
                System.err.println("id null");
                String sqlid = "select id from test_fatt";
                sqlid = sqlid + " where serie = " + Db.pc(serie, "VARHCAR");
                sqlid = sqlid + " and numero = " + Db.pc(numero, "LONG");
                sqlid = sqlid + " and anno = " + Db.pc(anno, "INTEGER");
                sqlid = sqlid + " and tipo_fattura != 7";
                try {
                    ResultSet rid = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sqlid);
                    if (rid.next()) {
                        id = rid.getInt("id");
                    }
                    rid.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(Documento.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + ", data, cliente from test_fatt";
            if (id == null) {
                System.err.println("Documento load Scontrino senza id");
            }
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PREVENTIVO)) {
            sql = sql + ", data, cliente from test_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + ", data, fornitore from test_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + ", data_doc as data, fornitore as cliente from test_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + ", data, cliente as cliente from test_pagamenti_ricorrenti";
        } else {
            JOptionPane.showMessageDialog(null, "errore in calcolo totale, tipo documento errato", "Errore", 0);
        }
        if (id == null && !tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            System.err.println("id null");
            id = InvoicexUtil.getIdDaNumero(tipoDocumento, serie, numero, anno);
            if (id == null) {
                return false;
            }
        }
        sql = sql + " where id = " + id;
        this.id_documento = id;
        this.sqlPerSconti = sql;
        ArrayList listSconti = null;
        java.util.Date data = null;
        try {
            listSconti = dbu.getListMap((Connection)Db.getConn(), (String)this.sqlPerSconti);
            data = cu.toDate(((Map)listSconti.get(0)).get("data"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        sql = "select sum(totale_imponibile) as totaImpo, sum(totale_ivato) as totaIvato, prezzo, sconto1, sconto2, iva, codici_iva.percentuale, codici_iva.descrizione,codici_iva.descrizione_breve";
        sql = InvoicexUtil.isZeroComeUno(data) ? sql + ", sum(if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0))) as quantita" : sql + ", sum(ifnull(quantita,0)) as quantita";
        sql = sql + ", sum(ifnull(quantita,0)) as quantita_orig";
        if (InvoicexUtil.isZeroComeUno(data)) {
            sql = sql + ", sum( ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) ) ) as lordo";
            sql = sql + ", sum( ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) * (1 + (codici_iva.percentuale / 100))) ) as lordoIvato";
        } else {
            sql = sql + ", sum(ifnull(prezzo,0) * ifnull(quantita,0)) as lordo";
            sql = sql + ", sum(ifnull(prezzo,0) * ifnull(quantita,0) * (1 + (codici_iva.percentuale / 100))) as lordoIvato";
        }
        if (main.fileIni.getValueBoolean("pref", "attivaArrotondamento", false).booleanValue()) {
            sql = sql + ", arrotondamento_parametro, arrotondamento_tipo";
        }
        sql = sql + ", iva_deducibile";
        sql = sql + " from ";
        if (this.table_righe_temp != null) {
            sql = sql + this.table_righe_temp;
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + "righ_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + "righ_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + "righ_fatt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + "righ_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + "righ_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + "righ_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + "righ_pagamenti_ricorrenti";
        }
        sql = sql + " left join codici_iva on iva = codice";
        if (id != null) {
            sql = sql + " where id_padre = " + id;
        }
        this.sqlPerDettagliIva = sql = sql + " group by id";
        sql = InvoicexUtil.isZeroComeUno(data) ? "select if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0)) as quantita" : "select ifnull(quantita,0) as quantita";
        sql = sql + ", ifnull(quantita,0) as quantita_orig";
        sql = sql + ", a.peso_kg as peso";
        sql = sql + ", totale_imponibile as impo";
        sql = sql + ", totale_ivato as ivato";
        sql = sql + ", flag_ritenuta";
        sql = sql + ", flag_rivalsa";
        if (InvoicexUtil.isZeroComeUno(data)) {
            sql = sql + ", round((ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) ) ),2) as lordo";
            sql = sql + ", round((ifnull(prezzo,0) * if(ifnull(quantita,0)=0 and ifnull(prezzo,0)!=0,1,ifnull(quantita,0) * (1 + codici_iva.percentuale / 100)) ), 2) as lordoIvato";
        } else {
            sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)),2) as lordo";
            sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0) * (1 + codici_iva.percentuale / 100)), 2) as lordoIvato";
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + ", codice_articolo";
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + ", iva_deducibile, r.iva";
        }
        sql = sql + " from ";
        if (this.table_righe_temp != null) {
            sql = sql + this.table_righe_temp;
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT)) {
            sql = sql + "righ_ddt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
            sql = sql + "righ_ddt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_SCONTRINO)) {
            sql = sql + "righ_fatt";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE)) {
            sql = sql + "righ_ordi";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO)) {
            sql = sql + "righ_ordi_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
            sql = sql + "righ_fatt_acquisto";
        } else if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_PAGAMENTO_RICORRENTE)) {
            sql = sql + "righ_pagamenti_ricorrenti";
        }
        sql = sql + " r left join articoli a on r.codice_articolo = a.codice";
        sql = sql + " left join codici_iva on r.iva = codici_iva.codice";
        if (id == null) {
            SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Problema nel calcolo del totale documento (id = null)", (String)"Errore");
        } else {
            if (cu.i0((Object)id) == 0) {
                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Errore in Documento.load id = 0");
            }
            sql = sql + " where id_padre = " + id;
        }
        this.sqlPerDettagli = sql;
        System.err.println("sql calcolo documento = " + sql);
        if ((tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) && main.pluginRitenute) {
            try {
                sqlrit = "select ritenuta";
                sqlrit = sqlrit + " from " + InvoicexUtil.getTabTestateFromTipoDoc(tipoDocumento);
                sqlrit = sqlrit + " where id = " + id;
                ResultSet rrit = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sqlrit);
                this.ritenuta = rrit.next() ? (rrit.getObject("ritenuta") == null || rrit.getInt("ritenuta") <= 0 ? 0 : rrit.getInt("ritenuta")) : 0;
                DbUtils.close((ResultSet)rrit);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        if ((tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA) || tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) && main.pluginRitenute) {
            try {
                sqlrit = "select rivalsaInpsPerc, rivalsaInpsTesto, rivalsa";
                sqlrit = sqlrit + " from " + InvoicexUtil.getTabTestateFromTipoDoc(tipoDocumento);
                sqlrit = sqlrit + " where id = " + id;
                ResultSet rriv = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sqlrit);
                this.setRivalsa_inps_perc(null);
                this.setRivalsa_inps_descrizione(null);
                if (rriv.next() && rriv.getObject("rivalsaInpsPerc") != null && !(rriv.getDouble("rivalsaInpsPerc") <= 0.0)) {
                    this.setRivalsaCodice(rriv.getInt("rivalsa"));
                    this.setRivalsa_inps_perc(rriv.getDouble("rivalsaInpsPerc"));
                    this.setRivalsa_inps_descrizione(rriv.getString("rivalsaInpsTesto"));
                }
                DbUtils.close((ResultSet)rriv);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        if (tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            try {
                String sqlbollo = "select marca_da_bollo, bollo_presente ";
                sqlbollo = sqlbollo + " from " + InvoicexUtil.getTabTestateFromTipoDoc(tipoDocumento);
                sqlbollo = sqlbollo + " where id = " + id;
                ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sqlbollo);
                if (list.size() > 0) {
                    this.speseBolloSiNo = cu.toBoolean(((Map)list.get(0)).get("bollo_presente"));
                    if (this.speseBolloSiNo) {
                        this.speseBollo = cu.toDouble0(((Map)list.get(0)).get("marca_da_bollo"));
                    }
                }
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        try {
            Map mapSconti = (Map)listSconti.get(0);
            this.setScontoTestata1(cu.d0(mapSconti.get("sconto1")));
            this.setScontoTestata2(cu.d0(mapSconti.get("sconto2")));
            this.setScontoTestata3(cu.d0(mapSconti.get("sconto3")));
            this.setSpeseTrasporto(cu.d0(mapSconti.get("spese_trasporto")));
            this.setSpeseVarieImponibili(cu.d0(mapSconti.get("spese_varie")));
            this.setSpeseIncasso(cu.d0(mapSconti.get("spese_incasso")));
            this.setData((Date)cu.toDate(mapSconti.get("data")));
            if (tipoDocumento.equals(Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO) || tipoDocumento.equals(Db.TIPO_DOCUMENTO_DDT_ACQUISTO)) {
                this.setCodiceCliente(cu.toLong0(mapSconti.get("fornitore")));
            } else {
                this.setCodiceCliente(cu.toLong0(mapSconti.get("cliente")));
            }
            if (!cu.s(mapSconti.get("prezzi_ivati")).equalsIgnoreCase("N")) {
                this.setPrezziIvati(true);
            }
            this.setSconto(cu.d0(mapSconti.get("sconto")));
            this.setAcconto(cu.d0(mapSconti.get("acconto")));
        }
        catch (Exception err) {
            return false;
        }
        return true;
    }

    public boolean loadScontrini(Db db, String tipoDocumento, Integer id) {
        this.db = db;
        String sql = "select sconto1,sconto2,sconto3, spese_varie, spese_trasporto, spese_incasso";
        sql = sql + ", cliente from test_fatt";
        this.sqlPerSconti = sql = sql + " where id = " + id;
        sql = "select sum(round((ifnull(prezzo,0) * ifnull(quantita,0)) * (1-ifnull(sconto1,0)/100) * (1-ifnull(sconto2,0)/100),2)) as totaImpo, prezzo, quantita, sconto1, sconto2, iva, percentuale, codici_iva.descrizione,codici_iva.descrizione_breve";
        sql = sql + ", sum(ifnull(quantita,0)) as quantita";
        sql = sql + ", sum(round((ifnull(prezzo,0) * ifnull(quantita,0)),2)) as lordo";
        sql = sql + ", iva_deducibile";
        sql = sql + " from ";
        sql = sql + "righ_fatt";
        sql = sql + " left join codici_iva on iva = codice";
        sql = sql + " where id_padre = " + id;
        this.sqlPerDettagliIva = sql = sql + " group by id";
        sql = "select ifnull(quantita,0) as quantita, a.peso_kg as peso ";
        sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)) * (1-ifnull(sconto1,0)/100) * (1-ifnull(sconto2,0)/100),2) as impo";
        sql = sql + ", flag_ritenuta";
        sql = sql + ", flag_rivalsa";
        sql = sql + ", round((ifnull(prezzo,0) * ifnull(quantita,0)),2) as lordo";
        sql = sql + " from ";
        sql = sql + "righ_fatt";
        sql = sql + " r left join articoli a on r.codice_articolo = a.codice";
        this.sqlPerDettagli = sql = sql + " where id_padre = " + id;
        try {
            ResultSet resuSconti = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerSconti);
            if (!resuSconti.next()) {
                DbUtils.close((ResultSet)resuSconti);
                return false;
            }
            this.setScontoTestata1(resuSconti.getObject("sconto1") == null ? 0.0 : resuSconti.getDouble("sconto1"));
            this.setScontoTestata2(resuSconti.getObject("sconto2") == null ? 0.0 : resuSconti.getDouble("sconto2"));
            this.setScontoTestata3(resuSconti.getObject("sconto3") == null ? 0.0 : resuSconti.getDouble("sconto3"));
            this.setSpeseTrasporto(resuSconti.getObject("spese_trasporto") == null ? 0.0 : resuSconti.getDouble("spese_trasporto"));
            this.setSpeseVarieImponibili(resuSconti.getObject("spese_varie") == null ? 0.0 : resuSconti.getDouble("spese_varie"));
            this.setSpeseIncasso(resuSconti.getObject("spese_incasso") == null ? 0.0 : resuSconti.getDouble("spese_incasso"));
            this.setCodiceCliente(resuSconti.getObject("cliente") == null ? 0L : resuSconti.getLong("cliente"));
            DbUtils.close((ResultSet)resuSconti);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
        return true;
    }

    public void caricaCliente(long codice) {
        this.cliente = new Cliente(codice);
    }

    public synchronized void calcolaTotali() {
        this.calcolaTotali(null);
        this.visualizzaCastellettoIva();
    }

    public synchronized void calcolaTotali(String iva_spese) {
        if (StringUtils.isBlank((String)this.sqlPerDettagli)) {
            return;
        }
        this.setTotale_rivalsa(0.0);
        this.calcolaTotaliSub(iva_spese, 1);
        if (this.getRivalsa_inps_perc() != null || this.ritenuta > 0) {
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleImponibilePerRitenuta = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleIvatoPerRitenuta = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleImponibilePerRitenuta += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleIvatoPerRitenuta += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
            if (this.getRivalsa_inps_perc() != null) {
                double sommeNonSoggetteRivalsa = 0.0;
                try {
                    ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
                    if (resuDett != null) {
                        while (resuDett.next()) {
                            if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_rivalsa"), (String)"N")) continue;
                            sommeNonSoggetteRivalsa += resuDett.getDouble("impo");
                        }
                        DbUtils.close((ResultSet)resuDett);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setTotaleImponibilePerRivalsa(this.totaleImponibile - sommeNonSoggetteRivalsa);
                this.setTotale_rivalsa(Util.round(this.getTotaleImponibilePerRivalsa() / 100.0 * this.getRivalsa_inps_perc(), 2));
                if (main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa", true).booleanValue()) {
                    this.totaleImponibilePerRitenuta += this.getTotale_rivalsa();
                }
            }
            try {
                ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
                while (resuDett.next()) {
                    if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_ritenuta"), (String)"N")) continue;
                    this.imponibile = resuDett.getDouble("impo") - resuDett.getDouble("impo") / 100.0 * this.scontoTestata1;
                    this.imponibile -= this.imponibile / 100.0 * this.scontoTestata2;
                    this.imponibile -= this.imponibile / 100.0 * this.scontoTestata3;
                    this.imponibile = Util.round(this.imponibile, 2);
                    this.totaleImponibilePerRitenuta -= this.imponibile;
                    this.ivato = resuDett.getDouble("ivato") - resuDett.getDouble("ivato") / 100.0 * this.scontoTestata1;
                    this.ivato -= this.ivato / 100.0 * this.scontoTestata2;
                    this.ivato -= this.ivato / 100.0 * this.scontoTestata3;
                    this.ivato = Util.round(this.ivato, 2);
                    this.totaleIvatoPerRitenuta -= this.ivato;
                }
                DbUtils.close((ResultSet)resuDett);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.totaleImponibileParziale = this.totaleImponibile;
            this.totaleIvatoParziale = this.totaleIvato;
        }
        this.calcolaTotaliSub(iva_spese, 2);
        this.dettagliIva = InvoicexUtil.getIveVector(this.getDettagliIvaMap(this.dettagliIvaDedMap));
    }

    public synchronized void calcolaTotaliSub(String iva_spese, int passaggio) {
        try {
            this.caricaCliente(this.getCodiceCliente());
            this.totaleQuantita = 0.0;
            this.totalePeso = 0.0;
            this.totaleSconti = 0.0;
            if (this.sqlPerDettagli == null) {
                return;
            }
            System.out.println("sqlPerDettagli = " + this.sqlPerDettagli);
            ResultSet resuDett = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
            if (resuDett == null) {
                return;
            }
            while (resuDett.next()) {
                this.totaleQuantita += resuDett.getDouble("quantita");
                if (!StringUtils.equalsIgnoreCase((String)resuDett.getString("flag_ritenuta"), (String)"N")) {
                    this.totaleSconti += resuDett.getDouble("lordo") - this.imponibile;
                    this.totaleSconti += resuDett.getDouble("lordoIvato") - this.ivato;
                }
                try {
                    double pesoriga = resuDett.getDouble("quantita") * resuDett.getDouble("peso");
                    this.totalePeso += pesoriga;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
            DbUtils.close((ResultSet)resuDett);
        }
        catch (Exception err) {
            err.printStackTrace();
            this.totaleQuantita = 0.0;
        }
        this.totaleImponibile = 0.0;
        this.totaleImponibilePositivo = 0.0;
        this.totaleIvato = 0.0;
        this.totaleIvatoPositivo = 0.0;
        double totaleImponibile_deducibile = 0.0;
        double totaleImponibile_indeducibile = 0.0;
        double totaleIvato_deducibile = 0.0;
        double totaleIvato_indeducibile = 0.0;
        boolean split_payment = false;
        if (this.tipoDocumento.equalsIgnoreCase(Db.TIPO_DOCUMENTO_FATTURA)) {
            try {
                split_payment = cu.toBoolean((Object)dbu.getObject((Connection)Db.getConn(), (String)("select split_payment from test_fatt_xmlpa where id_fattura = " + this.id_documento)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            DettaglioIva d;
            System.out.println("sqlPerDettagliIva = " + this.sqlPerDettagliIva);
            ResultSet resuTota = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagliIva);
            this.dettagliIvaDedMap.clear();
            while (resuTota.next()) {
                if (main.fileIni.getValueBoolean("pref", "attivaArrotondamento", false).booleanValue()) {
                    this.setParametriArrotondamento(resuTota.getString("arrotondamento_parametro"), resuTota.getString("arrotondamento_tipo"));
                }
                String kiva = resuTota.getString("iva");
                Double ded = cu.d((Object)resuTota.getObject("iva_deducibile"));
                if (ded == null) {
                    ded = 100.0;
                }
                IvaDed kivaded = new IvaDed(kiva, ded);
                if (!StringUtils.isNotEmpty((String)kiva)) continue;
                this.imponibile = resuTota.getDouble("totaImpo");
                this.imponibile = InvoicexUtil.calcolaPrezzoArrotondato(this.imponibile, this.parametroArrotondamento, this.perDifetto);
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata1;
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata2;
                this.imponibile -= this.imponibile / 100.0 * this.scontoTestata3;
                double perc_deducibilita = resuTota.getObject("iva_deducibile") == null ? 100.0 : cu.d0((Object)resuTota.getObject("iva_deducibile"));
                double imponibile_deducibile = this.imponibile / 100.0 * perc_deducibilita;
                double imponibile_indeducibile = this.imponibile - imponibile_deducibile;
                this.totaleImponibile += this.imponibile;
                this.totaleImponibilePositivo += this.imponibile;
                totaleImponibile_deducibile += imponibile_deducibile;
                totaleImponibile_indeducibile += imponibile_indeducibile;
                this.ivato = resuTota.getDouble("totaIvato");
                this.ivato = InvoicexUtil.calcolaPrezzoArrotondato(this.ivato, this.parametroArrotondamento, this.perDifetto);
                this.ivato -= this.ivato / 100.0 * this.scontoTestata1;
                this.ivato -= this.ivato / 100.0 * this.scontoTestata2;
                this.ivato -= this.ivato / 100.0 * this.scontoTestata3;
                double ivato_deducibile = this.ivato / 100.0 * perc_deducibilita;
                double ivato_indeducibile = this.ivato - ivato_deducibile;
                this.totaleIvato += this.ivato;
                this.totaleIvatoPositivo += this.ivato;
                totaleIvato_deducibile += ivato_deducibile;
                totaleIvato_indeducibile += ivato_indeducibile;
                DettaglioIva diva = this.dettagliIvaDedMap.get(kivaded);
                if (diva == null) {
                    diva = new DettaglioIva();
                    diva.setCodice(kiva);
                    diva.setPerc_deducibilita(ded);
                    diva.setDescrizione(resuTota.getString("descrizione"));
                    diva.setDescrizioneBreve(resuTota.getString("descrizione_breve"));
                    diva.setPercentuale(resuTota.getDouble("percentuale"));
                }
                diva.setImponibile(cu.d0((Object)diva.getImponibile()) + this.imponibile);
                diva.setImponibile_deducibile(cu.d0((Object)diva.getImponibile_deducibile()) + imponibile_deducibile);
                diva.setImponibile_indeducibile(cu.d0((Object)diva.getImponibile_indeducibile()) + imponibile_indeducibile);
                diva.imponibile_noarr = cu.d0((Object)diva.getImponibile());
                diva.setIvato(cu.d0((Object)diva.getIvato()) + this.ivato);
                diva.setIvato_deducibile(cu.d0((Object)diva.getIvato_deducibile()) + ivato_deducibile);
                diva.setIvato_indeducibile(cu.d0((Object)diva.getIvato_indeducibile()) + ivato_indeducibile);
                diva.ivato_noarr = cu.d0((Object)diva.getIvato());
                this.dettagliIvaDedMap.put(kivaded, diva);
            }
            DbUtils.close((ResultSet)resuTota);
            for (IvaDed ivadedkey : this.dettagliIvaDedMap.keySet()) {
                DettaglioIva d2 = this.dettagliIvaDedMap.get(ivadedkey);
                d2.setImponibile(Util.round(d2.getImponibile(), 2));
                d2.setIvato(Util.round(d2.getIvato(), 2));
                d2.setImponibile_deducibile(Util.round(d2.getImponibile_deducibile(), 2));
                d2.setImponibile_indeducibile(Util.round(d2.getImponibile_indeducibile(), 2));
                d2.setIvato_deducibile(Util.round(d2.getIvato_deducibile(), 2));
                d2.setIvato_indeducibile(Util.round(d2.getIvato_indeducibile(), 2));
            }
            String codiceIvaSpese = "";
            Iva ivaSpese = new Iva();
            codiceIvaSpese = iva_spese == null ? InvoicexUtil.getIvaSpesePerData(this.data, "codiceIvaSpese") : iva_spese;
            if (ivaSpese.load(Db.INSTANCE, codiceIvaSpese)) {
                boolean codiceIvaSpeseTrovato = false;
                this.speseImponibili = this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso;
                this.speseIvate = this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso;
                this.proporzioniIva.put(new IvaDed(ivaSpese.getCodice(), 100.0), 100.0);
                if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa_in_iva", true).booleanValue()) {
                    this.speseImponibili += this.getTotale_rivalsa();
                    this.speseIvate += this.getTotale_rivalsa() * ((ivaSpese.getPercentuale() + 100.0) / 100.0);
                }
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    DettaglioIva d3 = this.dettagliIvaDedMap.get(ivakey);
                    if (d3.getCodice().equalsIgnoreCase(codiceIvaSpese) && d3.getPerc_deducibilita() == 100.0) {
                        codiceIvaSpeseTrovato = true;
                        d3.setImponibile(d3.getImponibile() + this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                        d3.setImponibile(Util.round(d3.getImponibile(), 2));
                        d3.setImponibile_deducibile(d3.getImponibile_deducibile() + (this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso));
                        d3.setIvato(d3.getIvato() + this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                        d3.setIvato(Util.round(d3.getIvato(), 2));
                        d3.setIvato_deducibile(d3.getIvato_deducibile() + this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                        if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa_in_iva", true).booleanValue()) {
                            d3.setImponibile(d3.getImponibile() + this.getTotale_rivalsa());
                            d3.setImponibile(Util.round(d3.getImponibile(), 2));
                            d3.setImponibile_deducibile(d3.getImponibile_deducibile() + this.getTotale_rivalsa());
                            d3.setIvato(d3.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d3.getPercentuale(), 2)));
                            d3.setIvato(Util.round(d3.getIvato(), 2));
                            d3.setIvato_deducibile(d3.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * d3.getPercentuale(), 2)));
                        }
                    }
                    double imposta_deducibile = 0.0;
                    double imposta_indeducibile = 0.0;
                    if (!this.isPrezziIvati()) {
                        this.imposta_noarr = this.imposta = d3.getImponibile() / 100.0 * d3.getPercentuale();
                        this.imposta = Util.round(this.imposta, 2);
                    } else {
                        this.imposta_noarr = this.imposta = d3.getIvato() * d3.getPercentuale() / (100.0 + d3.getPercentuale());
                        this.imposta = Util.round(this.imposta, 2);
                    }
                    imposta_deducibile = Util.round(this.imposta / 100.0 * d3.getPerc_deducibilita(), 2);
                    imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                    d3.setImposta(this.imposta);
                    d3.imposta_noarr = this.imposta_noarr;
                    d3.setImposta_deducibile(imposta_deducibile);
                    d3.setImposta_indeducibile(imposta_indeducibile);
                    if (!this.isPrezziIvati()) continue;
                    d3.setImponibile(d3.getIvato() - d3.getImposta());
                    d3.setImponibile_deducibile(d3.getIvato_deducibile() - d3.getImposta_deducibile());
                    d3.setImponibile_indeducibile(d3.getIvato_indeducibile() - d3.getImposta_indeducibile());
                }
                if (!codiceIvaSpeseTrovato) {
                    DettaglioIva ds = new DettaglioIva();
                    ds.setCodice(codiceIvaSpese);
                    ds.setPercentuale(ivaSpese.getPercentuale());
                    ds.setDescrizione(ivaSpese.getDescrizione());
                    ds.setDescrizioneBreve(ivaSpese.getDescrizioneBreve());
                    ds.setImponibile(this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                    ds.setImponibile_deducibile(this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                    ds.setIvato(this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                    ds.setIvato_deducibile(this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso);
                    if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa_in_iva", true).booleanValue()) {
                        ds.setImponibile(ds.getImponibile() + this.getTotale_rivalsa());
                        ds.setImponibile(Util.round(ds.getImponibile(), 2));
                        ds.setImponibile_deducibile(ds.getImponibile_deducibile() + this.getTotale_rivalsa());
                        ds.setIvato(ds.getIvato() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                        ds.setIvato(Util.round(ds.getIvato(), 2));
                        ds.setIvato_deducibile(ds.getIvato_deducibile() + (this.getTotale_rivalsa() + Util.round(this.getTotale_rivalsa() / 100.0 * ds.getPercentuale(), 2)));
                    }
                    double imposta_deducibile = 0.0;
                    double imposta_indeducibile = 0.0;
                    if (!this.isPrezziIvati()) {
                        this.imposta_noarr = this.imposta = ds.getImponibile() / 100.0 * ivaSpese.getPercentuale();
                        this.imposta = Util.round(this.imposta, 2);
                        imposta_deducibile = Util.round(ds.getImponibile_deducibile() / 100.0 * ivaSpese.getPercentuale(), 2);
                    } else {
                        this.imposta_noarr = this.imposta = ds.getIvato() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale());
                        this.imposta = Util.round(this.imposta, 2);
                        imposta_deducibile = Util.round(ds.getIvato_deducibile() * ivaSpese.getPercentuale() / (100.0 + ivaSpese.getPercentuale()), 2);
                    }
                    ds.setImposta(this.imposta);
                    ds.setImposta_deducibile(imposta_deducibile);
                    ds.imposta_noarr = this.imposta_noarr;
                    ds.setPercentuale(ivaSpese.getPercentuale());
                    if (this.isPrezziIvati()) {
                        ds.setImponibile(ds.getIvato() - ds.getImposta());
                        ds.setImponibile_deducibile(ds.getIvato_deducibile() - ds.getImposta_deducibile());
                    }
                    if (ds.getImponibile() != 0.0) {
                        ds.setPerc_deducibilita(100.0);
                        this.dettagliIvaDedMap.put(new IvaDed(codiceIvaSpese, 100.0), ds);
                    }
                }
                this.totaleImponibile = 0.0;
                this.totaleImponibilePositivo = 0.0;
                this.totaleIvato = 0.0;
                this.totaleIvatoPositivo = 0.0;
                this.totaleImposta = 0.0;
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    DettaglioIva d4 = this.dettagliIvaDedMap.get(ivakey);
                    this.totaleImponibile += d4.getImponibile();
                    this.totaleImponibilePositivo += d4.getImponibile();
                    this.totaleIvato += d4.getIvato();
                    this.totaleIvatoPositivo += d4.getIvato();
                    this.totaleImposta += d4.getImposta();
                }
            } else {
                DettaglioIva d5;
                this.speseImponibili = this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso;
                this.speseIvate = this.speseTrasporto + this.speseVarieImponibili + this.speseIncasso;
                if (this.getRivalsa_inps_perc() != null && this.getRivalsa_inps_perc() != 0.0 && main.fileIni.getValueBoolean("pluginRitenute", "includi_rivalsa_in_iva", true).booleanValue()) {
                    boolean trovata_iva_std = false;
                    double iva_std = 22.0;
                    if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2011, (int)9, (int)17))) {
                        iva_std = 20.0;
                    } else if (this.data != null && this.data.before(DateUtils.getOnlyDate((int)2013, (int)10, (int)1))) {
                        iva_std = 21.0;
                    }
                    for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                        DettaglioIva d6 = this.dettagliIvaDedMap.get(ivakey);
                        if (d6.getPercentuale() != iva_std) continue;
                        trovata_iva_std = true;
                        break;
                    }
                    if (trovata_iva_std) {
                        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                            DettaglioIva d7 = this.dettagliIvaDedMap.get(ivakey);
                            if (d7.getPercentuale() != iva_std) continue;
                            d7.setImponibile(d7.getImponibile() + this.getTotale_rivalsa());
                            this.imposta_noarr = this.imposta = d7.getImponibile() / 100.0 * d7.getPercentuale();
                            this.imposta = Util.round(this.imposta, 2);
                            double imposta_deducibile = Util.round(d7.getImponibile_deducibile() / 100.0 * d7.getPercentuale(), 2);
                            d7.setImposta(this.imposta);
                            d7.setImponibile_deducibile(imposta_deducibile);
                            d7.setIvato(d7.getImponibile() + this.imposta);
                            d7.setIvato_deducibile(d7.getImponibile_deducibile() + imposta_deducibile);
                            break;
                        }
                    } else if (!this.isPrezziIvati()) {
                        this.speseImponibili += this.getTotale_rivalsa();
                    } else {
                        this.speseIvate += this.getTotale_rivalsa() * this.getIvaMedia(this.dettagliIvaDedMap);
                    }
                }
                this.totaleImponibile = 0.0;
                this.totaleImponibilePositivo = 0.0;
                this.totaleIvato = 0.0;
                this.totaleIvatoPositivo = 0.0;
                this.totaleImposta = 0.0;
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    DettaglioIva d8 = this.dettagliIvaDedMap.get(ivakey);
                    this.totaleImponibile += d8.getImponibile();
                    this.totaleImponibilePositivo += d8.getImponibile();
                    this.totaleIvato += d8.getIvato();
                    this.totaleIvatoPositivo += d8.getIvato();
                    this.totaleImposta += d8.getImposta();
                }
                Map<String, DettaglioIva> dettagliIvaMap = this.getDettagliIvaMap(this.dettagliIvaDedMap);
                for (String ivakeycodice : this.getDettagliIvaMap(this.dettagliIvaDedMap).keySet()) {
                    DettaglioIva d2;
                    d5 = dettagliIvaMap.get(ivakeycodice);
                    double importoSpeseRipartito = 0.0;
                    double nuovoImponibile = 0.0;
                    double nuovoIvato = 0.0;
                    if (!this.isPrezziIvati()) {
                        importoSpeseRipartito = this.speseImponibili * d5.getImponibile() / this.totaleImponibilePositivo;
                        d2 = this.getDetIva(ivakeycodice, 100.0);
                        if (d2 == null) {
                            d2 = new DettaglioIva();
                            d2.setCodice(ivakeycodice);
                            d2.setDescrizione(d5.getDescrizione());
                            d2.setDescrizioneBreve(d5.getDescrizioneBreve());
                            d2.setPercentuale(d5.getPercentuale());
                            d2.setPerc_deducibilita(100.0);
                        }
                        nuovoImponibile = !Double.isNaN(importoSpeseRipartito) ? cu.d0((Object)d2.getImponibile()) + importoSpeseRipartito : cu.d0((Object)d2.getImponibile());
                        this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d5.getPercentuale();
                        this.imposta = Util.round(this.imposta, 2);
                        d2.imponibile_noarr = nuovoImponibile;
                        nuovoImponibile = Util.round(nuovoImponibile, 2);
                        d2.setImponibile(nuovoImponibile);
                        d2.setImposta(this.imposta);
                        d2.imposta_noarr = this.imposta_noarr;
                        this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
                        continue;
                    }
                    importoSpeseRipartito = this.speseIvate * d5.getIvato() / this.totaleIvatoPositivo;
                    d2 = this.getDetIva(ivakeycodice, 100.0);
                    if (d2 == null) {
                        d2 = new DettaglioIva();
                        d2.setCodice(ivakeycodice);
                        d2.setDescrizione(d5.getDescrizione());
                        d2.setDescrizioneBreve(d5.getDescrizioneBreve());
                        d2.setPercentuale(d5.getPercentuale());
                        d2.setPerc_deducibilita(100.0);
                    }
                    nuovoIvato = !Double.isNaN(importoSpeseRipartito) ? d2.getIvato() + importoSpeseRipartito : d2.getIvato();
                    this.imposta_noarr = this.imposta = nuovoIvato * d5.getPercentuale() / (100.0 + d5.getPercentuale());
                    this.imposta = Util.round(this.imposta, 2);
                    d2.ivato_noarr = nuovoIvato;
                    nuovoIvato = Util.round(nuovoIvato, 2);
                    d2.setIvato(nuovoIvato);
                    d2.setImposta(this.imposta);
                    d2.setImponibile(nuovoIvato - this.imposta);
                    d2.imposta_noarr = this.imposta_noarr;
                    this.dettagliIvaDedMap.put(new IvaDed(ivakeycodice, 100.0), d2);
                }
                this.totaleImponibile = 0.0;
                this.totaleImponibilePositivo = 0.0;
                this.totaleIvato = 0.0;
                this.totaleIvatoPositivo = 0.0;
                this.totaleImposta = 0.0;
                for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                    d5 = this.dettagliIvaDedMap.get(ivakey);
                    this.totaleImponibile += d5.getImponibile();
                    this.totaleImponibilePositivo += d5.getImponibile();
                    this.totaleIvato += d5.getIvato();
                    this.totaleIvatoPositivo += d5.getIvato();
                    this.totaleImposta += d5.getImposta();
                }
            }
            this.totaleImponibilePreSconto = this.totaleImponibile;
            this.totaleIvatoPreSconto = this.totaleIvato;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                double imposta_indeducibile;
                double imposta_deducibile;
                double perc_sconto;
                d = this.dettagliIvaDedMap.get(ivakey);
                double scontoRipartito = 0.0;
                double nuovoImponibile = 0.0;
                double nuovoIvato = 0.0;
                if (!this.isPrezziIvati()) {
                    if (passaggio == 1) {
                        scontoRipartito = this.sconto * d.getImponibile() / this.totaleImponibilePositivo;
                        this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                        if (this.totaleImponibilePositivo != 0.0) {
                            this.proporzioniIva.put(ivakey, 100.0 * d.getImponibile() / this.totaleImponibilePositivo);
                        } else {
                            this.proporzioniIva.put(ivakey, 0.0);
                        }
                    } else {
                        scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
                    }
                    nuovoImponibile = !Double.isNaN(scontoRipartito) ? d.getImponibile() - scontoRipartito : d.getImponibile();
                    perc_sconto = nuovoImponibile * 100.0 / d.getImponibile();
                    if (perc_sconto == Double.NaN) {
                        perc_sconto = 0.0;
                    }
                    this.imposta_noarr = this.imposta = nuovoImponibile / 100.0 * d.getPercentuale();
                    this.imposta = Util.round(this.imposta, 2);
                    d.imponibile_noarr = nuovoImponibile;
                    nuovoImponibile = Util.round(nuovoImponibile, 2);
                    imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                    imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                    double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
                    double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
                    d.setImponibile(nuovoImponibile);
                    d.setImponibile_deducibile(Util.round(nuovoImponibile_deducibile, 2));
                    d.setImponibile_indeducibile(Util.round(nuovoImponibile_indeducibile, 2));
                    d.setImposta(this.imposta);
                    d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
                    d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
                    d.imposta_noarr = this.imposta_noarr;
                    continue;
                }
                if (passaggio == 1) {
                    scontoRipartito = this.sconto * d.getIvato() / this.totaleIvatoPositivo;
                    this.proporzioniIvaSconto.put(ivakey, scontoRipartito);
                    if (this.totaleIvatoPositivo != 0.0) {
                        this.proporzioniIva.put(ivakey, 100.0 * d.getIvato() / this.totaleIvatoPositivo);
                    } else {
                        this.proporzioniIva.put(ivakey, 0.0);
                    }
                } else {
                    scontoRipartito = this.proporzioniIvaSconto != null && d != null ? CastUtils.toDouble0((Object)this.proporzioniIvaSconto.get(ivakey)) : 0.0;
                }
                nuovoIvato = !Double.isNaN(scontoRipartito) ? d.getIvato() - scontoRipartito : d.getIvato();
                perc_sconto = nuovoIvato * 100.0 / d.getIvato();
                this.imposta_noarr = this.imposta = nuovoIvato * d.getPercentuale() / (100.0 + d.getPercentuale());
                this.imposta = Util.round(this.imposta, 2);
                d.ivato_noarr = nuovoIvato;
                nuovoIvato = Util.round(nuovoIvato, 2);
                d.setImponibile(nuovoIvato - this.imposta);
                nuovoImponibile = nuovoIvato - this.imposta;
                imposta_deducibile = Util.round(this.imposta / 100.0 * d.getPerc_deducibilita(), 2);
                imposta_indeducibile = Util.round(this.imposta - imposta_deducibile, 2);
                double nuovoIvato_deducibile = Util.round(nuovoIvato / 100.0 * d.getPerc_deducibilita(), 2);
                double nuovoIvato_indeducibile = Util.round(nuovoIvato - nuovoIvato_deducibile, 2);
                double nuovoImponibile_deducibile = Util.round(nuovoImponibile / 100.0 * d.getPerc_deducibilita(), 2);
                double nuovoImponibile_indeducibile = Util.round(nuovoImponibile + this.imposta - nuovoImponibile_deducibile - imposta_deducibile - imposta_indeducibile, 2);
                d.setIvato(nuovoIvato);
                d.setImposta(this.imposta);
                d.setImposta_deducibile(Util.round(imposta_deducibile, 2));
                d.setImposta_indeducibile(Util.round(imposta_indeducibile, 2));
                d.setImponibile_deducibile(nuovoImponibile_deducibile);
                d.setImponibile_indeducibile(nuovoImponibile_indeducibile);
                d.setIvato_deducibile(nuovoIvato_deducibile);
                d.setIvato_indeducibile(nuovoIvato_indeducibile);
                d.imposta_noarr = this.imposta_noarr;
            }
            this.totaleImponibile = 0.0;
            this.totaleImponibilePositivo = 0.0;
            this.totaleIvato = 0.0;
            this.totaleIvatoPositivo = 0.0;
            this.totaleImposta = 0.0;
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                this.totaleImponibile += d.getImponibile();
                this.totaleImponibilePositivo += d.getImponibile();
                this.totaleIvato += d.getIvato();
                this.totaleIvatoPositivo += d.getIvato();
                this.totaleImposta += d.getImposta();
            }
            this.totaleImponibile = Util.round(this.totaleImponibile, 2);
            this.totaleImponibilePositivo = Util.round(this.totaleImponibilePositivo, 2);
            this.totaleIvato = Util.round(this.totaleIvato, 2);
            this.totaleIvatoPositivo = Util.round(this.totaleIvatoPositivo, 2);
            this.totaleIva = this.totaleImposta = Util.round(this.totaleImposta, 2);
            this.totale = !this.isPrezziIvati() ? this.totaleImponibile + this.totaleImposta : this.totaleIvato;
            this.totaleSconti = this.totaleSconti;
            this.ritenuta_perc = 0.0;
            this.ritenuta_descrizione = "";
            this.totale_ritenuta = 0.0;
            this.totale_da_pagare = 0.0;
            this.totale_da_pagare_finale = 0.0;
            if (this.ritenuta > 0) {
                try {
                    ResultSet r = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)("select * from tipi_ritenuta where id = " + this.ritenuta));
                    if (r.next()) {
                        this.ritenuta_perc = r.getDouble("percentuale");
                        this.ritenuta_descrizione = r.getString("descrizione");
                        this.totale_ritenuta = Util.round(this.totaleImponibilePerRitenuta / 100.0 * this.ritenuta_perc, 2);
                        this.totale_da_pagare = this.totale - this.totale_ritenuta;
                        if (main.fileIni.getValueBoolean("pluginRitenute", "sottrai_rivalsa", false).booleanValue()) {
                            this.totale_da_pagare -= this.totale_rivalsa;
                        }
                    } else {
                        System.err.println("problema nel calcolo totale, manca ritenuta (" + this.ritenuta + ") in tabella");
                        this.totale_da_pagare = this.totale - this.totale_ritenuta;
                        if (main.fileIni.getValueBoolean("pluginRitenute", "sottrai_rivalsa", false).booleanValue()) {
                            this.totale_da_pagare -= this.totale_rivalsa;
                        }
                    }
                    DbUtils.close((ResultSet)r);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            } else {
                this.totale_da_pagare = this.totale;
                if (main.fileIni.getValueBoolean("pluginRitenute", "sottrai_rivalsa", false).booleanValue()) {
                    this.totale_da_pagare -= this.totale_rivalsa;
                }
            }
            if (passaggio > 1 && this.speseBolloSiNo) {
                this.speseBollo = cu.d0((Object)this.speseBollo);
                IvaDed codiceIvaBollo = new IvaDed("15", 100.0);
                Iva ivaBollo = new Iva();
                if (!ivaBollo.load(Db.INSTANCE, codiceIvaBollo.codice_iva)) {
                    ivaBollo.setCodice(codiceIvaBollo.codice_iva);
                    ivaBollo.setPercentuale(0.0);
                    ivaBollo.setDescrizione("Escluso art. 15");
                    ivaBollo.setDescrizioneBreve("Escluso art. 15");
                }
                DettaglioIva divabollo = null;
                if (this.dettagliIvaDedMap.containsKey(codiceIvaBollo)) {
                    divabollo = this.dettagliIvaDedMap.get(codiceIvaBollo);
                } else {
                    divabollo = new DettaglioIva();
                    divabollo.setCodice(codiceIvaBollo.codice_iva);
                    divabollo.setPerc_deducibilita(100.0);
                    divabollo.setDescrizione(ivaBollo.getDescrizione());
                    divabollo.setDescrizioneBreve(ivaBollo.getDescrizioneBreve());
                    divabollo.setPercentuale(ivaBollo.getPercentuale());
                }
                double imposta = this.speseBollo / 100.0 * ivaBollo.getPercentuale();
                imposta = Util.round(imposta, 2);
                divabollo.setImponibile(cu.d0((Object)divabollo.getImponibile()) + this.speseBollo);
                divabollo.setImponibile_deducibile(cu.d0((Object)divabollo.getImponibile_deducibile()) + this.speseBollo);
                divabollo.setImposta(imposta);
                divabollo.setImposta_deducibile(cu.d0((Object)divabollo.getImposta_deducibile()) + imposta);
                divabollo.setIvato(divabollo.getIvato() + this.speseBollo + imposta);
                this.dettagliIvaDedMap.put(codiceIvaBollo, divabollo);
                this.totaleImponibile += this.speseBollo.doubleValue();
                this.totale += this.speseBollo + imposta;
                this.totaleIvato += this.speseBollo + imposta;
                this.totaleIva += imposta;
                this.totaleImposta += imposta;
                this.totale_da_pagare += this.speseBollo + imposta;
                this.totale_da_pagare_finale += this.speseBollo + imposta;
            }
            System.out.println("calcolo deds");
            for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
                d = this.dettagliIvaDedMap.get(ivakey);
                d.setImponibile_deducibile(Util.round(d.getImponibile() - d.getImponibile_indeducibile(), 2));
                d.setImposta_deducibile(Util.round(d.getImposta() - d.getImposta_indeducibile(), 2));
            }
            this.totale_da_pagare_finale = this.totale_da_pagare - this.acconto;
            if (split_payment) {
                this.totale_da_pagare_finale -= this.totaleImposta;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public double getImpIvaNonDeducibile() {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImposta_indeducibile();
        }
        return ret;
    }

    public double getImpIvaNonDeducibileOld() throws SQLException, Exception {
        ResultSet dettagli = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
        double impDeducibile = 0.0;
        while (dettagli.next()) {
            String iva = CastUtils.toString((Object)dettagli.getString("iva"));
            Double ivaPerc = 0.0;
            ResultSet dettaglioIva = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)("SELECT percentuale FROM codici_iva WHERE codice = '" + iva + "'"));
            if (dettaglioIva.next()) {
                ivaPerc = dettaglioIva.getDouble("percentuale");
            }
            DbUtils.close((ResultSet)dettaglioIva);
            double imponibile = CastUtils.toDouble0((Object)dettagli.getDouble("impo"));
            if (this.scontoTestata1 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata1;
            }
            if (this.scontoTestata2 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata2;
            }
            if (this.scontoTestata3 != 0.0) {
                imponibile -= imponibile / 100.0 * this.scontoTestata3;
            }
            if (this.sconto > 0.0) {
                double sconto_proporzionato = 0.0;
                sconto_proporzionato = !this.prezziIvati ? imponibile * this.sconto / this.totaleImponibilePreSconto : imponibile * this.sconto / this.totaleIvatoPreSconto;
                imponibile -= sconto_proporzionato;
            }
            Double imposta = CastUtils.toDouble0((Object)imponibile) * ivaPerc / 100.0;
            Double percDedu = 100.0;
            if (dettagli.getObject("iva_deducibile") != null) {
                percDedu = CastUtils.toDouble0((Object)dettagli.getDouble("iva_deducibile"));
            }
            Double deducibile = imposta - imposta * (percDedu / 100.0);
            impDeducibile += deducibile.doubleValue();
            System.out.println("dettagli: " + dettagli.getDouble("iva_deducibile"));
        }
        DbUtils.close((ResultSet)dettagli);
        return impDeducibile;
    }

    public double getImpNonDeducibile() throws SQLException, Exception {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            ret += d.getImponibile_indeducibile();
        }
        return ret;
    }

    public double getImpNonDeducibileOld() throws SQLException, Exception {
        ResultSet dettagli = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)this.sqlPerDettagli);
        double impDeducibile = 0.0;
        while (dettagli.next()) {
            Double imponibile = CastUtils.toDouble0((Object)dettagli.getDouble("impo"));
            if (this.scontoTestata1 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata1;
            }
            if (this.scontoTestata2 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata2;
            }
            if (this.scontoTestata3 != 0.0) {
                imponibile = imponibile - imponibile / 100.0 * this.scontoTestata3;
            }
            if (this.sconto > 0.0) {
                double sconto_proporzionato = 0.0;
                sconto_proporzionato = !this.prezziIvati ? imponibile * this.sconto / this.totaleImponibilePreSconto : imponibile * this.sconto / this.totaleIvatoPreSconto;
                imponibile = imponibile - sconto_proporzionato;
            }
            Double percDedu = 100.0;
            if (dettagli.getObject("iva_deducibile") != null) {
                percDedu = CastUtils.toDouble0((Object)dettagli.getDouble("iva_deducibile"));
            }
            Double deducibile = imponibile - imponibile * (percDedu / 100.0);
            impDeducibile += deducibile.doubleValue();
            System.out.println("dettagli: " + dettagli.getDouble("iva_deducibile"));
        }
        DbUtils.close((ResultSet)dettagli);
        return impDeducibile;
    }

    public double getImpIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile_deducibile();
        }
        return ret;
    }

    public double getIvaDeducibile(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta_deducibile();
        }
        return ret;
    }

    public double getImpIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImponibile();
        }
        return ret;
    }

    public double getIva(String codiceIva) {
        double ret = 0.0;
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            if (!d.getCodice().equalsIgnoreCase(codiceIva)) continue;
            ret += d.getImposta();
        }
        return ret;
    }

    public void visualizzaCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\t percentuale\t imponibile\t imposta\t\t\t imponibile_noarr\t imposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        System.out.println(temp);
    }

    public String dumpCastellettoIva() {
        String temp = "Castelletto Iva\n";
        temp = temp + "codice\tdescrizione\tpercentuale\timponibile\timposta\t\t\timponibile_noarr\timposta_noarr\n";
        for (IvaDed ivakey : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva d = this.dettagliIvaDedMap.get(ivakey);
            temp = temp + d.getCodice();
            temp = temp + "\t" + d.getDescrizione();
            temp = temp + "\t" + d.getPercentuale() + " (ded.:" + d.getPerc_deducibilita() + ")";
            temp = temp + "\t" + d.getImponibile();
            temp = temp + "\t" + d.getImposta();
            temp = temp + "\t\t\t" + d.imponibile_noarr;
            temp = temp + "\t" + d.imposta_noarr;
            temp = temp + "\n";
        }
        temp = temp + "totaleiva " + this.totaleIva;
        temp = temp + "\t totaleimp " + this.totaleImponibile;
        temp = temp + "\t totale    " + this.totale;
        temp = temp + "\n";
        return temp;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public double getScontoTestata1() {
        return this.scontoTestata1;
    }

    public void setScontoTestata1(double scontoTestata1) {
        this.scontoTestata1 = scontoTestata1;
    }

    public double getScontoTestata2() {
        return this.scontoTestata2;
    }

    public void setParametriArrotondamento(String arrotondamentoParametro, String arrotondamentoTipo) {
        this.parametroArrotondamento = Double.parseDouble(arrotondamentoParametro);
        this.perDifetto = arrotondamentoTipo.equals("Inf.");
    }

    public void setScontoTestata2(double scontoTestata2) {
        this.scontoTestata2 = scontoTestata2;
    }

    public double getScontoTestata3() {
        return this.scontoTestata3;
    }

    public void setScontoTestata3(double scontoTestata3) {
        this.scontoTestata3 = scontoTestata3;
    }

    public double getTotaleSconti() {
        return this.totaleSconti;
    }

    public void setTotaleSconti(double totaleSconti) {
        this.totaleSconti = totaleSconti;
    }

    public double getTotale() {
        return this.totale;
    }

    public void setTotale(double totale) {
        this.totale = totale;
    }

    public double getTotaleQuantita() {
        return this.totaleQuantita;
    }

    public double getTotaleIva() {
        return this.totaleIva;
    }

    public void setTotaleIva(double totaleIva) {
        this.totaleIva = totaleIva;
    }

    public double getTotaleImponibile() {
        return this.totaleImponibile;
    }

    public void setTotaleImponibile(double totaleImponibile) {
        this.totaleImponibile = totaleImponibile;
    }

    public double getSpeseTrasporto() {
        return this.speseTrasporto;
    }

    public void setSpeseTrasporto(double speseTrasporto) {
        this.speseTrasporto = speseTrasporto;
    }

    public double getSpeseVarieImponibili() {
        return this.speseVarieImponibili;
    }

    public void setSpeseVarieImponibili(double speseVarieImponibili) {
        this.speseVarieImponibili = speseVarieImponibili;
    }

    public double getSpeseIncasso() {
        return this.speseIncasso;
    }

    public void setSpeseIncasso(double speseIncasso) {
        this.speseIncasso = speseIncasso;
    }

    public long getCodiceCliente() {
        return this.codiceCliente;
    }

    public void setCodiceCliente(long codiceCliente) {
        this.codiceCliente = codiceCliente;
    }

    public void setCodiceFornitore(long codiceFornitore) {
        this.codiceFornitore = codiceFornitore;
    }

    public int getRitenuta() {
        return this.ritenuta;
    }

    public void setRitenuta(int ritenuta) {
        this.ritenuta = ritenuta;
    }

    public double getTotale_ritenuta() {
        return this.totale_ritenuta;
    }

    public void setTotale_ritenuta(double totale_ritenuta) {
        this.totale_ritenuta = totale_ritenuta;
    }

    public double getTotale_da_pagare() {
        return this.totale_da_pagare;
    }

    public void setTotale_da_pagare(double totale_da_pagare) {
        this.totale_da_pagare = totale_da_pagare;
    }

    public double getTotale_da_pagare_finale() {
        return this.totale_da_pagare_finale;
    }

    public void setTotale_da_pagare_finale(double totale_da_pagare_finale) {
        this.totale_da_pagare_finale = totale_da_pagare_finale;
    }

    public double getAcconto() {
        return this.acconto;
    }

    public void setAcconto(double acconto) {
        this.acconto = acconto;
    }

    public double getRitenuta_perc() {
        return this.ritenuta_perc;
    }

    public void setRitenuta_perc(double ritenuta_perc) {
        this.ritenuta_perc = ritenuta_perc;
    }

    public String getRitenuta_descrizione() {
        return this.ritenuta_descrizione;
    }

    public void setRitenuta_descrizione(String ritenuta_descrizione) {
        this.ritenuta_descrizione = ritenuta_descrizione;
    }

    public boolean isRivalsa_inps() {
        return this.rivalsa_inps;
    }

    public void setRivalsa_inps(boolean rivalsa_inps) {
        this.rivalsa_inps = rivalsa_inps;
    }

    public void setRivalsaCodice(Integer codRivalsa) {
        if (!codRivalsa.equals("")) {
            this.rivalsa_codice = codRivalsa;
        }
    }

    public double getTotale_rivalsa() {
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < this.totale_rivalsa) {
                return massimale;
            }
        }
        return this.totale_rivalsa;
    }

    public void setTotale_rivalsa(double totale_rivalsa) {
        this.totale_rivalsa = totale_rivalsa;
        double massimale = 0.0;
        if (this.rivalsa_codice != null && this.rivalsa_codice != -1) {
            try {
                massimale = CastUtils.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT massimale FROM tipi_rivalsa WHERE id = " + Db.pc(this.rivalsa_codice, 4))));
            }
            catch (Exception ex) {
                massimale = 0.0;
            }
            if (massimale != 0.0 && massimale < totale_rivalsa) {
                this.totale_rivalsa = massimale;
            }
        }
    }

    public double getTotale_imponibile2() {
        return this.totale_imponibile2;
    }

    public void setTotale_imponibile2(double totale_imponibile2) {
        this.totale_imponibile2 = totale_imponibile2;
    }

    public double getTotaleImponibileParziale() {
        return this.totaleImponibileParziale;
    }

    public void setTotaleImponibileParziale(double totaleImponibileParziale) {
        this.totaleImponibileParziale = totaleImponibileParziale;
    }

    public Double getRivalsa_inps_perc() {
        return this.rivalsa_inps_perc;
    }

    public void setRivalsa_inps_perc(Double rivalsa_inps_perc) {
        this.rivalsa_inps_perc = rivalsa_inps_perc;
    }

    public String getRivalsa_inps_descrizione() {
        return this.rivalsa_inps_descrizione;
    }

    public void setRivalsa_inps_descrizione(String rivalsa_inps_descrizione) {
        this.rivalsa_inps_descrizione = rivalsa_inps_descrizione;
    }

    public void setData(Date date) {
        this.data = date;
    }

    public boolean isPrezziIvati() {
        return this.prezziIvati;
    }

    public void setPrezziIvati(boolean prezziIvati) {
        this.prezziIvati = prezziIvati;
    }

    public double getTotaleIvatoParziale() {
        return this.totaleIvatoParziale;
    }

    public void setTotaleIvatoParziale(double totaleIvatoParziale) {
        this.totaleIvatoParziale = totaleIvatoParziale;
    }

    public double getTotaleIvato() {
        return this.totaleIvato;
    }

    public void setTotaleIvato(double totaleIvato) {
        this.totaleIvato = totaleIvato;
    }

    public double getSconto() {
        return this.sconto;
    }

    public void setSconto(double sconto) {
        this.sconto = sconto;
    }

    public double getTotaleImponibilePerRivalsa() {
        return this.totaleImponibilePerRivalsa;
    }

    public void setTotaleImponibilePerRivalsa(double totaleImponibilePerRivalsa) {
        this.totaleImponibilePerRivalsa = totaleImponibilePerRivalsa;
    }

    private Map<String, DettaglioIva> getDettagliIvaMap(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        LinkedHashMap<String, DettaglioIva> dettagliIvaMap = new LinkedHashMap<String, DettaglioIva>();
        for (IvaDed key : dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = dettagliIvaDedMap.get(key);
            if (!dettagliIvaMap.containsKey(key.codice_iva.toUpperCase())) {
                dettagliIvaMap.put(key.codice_iva.toUpperCase(), new DettaglioIva());
            }
            DettaglioIva ddest = (DettaglioIva)dettagliIvaMap.get(key.codice_iva.toUpperCase());
            ddest.setImponibile(cu.d0((Object)ddest.getImponibile()) + cu.d0((Object)dsorg.getImponibile()));
            ddest.setIvato(cu.d0((Object)ddest.getIvato()) + cu.d0((Object)dsorg.getIvato()));
            ddest.setImposta(cu.d0((Object)ddest.getImposta()) + cu.d0((Object)dsorg.getImposta()));
            ddest.setCodice(dsorg.getCodice());
            ddest.setDescrizione(dsorg.getDescrizione());
            ddest.setDescrizioneBreve(dsorg.getDescrizioneBreve());
            ddest.setPercentuale(dsorg.getPercentuale());
        }
        return dettagliIvaMap;
    }

    private DettaglioIva getDetIva(String codice_iva, double perc_ded) {
        for (IvaDed key : this.dettagliIvaDedMap.keySet()) {
            DettaglioIva dsorg = this.dettagliIvaDedMap.get(key);
            if (!dsorg.getCodice().equalsIgnoreCase(codice_iva) || dsorg.getPerc_deducibilita() != perc_ded) continue;
            return dsorg;
        }
        return null;
    }

    private double getIvaMedia(Map<IvaDed, DettaglioIva> dettagliIvaDedMap) {
        Iterator<IvaDed> ivaiter = dettagliIvaDedMap.keySet().iterator();
        double totaleImponibile = 0.0;
        double totaleIvato = 0.0;
        while (ivaiter.hasNext()) {
            IvaDed ivakey = ivaiter.next();
            DettaglioIva d = dettagliIvaDedMap.get(ivakey);
            totaleImponibile += d.getImponibile();
            totaleIvato += d.getIvato();
        }
        double percmedia = totaleIvato / totaleImponibile;
        return percmedia;
    }
}

