/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.logic.provvigioni;

import it.tnx.Db;
import java.sql.ResultSet;

public class Agente {
    private ResultSet resu;
    private long codice;
    private boolean trovato = false;
    public static final String TIPO_IVA_ITALIA = "IT";
    public static final int TIPO_IVA_ITALIA_ALIQUOTA = 20;
    public static final String TIPO_IVA_ITALIA_DICITURA = "";
    public static final String TIPO_IVA_CEE = "CEE";
    public static final int TIPO_IVA_CEE_ALIQUOTA = 0;
    public static final String TIPO_IVA_CEE_DICITURA = "Non imponibile art. 41 del DL. 331/93";
    public static final String TIPO_IVA_CEE_DICITURA_ABBR = "N.i. art. 41";
    public static final String TIPO_IVA_ALTRO = "ALTRO";
    public static final int TIPO_IVA_ALTRO_ALIQUOTA = 0;
    public static final String TIPO_IVA_ALTRO_DICITURA = "Fattura Esente IVA.";
    public static final String TIPO_IVA_ALTRO_DICITURA_ABBR = "Es. Iva art. 8";
    public static final String TIPO_IVA_PAESI_CEE = "AT;BE;DK;FI;FR;DE;GB;GR;IE;LU;NL;PT;ES;SE;";

    public Agente(long codice) {
        String sql = "select * from clie_forn";
        sql = sql + " where codice = " + codice;
        ResultSet resu = Db.openResultSet(sql);
        this.codice = codice;
        this.resu = resu;
        try {
            if (resu.next()) {
                this.trovato = true;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public String get(String nomeCampo) {
        if (this.trovato) {
            try {
                if (this.resu.getString(nomeCampo) != null) {
                    return this.resu.getString(nomeCampo);
                }
                return TIPO_IVA_ITALIA;
            }
            catch (Exception err) {
                err.printStackTrace();
                return "!ERR!";
            }
        }
        return "!ERR!";
    }

    public boolean isItalian() {
        if (this.trovato) {
            try {
                if (this.resu.getString("paese") == null || this.resu.getString("paese").equalsIgnoreCase(TIPO_IVA_ITALIA) || this.resu.getString("paese").length() == 0) {
                    return true;
                }
            }
            catch (Exception err) {
                return true;
            }
        }
        return false;
    }

    public String getField(String nomeCampo) {
        if (this.trovato) {
            try {
                if (this.resu.getString(nomeCampo) != null) {
                    return this.resu.getString(nomeCampo);
                }
                return TIPO_IVA_ITALIA_DICITURA;
            }
            catch (Exception err) {
                err.printStackTrace();
                return TIPO_IVA_ITALIA_DICITURA;
            }
        }
        return TIPO_IVA_ITALIA_DICITURA;
    }

    public String getTipoIva() {
        if (this.trovato) {
            String paese = this.get("paese");
            if (paese.equalsIgnoreCase(TIPO_IVA_ITALIA) || paese.trim().length() == 0) {
                return TIPO_IVA_ITALIA;
            }
            if (TIPO_IVA_PAESI_CEE.indexOf(paese) >= 0) {
                String piva = this.get("piva_cfiscale");
                if (piva.length() > 0) {
                    return TIPO_IVA_CEE;
                }
                return TIPO_IVA_ITALIA;
            }
            return TIPO_IVA_ALTRO;
        }
        return TIPO_IVA_ITALIA;
    }

    public int getAliquotaIva() {
        if (this.trovato) {
            String tipoIva = this.getTipoIva();
            if (tipoIva.equals(TIPO_IVA_ITALIA)) {
                return 20;
            }
            if (tipoIva.equals(TIPO_IVA_CEE)) {
                return 0;
            }
            if (tipoIva.equals(TIPO_IVA_ALTRO)) {
                return 0;
            }
            return 20;
        }
        return 20;
    }

    public String getDicituraIva() {
        if (this.trovato) {
            String tipoIva = this.getTipoIva();
            if (tipoIva.equals(TIPO_IVA_ITALIA)) {
                return TIPO_IVA_ITALIA_DICITURA;
            }
            if (tipoIva.equals(TIPO_IVA_CEE)) {
                return TIPO_IVA_CEE_DICITURA;
            }
            if (tipoIva.equals(TIPO_IVA_ALTRO)) {
                return TIPO_IVA_ALTRO_DICITURA;
            }
            return TIPO_IVA_ITALIA_DICITURA;
        }
        return TIPO_IVA_ITALIA_DICITURA;
    }

    public String getDicituraAbbrIva() {
        if (this.trovato) {
            String tipoIva = this.getTipoIva();
            if (tipoIva.equals(TIPO_IVA_ITALIA)) {
                return TIPO_IVA_ITALIA_DICITURA;
            }
            if (tipoIva.equals(TIPO_IVA_CEE)) {
                return TIPO_IVA_CEE_DICITURA_ABBR;
            }
            if (tipoIva.equals(TIPO_IVA_ALTRO)) {
                return TIPO_IVA_ALTRO_DICITURA_ABBR;
            }
            return TIPO_IVA_ITALIA_DICITURA;
        }
        return TIPO_IVA_ITALIA_DICITURA;
    }
}

