/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.logic.provvigioni;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gestioneFatture.Util;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.Db2;
import it.tnx.commons.FormatUtils;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;

public class prnStampaProvvigioniMensili {
    private Connection connection;
    private Statement stat;
    private ResultSet resu;
    private String nomeFilePdf = "";
    private String localita_azienda = "";
    public String serie;
    public int numero;
    public int anno;
    private boolean prova;
    private int numeroDistinta;
    private double totale = 0.0;
    private Table datatable;
    private int riga;
    private String data;
    private BaseFont bf;
    private BaseFont bfCour;
    private BaseFont bf_italic;
    private BaseFont bf_bold;
    private BaseFont bf_times;
    private PdfContentByte cb;
    private Document document;
    private PdfWriter writer;
    int y;
    int iy = 1;
    String agente = "";
    String periodo = "";

    public prnStampaProvvigioniMensili(String sql, String agente, String periodo) {
        this.agente = agente;
        this.periodo = periodo;
        this.nomeFilePdf = "spool" + it.tnx.Util.getDirSeparator() + "provvigioni_" + it.tnx.Util.getDateTimeFormatYYYYMMDD_HHMM() + ".pdf";
        try {
            this.stat = Db.getConn().createStatement();
            this.resu = this.stat.executeQuery(sql);
            this.report();
            this.reportView();
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
        }
    }

    int quantePagine() {
        return 1;
    }

    int quanteRighe() {
        return 30;
    }

    void report() {
        this.reportInit();
        for (int i = 0; i < this.quantePagine(); ++i) {
            this.pagina(i);
        }
        this.reportEnd();
    }

    void reportInit() {
        try {
            this.document = new Document(PageSize.A4);
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.nomeFilePdf));
            this.document.addTitle("Stampa Provvigioni");
            this.document.addAuthor("TNX");
            this.document.addHeader("Expires", "0");
            this.document.open();
            this.bf = BaseFont.createFont((String)"Helvetica", (String)"winansi", (boolean)false);
            this.bfCour = BaseFont.createFont((String)"Courier", (String)"winansi", (boolean)false);
            this.bf_italic = BaseFont.createFont((String)"Helvetica-Oblique", (String)"winansi", (boolean)false);
            this.bf_bold = BaseFont.createFont((String)"Helvetica-Bold", (String)"winansi", (boolean)false);
            this.bf_times = BaseFont.createFont((String)"Times-Roman", (String)"winansi", (boolean)false);
            this.cb = this.writer.getDirectContent();
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(null, err.toString());
        }
    }

    void reportEnd() {
        this.document.close();
    }

    void reportView() {
        try {
            Util.start(this.nomeFilePdf);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void pagina(int pagina) {
        this.sfondo();
        this.intestazione();
        this.corpo();
        this.piede();
    }

    void sfondo() {
    }

    void intestazione() {
        try {
            Image logoAzienda = Image.getInstance((byte[])InvoicexUtil.caricaLogoDaDbBytes(Db.getConn(), "logo"));
            logoAzienda.scaleToFit(200.0f, 100.0f);
            logoAzienda.setAbsolutePosition(35.0f, PageSize.A4.getHeight() - 20.0f - logoAzienda.getScaledHeight());
            this.document.add((Element)logoAzienda);
            this.document.add((Element)new Phrase("\n"));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            this.riga = 0;
            double iy = 1.25;
            double y = 4.0;
            int numColumns = 1;
            Table datatable = new Table(numColumns);
            int[] headerwidths = new int[]{100};
            datatable.setWidths(headerwidths);
            datatable.setBorderWidth(0.0f);
            datatable.setWidth(100.0f);
            datatable.setPadding(1.0f);
            datatable.setAlignment(2);
            datatable.setBorderColor(Color.RED);
            Statement statInt = Db.getConn().createStatement();
            String sqlInt = "select " + main.campiDatiAzienda + " from dati_azienda";
            ResultSet resuInt = statInt.executeQuery(sqlInt);
            resuInt.next();
            this.localita_azienda = resuInt.getString("localita");
            Cell cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga1"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga2"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga3"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga4"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga5"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga6"), ""), new Font(1, 7.0f, 0)));
            this.setLogo(cell1);
            datatable.addCell(cell1);
            this.document.add((Element)datatable);
            datatable = new Table(3);
            int[] headerwidths2 = new int[]{0, 100, 0};
            datatable.setWidths(headerwidths2);
            datatable.setBorderWidth(1.0f);
            datatable.setWidth(100.0f);
            datatable.setPadding(2.0f);
            datatable.addCell("");
            Cell temp = new Cell((Element)new Phrase("Stampa Provvigioni", new Font(1, 9.0f, 1)));
            temp.setHorizontalAlignment(1);
            datatable.addCell(temp);
            datatable.addCell("");
            this.document.add((Element)datatable);
            this.document.add((Element)new Phrase("\nAgente: " + this.agente, new Font(1, 9.0f, 1)));
            this.document.add((Element)new Phrase("\nPeriodo: " + this.periodo, new Font(1, 9.0f, 1)));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void corpo() {
        boolean continua = true;
        boolean continua1 = true;
        boolean continua2 = true;
        SimpleDateFormat df = new SimpleDateFormat();
        String oldCliente = "";
        String oldFattura = "";
        try {
            this.datatable = new Table(7);
            int[] headerwidths3 = new int[]{6, 10, 10, 5, 5, 5, 5};
            this.datatable.setWidths(headerwidths3);
            this.datatable.setBorderWidth(0.1f);
            this.datatable.setWidth(100.0f);
            this.datatable.setPadding(2.0f);
            Cell c = new Cell((Element)new Phrase("Scadenza", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Fattura", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Cliente", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Importo scadenza", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("% Provvigione", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Importo Provvigione", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Pagata", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            this.totale = 0.0;
            while (this.resu.next()) {
                c = new Cell((Element)new Phrase(it.tnx.Util.formatDataItalian(this.resu.getDate("S data scadenza")), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(this.resu.getString("serie") + this.resu.getString("numero") + " del " + it.tnx.Util.formatDataItalian(this.resu.getDate("data")), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(this.resu.getString("cliente"), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(FormatUtils.formatEuroIta((double)this.resu.getDouble("P importo")), new Font(1, 8.0f, 0)));
                this.set2(c);
                c.setHorizontalAlignment(2);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(FormatUtils.formatPerc((double)this.resu.getDouble("P %")), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(FormatUtils.formatEuroIta((double)this.resu.getDouble("P provvigione")), new Font(1, 8.0f, 0)));
                this.set2(c);
                c.setHorizontalAlignment(2);
                this.datatable.addCell(c);
                c = new Cell((Element)new Phrase(Db2.nz(this.resu.getString("P pagata"), ""), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                this.totale += this.resu.getDouble("P provvigione");
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void piede() {
        try {
            Cell c = new Cell();
            this.set2(c);
            c.setColspan(4);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Totale   \u20ac " + Db.formatValuta(this.totale), new Font(1, 8.0f, 1)));
            this.set2(c);
            c.setColspan(2);
            c.setHorizontalAlignment(2);
            this.datatable.addCell(c);
            this.document.add((Element)this.datatable);
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(null, err.toString());
        }
    }

    float cx(float x) {
        return PageSize.A4.getWidth() / 100.0f * x;
    }

    float cy(float y) {
        return PageSize.A4.getHeight() - PageSize.A4.getHeight() / 100.0f * y;
    }

    float cx(double x) {
        return PageSize.A4.getWidth() / 100.0f * (float)x;
    }

    float cy(double y) {
        return PageSize.A4.getHeight() - PageSize.A4.getHeight() / 100.0f * (float)y;
    }

    void set1(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(220, 220, 220));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    void set2(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    void set3(Cell tempPdfCell) {
        tempPdfCell.setBorderWidth(0.0f);
    }

    void setLogo(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setHorizontalAlignment(2);
        tempPdfCell.setBorderWidth(0.0f);
        tempPdfCell.setBorderWidthBottom(10.0f);
        tempPdfCell.setBorder(0);
        tempPdfCell.setBorderColor(new Color(250, 0, 0));
    }

    void setVuoto(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(255, 255, 255));
        tempPdfCell.setBorderWidth(0.0f);
        tempPdfCell.setBorder(0);
    }
}

