/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture.primaNota;

import gestioneFatture.JDialogCompilazioneReport;
import gestioneFatture.MyJasperManager;
import gestioneFatture.Reports;
import gestioneFatture.Util;
import gestioneFatture.main;
import gestioneFatture.primaNota.PrimaNotaUtils;
import gestioneFatture.primaNota.frmStampaRegistroIva;
import it.tnx.Db;
import it.tnx.SwingWorker;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public class ElaboraIva
extends SwingWorker {
    public frmStampaRegistroIva padre = null;
    public boolean xls = false;
    public JasperPrint jasperPrint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object construct() {
        JDialogCompilazioneReport dialog = new JDialogCompilazioneReport();
        dialog.setLocationRelativeTo(main.getPadreFrame());
        dialog.setVisible(true);
        main.fileIni.setValue("frm_stampa_registro_iva", "data", this.padre.comData.getSelectedItem());
        String sql = "";
        int anno = 0;
        try {
            anno = Integer.parseInt(this.padre.texAnno.getText());
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        PrimaNotaUtils pn = new PrimaNotaUtils(dialog);
        try {
            pn.generaPrimaNota(this.padre.tipoLiquidazione, this.padre.comPeriodo.getSelectedIndex() + 1, anno, this.padre.comData.getSelectedIndex() != 0, this.padre.scontrini.isSelected(), this.padre.dal.getDate(), this.padre.al.getDate(), this.padre.stampa_definitiva.isSelected());
            File frep = new File("reports/iva.jrxml");
            JasperReport jasperReport = Reports.getReport(frep);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (this.padre.radAnnuale.isSelected()) {
                parameters.put("periodo", "Anno " + this.padre.texAnno.getText());
            } else if (this.padre.radData.isSelected()) {
                parameters.put("periodo", "Dal " + DateUtils.formatDateIta((java.util.Date)this.padre.dal.getDate()) + " al " + DateUtils.formatDateIta((java.util.Date)this.padre.al.getDate()));
            } else {
                parameters.put("periodo", this.padre.comPeriodo.getSelectedItem() + " " + this.padre.texAnno.getText());
            }
            parameters.put("anno", this.padre.texAnno.getText());
            parameters.put("tipo_numerazione_pagine", this.padre.tipo_numero_pagina.getSelectedIndex());
            int pro = CastUtils.toInteger0((Object)this.padre.progressivo.getText());
            if (pro > 0) {
                --pro;
            }
            parameters.put("progressivo_partenza", pro);
            String int1 = "";
            try {
                sql = "select ragione_sociale, indirizzo, localita, cap, provincia, cfiscale, piva from dati_azienda";
                Map m = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)sql).get(0);
                int1 = int1 + m.get("ragione_sociale") + ", " + m.get("indirizzo") + ", " + m.get("cap") + " " + m.get("localita") + " (" + m.get("provincia") + "), Partita IVA " + m.get("piva") + ", Codice Fiscale " + m.get("cfiscale");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            parameters.put("intestazione1", int1);
            int codiceIva = 0;
            parameters.put("iva1", "");
            parameters.put("iva2", "");
            parameters.put("iva3", "");
            parameters.put("iva4", "");
            parameters.put("iva5", "");
            for (Map miva : pn.riva) {
                if (++codiceIva > 5) break;
                try {
                    parameters.put("iva" + codiceIva, "Aliquota " + it.tnx.Util.formatNumero0Decimali(cu.d(miva.get("percentuale"))) + " %");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            double saldo1 = 0.0;
            double saldo2 = 0.0;
            double creditoPeriodoPrec = 0.0;
            parameters.put("totaleIvaAcquisti", new Double(pn.totali.totaleAcquisti));
            parameters.put("totaleIvaVendite", new Double(pn.totali.totaleVendite));
            DebugUtils.dump(parameters);
            saldo1 = pn.totali.totaleAcquisti - pn.totali.totaleVendite;
            System.out.println("saldo1: " + saldo1);
            parameters.put("ivaSaldo1", new Double(Math.abs(saldo1)));
            creditoPeriodoPrec = it.tnx.Util.getDouble(this.padre.texIvaPrecedente.getText());
            parameters.put("ivaACreditoPeriodoPrec", new Double(creditoPeriodoPrec));
            saldo2 = saldo1 + creditoPeriodoPrec;
            parameters.put("ivaSaldo2", new Double(Math.abs(saldo2)));
            if (saldo1 < 0.0) {
                parameters.put("scrittaDebitoCredito1", "Debito");
            } else {
                parameters.put("scrittaDebitoCredito1", "Credito");
            }
            if (saldo2 < 0.0) {
                parameters.put("scrittaDebitoCredito2", "Debito");
            } else {
                parameters.put("scrittaDebitoCredito2", "Credito");
            }
            if (!this.xls) {
                Connection conn = Db.getConn();
                this.jasperPrint = MyJasperManager.fillReport(jasperReport, parameters, conn);
                InvoicexUtil.apriStampa(this.jasperPrint);
            }
            Map<String, String> colonne = Collections.synchronizedMap(new LinkedHashMap());
            colonne.put("id", "");
            colonne.put("tipo", "");
            colonne.put("data", "data doc. interno");
            colonne.put("numero_prog", "num. doc. interno");
            colonne.put("numero_doc", "num. doc. esterno");
            colonne.put("data_doc", "data doc. esterno");
            colonne.put("ragione_sociale", "");
            colonne.put("piva_cfiscale", "partita iva");
            colonne.put("totale", "");
            colonne.put("imp1", "Imponibile " + parameters.get("iva1"));
            colonne.put("iva1", "Iva " + parameters.get("iva1"));
            colonne.put("imp2", "Imponibile " + parameters.get("iva2"));
            colonne.put("iva2", "Iva " + parameters.get("iva2"));
            colonne.put("imp3", "Imponibile " + parameters.get("iva3"));
            colonne.put("iva3", "Iva " + parameters.get("iva3"));
            colonne.put("imp4", "Imponibile " + parameters.get("iva4"));
            colonne.put("iva4", "Iva " + parameters.get("iva4"));
            colonne.put("imp5", "Imponibile " + parameters.get("iva5"));
            colonne.put("iva5", "Iva " + parameters.get("iva5"));
            colonne.put("altre_imp", "Esenti/Non Imponibili/Fuori campo");
            colonne.put("imp_deducibile", "imponibile indeducibile");
            colonne.put("iva_deducibile", "iva indeducibile");
            File exportDir = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export");
            exportDir.mkdirs();
            File nomeFile = new File(SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export" + File.separator + "iva.xls");
            try {
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet("Fatture di acquisto");
                sheet.getPrintSetup().setPaperSize((short)9);
                ResultSet racq = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)"select * from stampa_iva_semplice where tipo = 'A'");
                short row_tot_acq = this.accodaXls(racq, sheet, colonne, wb);
                sheet = wb.createSheet("Fatture di vendita");
                sheet.getPrintSetup().setPaperSize((short)9);
                ResultSet rven = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)"select * from stampa_iva_semplice where tipo = 'V'");
                short row_tot_ven = this.accodaXls(rven, sheet, colonne, wb);
                sheet = wb.createSheet("Totali");
                sheet.getPrintSetup().setPaperSize((short)9);
                this.accodaXlsTotali(creditoPeriodoPrec, sheet, wb, row_tot_acq, row_tot_ven, parameters);
                FileOutputStream fileOut = new FileOutputStream(nomeFile);
                wb.write((OutputStream)fileOut);
                fileOut.close();
                Util.start2(nomeFile.getAbsolutePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SwingUtils.showErrorMessage((Component)this.padre, (String)("Errore: " + ex.getMessage()));
            }
        }
        catch (Exception err) {
            SwingUtils.showExceptionMessage((Component)this.padre, (Exception)err);
        }
        finally {
            dialog.setVisible(false);
            return null;
        }
    }

    @Override
    public void finished() {
        this.padre.setCursor(new Cursor(0));
    }

    private Short accodaXls(ResultSet rs, HSSFSheet sheet, Map colonne, HSSFWorkbook wb) {
        try {
            short contarows = 0;
            HSSFDataFormat format = wb.createDataFormat();
            HSSFRow row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            row.createCell(0).setCellValue(this.padre.getTitle());
            row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            row.createCell(0).setCellValue(sheet.getSheetName());
            row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            int columns = 0;
            columns = rs.getMetaData().getColumnCount();
            Iterator iter = colonne.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = colonne.get(key);
                String col = "";
                col = (String)value;
                if (col == null || col.length() == 0) {
                    col = (String)key;
                }
                row.createCell(i).setCellValue(col);
                i = (short)(i + 1);
            }
            HSSFCellStyle styledouble = wb.createCellStyle();
            styledouble.setDataFormat(format.getFormat("#,##0.00###"));
            HSSFCellStyle styleint = wb.createCellStyle();
            styleint.setDataFormat(format.getFormat("#,##0"));
            HSSFCellStyle styledata = wb.createCellStyle();
            styledata.setDataFormat(format.getFormat("dd/MM/yy"));
            int rowcount = 0;
            rs.last();
            rowcount = rs.getRow();
            rs.beforeFirst();
            for (int j = 0; j < rowcount; ++j) {
                row = sheet.createRow((int)contarows);
                contarows = (short)(contarows + 1);
                iter = colonne.keySet().iterator();
                i = 0;
                while (iter.hasNext()) {
                    HSSFCell cell;
                    String key = (String)iter.next();
                    String value = (String)colonne.get(key);
                    Object o = null;
                    rs.absolute(j + 1);
                    o = rs.getObject(key);
                    if (o instanceof Double) {
                        cell = row.createCell(i);
                        cell.setCellValue(((Double)o).doubleValue());
                        cell.setCellStyle(styledouble);
                    } else if (o instanceof BigDecimal) {
                        cell = row.createCell(i);
                        cell.setCellValue(((BigDecimal)o).doubleValue());
                        cell.setCellStyle(styledouble);
                    } else if (o instanceof Integer) {
                        cell = row.createCell(i);
                        cell.setCellValue((double)((Integer)o).intValue());
                        cell.setCellStyle(styleint);
                    } else if (o instanceof Date) {
                        cell = row.createCell(i);
                        cell.setCellValue((java.util.Date)((Date)o));
                        cell.setCellStyle(styledata);
                    } else if (o instanceof byte[]) {
                        cell = row.createCell(i);
                        cell.setCellValue(new String((byte[])o));
                        cell.setCellStyle(styleint);
                        row.createCell(i).setCellValue(new String((byte[])o));
                    } else if (o instanceof Long) {
                        cell = row.createCell(i);
                        cell.setCellValue((double)((Long)o).longValue());
                        cell.setCellStyle(styleint);
                    } else {
                        if (!(o instanceof String) && o != null) {
                            System.out.println(o.getClass());
                        }
                        row.createCell(i).setCellValue(CastUtils.toString((Object)o));
                    }
                    i = (short)(i + 1);
                }
            }
            row = sheet.createRow((int)contarows);
            contarows = (short)(contarows + 1);
            row = sheet.createRow((int)contarows);
            row.createCell(7).setCellValue("Totali");
            row.createCell(8).setCellFormula("SUM(I1:I" + contarows + ")");
            row.getCell(8).setCellStyle(styledouble);
            row.createCell(9).setCellFormula("SUM(J1:J" + contarows + ")");
            row.getCell(9).setCellStyle(styledouble);
            row.createCell(10).setCellFormula("SUM(K1:K" + contarows + ")");
            row.getCell(10).setCellStyle(styledouble);
            row.createCell(11).setCellFormula("SUM(L1:L" + contarows + ")");
            row.getCell(11).setCellStyle(styledouble);
            row.createCell(12).setCellFormula("SUM(M1:M" + contarows + ")");
            row.getCell(12).setCellStyle(styledouble);
            row.createCell(13).setCellFormula("SUM(N1:N" + contarows + ")");
            row.getCell(13).setCellStyle(styledouble);
            row.createCell(14).setCellFormula("SUM(O1:O" + contarows + ")");
            row.getCell(14).setCellStyle(styledouble);
            row.createCell(15).setCellFormula("SUM(P1:P" + contarows + ")");
            row.getCell(15).setCellStyle(styledouble);
            row.createCell(16).setCellFormula("SUM(Q1:Q" + contarows + ")");
            row.getCell(16).setCellStyle(styledouble);
            row.createCell(17).setCellFormula("SUM(R1:R" + contarows + ")");
            row.getCell(17).setCellStyle(styledouble);
            row.createCell(18).setCellFormula("SUM(S1:S" + contarows + ")");
            row.getCell(18).setCellStyle(styledouble);
            row.createCell(19).setCellFormula("SUM(T1:T" + contarows + ")");
            row.getCell(19).setCellStyle(styledouble);
            row.createCell(20).setCellFormula("SUM(U1:U" + contarows + ")");
            row.getCell(20).setCellStyle(styledouble);
            row.createCell(21).setCellFormula("SUM(V1:V" + contarows + ")");
            row.getCell(21).setCellStyle(styledouble);
            contarows = (short)(contarows + 1);
            return contarows;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean accodaXlsTotali(double creditoPeriodoPrec, HSSFSheet sheet, HSSFWorkbook wb, short row_tot_acq, short row_tot_ven, Map params) {
        try {
            int contarows = 0;
            HSSFDataFormat format = wb.createDataFormat();
            HSSFCellStyle styledouble = wb.createCellStyle();
            styledouble.setDataFormat(format.getFormat("#,##0.00###"));
            HSSFFormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
            HSSFRow row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row.createCell(1).setCellValue("Iva per Fatture di vendita");
            row.createCell(2).setCellFormula("'Fatture di vendita'!K" + row_tot_ven + " + 'Fatture di vendita'!M" + row_tot_ven + " + 'Fatture di vendita'!O" + row_tot_ven + " + 'Fatture di vendita'!Q" + row_tot_ven + " + 'Fatture di vendita'!S" + row_tot_ven);
            evaluator.evaluateFormulaCell((Cell)row.getCell(2));
            row.getCell(2).setCellStyle(styledouble);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row.createCell(1).setCellValue("Iva per Fatture di acquisto");
            row.createCell(2).setCellFormula("'Fatture di acquisto'!K" + row_tot_acq + " + 'Fatture di acquisto'!M" + row_tot_acq + " + 'Fatture di acquisto'!O" + row_tot_acq + " + 'Fatture di acquisto'!Q" + row_tot_acq + " + 'Fatture di acquisto'!S" + row_tot_acq);
            evaluator.evaluateFormulaCell((Cell)row.getCell(2));
            row.getCell(2).setCellStyle(styledouble);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row.createCell(1).setCellFormula("CONCATENATE(\"Iva a \",IF((C3-C4) >= 0, \"debito\", \"credito\"))");
            row.createCell(2).setCellFormula("ABS(C3-C4)");
            evaluator.evaluateFormulaCell((Cell)row.getCell(2));
            row.getCell(2).setCellStyle(styledouble);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row.createCell(1).setCellValue("Iva a credito da periodo precedente");
            row.createCell(2).setCellValue(((Double)params.get("ivaACreditoPeriodoPrec")).doubleValue());
            row.getCell(2).setCellStyle(styledouble);
            row = sheet.createRow(contarows);
            contarows = (short)(contarows + 1);
            row.createCell(1).setCellFormula("CONCATENATE(\"Iva a \",IF((C5-C6) >= 0, \"debito\", \"credito\"))");
            row.createCell(2).setCellFormula("ABS(C5-C6)");
            evaluator.evaluateFormulaCell((Cell)row.getCell(2));
            row.getCell(2).setCellStyle(styledouble);
            sheet.autoSizeColumn(1);
            sheet.autoSizeColumn(2);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

