/*
 * Decompiled with CFR 0.152.
 */
package gestioneFatture;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import gestioneFatture.CoordinateBancarie;
import gestioneFatture.Util;
import gestioneFatture.dbDocumento;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JOptionPane;

public class prnDistRb {
    private Connection connection;
    private Statement stat;
    private ResultSet resu;
    private String nomeFilePdf = "";
    private String localita_azienda = "Poggibonsi";
    public String serie;
    public int numero;
    public int anno;
    private dbDocumento prev = new dbDocumento();
    private CoordinateBancarie coord;
    private boolean prova;
    private int numeroDistinta;
    private double totale = 0.0;
    private Table datatable;
    private int riga;
    private String data;
    private BaseFont bf;
    private BaseFont bfCour;
    private BaseFont bf_italic;
    private BaseFont bf_bold;
    private BaseFont bf_times;
    private PdfContentByte cb;
    private Document document;
    private PdfWriter writer;
    int y;
    int iy = 1;
    double totaleFattura;
    double totaleScadenze;
    Vector documentiAnomali = new Vector();
    public int rispostaConferma = 0;
    public static final int RISPOSTA_CONTINUA = 0;
    public static final int RISPOSTA_ANNULLA = 1;
    Db dbUtil = new Db();

    public prnDistRb(String sql, CoordinateBancarie coord, boolean prova, int numeroDistinta, String data_distinta) {
        this.nomeFilePdf = "spool" + it.tnx.Util.getDirSeparator() + "distintaRiba_" + String.valueOf(numeroDistinta) + ".pdf";
        this.coord = coord;
        this.prova = prova;
        this.numeroDistinta = numeroDistinta;
        this.data = data_distinta;
        try {
            this.stat = Db.getConn().createStatement();
            this.resu = this.stat.executeQuery(sql);
            this.report();
            if (this.documentiAnomali.size() > 0) {
                String elencoFatture = "Elenco delle fatture con scadenze anomale";
                for (int i = 0; i < this.documentiAnomali.size(); ++i) {
                    elencoFatture = elencoFatture + "\n" + this.documentiAnomali.get(i).toString();
                }
                elencoFatture = elencoFatture + "\n\nVuoi comunque continuare la stampa ?";
                int ret = JOptionPane.showConfirmDialog(main.getPadreWindow(), elencoFatture, "Attenzione", 0);
                if (ret == 0) {
                    this.rispostaConferma = 0;
                    this.reportView();
                } else {
                    this.rispostaConferma = 1;
                }
            } else {
                this.reportView();
            }
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
        }
    }

    int quantePagine() {
        return 1;
    }

    int quanteRighe() {
        return 30;
    }

    void report() {
        this.reportInit();
        for (int i = 0; i < this.quantePagine(); ++i) {
            this.pagina(i);
        }
        this.reportEnd();
    }

    void reportInit() {
        try {
            this.document = new Document(PageSize.A4);
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(this.nomeFilePdf));
            this.document.addTitle("ddt");
            this.document.addSubject("ddt");
            this.document.addKeywords("ddt");
            this.document.addAuthor("TNX s.a.s");
            this.document.addHeader("Expires", "0");
            this.document.open();
            this.bf = BaseFont.createFont((String)"Helvetica", (String)"winansi", (boolean)false);
            this.bfCour = BaseFont.createFont((String)"Courier", (String)"winansi", (boolean)false);
            this.bf_italic = BaseFont.createFont((String)"Helvetica-Oblique", (String)"winansi", (boolean)false);
            this.bf_bold = BaseFont.createFont((String)"Helvetica-Bold", (String)"winansi", (boolean)false);
            this.bf_times = BaseFont.createFont((String)"Times-Roman", (String)"winansi", (boolean)false);
            this.cb = this.writer.getDirectContent();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void reportEnd() {
        this.document.close();
    }

    void reportView() {
        try {
            Util.start(this.nomeFilePdf);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void pagina(int pagina) {
        this.sfondo();
        this.intestazione();
        this.corpo();
        this.piede();
    }

    void sfondo() {
    }

    void intestazione() {
        try {
            Image logoAzienda = Image.getInstance((byte[])InvoicexUtil.caricaLogoDaDbBytes(Db.getConn(), "logo"));
            logoAzienda.scaleToFit(200.0f, 100.0f);
            logoAzienda.setAbsolutePosition(35.0f, PageSize.A4.getHeight() - 20.0f - logoAzienda.getScaledHeight());
            this.document.add((Element)logoAzienda);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        try {
            this.document.add((Element)new Phrase("\n"));
            this.riga = 0;
            double iy = 1.25;
            double y = 4.0;
            this.resu.next();
            int numColumns = 2;
            Table datatable = new Table(numColumns);
            int[] headerwidths = new int[]{65, 35};
            datatable.setWidths(headerwidths);
            datatable.setBorderWidth(0.0f);
            datatable.setWidth(100.0f);
            datatable.setPadding(2.0f);
            Statement statInt = Db.getConn().createStatement();
            String sqlInt = "select " + main.campiDatiAzienda + " from dati_azienda";
            ResultSet resuInt = statInt.executeQuery(sqlInt);
            resuInt.next();
            this.localita_azienda = resuInt.getString("localita");
            Cell cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga1"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga2"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga3"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga4"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga5"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase("", new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            datatable.addCell(cell1);
            cell1 = new Cell((Element)new Phrase(Db.nz(resuInt.getString("intestazione_riga6"), ""), new Font(1, 7.0f, 0)));
            cell1.setBorderWidth(0.0f);
            this.setLogo(cell1);
            datatable.addCell(cell1);
            this.document.add((Element)datatable);
            datatable = new Table(3);
            int[] headerwidths2 = new int[]{0, 100, 0};
            datatable.setWidths(headerwidths2);
            datatable.setBorderWidth(1.0f);
            datatable.setWidth(100.0f);
            datatable.setPadding(2.0f);
            datatable.addCell("");
            Cell temp = this.prova ? new Cell((Element)new Phrase("STAMPA IN PROVA - Distinta Ricevute Bancarie del " + this.data + " - STAMPA IN PROVA", new Font(1, 9.0f, 1))) : new Cell((Element)new Phrase("Distinta Ricevute Bancarie numero " + this.numeroDistinta + " del " + this.data, new Font(1, 9.0f, 1)));
            temp.setHorizontalAlignment(1);
            datatable.addCell(temp);
            datatable.addCell("");
            this.document.add((Element)datatable);
            this.document.add((Element)new Phrase("\nSpettabile " + this.coord.findDescription(), new Font(1, 9.0f, 0)));
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void corpo() {
        boolean continua = true;
        boolean continua1 = true;
        boolean continua2 = true;
        SimpleDateFormat df = new SimpleDateFormat();
        String oldCliente = "";
        String oldFattura = "";
        try {
            this.datatable = new Table(2);
            int[] headerwidths3 = new int[]{70, 30};
            this.datatable.setWidths(headerwidths3);
            this.datatable.setBorderWidth(0.1f);
            this.datatable.setWidth(100.0f);
            this.datatable.setPadding(2.0f);
            Cell c = new Cell((Element)new Phrase("Cliente", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Scadenze", new Font(1, 8.0f, 0)));
            this.set1(c);
            this.datatable.addCell(c);
            try {
                ResultSetMetaData meta = this.resu.getMetaData();
                for (int im = 1; im <= meta.getColumnCount(); ++im) {
                    System.out.println("col:" + meta.getColumnName(im));
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            oldCliente = this.resu.getString("clie_forn_codice");
            while (continua) {
                if (Db.nz(this.resu.getString("t.opzione_riba_dest_diversa"), "N").equalsIgnoreCase("S")) {
                    c = new Cell((Element)new Phrase(Db.nz(this.resu.getString("t.dest_ragione_sociale"), ""), new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase(" (cod. " + this.resu.getString("clie_forn_codice") + ")", new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase("\n" + this.resu.getString("t.dest_indirizzo"), new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase("\n" + this.resu.getString("t.dest_cap") + " " + this.resu.getString("t.dest_localita") + "(" + this.resu.getString("t.dest_provincia") + ")", new Font(1, 8.0f, 0)));
                } else {
                    c = new Cell((Element)new Phrase(Db.nz(this.resu.getString("clie_forn_ragione_sociale"), ""), new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase(" (cod. " + this.resu.getString("clie_forn_codice") + ")", new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase("\n" + this.resu.getString("clie_forn_indirizzo"), new Font(1, 8.0f, 0)));
                    c.add((Object)new Phrase("\n" + this.resu.getString("clie_forn_cap") + " " + this.resu.getString("clie_forn_localita") + "(" + this.resu.getString("clie_forn_provincia") + ")", new Font(1, 8.0f, 0)));
                }
                c.add((Object)new Phrase("\nP.IVA / Codice Fiscale : " + this.resu.getString("clie_forn_piva_cfiscale"), new Font(1, 8.0f, 0)));
                c.add((Object)new Phrase("\nBanca (ABI " + Db.nz(this.resu.getString("t_banca_abi"), "") + ") " + Db.nz(this.resu.getString("banche_abi_nome"), ""), new Font(1, 8.0f, 0)));
                c.add((Object)new Phrase("\nAgenzia (CAB " + Db.nz(this.resu.getString("t_banca_cab"), "") + ") " + Db.nz(this.resu.getString("comuni_comune"), "") + " indirizzo " + Db.nz(this.resu.getString("banche_cab_indirizzo"), ""), new Font(1, 8.0f, 0)));
                this.set2(c);
                this.datatable.addCell(c);
                c = new Cell();
                while (continua1) {
                    if (c.getElements().hasNext()) {
                        c.add((Object)new Phrase("\n\nFattura " + Db.nz(this.resu.getString("t.serie"), "") + Db.nz(this.resu.getString("t.numero"), "") + " del " + Db.formatData(this.resu.getString("t.data")), new Font(1, 7.0f, 0)));
                    } else {
                        c.add((Object)new Phrase("Fattura " + Db.nz(this.resu.getString("t.serie"), "") + Db.nz(this.resu.getString("t.numero"), "") + " del " + Db.formatData(this.resu.getString("t.data")), new Font(1, 7.0f, 0)));
                    }
                    double dapagare = this.resu.getDouble("t.totale");
                    if (CastUtils.toDouble0((Object)this.resu.getDouble("t.totale_da_pagare")) != 0.0) {
                        dapagare = this.resu.getDouble("t.totale_da_pagare");
                    }
                    c.add((Object)new Phrase("\nImporto Fattura  \u20ac " + Db.formatValuta(dapagare), new Font(1, 7.0f, 0)));
                    this.totaleFattura = dapagare;
                    this.totaleScadenze = 0.0;
                    while (continua2) {
                        c.add((Object)new Phrase("\nR.B. " + this.resu.getString("scadenze.numero") + "  \u20ac " + Db.formatValuta(this.resu.getDouble("scadenze.importo")) + " Scad. " + Db.formatData(this.resu.getString("scadenze.data_scadenza")), new Font(1, 8.0f, 0)));
                        this.totale += this.resu.getDouble("scadenze.importo");
                        this.totaleScadenze += this.resu.getDouble("scadenze.importo");
                        oldCliente = this.resu.getString("clie_forn_codice");
                        oldFattura = this.resu.getString("t.serie") + this.resu.getString("t.numero");
                        if (!this.resu.next()) {
                            continua2 = false;
                            this.resu.previous();
                            continue;
                        }
                        if (oldFattura.equals(this.resu.getString("t.serie") + this.resu.getString("t.numero"))) continue;
                        continua2 = false;
                        this.resu.previous();
                    }
                    if (it.tnx.Util.round(this.totaleFattura, 2) != it.tnx.Util.round(this.totaleScadenze, 2)) {
                        this.documentiAnomali.add(Db.nz(this.resu.getString("t.numero"), "") + " del " + Db.formatData(this.resu.getString("t.data")) + " tot. Fattura:" + it.tnx.Util.formatValutaEuro(this.totaleFattura) + " tot. Scad.:" + it.tnx.Util.formatValutaEuro(this.totaleScadenze));
                    }
                    continua2 = true;
                    if (!this.resu.next()) {
                        continua1 = false;
                        this.resu.previous();
                        continue;
                    }
                    if (oldCliente.equals(this.resu.getString("clie_forn_codice"))) continue;
                    continua1 = false;
                    this.resu.previous();
                }
                continua1 = true;
                this.set2(c);
                this.datatable.addCell(c);
                oldCliente = this.resu.getString("clie_forn_codice");
                if (this.resu.next()) continue;
                continua = false;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    void piede() {
        try {
            Cell c = new Cell();
            this.set2(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("Totale   \u20ac " + Db.formatValuta(this.totale), new Font(1, 8.0f, 1)));
            this.set2(c);
            this.datatable.addCell(c);
            this.document.add((Element)this.datatable);
            this.datatable = new Table(2);
            int[] headerwidths3 = new int[]{70, 30};
            this.datatable.setWidths(headerwidths3);
            this.datatable.setBorderWidth(0.0f);
            this.datatable.setWidth(100.0f);
            this.datatable.setPadding(1.0f);
            String strLocalizzazione = "";
            if (this.localita_azienda != null && !this.localita_azienda.equalsIgnoreCase("")) {
                strLocalizzazione = this.localita_azienda + ", ";
            }
            c = new Cell((Element)new Phrase(strLocalizzazione + this.data, new Font(1, 8.0f, 1)));
            this.set3(c);
            this.datatable.addCell(c);
            c = new Cell((Element)new Phrase("L'Amministratore", new Font(1, 8.0f, 1)));
            this.set3(c);
            this.datatable.addCell(c);
            this.document.add((Element)this.datatable);
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(null, err.toString());
        }
    }

    float cx(float x) {
        return PageSize.A4.getWidth() / 100.0f * x;
    }

    float cy(float y) {
        return PageSize.A4.getHeight() - PageSize.A4.getHeight() / 100.0f * y;
    }

    float cx(double x) {
        return PageSize.A4.getWidth() / 100.0f * (float)x;
    }

    float cy(double y) {
        return PageSize.A4.getHeight() - PageSize.A4.getHeight() / 100.0f * (float)y;
    }

    void set1(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(220, 220, 220));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    void set2(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    void set3(Cell tempPdfCell) {
        tempPdfCell.setBorderWidth(0.0f);
    }

    void setLogo(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setHorizontalAlignment(0);
        tempPdfCell.setBorderWidth(0.0f);
    }

    void setVuoto(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(255, 255, 255));
        tempPdfCell.setBorderWidth(0.0f);
    }
}

