/*
 * Decompiled with CFR 0.152.
 */
package it.tnx;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MyProxySelector
extends ProxySelector {
    ProxySelector defsel = null;
    HashMap<SocketAddress, InnerProxy> proxies = new HashMap();

    public MyProxySelector(ProxySelector def) {
        this.defsel = def;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        if (this.defsel != null) {
            return this.defsel.select(uri);
        }
        ArrayList<Proxy> l = new ArrayList<Proxy>();
        l.add(Proxy.NO_PROXY);
        return l;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        InnerProxy p = this.proxies.get(sa);
        if (p != null) {
            if (p.failed() >= 3) {
                this.proxies.remove(sa);
            }
        } else if (this.defsel != null) {
            this.defsel.connectFailed(uri, sa, ioe);
        }
    }

    class InnerProxy {
        Proxy proxy;
        SocketAddress addr;
        int failedCount = 0;

        InnerProxy(InetSocketAddress a) {
            this.addr = a;
            this.proxy = new Proxy(Proxy.Type.HTTP, a);
        }

        SocketAddress address() {
            return this.addr;
        }

        Proxy toProxy() {
            return this.proxy;
        }

        int failed() {
            return ++this.failedCount;
        }
    }
}

