/*
 * Decompiled with CFR 0.152.
 */
package it.tnx;

import it.tnx.Db2;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.jdic.desktop.Desktop;

public class Util {
    public static final String EURO = "\u20ac";
    public static final MediaTracker tracker = new MediaTracker(new Component(){});

    public static Date getCurrentDateTime() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return cal.getTime();
    }

    public static int getCurrenteYear() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return cal.get(1);
    }

    public static int getCurrenteMonth() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return cal.get(2) + 1;
    }

    public static Date getDateTime() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return cal.getTime();
    }

    public static Date getDateTime(String date) {
        SimpleDateFormat myFormat = new SimpleDateFormat("dd/MM/yy");
        myFormat.setLenient(false);
        try {
            Date myDate = myFormat.parse(date);
            return myDate;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Date getDateFromDDMMYY(String date) {
        SimpleDateFormat myFormat = new SimpleDateFormat("dd/MM/yy");
        myFormat.setLenient(false);
        try {
            Date myDate = myFormat.parse(date);
            return myDate;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Date getDateFromDDMMYYYY(String date) {
        SimpleDateFormat myFormat = new SimpleDateFormat("dd/MM/yyyy");
        myFormat.setLenient(false);
        try {
            Date myDate = myFormat.parse(date);
            return myDate;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static String getDateTimeFormatYYYYMMDD_HHMM() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_hhmm");
        return sdf.format(cal.getTime());
    }

    public static String getYearString() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return String.valueOf(cal.get(1));
    }

    public static String getYearStringMenoUno() {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        return String.valueOf(cal.get(1) - 1);
    }

    public static String getDateStringITALIAN(int dateFormatStyle) {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        DateFormat df = DateFormat.getDateInstance(dateFormatStyle, Locale.ITALY);
        return df.format(cal.getTime());
    }

    public static String getDateStringITALIAN(Date data, int dateFormatStyle) {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        cal.setTime(data);
        DateFormat df = DateFormat.getDateInstance(dateFormatStyle, Locale.ITALY);
        return df.format(cal.getTime());
    }

    public static String getDateTimeStringITALIAN(int dateFormatStyle, int timeFormatStyle) {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        DateFormat df = DateFormat.getDateTimeInstance(dateFormatStyle, timeFormatStyle, Locale.ITALY);
        return df.format(cal.getTime());
    }

    public static String getDateTimeStringITALIAN(Date data, int dateFormatStyle, int timeFormatStyle) {
        Calendar cal = Calendar.getInstance(Locale.ITALY);
        cal.setTime(data);
        DateFormat df = DateFormat.getDateTimeInstance(dateFormatStyle, timeFormatStyle, Locale.ITALY);
        return df.format(cal.getTime());
    }

    public static Image setSize(Image image, int width, int height) {
        return Util.setSize(image, width, height, 1);
    }

    public static Image setSize(Image image, int width, int height, int hints) {
        return image.getScaledInstance(width, height, hints);
    }

    public static String getFileNameFromFullFileName(String fileName, String separator) {
        int li = fileName.lastIndexOf(separator);
        return fileName.substring(li + 1);
    }

    public static String getPathFromFullFileName(String fileName, String separator) {
        int li = fileName.lastIndexOf(separator);
        return fileName.substring(0, li);
    }

    public static String getDirSeparator() {
        return System.getProperty("file.separator");
    }

    public static boolean copyFile(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            dest.mkdir();
            File[] filesInThisDir = source.listFiles();
            for (int i = 0; i < filesInThisDir.length; ++i) {
                Util.copyFile(filesInThisDir[i], new File(dest, filesInThisDir[i].getName()));
            }
        } else {
            int nextByte;
            FileInputStream istream = new FileInputStream(source);
            FileOutputStream ostream = new FileOutputStream(dest);
            dest.createNewFile();
            while ((nextByte = ((InputStream)istream).read()) != -1) {
                ((OutputStream)ostream).write(nextByte);
            }
            ((InputStream)istream).close();
            ((OutputStream)ostream).close();
        }
        return true;
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getTempDir(boolean withFinalSlash) {
        System.out.println("TempDir:" + System.getProperty("java.io.tmpdir") + Util.getDirSeparator());
        if (withFinalSlash) {
            return System.getProperty("java.io.tmpdir") + Util.getDirSeparator();
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserDir() {
        return System.getProperty("user.home");
    }

    public static String getUserDir(boolean withFinalSlash) {
        System.out.println("UserDir:" + System.getProperty("user.home") + Util.getDirSeparator());
        if (withFinalSlash) {
            return System.getProperty("user.home") + Util.getDirSeparator();
        }
        return System.getProperty("user.home");
    }

    public static double toDouble(String value) {
        double d = 0.0;
        value = value.replaceAll(",", ".");
        try {
            d = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static String int2str(int value) {
        return String.valueOf(value);
    }

    public static double floor(double x, int decimals) {
        int factor = 1;
        for (int i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        if (decimals < 0) {
            return (double)factor * Math.floor(x / (double)factor);
        }
        return Math.floor((double)factor * x) / (double)factor;
    }

    public static double ceil(double x, int decimals) {
        int factor = 1;
        for (int i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        if (decimals < 0) {
            return (double)factor * Math.ceil(x / (double)factor);
        }
        return Math.ceil((double)factor * x) / (double)factor;
    }

    public static double rint(double x, int decimals) {
        int factor = 1;
        for (int i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        if (decimals < 0) {
            return (double)factor * Math.rint(x / (double)factor);
        }
        return Math.rint((double)factor * x) / (double)factor;
    }

    public static double round(double x, int decimals) {
        try {
            if (Double.valueOf(x).isNaN()) {
                x = 0.0;
            }
            int decimali_aggiuntivi_affidabili = 4;
            double numero_che_arrotondo = Math.round(x * Math.pow(10.0, decimals + decimali_aggiuntivi_affidabili));
            return (double)Math.round(numero_che_arrotondo / Math.pow(10.0, decimali_aggiuntivi_affidabili)) / Math.pow(10.0, decimals);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double round_old(double x, int decimals) {
        try {
            if (Double.valueOf(x).isNaN()) {
                x = 0.0;
            }
            BigDecimal bd = new BigDecimal(String.valueOf(x));
            bd = bd.setScale(decimals, 4);
            return bd.doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double round_old2(double x, int decimals) {
        int factor = 1;
        x = Double.parseDouble(String.format(Locale.ENGLISH, "%f", x));
        for (int i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        x = decimals < 0 ? (double)((long)factor * Math.round(x / (double)factor)) : (double)Math.round((double)factor * x) / (double)factor;
        return x;
    }

    public static double round_old3(double x, int decimals) {
        int i;
        int factor = 1;
        ++decimals;
        for (i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        x = decimals < 0 ? (double)((long)factor * Math.round(x / (double)factor)) : (double)Math.round((double)factor * x) / (double)factor;
        --decimals;
        factor = 1;
        for (i = 0; i < Math.abs(decimals); ++i) {
            factor *= 10;
        }
        if (decimals < 0) {
            return (long)factor * Math.round(x / (double)factor);
        }
        return (double)Math.round((double)factor * x) / (double)factor;
    }

    public static Vector getVectorFromArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        if (obj.length == 0) {
            return null;
        }
        Vector<Object> temp = new Vector<Object>();
        for (int i = 0; i < obj.length; ++i) {
            temp.add(obj[i]);
        }
        return temp;
    }

    public static void openUrlInBrowser(URL url) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac os")) {
            try {
                System.out.println("openUrlInBrowser:mac os(" + osName + "):" + url);
                Runtime.getRuntime().exec("open " + url.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                Desktop.browse((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String format2Decimali(double valore) {
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(2);
        form.setMinimumFractionDigits(2);
        System.out.println("Importo: " + form.format(Util.round(valore, 2)));
        return form.format(Util.round(valore, 2));
    }

    public static String format5Decimali(double valore) {
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(5);
        form.setMinimumFractionDigits(5);
        return form.format(Util.round(valore, 5));
    }

    public static String formatNumero2Decimali(double valore) {
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(2);
        form.setMinimumFractionDigits(0);
        if (form.format(valore).equalsIgnoreCase("0")) {
            return "";
        }
        return form.format(Util.round(valore, 2));
    }

    public static String formatNumero5Decimali(double valore) {
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(5);
        form.setMinimumFractionDigits(0);
        if (form.format(valore).equalsIgnoreCase("0")) {
            return "";
        }
        return form.format(Util.round(valore, 5));
    }

    public static String formatValutaEuro(double valore) {
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(2);
        form.setMinimumFractionDigits(2);
        if (form.format(Util.round(valore, 2)).equalsIgnoreCase("0")) {
            return "";
        }
        return form.format(Util.round(valore, 2));
    }

    public static String formatNumero0Decimali(double valore) {
        valore = Util.round(valore, 0);
        NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
        form.setMaximumFractionDigits(0);
        form.setMinimumFractionDigits(0);
        if (form.format(valore).equalsIgnoreCase("0")) {
            return "0";
        }
        return form.format(valore);
    }

    public static String formatDataItalian(Date data) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (data != null) {
            return sdf.format(data);
        }
        return "";
    }

    public static String formatData(String dataMysql) {
        return dataMysql.substring(8, 10) + "/" + dataMysql.substring(5, 7) + "/" + dataMysql.substring(0, 4);
    }

    public static String formatDataY2(String dataMysql) {
        return dataMysql.substring(8, 10) + "/" + dataMysql.substring(5, 7) + "/" + dataMysql.substring(2, 4);
    }

    public static String formatDataMysql(Date data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(data);
    }

    public static String formatDataTempoMysql(Date data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return dateFormat.format(data);
    }

    public static String formatDataMysqlFromItalian(String data) {
        if (data.length() == 10) {
            return data.substring(6, 10) + "-" + data.substring(3, 5) + "-" + data.substring(0, 2);
        }
        if (data.length() == 8) {
            return data.substring(6, 8) + "-" + data.substring(3, 5) + "-" + data.substring(0, 2);
        }
        return "";
    }

    public static double getDouble(String numero) {
        if (numero == null) {
            return 0.0;
        }
        if (numero.equals("")) {
            return 0.0;
        }
        try {
            numero = Db2.replaceChars(numero, '.', "");
            numero = numero.replace(',', '.');
            return Double.valueOf(numero);
        }
        catch (Exception err) {
            return 0.0;
        }
    }

    public static double getDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        String numero = String.valueOf(value);
        if (numero.equals("")) {
            return 0.0;
        }
        try {
            numero = Db2.replaceChars(numero, '.', "");
            numero = numero.replace(',', '.');
            return Double.valueOf(numero);
        }
        catch (Exception err) {
            return 0.0;
        }
    }

    public static double getDoubleEng(String numero) {
        if (numero.equals("")) {
            return 0.0;
        }
        try {
            return Double.valueOf(numero);
        }
        catch (Exception err) {
            return 0.0;
        }
    }

    public static int getInt(String numero) {
        try {
            numero = Db2.replaceChars(numero, '.', "");
            numero = numero.replace(',', '.');
            return Integer.valueOf(numero);
        }
        catch (Exception err) {
            System.out.println("!!! warning getInt:" + numero);
            return 0;
        }
    }

    public static String nz(String valore) {
        if (valore == null) {
            return "";
        }
        return valore;
    }

    public static String nz(String valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore;
    }

    public static String nz(Object valore) {
        if (valore == null) {
            return "";
        }
        return valore.toString();
    }

    public static String nz(Object valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore.toString();
    }

    public static boolean dumpTable(String tableName, Connection dbConnection, OutputStream outputStream) {
        return Util.dumpTable(tableName, dbConnection, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpTable(String tableName, Connection dbConnection, OutputStream outputStream, String tipo) {
        StringBuilder sb = new StringBuilder();
        Statement stat = null;
        ResultSet resu = null;
        int limit_da = 0;
        int limit_quanti = 10000;
        if (tableName.equalsIgnoreCase("files")) {
            limit_quanti = 1;
        } else if (tableName.equalsIgnoreCase("storico")) {
            limit_quanti = 100;
        }
        boolean ancora = true;
        try {
            stat = dbConnection.createStatement();
            PrintStream o = new PrintStream(outputStream, true, "UTF8");
            if (tipo != null && tipo.equalsIgnoreCase("VIEW")) {
                o.println("drop view IF EXISTS " + tableName + ";");
            } else {
                o.println("drop table IF EXISTS " + tableName + ";");
            }
            o.println(Util.getCreateTable(tableName, dbConnection) + ";");
            if (tipo == null || !tipo.equalsIgnoreCase("VIEW")) {
                ArrayList<String> campiblob = new ArrayList<String>();
                boolean campiblobset = false;
                while (ancora) {
                    String sql = "select * from " + tableName + " limit " + limit_da + ", " + limit_quanti;
                    System.out.println("sql = " + sql);
                    resu = stat.executeQuery(sql);
                    ResultSetMetaData meta = resu.getMetaData();
                    int columns = meta.getColumnCount();
                    sb.setLength(0);
                    int conta = 0;
                    while (resu.next()) {
                        String valoreCampo;
                        ++conta;
                        sb.setLength(0);
                        if (tableName.equalsIgnoreCase("files")) {
                            int i;
                            sb.append("insert into " + tableName + " values (");
                            Integer pk = cu.i((Object)resu.getObject("id"));
                            for (i = 1; i <= columns; ++i) {
                                if (meta.getColumnType(i) == -4) {
                                    sb.append("''");
                                    if (!campiblobset) {
                                        campiblob.add(meta.getColumnName(i));
                                    }
                                } else {
                                    valoreCampo = Db2.pc(resu.getObject(i), meta.getColumnType(i));
                                    sb.append(valoreCampo);
                                }
                                if (i == columns) continue;
                                sb.append(",");
                            }
                            campiblobset = true;
                            sb.append(");");
                            o.println(sb.toString());
                            for (i = 0; i < campiblob.size(); ++i) {
                                String campo = (String)campiblob.get(i);
                                InputStream is = resu.getBinaryStream(campo);
                                if (is == null) continue;
                                byte[] buff = new byte[10000];
                                int read = 0;
                                while ((read = is.read(buff)) >= 0) {
                                    if (read <= 0) continue;
                                    String parte = Db2.bytesToHex(buff, 0, read);
                                    o.println("update " + tableName + " set " + campo + " = CONCAT(" + campo + ", 0x" + parte + ") where id = " + pk + ";");
                                }
                                is.close();
                            }
                        } else {
                            sb.append("insert into " + tableName + " values (");
                            for (int i = 1; i <= columns; ++i) {
                                valoreCampo = dbu.sql((Object)resu.getObject(i));
                                sb.append(valoreCampo);
                                if (i == columns) continue;
                                sb.append(",");
                            }
                            sb.append(");");
                            o.println(sb.toString());
                        }
                        o.flush();
                    }
                    if (conta == 0) {
                        ancora = false;
                    } else {
                        limit_da += limit_quanti;
                    }
                    resu.close();
                }
            }
            sb = null;
            boolean bl = true;
            return bl;
        }
        catch (Exception err) {
            err.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                resu.close();
            }
            catch (Exception exception) {}
            try {
                stat.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpTableOld(String tableName, Connection dbConnection, OutputStream outputStream) {
        StringBuffer sb = null;
        Statement stat = null;
        ResultSet resu = null;
        try {
            stat = dbConnection.createStatement();
            resu = stat.executeQuery("select * from " + tableName);
            ResultSetMetaData meta = resu.getMetaData();
            int columns = meta.getColumnCount();
            PrintStream o = new PrintStream(outputStream);
            o.println("drop table IF EXISTS " + tableName + ";");
            o.println(Util.getCreateTable(tableName, dbConnection) + ";");
            sb = new StringBuffer();
            int conta = 0;
            while (resu.next()) {
                ++conta;
                sb.setLength(0);
                sb.append("insert into " + tableName + " values (");
                for (int i = 1; i <= columns; ++i) {
                    String valoreCampo = Db2.pc(resu.getObject(i), meta.getColumnType(i));
                    sb.append(valoreCampo);
                    if (i == columns) continue;
                    sb.append(",");
                }
                sb.append(");");
                o.println(sb.toString());
                o.flush();
            }
            sb = null;
            boolean bl = true;
            return bl;
        }
        catch (Exception err) {
            err.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                resu.close();
            }
            catch (Exception exception) {}
            try {
                stat.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getCreateTable(String tableName, Connection dbConnection) {
        ResultSet show = null;
        String sqlCreate = "";
        boolean campiPK = false;
        try {
            Statement stat = dbConnection.createStatement();
            show = stat.executeQuery("SHOW CREATE TABLE " + tableName);
            if (show.next()) {
                sqlCreate = show.getString(2);
                sqlCreate = StringUtils.replace((String)sqlCreate, (String)"CREATE TABLE ", (String)"CREATE TABLE IF NOT EXISTS ");
            }
            try {
                show.getStatement().close();
                show.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sqlCreate;
        }
        catch (Exception err) {
            err.printStackTrace();
            return sqlCreate;
        }
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        Util.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                Util.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void dumpMem() {
        System.out.println(Util.getMem());
    }

    public static String getMem() {
        double f = (double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0;
        double t = (double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0;
        double m = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
        double u = t - f;
        String out = "dumpMem: max: " + m + " tot:" + t + " free:" + f + " in use:" + u;
        return out;
    }

    public static void main(String[] args) {
        System.out.println(Util.round(511.115, 2));
        BigDecimal bdTest = new BigDecimal("586.795");
        bdTest = bdTest.setScale(2, 4);
        System.out.println("bdTest:" + bdTest);
        bdTest = new BigDecimal(586.795);
        bdTest = bdTest.setScale(2, 4);
        System.out.println("bdTest:" + bdTest);
        System.out.println("-----------------");
        double test = 0.145;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2));
        System.out.println("-----------------");
        test = 0.575;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2));
        System.out.println("-----------------");
        test = 9.905;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2));
        System.out.println("-----------------");
        test = 586.795;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2));
        System.out.println("-----------------");
        test = 3.8949997425079346;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2) + " " + FormatUtils.formatEuroItaMax5((double)test));
        System.out.println("-----------------");
        test = 36.0048f;
        System.out.println(test + " " + Util.round(test, 2) + " " + Util.round_old2(test, 2) + " " + Util.round_old3(test, 2) + " " + FormatUtils.formatEuroItaMax5((double)test));
        System.out.println("-----------------");
        double val = 1.0;
        BigDecimal ver = new BigDecimal("1.000");
        NumberFormat nf2 = NumberFormat.getInstance(Locale.ENGLISH);
        nf2.setMaximumFractionDigits(2);
        nf2.setMinimumFractionDigits(2);
        nf2.setGroupingUsed(false);
        for (int i = 0; i < 10000; ++i) {
            ver = ver.multiply(new BigDecimal("1.001"));
            BigDecimal ver2 = ver.setScale(2, RoundingMode.HALF_UP);
            String val1 = cu.s((Object)nf2.format(Util.round(val *= 1.001, 2)));
            if (val1.equals(ver2.toPlainString())) continue;
            System.out.println("diversi " + val + " bigd:" + ver2 + " round:" + val1);
        }
    }
}

