/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.dbeans;

import it.tnx.dbeans.ResultSet.ScrollingResultSetTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import tnxbeans.DbEvent;
import tnxbeans.DbListener;
import tnxbeans.SortableTableModel;
import tnxbeans.tnxDbPanel;

public class JTableDb
extends JTable
implements Serializable,
TableColumnModelListener {
    public Vector dbChiave;
    public tnxDbPanel dbPanel;
    public JScrollPane scrollPane;
    public String dbNomeTabella;
    public boolean dbEditabile = false;
    private Connection connection;
    private Statement stat;
    private SortableTableModel tm;
    private ScrollingResultSetTableModel tm2;
    public String oldSql;
    private Connection oldConnection;
    public ResultSetMetaData meta;
    public boolean isFinding = false;
    public boolean flagUsaThread = false;
    public boolean flagUsaOrdinamento = true;
    public Hashtable columnsSizePerc;
    public Hashtable columnsAlign;
    public Hashtable columnsProps;
    public Hashtable columnsName = new Hashtable();
    private boolean isAlreadyAlign = false;
    private boolean isAlreadyProps = false;
    private int oldWidth;
    private int oldSelectedRow;
    private boolean isResizing = false;
    private int countOpens = 0;
    private int countResize = 0;
    public DefaultTableCellRenderer infoRender;
    private int prevRow = 0;
    private boolean dirty = false;
    private boolean giaAgganciato = false;
    private int rollOverRowIndex = -1;

    public JTableDb() {
        RollOverListener lst = new RollOverListener();
        this.addMouseMotionListener(lst);
        this.addMouseListener(lst);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (this.isRowSelected(row)) {
            c.setForeground(this.getSelectionForeground());
            c.setBackground(this.getSelectionBackground());
        } else if (row == this.rollOverRowIndex) {
            c.setForeground(this.getSelectionForeground().brighter());
            c.setBackground(this.getSelectionBackground().brighter());
        } else {
            c.setForeground(this.getForeground());
            c.setBackground(this.getBackground());
        }
        return c;
    }

    public int getColumnByName(String colName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equalsIgnoreCase(colName)) continue;
            return i;
        }
        return -1;
    }

    public boolean dbOpen(Connection connection, String sql) {
        if (this.dbPanel != null && !this.giaAgganciato) {
            this.dbPanel.addDbListener(new DbListener(){

                @Override
                public void statusFired(DbEvent event) {
                    tnxDbPanel cfr_ignored_0 = JTableDb.this.dbPanel;
                    if (event.getStatus() == tnxDbPanel.STATUS_REFRESHING) {
                        JTableDb.this.dbPanel.sincronizzaSelezioneGrigliaJTableDb(JTableDb.this);
                    }
                }
            });
            this.giaAgganciato = true;
        }
        DefaultTableCellRenderer dateRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
                if (value != null) {
                    super.setValue(dateFormat.format((Date)value));
                } else {
                    super.setValue("");
                }
            }
        };
        DefaultTableCellRenderer dateTimeRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy hh:mm");
                if (value != null) {
                    super.setValue(dateFormat.format(value));
                } else {
                    super.setValue("");
                }
            }
        };
        DefaultTableCellRenderer currencyRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                DecimalFormat form = new DecimalFormat("#,##0.00");
                try {
                    super.setValue(form.format(value));
                    if (form.format(value).startsWith("-")) {
                        this.setForeground(new Color(200, 0, 0));
                    } else {
                        this.setForeground(Color.black);
                    }
                }
                catch (Exception err) {
                    System.out.println("grid2 cannot format");
                    super.setValue(null);
                }
                this.setHorizontalAlignment(4);
            }
        };
        this.infoRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                if (value.toString().equals("*") && JTableDb.this.dbEditabile) {
                    this.setBackground(new Color(220, 200, 200));
                } else {
                    this.setBackground(new Color(200, 200, 200));
                }
                this.setHorizontalAlignment(0);
            }
        };
        this.setAutoResizeMode(0);
        ++this.countOpens;
        this.getParent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JTableDb.this.this_mousePressed(e);
            }
        });
        this.oldSql = sql;
        this.oldConnection = connection;
        if (!this.flagUsaThread) {
            ResultSet resu = null;
            try {
                this.stat = connection.createStatement(1005, 1008);
                resu = this.stat.executeQuery(sql);
                ResultSetMetaData meta = resu.getMetaData();
                this.tm2 = new ScrollingResultSetTableModel(resu);
                int numeColo = meta.getColumnCount();
                String[] Colo = new String[numeColo];
                for (int i = 1; i <= numeColo; ++i) {
                    Colo[i - 1] = meta.getColumnName(i);
                }
                this.tm = new SortableTableModel(Colo, 0, meta);
                int numRec = 0;
                while (resu.next()) {
                    ++numRec;
                    Object[] reco = new Object[numeColo];
                    for (int i = 1; i <= numeColo; ++i) {
                        reco[i - 1] = meta.getColumnType(i) == 12 || meta.getColumnType(i) == 1 ? resu.getString(i) : (meta.getColumnType(i) == 4 || meta.getColumnType(i) == 5 ? new Integer(resu.getInt(i)) : (meta.getColumnType(i) == -5 ? resu.getObject(i) : (meta.getColumnType(i) == 3 || meta.getColumnType(i) == 8 ? new Double(resu.getDouble(i)) : (meta.getColumnType(i) == 91 ? resu.getDate(i) : resu.getObject(i)))));
                    }
                    this.tm.addRow(reco);
                }
                if (this == null) {
                    return true;
                }
                this.setModel(this.tm2);
                if (this.dbEditabile) {
                    // empty if block
                }
                for (int i = 1; i <= numeColo; ++i) {
                    if (meta.getColumnType(i) == 12 || meta.getColumnType(i) == 1 || meta.getColumnType(i) == 4 || meta.getColumnType(i) == 5 || meta.getColumnType(i) == -5) continue;
                    if (meta.getColumnType(i) == 3 || meta.getColumnType(i) == 8) {
                        this.getColumn(meta.getColumnName(i)).setCellRenderer(currencyRender);
                        continue;
                    }
                    if (meta.getColumnType(i) == 91) {
                        this.getColumn(meta.getColumnName(i)).setCellRenderer(dateRender);
                        continue;
                    }
                    if (meta.getColumnType(i) != 93) continue;
                    this.getColumn(meta.getColumnName(i)).setCellRenderer(dateTimeRender);
                }
                this.meta = meta;
                TableColumnModel defColu = this.getColumnModel();
                if (!this.dbEditabile) {
                    this.setDefaultEditor(this.getColumnClass(1), null);
                }
                while (this.tm.getRowCount() != this.getRowCount()) {
                    Thread.yield();
                }
                this.getSelectionModel().setSelectionInterval(0, 0);
                if (this.flagUsaOrdinamento) {
                    // empty if block
                }
                return true;
            }
            catch (Exception err) {
                err.printStackTrace();
                System.out.println("sql errore:" + sql);
            }
        }
        return true;
    }

    public void dbGoNext() {
        if (this.getSelectedRow() < this.getRowCount() - 1) {
            this.getSelectionModel().setSelectionInterval(this.getSelectedRow() + 1, this.getSelectedRow() + 1);
            if (this.getSelectedRow() == 0) {
                this.dbGoNext();
            } else {
                this.dbSelezionaRiga();
            }
        }
    }

    public void dbGoPrevious() {
        if (this.getSelectedRow() > 0) {
            this.getSelectionModel().setSelectionInterval(this.getSelectedRow() - 1, this.getSelectedRow() - 1);
            this.dbSelezionaRiga();
        }
    }

    public void dbGoFirst() {
        this.getSelectionModel().setSelectionInterval(0, 0);
        this.dbSelezionaRiga();
    }

    public void dbGoLast() {
        this.getSelectionModel().setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        this.dbSelezionaRiga();
    }

    public void dbSelezionaRiga() {
        if (this.dbPanel != null && this.getSelectedRowCount() > 0) {
            int ret;
            try {
                if (this.getValueAt(this.getSelectedRow(), 0).toString().equals("*") && this.dbEditabile) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("panel stato:" + this.dbPanel.dbStato);
            if (!this.dbPanel.dbStato.equals(tnxDbPanel.DB_LETTURA) && !this.isFinding && (ret = JOptionPane.showConfirmDialog(this.getRootPane(), "Salvare le modifiche apportate ?", "Attenzione", 0, 3)) == 0) {
                this.dbPanel.dbSave();
                this.dbRefresh();
            }
            Vector<String> temp = new Vector<String>();
            for (int i = 0; i < this.dbChiave.size(); ++i) {
                boolean trovato = false;
                int idCampo = 0;
                for (int j = 0; j < this.tm.getColumnCount(); ++j) {
                    if (!this.tm.getColumnName(j).equalsIgnoreCase((String)this.dbChiave.get(i))) continue;
                    trovato = true;
                    idCampo = j;
                    j = this.tm.getColumnCount();
                }
                if (!trovato) continue;
                String valore = "";
                valore = this.nz(this.tm.getValueAt(this.getSelectedRow(), idCampo).toString(), "");
                temp.add(valore);
            }
            this.dbPanel.dbSelectSingle(temp);
            this.dbPanel.dbRefresh();
        }
    }

    public boolean dbFindFirst() {
        this.isFinding = true;
        this.setRowSelectionInterval(0, 0);
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int j;
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            if ((griglia = this.nz(this.getValueAt(j = this.getSelectedRow(), numeColo), "")).length() < campo.length() || !griglia.substring(0, campo.length()).equalsIgnoreCase(campo)) continue;
            this.setRowSelectionInterval(j, j);
            this.scrollToRow(this.getSelectedRow());
            this.dbSelezionaRiga();
            if (this.dbPanel.butSave != null) {
                this.dbPanel.butSave.setEnabled(false);
            }
            if (this.dbPanel.butUndo == null) continue;
            this.dbPanel.butUndo.setEnabled(false);
        }
        if (!this.dbFindNext()) {
            JOptionPane.showMessageDialog(null, "Posizione inesistente");
            this.isFinding = false;
            return false;
        }
        this.isFinding = false;
        return true;
    }

    public boolean dbFindNext() {
        this.isFinding = true;
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            for (int j = this.getSelectedRow() + 1; j < this.getRowCount(); ++j) {
                griglia = this.nz(this.getValueAt(j, numeColo), "");
                if (griglia.length() < campo.length() || !griglia.substring(0, campo.length()).equalsIgnoreCase(campo)) continue;
                this.setRowSelectionInterval(j, j);
                this.scrollToRow(this.getSelectedRow());
                this.dbSelezionaRiga();
                if (this.dbPanel.butSave != null) {
                    this.dbPanel.butSave.setEnabled(false);
                }
                if (this.dbPanel.butUndo != null) {
                    this.dbPanel.butUndo.setEnabled(false);
                }
                this.isFinding = false;
                return true;
            }
        }
        this.isFinding = false;
        return false;
    }

    public boolean dbFindExact() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        this.isFinding = true;
        this.setRowSelectionInterval(0, 0);
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            for (int j = this.getSelectedRow() + 1; j < this.getRowCount(); ++j) {
                griglia = this.nz(this.getValueAt(j, numeColo), "");
                try {
                    if (this.getValueAt(j, numeColo) != null && this.meta.getColumnType(numeColo + 1) == 91) {
                        griglia = dateFormat.format((Date)this.getValueAt(j, numeColo));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (griglia.length() < campo.length()) continue;
                try {
                    if (!griglia.equalsIgnoreCase(campo)) continue;
                    this.setRowSelectionInterval(j, j);
                    this.scrollToRow(this.getSelectedRow());
                    this.dbSelezionaRiga();
                    if (this.dbPanel.butSave != null) {
                        this.dbPanel.butSave.setEnabled(false);
                    }
                    if (this.dbPanel.butUndo != null) {
                        this.dbPanel.butUndo.setEnabled(false);
                    }
                    this.isFinding = false;
                    return true;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }
        this.isFinding = false;
        return false;
    }

    public void dbRefresh() {
        if (this.dbPanel != null && !this.giaAgganciato) {
            this.dbPanel.addDbListener(new DbListener(){

                @Override
                public void statusFired(DbEvent event) {
                    tnxDbPanel cfr_ignored_0 = JTableDb.this.dbPanel;
                    if (event.getStatus() == tnxDbPanel.STATUS_REFRESHING) {
                        JTableDb.this.dbPanel.sincronizzaSelezioneGrigliaJTableDb(JTableDb.this);
                    }
                }
            });
            this.giaAgganciato = true;
        }
        this.oldSelectedRow = this.getSelectedRow();
        this.dbOpen(this.oldConnection, this.oldSql);
        if (this.dbPanel != null) {
            this.dbPanel.sincronizzaSelezioneGrigliaJTableDb(this);
        } else {
            try {
                if (this.getRowCount() > this.oldSelectedRow && this.oldSelectedRow >= 0 && this.getRowCount() > 0) {
                    System.out.println("grid refresh:rowcount:" + this.getRowCount() + " oldrow:" + this.oldSelectedRow);
                    this.setRowSelectionInterval(this.oldSelectedRow, this.oldSelectedRow);
                    this.scrollToRow(this.getSelectedRow());
                } else {
                    this.setRowSelectionInterval(0, 0);
                    this.scrollToRow(this.getSelectedRow());
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    private String nz(String valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore;
    }

    private String nz(Object valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore.toString();
    }

    public void scrollToRow(int row) {
        this.scrollPane = (JScrollPane)this.getParent().getParent();
        Rectangle rect = this.getCellRect(row, 1, true);
        this.scrollPane.getViewport().setViewPosition(new Point(1, (int)rect.getY()));
    }

    void this_mouseClicked(MouseEvent e) {
    }

    void this_mousePressed(MouseEvent e) {
        this.dbSelezionaRiga();
        if (e.getClickCount() == 2 && this.dbPanel != null) {
            Container tempParent = this.dbPanel.getParent();
            if (!tempParent.getClass().getName().equalsIgnoreCase("JTabbedPane")) {
                for (int i = 0; i < 5; ++i) {
                    if (!(tempParent = tempParent.getParent()).getClass().getName().equalsIgnoreCase("javax.swing.JTabbedPane")) continue;
                    i = 10;
                }
            }
            if (tempParent.getClass().getName().equalsIgnoreCase("javax.swing.JTabbedPane")) {
                JTabbedPane tempTab = (JTabbedPane)tempParent;
                tempTab.setSelectedIndex(0);
            }
        }
    }

    private class RollOverListener
    extends MouseInputAdapter {
        private RollOverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTableDb.this.rollOverRowIndex = -1;
            JTableDb.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = JTableDb.this.rowAtPoint(e.getPoint());
            if (row != JTableDb.this.rollOverRowIndex) {
                JTableDb.this.rollOverRowIndex = row;
                JTableDb.this.repaint();
            }
        }
    }
}

