/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.gui;

import com.jidesoft.swing.SelectAllUtils;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.JXDatePicker;

public class DateDocument
extends PlainDocument {
    private final JTextField textfield;

    public DateDocument(JTextField textfield) {
        this.textfield = textfield;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (this.getLength() == 8 && this.getText(0, 8).equals("__/__/__")) {
            this.remove(0, 8);
            this.textfield.setForeground(UIManager.getColor("Label.foreground"));
        }
        if (this.getLength() + str.length() > 8) {
            Toolkit.getDefaultToolkit().beep();
        } else if (str != null && str.length() > 0) {
            if (str.length() == 1) {
                try {
                    int n = Integer.parseInt(str);
                }
                catch (NumberFormatException numErr) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (offset == 1 || offset == 4) {
                    super.insertString(offset, str, a);
                    if (!this.getText(offset + 1, 1).equalsIgnoreCase("/")) {
                        super.insertString(offset + 1, "/", a);
                    }
                } else {
                    super.insertString(offset, str, a);
                }
            } else {
                super.insertString(offset, str, a);
            }
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        if (offs == 2 || offs == 5) {
            try {
                super.remove(offs - 1, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
    }

    public static void installDateDocument(JTextField textfield) {
        try {
            if (textfield.getParent() instanceof JXDatePicker) {
                ((JXDatePicker)textfield.getParent()).setFormats(new String[]{"dd/MM/yy"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        textfield.setDocument(new DateDocument(textfield));
        SelectAllUtils.install((Component)textfield);
        MyHighlighter hp = new MyHighlighter();
        try {
            textfield.getHighlighter().addHighlight(0, 0, hp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MyHighlighter
    implements Highlighter.HighlightPainter {
        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            String text = null;
            Rectangle rbounds = bounds.getBounds();
            text = c.getText();
            g.setColor(UIManager.getColor("Label.disabledForeground"));
            int remove = text.length();
            FontMetrics fm = g.getFontMetrics();
            int swidth = fm.stringWidth(text);
            try {
                g.drawString("__/__/__".substring(remove, 8), rbounds.x + swidth, rbounds.height);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

