/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class KeyableCellEditor
implements TableCellEditor,
FocusListener,
KeyListener,
Serializable {
    List listeners = new Vector();
    JTextField textField;
    Object lastValue = null;
    Format currentFormat;
    JTable table;

    public KeyableCellEditor() {
        this(null);
    }

    public KeyableCellEditor(JTextField aTextField) {
        this.textField = aTextField;
        if (this.textField == null) {
            this.textField = new JTextField();
        }
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.addKeyListener(this);
        this.textField.addFocusListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        table.removeKeyListener(this);
        table.addKeyListener(this);
        return this.getEditorComponent(value);
    }

    protected Component getEditorComponent(Object value) {
        if (value != null) {
            this.textField.setText(value.toString());
        } else {
            this.textField.setText("");
        }
        if (value instanceof Number) {
            this.textField.setHorizontalAlignment(4);
        } else {
            this.textField.setHorizontalAlignment(2);
        }
        this.lastValue = value;
        this.textField.selectAll();
        this.textField.requestFocus();
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this.lastValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent == null) {
            this.textField.setText("");
            this.textField.requestFocus();
            return true;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        if (anEvent instanceof KeyEvent) {
            this.textField.setText("");
            this.textField.requestFocus();
            return true;
        }
        this.textField.selectAll();
        this.textField.requestFocus();
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.lastValue = this.textField.getText();
        this.fireEditingStopped();
        this.table.removeKeyListener(this);
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.table.removeKeyListener(this);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    protected void fireEditingCanceled() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ((CellEditorListener)it.next()).editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ((CellEditorListener)it.next()).editingStopped(event);
        }
    }

    protected void onEnterKey() {
        this.stopCellEditing();
    }

    protected void onEscapeKey() {
        this.cancelCellEditing();
    }

    protected void moveEditCell(int dRow, int dCol) {
        if (this.table == null) {
            return;
        }
        int row = this.table.getSelectedRow() + dRow;
        int col = this.table.getSelectedColumn() + dCol;
        row = Math.max(0, row);
        row = Math.min(row, this.table.getRowCount() - 1);
        col = Math.max(0, col);
        col = Math.min(col, this.table.getColumnCount() - 1);
        this.stopCellEditing();
        this.table.setRowSelectionInterval(row, row);
        this.table.setColumnSelectionInterval(col, col);
        this.table.editCellAt(row, col);
        this.textField.selectAll();
        this.textField.requestFocus();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 37 && this.textField.getSelectionStart() == 0) {
            this.moveEditCell(0, -1);
            e.consume();
            return;
        }
        if (keyCode == 39 && this.textField.getSelectionEnd() == this.textField.getText().length()) {
            this.moveEditCell(0, 1);
            e.consume();
            return;
        }
        if (keyCode == 38) {
            this.moveEditCell(-1, 0);
            e.consume();
            return;
        }
        if (keyCode == 40) {
            this.moveEditCell(1, 0);
            e.consume();
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            this.onEnterKey();
            return;
        }
        if (keyCode == 27) {
            this.onEscapeKey();
            return;
        }
        if (keyCode == 9) {
            if (e.isShiftDown()) {
                this.moveEditCell(0, -1);
            } else {
                this.moveEditCell(0, 1);
            }
            e.consume();
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.stopCellEditing();
    }
}

