/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.importExportAscii;

import it.tnx.commons.FormatUtils;
import org.apache.commons.lang.StringUtils;

public class CampoReadyTec {
    public static char TIPO_ALFANUMERICO = (char)65;
    public static char TIPO_ALFANUMERICO_NOTRIM = (char)66;
    public static char TIPO_NUMERICO = (char)78;
    public static char TIPO_DATA = (char)68;
    public static char ALLINEAMENTO_SINISTRA = (char)83;
    public static char ALLINEAMENTO_DESTRA = (char)68;
    public static char ALLINEAMENTO_DATA_ENG = (char)65;
    public static char ALLINEAMENTO_DATA_ITA = (char)71;
    public static int SEGNO_NO = 0;
    public static int SEGNO_PRIMA = 1;
    public static int SEGNO_DOPO = 2;
    public static int DATA_CON_SECOLO = 8;
    public static int DATA_NO_SECOLO = 6;
    private String nomeCampo;
    private Object valore;
    private char tipo;
    private char allineamento_formato;
    private int segno;
    private int decimali_secolo;
    private String virgola;
    private int lunghezza;
    private boolean obbligatorio;

    public CampoReadyTec(String nomeCampo, Object value, char tipo, char allineamento, int segno, int decimali, String virgola, int lunghezza, boolean obbligatorio) {
        this.nomeCampo = nomeCampo;
        if (value instanceof String) {
            String ret = (String)value;
            ret = StringUtils.replace((String)ret, (String)"\n", (String)" ");
            ret = StringUtils.replace((String)ret, (String)"\r", (String)" ");
            ret = StringUtils.replace((String)ret, (String)"\t", (String)" ");
            this.valore = ret;
        } else {
            this.valore = value;
        }
        this.tipo = tipo;
        this.allineamento_formato = allineamento;
        this.segno = segno;
        this.decimali_secolo = decimali;
        this.virgola = virgola;
        this.lunghezza = lunghezza;
        this.obbligatorio = obbligatorio;
    }

    public String getNomeCampo() {
        return this.nomeCampo;
    }

    private boolean isEmpty() {
        if (this.valore instanceof String) {
            String ret = String.valueOf(this.valore);
            return ret.equals("");
        }
        return this.valore == null;
    }

    public String formatCampo() throws Exception {
        String field = "";
        if (this.valore != null && !this.isEmpty()) {
            if (this.tipo == TIPO_ALFANUMERICO) {
                field = String.valueOf(this.valore).trim().toUpperCase();
            } else if (this.tipo == TIPO_ALFANUMERICO_NOTRIM) {
                field = String.valueOf(this.valore).toUpperCase();
            } else if (this.tipo == TIPO_NUMERICO) {
                String sign = "";
                if (this.decimali_secolo == 0) {
                    int value = -1;
                    try {
                        if (this.valore instanceof Double) {
                            double val = (Double)this.valore;
                            value = Integer.parseInt(FormatUtils.formatNumNoDec((double)val));
                        } else {
                            value = Integer.parseInt(String.valueOf(this.valore));
                        }
                    }
                    catch (Exception e) {
                        throw new Exception("Impossibile usare il campo " + this.nomeCampo + " come numero (valore = " + this.valore + ")");
                    }
                    sign = value >= 0 ? "+" : "-";
                    field = String.valueOf(value);
                } else {
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(String.valueOf(this.valore));
                        field = FormatUtils.formatParametr((double)value, (int)this.decimali_secolo, (String)this.virgola);
                        field = field.replace(",", "");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Impossibile usare il campo " + this.nomeCampo + " come decimale (valore = " + this.valore + ")");
                    }
                    sign = value >= 0.0 ? "+" : "-";
                }
                if (this.segno == SEGNO_PRIMA) {
                    field = sign + field;
                } else if (this.segno == SEGNO_DOPO) {
                    field = field + sign;
                }
            } else if (this.tipo == TIPO_DATA) {
                String value = String.valueOf(this.valore);
                String[] dataSplit = value.split("-");
                String anno = dataSplit[0];
                String mese = dataSplit[1];
                String giorno = dataSplit[2];
                if (this.decimali_secolo == DATA_NO_SECOLO) {
                    anno = anno.substring(2);
                }
                field = this.allineamento_formato == ALLINEAMENTO_DATA_ENG ? anno + mese + giorno : giorno + mese + anno;
            }
        } else {
            if (this.obbligatorio) {
                throw new Exception("Il campo " + this.nomeCampo + " \u00e8 obbligatorio, non sono stati passati valori. Controllare l'anagrafica per procedere con l'export");
            }
            field = "";
        }
        if (field.length() > this.lunghezza) {
            field = field.substring(0, this.lunghezza);
        } else if (field.length() < this.lunghezza) {
            while (field.length() < this.lunghezza) {
                String riempimento = " ";
                if (this.allineamento_formato == ALLINEAMENTO_DESTRA) {
                    field = riempimento + field;
                    continue;
                }
                field = field + riempimento;
            }
        }
        return field;
    }
}

