/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.importExportAscii;

import gestioneFatture.Db;
import gestioneFatture.JDialogWait;
import gestioneFatture.logic.Iva;
import gestioneFatture.main;
import it.tnx.Util;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.importExportAscii.CampoReadyTec;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class FatSeqExp
extends SwingWorker {
    private List<Map> rs;
    private ArrayList<ArrayList> listaRighe;
    private boolean erroreCliente = false;
    private boolean erroreIva = false;
    private String clientiConErrori = "";
    private String codiciIvaNonCollegati = "";
    private String codiceIvaDefault = null;
    private String codiceContoDefault = null;
    private String codiceContoDefaultOrig = null;
    private String esigDiffIva = "0";
    public String nomeFile = null;
    Map param = null;

    public FatSeqExp(List<Map> rs, Map param) {
        this.rs = rs;
        this.param = param;
    }

    protected void done() {
        super.done();
        if (this.param.get("waitDialog") != null) {
            ((JDialogWait)this.param.get("waitDialog")).dispose();
        }
    }

    protected void process(List chunks) {
        if (this.param.get("waitDialog") != null) {
            for (Object o : chunks) {
                ((JDialogWait)this.param.get((Object)"waitDialog")).labStato.setText(cu.s(o));
            }
        }
    }

    protected Object doInBackground() throws Exception {
        block95: {
            Date dal = cu.toDate(this.param.get("dal"));
            Date al = cu.toDate(this.param.get("al"));
            Integer clifor = cu.i(this.param.get("clifor"));
            Component frm = (Component)this.param.get("frm");
            try {
                ArrayList list_spese;
                Map dati_azienda = (Map)dbu.getListMap((Connection)Db.getConn(), (String)"select export_fatture_estrai_scadenze, export_fatture_estrai_acconti, export_fatture_codice_iva, export_fatture_conto_ricavi, export_fatture_esig_diff_iva, export_fatture_cod_pag_std, export_fatture_tipo_eff_std, export_fatture_usa_conti_contab, json_param_impexp from dati_azienda").get(0);
                HashMap tab_iva = dbu.getListMapMap((Connection)Db.getConn(), (String)"select * from codici_iva", (String)"codice");
                String json = cu.s(dati_azienda.get("json_param_impexp"));
                JSONObject json_param_impexp = null;
                if (json != null && StringUtils.isNotBlank((String)json)) {
                    JSONParser parser = new JSONParser();
                    json_param_impexp = (JSONObject)parser.parse(json);
                }
                boolean estrai_scadenze = cu.toBoolean(dati_azienda.get("export_fatture_estrai_scadenze"));
                boolean estrai_acconti = cu.toBoolean(dati_azienda.get("export_fatture_estrai_acconti"));
                boolean usa_conti_contab = cu.toBoolean(dati_azienda.get("export_fatture_usa_conti_contab"));
                System.out.println("ReadyTec() usa_conti_contab:" + usa_conti_contab);
                this.codiceIvaDefault = cu.toString(dati_azienda.get("export_fatture_codice_iva"));
                this.codiceContoDefaultOrig = this.codiceContoDefault = cu.toString(dati_azienda.get("export_fatture_conto_ricavi"));
                this.esigDiffIva = cu.s(dati_azienda.get("export_fatture_esig_diff_iva"));
                this.listaRighe = new ArrayList();
                InvoicexUtil.generaTotaliDocumentoDate(dal, al, this, clifor);
                this.publish(new Object[]{"preparazione dati iva"});
                String sql = "select SUM(IFNULL(spese_trasporto,0)) as tot_spese_trasporto, SUM(IFNULL(spese_incasso,0)) as tot_spese_incassso from test_fatt t where 1 = 1";
                if (dal != null) {
                    sql = sql + " and t.data >= " + dbu.sql((Object)dal);
                }
                if (al != null) {
                    sql = sql + " and t.data <= " + dbu.sql((Object)al);
                }
                if ((list_spese = dbu.getListMap((Connection)Db.getConn(), (String)sql)) != null && list_spese.size() == 1) {
                    double tot_spese_trasporto = cu.d0(((Map)list_spese.get(0)).get("tot_spese_trasporto"));
                    double tot_spese_incasso = cu.d0(((Map)list_spese.get(0)).get("tot_spese_incasso"));
                    double tot_spese = tot_spese_incasso + tot_spese_trasporto;
                    if (tot_spese_incasso != 0.0) {
                        String codice_iva_trasporto = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select codiceIvaSpese from dati_azienda"));
                        String codice_iva_incasso = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select codiceIvaSpese from dati_azienda"));
                        if (!codice_iva_incasso.equals(codice_iva_trasporto)) {
                            throw new Exception("Nelle fatture selezionate ci sono " + tot_spese_incasso + " \u20ac di spese di incasso ma i codici IVA tra spese di incasso e spese di trasporto sono diversi\nIn questo tipo di export non \u00e8 consentito");
                        }
                    }
                }
                ArrayList iveriga = DbUtils.getListMap((Connection)Db.getConn(), (String)"SELECT t.id_padre, t.codice_iva, CAST(IFNULL(i.codice_readytec, t.perc_iva) AS CHAR(20)) as iva_rea, t.totale as tivato, t.imponibile as timpo, t.iva as tiva FROM test_fatt_iva t left join codici_iva i on t.codice_iva = i.codice WHERE t.codice_iva != '' and t.totale != 0");
                HashMap iveriga2 = new HashMap();
                System.out.println("inizio group");
                for (Map m : iveriga) {
                    Integer id = cu.i(m.get("id_padre"));
                    if (!iveriga2.containsKey(id)) {
                        iveriga2.put(id, new ArrayList());
                    }
                    ArrayList l = (ArrayList)iveriga2.get(id);
                    l.add(m);
                }
                this.publish(new Object[]{"preparazione dati scadenze"});
                String qScad = "SELECT fat.id, sum(par.importo) as pagato FROM test_fatt fat LEFT JOIN scadenze sca ON (sca.documento_tipo = 'FA' AND sca.id_doc = fat.id) LEFT JOIN scadenze_parziali par ON par.id_scadenza = sca.id GROUP BY fat.id";
                ArrayList pagamentiList = DbUtils.getListMap((Connection)Db.getConn(), (String)qScad);
                HashMap<Integer, Double> pagamenti = new HashMap<Integer, Double>();
                System.out.println("inizio group");
                for (Map m : pagamentiList) {
                    Integer id = (Integer)m.get("id");
                    Double importo = CastUtils.toDouble0(m.get("pagato"));
                    pagamenti.put(id, importo);
                }
                System.out.println("fine group");
                sql = "SELECT t.id as fatt_id, s.*  FROM test_fatt t  LEFT JOIN scadenze s ON (s.documento_tipo = 'FA' AND s.id_doc = t.id)";
                sql = sql + " where 1 = 1";
                if (clifor != null) {
                    sql = sql + " and t.cliente = " + dbu.sql((Object)clifor);
                }
                if (dal != null) {
                    sql = sql + " and t.data >= " + dbu.sql((Object)dal);
                }
                if (al != null) {
                    sql = sql + " and t.data <= " + dbu.sql((Object)al);
                }
                sql = sql + " order by t.anno, t.serie, t.numero, s.numero";
                System.out.println("sql scadenze = " + sql);
                ArrayList scadenze = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                HashMap scadenze_per_fat = new HashMap();
                if (estrai_scadenze) {
                    for (Map m : scadenze) {
                        Integer id = cu.toInteger(m.get("fatt_id"));
                        List list_per_fat = null;
                        list_per_fat = scadenze_per_fat.containsKey(id) ? (List)scadenze_per_fat.get(id) : new ArrayList();
                        list_per_fat.add(m);
                        scadenze_per_fat.put(id, list_per_fat);
                    }
                }
                for (Map m : this.rs) {
                    if (!StringUtils.isEmpty((String)cu.s(m.get("ragione_sociale"))) && !StringUtils.isEmpty((String)cu.s(m.get("indirizzo"))) && !StringUtils.isEmpty((String)cu.s(m.get("cap"))) && !StringUtils.isEmpty((String)cu.s(m.get("localita")))) continue;
                    this.erroreCliente = true;
                    this.clientiConErrori = this.clientiConErrori + cu.s(m.get("codice")) + " - " + cu.s(m.get("ragione_sociale")) + "\n";
                }
                if (this.erroreCliente) break block95;
                for (Map rsm : this.rs) {
                    int i;
                    int numCodiciIva;
                    ArrayList<CampoReadyTec> listaCampi = new ArrayList<CampoReadyTec>();
                    int tipoFattura = 1;
                    if (cu.i(rsm.get("tipo_fattura")) == 3) {
                        tipoFattura = 2;
                    }
                    System.out.println("rsm = " + rsm);
                    sql = "select IFNULL(i.conto_readytec,'') as conto_readytec from test_fatt t  left join righ_fatt r on t.id = r.id_padre left join codici_iva i on r.iva = i.codice where t.id = " + rsm.get("id_doc") + " group by IFNULL(i.conto_readytec,'')";
                    ArrayList list_conti_iva = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                    this.codiceContoDefault = this.codiceContoDefaultOrig;
                    if (list_conti_iva.size() > 1) {
                        SwingUtils.showErrorMessage((Component)frm, (String)("La fattura " + rsm.get("serie") + rsm.get("numero") + " del " + rsm.get("data") + " contiene pi\u00f9 di un conto \u00e8 non \u00e8 possibile esportarla"));
                        continue;
                    }
                    if (list_conti_iva.size() == 1) {
                        String conto_iva = cu.s(((Map)list_conti_iva.get(0)).get("conto_readytec"));
                        if (StringUtils.isNotBlank((String)conto_iva)) {
                            System.out.println("impostato conto da codice iva = " + conto_iva + " invece di conto default = " + this.codiceContoDefault);
                            this.codiceContoDefault = conto_iva;
                        }
                    } else {
                        throw new Exception("Manca il codice/conto FATSEQ in anagrafica IVA - Fattura " + rsm.get("serie") + rsm.get("numero") + " del " + rsm.get("data"));
                    }
                    this.publish(new Object[]{"esportazione " + cu.s(rsm.get("serie")) + "/" + cu.i(rsm.get("numero")) + " del " + DateUtils.formatDateIta((Date)cu.toDate(rsm.get("data")))});
                    listaCampi.add(new CampoReadyTec("DITTANUM", null, CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 4, false));
                    listaCampi.add(new CampoReadyTec("TIPODOC", tipoFattura, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 1, true));
                    listaCampi.add(new CampoReadyTec("DATAFAT", cu.toDate(rsm.get("data")), CampoReadyTec.TIPO_DATA, CampoReadyTec.ALLINEAMENTO_DATA_ENG, 0, CampoReadyTec.DATA_NO_SECOLO, ",", 6, true));
                    String serie = "";
                    if (main.getPersonalContain("premioceleste") && cu.s(rsm.get("serie")).equals("P")) {
                        serie = "1";
                    } else if (tipoFattura != 2) {
                        serie = null;
                        String serie_fattura = cu.s(rsm.get("serie"));
                        List list = (List)json_param_impexp.get("tabSerieFatseq");
                        if (list != null && list.size() > 0) {
                            for (Map m : list) {
                                if (!cu.s(m.get("Serie Invoicex")).equalsIgnoreCase(serie_fattura)) continue;
                                serie = cu.s(m.get("Serie TeamSystem"));
                                break;
                            }
                            if (serie == null) {
                                for (Map m : list) {
                                    if (!cu.s(m.get("Serie Invoicex")).equalsIgnoreCase("")) continue;
                                    serie = cu.s(m.get("Serie TeamSystem"));
                                    break;
                                }
                            }
                            if (serie == null) {
                                serie = "";
                            }
                        } else {
                            serie = "";
                            if (StringUtils.isNotBlank((String)serie_fattura)) {
                                try {
                                    char asci = serie_fattura.toUpperCase().charAt(0);
                                    if (asci < 'A' || asci > 'Z') {
                                        String msg = "";
                                        try {
                                            msg = cu.s(rsm.get("serie")) + "/" + cu.i(rsm.get("numero"));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore, la fattura " + msg + " ha la serie non alfabetica e non \u00e8 gestitibile"), (boolean)true);
                                        return null;
                                    }
                                    serie = String.valueOf(asci - 64);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
                                }
                            }
                        }
                    } else {
                        serie = "";
                    }
                    System.out.println("serie = " + serie);
                    System.out.println("rsm.get(\"numero\") = " + rsm.get("numero"));
                    if (serie.equals("") && cu.i(rsm.get("numero")) == 504) {
                        System.out.println("debug");
                    }
                    listaCampi.add(new CampoReadyTec("SERIE", serie, CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 2, CampoReadyTec.SEGNO_NO, ",", 2, false));
                    listaCampi.add(new CampoReadyTec("NUMFAT", cu.i(rsm.get("numero")), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 6, true));
                    if (cu.i(rsm.get("numero")) == 2022) {
                        System.out.println("stop");
                    }
                    listaCampi.add(new CampoReadyTec("CLFO", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 5, false));
                    listaCampi.add(new CampoReadyTec("RAGSOC", cu.s(rsm.get("ragione_sociale")), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 32, true));
                    listaCampi.add(new CampoReadyTec("INDIRIZZO", cu.s(rsm.get("indirizzo")), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 32, true));
                    listaCampi.add(new CampoReadyTec("CAP", cu.s(rsm.get("cap")), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 5, true));
                    listaCampi.add(new CampoReadyTec("LOCALITA", cu.s(rsm.get("localita")), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 25, true));
                    listaCampi.add(new CampoReadyTec("PROV", cu.s(rsm.get("provincia")).toUpperCase(), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 2, false));
                    listaCampi.add(new CampoReadyTec("PARTIVA", cu.s(rsm.get("piva_cfiscale")).toUpperCase(), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 11, false));
                    listaCampi.add(new CampoReadyTec("CODFISC", cu.s(rsm.get("cfiscale")).toUpperCase(), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 16, false));
                    System.out.println("rsm.get(\"id\") = " + rsm.get("id_doc"));
                    ArrayList codiciIva = (ArrayList)iveriga2.get(cu.i(rsm.get("id_doc")));
                    if (codiciIva == null) {
                        System.out.println("stop");
                    }
                    double totale_imponibile = 0.0;
                    for (numCodiciIva = 1; numCodiciIva <= 8; ++numCodiciIva) {
                        if (codiciIva != null && codiciIva.size() >= numCodiciIva) {
                            try {
                                Double timpo = Math.abs(CastUtils.toDouble0(((Map)codiciIva.get(numCodiciIva - 1)).get("timpo")));
                                listaCampi.add(new CampoReadyTec("FAT-IMPONIBILE-" + numCodiciIva, timpo != 0.0 ? timpo : null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                                totale_imponibile += cu.d0((Object)timpo).doubleValue();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.erroreIva = true;
                            }
                            continue;
                        }
                        listaCampi.add(new CampoReadyTec("FAT-IMPONIBILE-" + numCodiciIva, null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_NO, "", 12, false));
                    }
                    for (numCodiciIva = 1; numCodiciIva <= 8; ++numCodiciIva) {
                        if (codiciIva != null && codiciIva.size() >= numCodiciIva) {
                            try {
                                Integer codicei = CastUtils.toInteger0(((Map)codiciIva.get(numCodiciIva - 1)).get("iva_rea"));
                                if (codicei == 0) {
                                    if (this.codiceIvaDefault.equals("")) {
                                        this.codiciIvaNonCollegati = this.codiciIvaNonCollegati + "Impostare il codice di collegamento TeamSystem FATSEQ per il codice IVA " + ((Map)codiciIva.get(numCodiciIva - 1)).get("iva") + "\n";
                                    } else {
                                        codicei = CastUtils.toInteger0((Object)this.codiceIvaDefault);
                                    }
                                }
                                listaCampi.add(new CampoReadyTec("FAT-ALIVA-" + numCodiciIva, codicei != 0 ? codicei : null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 3, false));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.erroreIva = true;
                            }
                            continue;
                        }
                        listaCampi.add(new CampoReadyTec("FAT-ALIVA-" + numCodiciIva, null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 3, false));
                    }
                    double totale_iva = 0.0;
                    for (int numCodiciIva2 = 1; numCodiciIva2 <= 8; ++numCodiciIva2) {
                        if (codiciIva != null && codiciIva.size() >= numCodiciIva2) {
                            try {
                                Double tiva = Math.abs(CastUtils.toDouble0(((Map)codiciIva.get(numCodiciIva2 - 1)).get("tiva")));
                                listaCampi.add(new CampoReadyTec("FAT-IMPIVA-" + numCodiciIva2, tiva != 0.0 ? tiva : null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 10, false));
                                totale_iva += cu.d0((Object)tiva).doubleValue();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                this.erroreIva = true;
                            }
                            continue;
                        }
                        listaCampi.add(new CampoReadyTec("FAT-IMPIVA-" + numCodiciIva2, null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_NO, "", 10, false));
                    }
                    double totale = 0.0;
                    totale = cu.d0(rsm.get("totale_da_pagare")) != 0.0 ? cu.d0(rsm.get("totale_da_pagare")).doubleValue() : cu.d0(rsm.get("totale")).doubleValue();
                    listaCampi.add(new CampoReadyTec("FAT-TIPOIVA", 0, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 3, true));
                    String cod_pag = cu.s(rsm.get("id_pagamento_teamsystem"));
                    if (StringUtils.isBlank((String)cod_pag)) {
                        cod_pag = cu.s(dati_azienda.get("export_fatture_cod_pag_std"));
                    }
                    listaCampi.add(new CampoReadyTec("FAT-CODPAGIN", cod_pag, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 3, false));
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-1", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                    if (estrai_acconti) {
                        listaCampi.add(new CampoReadyTec("FAT-ACCONTI", pagamenti.get(cu.i(rsm.get("id_doc"))), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 10, false));
                    } else {
                        listaCampi.add(new CampoReadyTec("FAT-ACCONTI", 0, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 10, false));
                    }
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-1", null, CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, CampoReadyTec.SEGNO_NO, 0, "", 33, false));
                    listaCampi.add(new CampoReadyTec("FAT-ESIGIBILITA-DIFFERITA", this.esigDiffIva, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, CampoReadyTec.SEGNO_NO, 0, "", 1, false));
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-1", null, CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_SINISTRA, CampoReadyTec.SEGNO_NO, 0, "", 14, false));
                    listaCampi.add(new CampoReadyTec("FAT-IMPSPINC", cu.d0(rsm.get("spese_incasso")), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 10, false));
                    listaCampi.add(new CampoReadyTec("FAT-IMPBOLLI", cu.d0(rsm.get("marca_da_bollo")), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 10, false));
                    String tabella = "test_fatt";
                    String tab_righe = "righ_fatt";
                    Integer id = cu.i(rsm.get("id_doc"));
                    boolean acquisto = false;
                    Double totaleConto = null;
                    boolean prezziIvati = cu.toBoolean(rsm.get("prezzi_ivati"));
                    if (!prezziIvati) {
                        totaleConto = cu.d0(rsm.get("totale_imponibile")) - cu.d0(rsm.get("spese_incasso")) - cu.d0(rsm.get("spese_trasporto")) - cu.d0(rsm.get("marca_da_bollo"));
                    } else {
                        totaleConto = cu.d0(rsm.get("totale_imponibile"));
                        totaleConto = totaleConto - cu.d0(rsm.get("marca_da_bollo"));
                        double totaleSpese = cu.d0(rsm.get("spese_incasso")) + cu.d0(rsm.get("spese_trasporto"));
                        totaleSpese = this.getImponibileSpese(tabella, id, totaleSpese, tab_iva);
                        totaleConto = totaleConto - Util.round(totaleSpese, 2);
                    }
                    List listTotali = null;
                    if (usa_conti_contab) {
                        try {
                            Class<?> cl = Class.forName("it.tnx.invoicex.pnota.PNUtil", true, main.pf.classloader);
                            Method m = cl.getDeclaredMethod("getTotaliRighePerConto", String.class, Integer.class);
                            listTotali = (List)m.invoke(cl.newInstance(), "test_fatt", rsm.get("id_doc"));
                            System.out.println("ReadyTec() listTotali = " + listTotali);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-2", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 36, false));
                    List lscadenze = null;
                    try {
                        lscadenze = (List)scadenze_per_fat.get(id);
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                    int nscadenze = 0;
                    if (lscadenze != null) {
                        nscadenze = lscadenze.size();
                    }
                    for (i = 1; i <= 12; ++i) {
                        String tipo_eff = "";
                        if (i <= nscadenze && StringUtils.isBlank((String)(tipo_eff = cu.s(rsm.get("tipo_effetto_teamsystem"))))) {
                            tipo_eff = cu.s(dati_azienda.get("export_fatture_tipo_eff_std"));
                        }
                        listaCampi.add(new CampoReadyTec("FAT-TIPO-EFF-0" + i, tipo_eff, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 1, false));
                    }
                    for (i = 1; i <= 12; ++i) {
                        Date data = null;
                        if (i <= nscadenze) {
                            data = cu.toDate(((Map)lscadenze.get(i - 1)).get("data_scadenza"));
                        }
                        listaCampi.add(new CampoReadyTec("FAT-DATA-SCAD-0" + i, data, CampoReadyTec.TIPO_DATA, CampoReadyTec.ALLINEAMENTO_DATA_ENG, 0, CampoReadyTec.DATA_CON_SECOLO, ",", 8, false));
                    }
                    for (i = 1; i <= 12; ++i) {
                        Double importo = null;
                        if (i <= nscadenze) {
                            importo = cu.toDouble(((Map)lscadenze.get(i - 1)).get("importo"));
                        }
                        listaCampi.add(new CampoReadyTec("FAT-IMPO-SCAD-01" + i, importo, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                    }
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-2", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 96, false));
                    if (usa_conti_contab) {
                        i = 0;
                        if (listTotali != null && listTotali.size() > 0) {
                            for (Map m : listTotali) {
                                listaCampi.add(new CampoReadyTec("FAT-CONTO-" + ++i, m.get("conto"), CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_NO, "", 7, false));
                            }
                        }
                        listaCampi.add(new CampoReadyTec("RIEMPIMENTO-3", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 140 - i * 7, false));
                        i = 0;
                        if (listTotali != null && listTotali.size() > 0) {
                            for (Map m : listTotali) {
                                listaCampi.add(new CampoReadyTec("FAT-TOT-CONTO-" + ++i, Math.abs(cu.d0(m.get("imponibile"))), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                            }
                        }
                        listaCampi.add(new CampoReadyTec("RIEMPIMENTO-4", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 240 - i * 12, false));
                    } else {
                        listaCampi.add(new CampoReadyTec("FAT-CONTO-1", this.codiceContoDefault, CampoReadyTec.TIPO_ALFANUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_NO, "", 7, false));
                        listaCampi.add(new CampoReadyTec("RIEMPIMENTO-3", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 133, false));
                        listaCampi.add(new CampoReadyTec("FAT-TOT-CONTO-01", Math.abs(totaleConto), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                        listaCampi.add(new CampoReadyTec("RIEMPIMENTO-4", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 228, false));
                    }
                    listaCampi.add(new CampoReadyTec("FAT-TOT-DOCUM", Math.abs(totale), CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 2, CampoReadyTec.SEGNO_DOPO, "", 12, false));
                    listaCampi.add(new CampoReadyTec("FAT-TIPOFAT", 3, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_NO, "", 1, false));
                    listaCampi.add(new CampoReadyTec("RIEMPIMENTO-5", null, CampoReadyTec.TIPO_NUMERICO, CampoReadyTec.ALLINEAMENTO_DESTRA, 0, CampoReadyTec.SEGNO_DOPO, "", 78, false));
                    listaCampi.add(new CampoReadyTec("VERSIONE-1", "1 ", CampoReadyTec.TIPO_ALFANUMERICO_NOTRIM, CampoReadyTec.ALLINEAMENTO_SINISTRA, 0, CampoReadyTec.SEGNO_NO, "", 2, false));
                    this.listaRighe.add(listaCampi);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)"Errore nella lettura dei dati", (String)"Errore Database");
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)("Errore: " + ex.getMessage()), (String)"Errore");
                return false;
            }
        }
        try {
            File startDir;
            if (this.erroreCliente || this.erroreIva) {
                if (this.erroreCliente) {
                    String msg = "Le anagrafiche di alcuni clienti non sono complete:\n" + this.clientiConErrori;
                    System.out.println("msg = " + msg);
                    SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)msg, (String)"Errore anagrafica clienti", (boolean)true);
                    return false;
                }
                if (!this.codiciIvaNonCollegati.equals("")) {
                    System.out.println("codiciIvaNonCollegati = " + this.codiciIvaNonCollegati);
                    SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)this.codiciIvaNonCollegati, (String)"Errore anagrafica clienti", (boolean)true);
                    return false;
                }
                if (this.erroreIva) {
                    SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)"Si \u00e8 verificato un errore nella lettura dei codici IVA", (String)"Errore codici IVA", (boolean)true);
                    return false;
                }
                SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)"Impossibile proseguire", (String)"Errore");
                return false;
            }
            String dir = System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "TeamSystemFATSEQExport" + File.separator;
            if (this.param.get("dir") != null) {
                dir = (String)this.param.get("dir");
            }
            if (!(startDir = new File(dir)).exists()) {
                startDir.mkdir();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
            this.nomeFile = dir + "export_TeamSystem_FATSEQ_" + sdf.format(new Date()) + ".txt";
            if (this.param.get("dir") != null) {
                this.nomeFile = dir + "fatture_vendita.txt";
            }
            this.publish(new Object[]{"scrittura file in corso"});
            FileOutputStream fos = new FileOutputStream(this.nomeFile);
            for (ArrayList riga : this.listaRighe) {
                String concat = "";
                System.out.println("riga = " + riga);
                for (CampoReadyTec campo : riga) {
                    try {
                        String rigaText = campo.formatCampo();
                        rigaText = rigaText.replace("\u00e0", "a");
                        rigaText = rigaText.replace("\u00e8", "e");
                        rigaText = rigaText.replace("\u00e9", "e");
                        rigaText = rigaText.replace("\u00ec", "i");
                        rigaText = rigaText.replace("\u00f2", "o");
                        rigaText = rigaText.replace("\u00f9", "u");
                        concat = concat + rigaText;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingUtils.showErrorMessage((Component)main.getPadreFrame(), (String)e.getMessage(), (String)"Errore Export");
                        return null;
                    }
                }
                concat = concat + "\r\n";
                fos.write(concat.getBytes("ISO-8859-1"));
            }
            fos.close();
            if (this.param.get("dir") == null) {
                gestioneFatture.Util.start2(dir);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private Double getImponibileSpese(String tab_testata, Integer id, double spese, HashMap tab_iva) throws Exception {
        boolean acquisto = tab_testata.endsWith("_acquisto");
        String tabella = tab_testata;
        String tab_righe = InvoicexUtil.getTabRigheFromTabTestate(tab_testata);
        String campo_clifor = acquisto ? "fornitore" : "cliente";
        String campo_totale_imponibile = acquisto ? "imponibile" : "totale_imponibile";
        String campo_totale_iva = acquisto ? "iva" : "totale_iva";
        String campo_totale = acquisto ? "importo" : "totale";
        String campo_id_test_fatt = acquisto ? "id_test_fatt_acquisto" : "id_test_fatt";
        String sql = "select t.id, t.tipo_fattura, t.serie, t.numero, t.anno, t.data, t." + campo_totale_imponibile + " as totale_imponibile, t." + campo_totale_iva + " as totale_iva, t." + campo_totale + " as totale";
        sql = sql + " , i.codice_iva, i.perc_iva, i.imponibile as iva_imponibile, i.iva as iva_iva, i.totale as iva_totale " + (acquisto ? ", i.perc_deducibile" : "");
        sql = sql + " , t.spese_incasso";
        sql = sql + " , t.spese_trasporto";
        sql = sql + " , t.sconto as sconto_a_importo";
        sql = sql + " , t.totale_imponibile_pre_sconto";
        sql = sql + " , t.totale_ivato_pre_sconto";
        sql = sql + " , t.prezzi_ivati";
        sql = sql + " , t.sconto1";
        sql = sql + " , t.sconto2";
        sql = sql + " , t.sconto3";
        if (main.pluginRitenute) {
            sql = sql + " , t.totale_da_pagare";
            sql = sql + " , t.totale_ritenuta";
            sql = sql + " , t.totaleRivalsa as totale_rivalsa";
            sql = sql + " , t.ritenuta";
            sql = sql + " , t.rivalsa";
        }
        if (tabella.equalsIgnoreCase("test_fatt")) {
            sql = sql + " , tx.split_payment as split_payment_doc";
        }
        if (acquisto) {
            sql = sql + " , numero_doc, serie_doc, data_doc";
        }
        String tabella_det_iva = tabella + "_iva";
        if (acquisto) {
            tabella_det_iva = tabella_det_iva + "_ded";
        }
        sql = sql + " from " + tabella + " t left join " + tabella_det_iva + " i on t.id = i.id_padre";
        if (tabella.equalsIgnoreCase("test_fatt")) {
            sql = sql + " left join test_fatt_xmlpa tx on t.id = tx.id_fattura ";
        }
        sql = sql + " left join clie_forn cf on t." + campo_clifor + " = cf.codice";
        sql = sql + " where t.id = " + id;
        sql = sql + " order by i.codice_iva";
        System.out.println("sql list = " + sql);
        ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
        Map m = (Map)list.get(0);
        HashMap mit = new HashMap();
        mit.put("data", m.get("data"));
        double sconto_a_importo = cu.toDouble0(m.get("sconto_a_importo"));
        double sconto1 = (100.0 - cu.toDouble0(m.get("sconto1"))) / 100.0;
        double sconto2 = (100.0 - cu.toDouble0(m.get("sconto2"))) / 100.0;
        double sconto3 = (100.0 - cu.toDouble0(m.get("sconto3"))) / 100.0;
        double totale_ivato = cu.toDouble0(m.get(campo_totale));
        double totale_imponibile = cu.toDouble0(m.get("totale_imponibile"));
        double totale_ivato_pre_sconto = cu.toDouble0(m.get("totale_ivato_pre_sconto"));
        double totale_imponibile_pre_sconto = cu.toDouble0(m.get("totale_imponibile_pre_sconto"));
        boolean prezzi_ivati = false;
        if (CastUtils.toBoolean(m.get("prezzi_ivati"))) {
            prezzi_ivati = true;
        }
        Double totale_da_pagare = null;
        Double totale_ritenuta = null;
        Double totale_rivalsa = null;
        if (main.pluginRitenute) {
            totale_da_pagare = cu.toDouble0(m.get("totale_da_pagare"));
            totale_ritenuta = cu.toDouble0(m.get("totale_ritenuta"));
            totale_rivalsa = cu.toDouble0(m.get("totale_rivalsa"));
        }
        double sconto_a_importo_perc = 1.0;
        if (totale_imponibile_pre_sconto != 0.0) {
            sconto_a_importo_perc = totale_imponibile / totale_imponibile_pre_sconto;
            if (totale_rivalsa != null && cu.toBoolean((Object)main.getGlobDatiAzienda("includi_rivalsa_in_iva", true))) {
                sconto_a_importo_perc = (totale_imponibile - totale_rivalsa) / (totale_imponibile_pre_sconto - totale_rivalsa);
            }
        }
        HashMap<String, Double> proporzioniIva = null;
        String codiceIvaSpese = "";
        codiceIvaSpese = InvoicexUtil.getIvaSpesePerData(cu.toDate(m.get("data")), "codiceIvaSpese");
        Iva ivaSpese = new Iva();
        boolean ripartire_spese = false;
        proporzioniIva = new HashMap<String, Double>();
        if (ivaSpese.load(Db.INSTANCE, codiceIvaSpese)) {
            proporzioniIva.put(codiceIvaSpese, 100.0);
        } else {
            sql = "select conto, sum(prezzo_ivato_netto_totale) as somma_totale_ivato, sum(prezzo_netto_totale) as somma_totale, iva";
            sql = sql + " from " + tab_righe;
            sql = sql + " where id_padre = " + id;
            sql = sql + " group by iva";
            System.out.println("sql = " + sql);
            ArrayList listrighe = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
            double totale_ivato_righe = totale_ivato_pre_sconto - cu.toDouble0(m.get("spese_trasporto")) - cu.toDouble0(m.get("spese_incasso"));
            double totale_righe = totale_imponibile_pre_sconto - cu.toDouble0(m.get("spese_trasporto")) - cu.toDouble0(m.get("spese_incasso"));
            for (Map mr : listrighe) {
                double somma_totale_ivato_iva = cu.toDouble0(mr.get("somma_totale_ivato"));
                double somma_totale_iva = cu.toDouble0(mr.get("somma_totale"));
                if (cu.toBoolean((Object)main.getGlobDatiAzienda("includi_rivalsa_in_iva", true))) {
                    double iva_std = 22.0;
                    Date data = cu.toDate(m.get("data"));
                    if (data != null && data.before(DateUtils.getOnlyDate((int)2011, (int)9, (int)17))) {
                        iva_std = 20.0;
                    } else if (data != null && data.before(DateUtils.getOnlyDate((int)2013, (int)10, (int)1))) {
                        iva_std = 21.0;
                    }
                    try {
                        double perc_iva = cu.toDouble0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("select percentuale from codici_iva where codice = " + Db.pc((Object)cu.toString(mr.get("iva")), 12))));
                        if (perc_iva == iva_std) {
                            somma_totale_ivato_iva += totale_rivalsa * (1.0 + iva_std / 100.0);
                            somma_totale_iva += totale_rivalsa.doubleValue();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (prezzi_ivati) {
                    proporzioniIva.put(cu.toString(mr.get("iva")), 100.0 * somma_totale_ivato_iva / totale_ivato_righe);
                    continue;
                }
                proporzioniIva.put(cu.toString(mr.get("iva")), 100.0 * somma_totale_iva / totale_righe);
            }
            System.out.println("proporzioniIvaPrezziIvati = " + proporzioniIva);
        }
        double spese_imp = 0.0;
        if (spese != 0.0) {
            spese *= sconto_a_importo_perc;
            for (Map.Entry entry : proporzioniIva.entrySet()) {
                String codice_iva_prop = (String)entry.getKey();
                Double perc_prop = (Double)entry.getValue();
                double spese_prop = spese * perc_prop / 100.0;
                double perc_iva = cu.d0(((Map)tab_iva.get(codice_iva_prop)).get("percentuale"));
                double spese_prop_imp = 100.0 * spese_prop / (100.0 + perc_iva);
                spese_imp += spese_prop_imp;
            }
        }
        return spese_imp;
    }
}

