/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import gestioneFatture.InvoicexEvent;
import gestioneFatture.JDialogInsert;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ImportArticoli
implements HSSFListener {
    private POIFSFileSystem fs;
    private int lastRowNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private ArrayList boundSheetRecords = new ArrayList();
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private ArrayList chiaviDb;
    private HashMap valorim = new HashMap(10);
    private String sql = "";
    private String sqlpre = "";
    private String listino = "";
    public JDialogInsert insert;
    private int lastRow;
    NumberFormat nf1 = new DecimalFormat("0");
    DecimalFormat df = new DecimalFormat("0.#####");
    boolean interrompi = false;
    Integer deposito = null;
    int elab_ok = 0;
    int elab_ko = 0;
    private String filename;
    TipoImport giacenze = TipoImport.NO;

    public ImportArticoli(POIFSFileSystem fs) {
        this.fs = fs;
    }

    public ImportArticoli(String filename, String listino, int lastRow, TipoImport giacenze, Integer deposito) throws IOException, FileNotFoundException {
        this(new POIFSFileSystem((InputStream)new FileInputStream(filename)));
        this.lastRow = lastRow;
        this.listino = listino;
        this.giacenze = giacenze;
        this.filename = filename;
        this.deposito = deposito;
        this.chiaviDb = new ArrayList();
        this.chiaviDb.add("codice");
        this.chiaviDb.add("descrizione");
        this.chiaviDb.add("prezzo");
        this.chiaviDb.add("iva");
        this.chiaviDb.add("um");
        this.chiaviDb.add("codice_a_barre");
        this.chiaviDb.add("codice_fornitore");
        this.chiaviDb.add("descrizione_en");
        this.chiaviDb.add("um_en");
        this.chiaviDb.add("gestione_lotti");
        this.chiaviDb.add("gestione_matricola");
        this.chiaviDb.add("fornitore");
        this.chiaviDb.add("categoria");
        this.chiaviDb.add("sottocategoria");
        this.chiaviDb.add("peso_kg");
        this.chiaviDb.add("disponibilita_reale");
    }

    public void process() throws IOException {
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)new AbortableHSSFListener(){

            public short abortableProcessRecord(Record record) throws HSSFUserException {
                if (ImportArticoli.this.interrompi) {
                    System.out.println("aborto");
                    return 1;
                }
                return 0;
            }
        });
        if (this.outputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        try {
            factory.abortableProcessWorkbookEvents(request, this.fs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.events.fireInvoicexEvent(new InvoicexEvent(this, 78));
    }

    public void processRecord(Record record) {
        int thisRow;
        block46: {
            thisRow = -1;
            int thisColumn = -1;
            try {
                String temp = "";
                switch (record.getSid()) {
                    case 133: {
                        this.boundSheetRecords.add(record);
                        break;
                    }
                    case 2057: {
                        break;
                    }
                    case 252: {
                        this.sstRecord = (SSTRecord)record;
                        break;
                    }
                    case 513: {
                        break;
                    }
                    case 517: {
                        break;
                    }
                    case 6: {
                        FormulaRecord frec = (FormulaRecord)record;
                        thisRow = frec.getRow();
                        thisColumn = frec.getColumn();
                        break;
                    }
                    case 519: {
                        StringRecord srec = (StringRecord)record;
                        temp = cu.s((Object)srec.getString());
                        temp = temp.replaceAll("\\s+$", "");
                        this.valorim.put(this.chiaviDb.get(thisColumn), temp);
                        thisRow = this.nextRow;
                        thisColumn = this.nextColumn;
                        break;
                    }
                    case 516: {
                        LabelRecord lrec = (LabelRecord)record;
                        thisRow = lrec.getRow();
                        thisColumn = lrec.getColumn();
                        temp = cu.s((Object)lrec.getValue());
                        temp = temp.replaceAll("\\s+$", "");
                        this.valorim.put(this.chiaviDb.get(thisColumn), temp);
                        break;
                    }
                    case 253: {
                        LabelSSTRecord lsrec = (LabelSSTRecord)record;
                        thisRow = lsrec.getRow();
                        thisColumn = lsrec.getColumn();
                        if (this.sstRecord == null) {
                            this.valorim.put(this.chiaviDb.get(thisColumn), "");
                            break;
                        }
                        temp = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                        temp = temp.replaceAll("\\s+$", "");
                        if (this.chiaviDb.get(lsrec.getColumn()).equals("prezzo")) {
                            Double prezzo = cu.toDoubleAll((Object)temp);
                            if (prezzo == null) break;
                            this.valorim.put(this.chiaviDb.get(thisColumn), prezzo);
                            break;
                        }
                        this.valorim.put(this.chiaviDb.get(thisColumn), temp);
                        break;
                    }
                    case 28: {
                        break;
                    }
                    case 515: {
                        NumberRecord numrec = (NumberRecord)record;
                        thisRow = numrec.getRow();
                        thisColumn = numrec.getColumn();
                        if (!(this.chiaviDb.get(numrec.getColumn()).equals("prezzo") || this.chiaviDb.get(numrec.getColumn()).equals("peso_kg") || this.chiaviDb.get(numrec.getColumn()).equals("disponibilita_reale"))) {
                            this.valorim.put(this.chiaviDb.get(thisColumn), this.nf1.format(numrec.getValue()));
                            break;
                        }
                        if (this.chiaviDb.get(numrec.getColumn()).equals("prezzo")) {
                            Double prezzo = 0.0;
                            try {
                                prezzo = numrec.getValue();
                            }
                            catch (Exception e) {
                                System.err.println("!!! errore prezzo:" + this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec) + " msg:" + e.getMessage());
                            }
                            this.valorim.put(this.chiaviDb.get(thisColumn), prezzo);
                            break;
                        }
                        this.valorim.put(this.chiaviDb.get(thisColumn), numrec.getValue());
                        break;
                    }
                    case 638: {
                        break;
                    }
                }
                if (record instanceof MissingCellDummyRecord) {
                    MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
                    thisRow = mc.getRow();
                    thisColumn = mc.getColumn();
                    if (this.chiaviDb.size() > thisColumn) {
                        this.valorim.put(this.chiaviDb.get(thisColumn), null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (SwingUtils.showYesNoMessage((Component)main.padre_panel.desktop.getSelectedFrame(), (String)("Si \u00e8 verificato questo problema:\n" + e.getClass().getSimpleName() + ":" + e.getMessage() + "\n\nVuoi continuare ?"))) break block46;
                this.interrompi = true;
            }
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            if (this.valorim.get("codice") == null || StringUtils.isBlank((String)cu.toString(this.valorim.get("codice")))) {
                this.insert.updateValue();
            } else {
                block49: {
                    int rowsupdatedprezzi;
                    int rowsupdated;
                    Double giac;
                    Double prezzo;
                    block47: {
                        Iterator it = this.valorim.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            Object v = entry.getValue();
                            if (v != null && !StringUtils.isBlank((String)cu.toString(v))) continue;
                            it.remove();
                        }
                        if (this.valorim.containsKey("iva") && (this.valorim.get("iva") == null || this.valorim.get("iva").toString().length() == 0)) {
                            this.valorim.put("iva", InvoicexUtil.getIvaDefaultPassaggio());
                        }
                        if (this.valorim.get("peso_kg") != null) {
                            System.out.println("peso:" + this.valorim.get("peso_kg"));
                        }
                        prezzo = 0.0;
                        try {
                            prezzo = (Double)this.valorim.get("prezzo");
                        }
                        catch (Exception entry) {
                            // empty catch block
                        }
                        this.valorim.remove("prezzo");
                        giac = cu.d(this.valorim.get("disponibilita_reale"));
                        this.valorim.remove("disponibilita_reale");
                        rowsupdated = 0;
                        rowsupdatedprezzi = 0;
                        this.sql = "insert into articoli set " + DbUtils.prepareSqlFromMap((Map)this.valorim);
                        try {
                            DbUtils.tryExecQuery((Connection)Db.getConn(), (String)this.sql);
                            rowsupdated = 1;
                            ++this.elab_ok;
                        }
                        catch (Exception e) {
                            if (e instanceof SQLException && ((SQLException)e).getErrorCode() == 1062) {
                                this.sql = "update articoli set " + DbUtils.prepareSqlFromMap((Map)this.valorim);
                                this.sql = this.sql + " where codice = '" + Db.aa(CastUtils.toString(this.valorim.get("codice"))) + "'";
                                try {
                                    rowsupdated = DbUtils.tryExecQueryWithResult((Connection)Db.getConn(), (String)this.sql);
                                    ++this.elab_ok;
                                }
                                catch (Exception ex) {
                                    System.err.println("sql di errore articoli: " + this.sql);
                                    ++this.elab_ko;
                                    ex.printStackTrace();
                                }
                            }
                            e.printStackTrace();
                            if (SwingUtils.showYesNoMessage((Component)main.padre_panel.desktop.getSelectedFrame(), (String)("Si \u00e8 verificato questo problema:\n" + e.getClass().getSimpleName() + ":" + e.getMessage() + "\n\nVuoi continuare ?"))) break block47;
                            this.interrompi = true;
                        }
                    }
                    if (!this.interrompi) {
                        block48: {
                            this.sqlpre = "insert into articoli_prezzi SET articolo = '" + Db.aa(CastUtils.toString(this.valorim.get("codice"))) + "', prezzo = (" + prezzo + "), listino = '" + Db.aa(this.listino) + "'";
                            try {
                                DbUtils.tryExecQuery((Connection)Db.getConn(), (String)this.sqlpre);
                                rowsupdatedprezzi = 1;
                                ++this.elab_ok;
                            }
                            catch (Exception e) {
                                if (!(e instanceof SQLException) || ((SQLException)e).getErrorCode() != 1062) break block48;
                                try {
                                    Integer id_ap = cu.i((Object)dbu.getObject((Connection)Db.getConn(), (String)("select id from articoli_prezzi where articolo = '" + Db.aa(CastUtils.toString(this.valorim.get("codice"))) + "' and listino = '" + Db.aa(this.listino) + "'")));
                                    this.sqlpre = "update articoli_prezzi SET prezzo = (" + prezzo + ") where id = " + id_ap;
                                    rowsupdatedprezzi = DbUtils.tryExecQueryWithResult((Connection)Db.getConn(), (String)this.sqlpre);
                                    ++this.elab_ok;
                                }
                                catch (Exception ex) {
                                    System.err.println("sql di errore articoli prezzi: " + this.sqlpre);
                                    ++this.elab_ko;
                                    ex.printStackTrace();
                                }
                            }
                        }
                        if (this.giacenze != TipoImport.NO && giac != null) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("classe", this);
                            map.put("articolo", this.valorim.get("codice"));
                            map.put("tipoimport", (Object)this.giacenze);
                            map.put("giacenza", giac);
                            map.put("deposito", this.deposito);
                            map.put("rowsupdated", rowsupdated);
                            map.put("rowsupdatedprezzi", rowsupdatedprezzi);
                            map.put("nomefile", new File(this.filename).getName());
                            try {
                                main.events.fireInvoicexEventExc(new InvoicexEvent(map, 42));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (SwingUtils.showYesNoMessage((Component)main.padre_panel.desktop.getSelectedFrame(), (String)("Si \u00e8 verificato questo problema:\n" + e.getClass().getSimpleName() + ":" + e.getMessage() + "\n\nVuoi continuare ?"))) break block49;
                                this.interrompi = true;
                            }
                        }
                    }
                }
                this.sql = "";
                this.sqlpre = "";
                this.valorim.clear();
                this.insert.updateValue();
                System.out.println("elab_ok:" + this.elab_ok + " elab_ko:" + this.elab_ko);
            }
        }
    }

    public static enum TipoImport {
        NO,
        GIACENZA_TOTALE,
        GIACENZA_DEPOSITO;

    }
}

