/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import it.tnx.invoicex.PlatformUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class MacAddressUtils {
    public static String cachemac = null;

    public static String getMacAddress() {
        if (cachemac != null) {
            return cachemac;
        }
        try {
            if (PlatformUtils.isWindows()) {
                cachemac = MacAddressUtils.getWindowsMacAddress();
                return cachemac;
            }
            if (PlatformUtils.isLinux()) {
                cachemac = MacAddressUtils.getLinuxMacAddress();
                return cachemac;
            }
            if (PlatformUtils.isMac()) {
                cachemac = MacAddressUtils.getMacintoshMacAddress();
                return cachemac;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "no_mac";
    }

    /*
     * Loose catch block
     */
    public static String getWindowsMacAddress() throws Exception {
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String sLine = null;
            while ((sLine = br.readLine()) != null) {
                if (!MacAddressUtils.isPhysicalAddressLine(sLine = sLine.trim())) continue;
                StringTokenizer st = new StringTokenizer(sLine, ":");
                st.nextToken();
                try {
                    String string = st.nextToken().trim();
                    return string;
                }
                catch (Exception e) {
                    String string;
                    block9: {
                        System.out.println(e.toString() + " linea:" + sLine);
                        e.printStackTrace();
                        string = sLine;
                        if (br == null) break block9;
                        br.close();
                    }
                    return string;
                }
            }
            throw new Exception("Can't get windows MAC Address");
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public static String getLinuxMacAddress() throws Exception {
        return MacAddressUtils.getLinuxMacAddressViaIfconfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxMacAddressViaArp() throws Exception {
        String cmd = "/sbin/arp";
        File ftest = new File(cmd);
        if (!ftest.exists()) {
            cmd = "/usr/sbin/arp";
        }
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            br.readLine();
            String sLine = br.readLine();
            try {
                if (sLine != null) {
                    StringTokenizer st = new StringTokenizer(sLine, " \t");
                    st.nextToken();
                    st.nextToken();
                    String string = st.nextToken().trim();
                    return string;
                }
                String st = "";
                return st;
            }
            catch (Exception e) {
                System.out.println(e.toString() + " linea:" + sLine);
                e.printStackTrace();
                String string = sLine;
                return string;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxMacAddressViaIfconfig() throws Exception {
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringTokenizer st = new StringTokenizer(br.readLine(), " \t");
            String sToken = "";
            while (st.hasMoreTokens()) {
                sToken = st.nextToken();
            }
            String string = sToken;
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSunSolarisMacAddress() throws Exception {
        Process p = Runtime.getRuntime().exec("/sbin/arp");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            br.readLine();
            StringTokenizer st = new StringTokenizer(br.readLine(), " \t");
            st.nextToken();
            st.nextToken();
            String string = st.nextToken().trim();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMacintoshMacAddress() throws Exception {
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String sLine = null;
            while ((sLine = br.readLine()) != null) {
                if (!(sLine = sLine.trim()).startsWith("ether")) continue;
                StringTokenizer st = new StringTokenizer(sLine, " \t");
                st.nextToken();
                String string = st.nextToken();
                return string;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        throw new Exception("Can't obtain MacAddress...");
    }

    public static void main(String[] args) {
        try {
            System.out.println("MAC: " + MacAddressUtils.getMacAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isPhysicalAddressLine(String sLine) {
        return sLine.startsWith("Physical Address") || sLine.startsWith("Fyysinen osoite") || sLine.startsWith("Physikalische Adresse") || sLine.startsWith("Adres fizyczny") || sLine.startsWith("Fysisk adress") || sLine.startsWith("Indirizzo fisico") || sLine.startsWith("Endere\u00e7o f\u00edsico") || sLine.startsWith("Direcci\u00f3n fisica");
    }

    private MacAddressUtils() {
    }
}

