/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import gestioneFatture.DumpThread;
import gestioneFatture.Scadenze;
import gestioneFatture.Storico;
import gestioneFatture.dbDocumento;
import gestioneFatture.dbFattura;
import gestioneFatture.dbFatturaRicevuta;
import gestioneFatture.dbOrdine;
import gestioneFatture.frmElenDDT;
import gestioneFatture.frmElenFatt;
import gestioneFatture.frmElenFattAcquisto;
import gestioneFatture.frmElenOrdini;
import gestioneFatture.iniFileProp;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.logic.provvigioni.ProvvigioniFattura;
import gestioneFatture.main;
import it.tnx.ClassPathHacker;
import it.tnx.Db;
import it.tnx.JFrameMessage;
import it.tnx.accessoUtenti.Utente;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.FileUtils;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.LoggingOutputStream;
import it.tnx.invoicex.Main;
import it.tnx.invoicex.MyDebugUtils;
import it.tnx.invoicex.iu;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import mjpf.EntryDescriptor;
import mjpf.PluginEntry;
import mjpf.PluginFactory;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MainBatch {
    String file_param = null;
    String param_prop = null;
    JSONObject json_param = null;
    PrintStream origerr = null;
    PrintStream origout = null;
    ByteArrayOutputStream baoserr = new ByteArrayOutputStream();
    ByteArrayOutputStream baosout = new ByteArrayOutputStream();
    private String working_dir = null;
    public static final String tipo_documento_fattura_vendita = "fattura_vendita";
    public static final String tipo_documento_fattura_acquisto = "fattura_acquisto";
    public static final String tipo_documento_ordine_vendita = "ordine_vendita";
    public static final String tipo_documento_ordine_acquisto = "ordine_acquisto";
    public static final String tipo_documento_ddt_vendita = "ddt_vendita";
    public static final String tipo_documento_ddt_acquisto = "ddt_acquisto";
    public static Map<String, String> tipi_doc_inv = new HashMap<String, String>();

    public MainBatch() {
        System.setProperty("logfile.name", "invoicex.log");
        this.origerr = new PrintStream(System.err);
        this.origout = new PrintStream(System.out);
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)new LoggingOutputStream(Category.getRoot(), Priority.WARN), (OutputStream)new PrintStream(this.baosout)), true));
        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)new LoggingOutputStream(Category.getRoot(), Priority.INFO), (OutputStream)new PrintStream(this.baosout)), true));
        Main.atomicMain.set(new main());
    }

    public void exec(String funzione, String file_param) {
        MicroBench mb;
        block31: {
            System.out.println("funzione = " + funzione + " file_param:" + file_param);
            System.out.flush();
            main.isBatch = true;
            mb = new MicroBench(true);
            try {
                if (file_param != null && this.file_param == null) {
                    this.file_param = file_param;
                }
                this.init();
                if (funzione.equalsIgnoreCase("getPdf")) {
                    Object ret = this.getPdf(cu.s(this.json_param.get("tipo_doc")), cu.i(this.json_param.get("id")));
                    mb.out("fine");
                    if (ret instanceof String) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        retj.put("file", ret);
                        this.ok(retj.toJSONString());
                    }
                    this.error(ret == null ? "ret = null" : ret.toString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("convertiDoc")) {
                    ArrayList<Integer> righe_da_includere = null;
                    JSONArray jrighe_includere = (JSONArray)this.json_param.get("righe_da_includere");
                    System.out.println("jrighe_includere = " + jrighe_includere);
                    if (jrighe_includere != null) {
                        righe_da_includere = new ArrayList<Integer>();
                        for (Object origa : jrighe_includere) {
                            righe_da_includere.add(cu.i(((JSONObject)origa).get("id")));
                        }
                    }
                    Object ret = this.convertiDoc(cu.s(this.json_param.get("da_tipo_doc")), cu.s(this.json_param.get("a_tipo_doc")), cu.i(this.json_param.get("id")), righe_da_includere);
                    mb.out("fine");
                    if (ret instanceof Integer) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        retj.put("id", ret);
                        this.ok(retj.toJSONString());
                    } else if (ret instanceof Exception) {
                        this.error(ret == null ? "ret = null" : ((Exception)ret).getMessage());
                    }
                    this.error(ret == null ? "ret = null" : ret.toString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("saveDocument")) {
                    Object ret = this.saveDocument(cu.s(this.json_param.get("tipo_doc")));
                    mb.out("fine");
                    if (ret instanceof Integer) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        retj.put("id", ret);
                        this.ok(retj.toJSONString());
                    }
                    this.error(ret == null ? "ret = null" : ret.toString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("generaProvvigioni")) {
                    Object ret = this.generaProvvigioni(cu.i(this.json_param.get("id_fattura")));
                    mb.out("fine");
                    if (ret instanceof Boolean && ((Boolean)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString());
                    }
                    this.error(ret == null ? "ret = null" : ret.toString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("calcolaTotali")) {
                    Object ret = this.calcolaTotali(cu.s(this.json_param.get("tipo_doc")), cu.i(this.json_param.get("id")));
                    mb.out("fine");
                    if (ret instanceof Boolean && ((Boolean)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString());
                    }
                    this.error(ret == null ? "ret = null" : ret.toString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("backup")) {
                    if (main.pluginBackupTnx) {
                        URL[] url = new URL[]{new URL("file:plugins/InvoicexPluginBackupTnx.jar")};
                        URLClassLoader classloader = new URLClassLoader(url);
                        Class<?> cl = classloader.loadClass("invoicexpluginbackuptnx.DumpThreadOnline");
                        Constructor<?> cons = cl.getConstructor(JFrameMessage.class);
                        Object odump = cons.newInstance(new JFrameMessage());
                        Method mstart = cl.getMethod("start", new Class[0]);
                        mstart.invoke(odump, new Object[0]);
                        Method mjoin = cl.getMethod("join", new Class[0]);
                        mjoin.invoke(odump, new Object[0]);
                    } else {
                        DumpThread dump = new DumpThread(new JFrameMessage());
                        dump.start();
                        dump.join();
                    }
                    System.out.println("backup completato");
                    break block31;
                }
                if (funzione.equalsIgnoreCase("calcolaCmp")) {
                    DebugUtils.dump((Object)this.json_param);
                    URL[] url = new URL[]{new URL("file:plugins/InvoicexPluginToysforyou.jar")};
                    URLClassLoader classloader = new URLClassLoader(url);
                    Class<?> cl = classloader.loadClass("invoicexplugintoysforyou.PreGiacenzaCmp");
                    Method m = cl.getDeclaredMethod("calcolaCmp", Date.class, List.class, String.class, Boolean.TYPE, Date.class);
                    if (cu.s(this.json_param.get("a_data")).equals("")) {
                        this.json_param.put("a_data", null);
                    }
                    if (cu.s(this.json_param.get("articoli")).equals("")) {
                        this.json_param.put("articoli", null);
                    }
                    if (cu.s(this.json_param.get("campo_da_aggiornare")).equals("")) {
                        this.json_param.put("campo_da_aggiornare", null);
                    }
                    if (cu.s(this.json_param.get("aggiorna_prezzi_unitari")).equals("")) {
                        this.json_param.put("aggiorna_prezzi_unitari", false);
                    }
                    if (cu.s(this.json_param.get("da_data")).equals("")) {
                        this.json_param.put("da_data", null);
                    }
                    Map ret = (Map)m.invoke(cl.newInstance(), cu.toDate(this.json_param.get("a_data")), (List)this.json_param.get("articoli"), this.json_param.get("campo_da_aggiornare"), this.json_param.get("aggiorna_prezzi_unitari"), cu.toDate(this.json_param.get("da_data")));
                    mb.out("fine");
                    JSONObject retj = new JSONObject();
                    retj.putAll(ret);
                    this.ok(retj.toJSONString());
                    break block31;
                }
                if (funzione.equalsIgnoreCase("exportOrdiniEdifact")) {
                    DebugUtils.dump((Object)this.json_param);
                    System.out.println("json_param.get(\"idOrdini\"):" + this.json_param.get("idOrdini"));
                    try {
                        System.out.println("json_param.get(\"idOrdini\").getclass():" + this.json_param.get("idOrdini").getClass());
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                    URL[] url = new URL[]{new URL("file:plugins/InvoicexPluginToysforyou.jar")};
                    URLClassLoader classloader = new URLClassLoader(url);
                    Class<?> cl = classloader.loadClass("invoicexplugintoysforyou.InvoicexPluginToysforyou");
                    Method m = cl.getDeclaredMethod("exportOrdiniEdifact", JSONArray.class, Boolean.TYPE, frmElenOrdini.class, Boolean.TYPE);
                    System.out.println("m: " + m);
                    System.out.println("m: " + m.getName());
                    Map ret = new HashMap();
                    try {
                        ret = (Map)m.invoke(cl.newInstance(), this.json_param.get("idOrdini"), false, null, cu.b(this.json_param.get("simulazione")));
                    }
                    catch (Exception e) {
                        System.out.println("e: " + e);
                        e.printStackTrace(System.out);
                    }
                    mb.out("fine");
                    JSONObject retj = new JSONObject();
                    retj.putAll(ret);
                    this.ok(retj.toJSONString());
                    break block31;
                }
                this.error("funzione '" + funzione + "' non definita");
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.error(t.toString());
                mb.out("fine con errore");
                System.exit(1);
            }
        }
        mb.out("fine ok");
        this.output();
        System.exit(0);
    }

    public void init() throws ParseException, IOException {
        System.out.println("Invoicex (Batch) ver. " + main.version + " " + main.build);
        System.out.flush();
        JSONObject db = null;
        if (this.file_param != null) {
            System.out.println("file_param = " + this.file_param);
            String filecontent = FileUtils.readContent((File)new File(this.file_param));
            JSONParser parser = new JSONParser();
            this.json_param = (JSONObject)parser.parse(filecontent);
            db = (JSONObject)this.json_param.get("db");
            this.param_prop = (String)this.json_param.get("param_prop");
            if (db == null && this.param_prop == null) {
                this.error("parametri del db vuoti e nessun param_prop passato");
            }
        }
        File fwd = new File("./");
        try {
            main.wd = fwd.getCanonicalPath() + File.separator;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.paramProp = "param_prop.txt";
        if (this.param_prop != null) {
            main.paramProp = this.param_prop;
        }
        if (!main.paramProp.equals("json")) {
            File test = new File(main.paramProp);
            if (!test.exists()) {
                this.error("il file di parametri " + test.getAbsolutePath() + " non esiste");
            }
            main.fileIni = new iniFileProp();
            main.fileIni.realFileName = main.wd + main.paramProp;
            Main.atomicMain.get().loadIni();
        } else {
            main.fileIni = new iniFileProp(){

                @Override
                public String getValue(String subject, String variable) {
                    System.out.println("getValue subject:" + subject + " variable:" + variable + " = " + this.json.get("param_" + subject + "_" + variable));
                    return cu.s(this.json.get("param_" + subject + "_" + variable));
                }

                @Override
                public synchronized boolean setValue(String subject, String variable, String value) {
                    return true;
                }

                @Override
                public synchronized boolean existKey(String subject, String variable) {
                    return this.json.containsKey("param_" + subject + "_" + variable);
                }
            };
            main.fileIni.json = this.json_param;
            System.out.println("json = " + this.json_param);
        }
        if (db != null) {
            Db.dbServ = (String)db.get("server");
            Db.dbPort = 3306;
            int ip = Db.dbServ.indexOf(":");
            if (ip > 0) {
                String server = Db.dbServ.substring(0, ip);
                String porta = Db.dbServ.substring(ip + 1, Db.dbServ.length());
                try {
                    Db.dbPort = Integer.parseInt(porta);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Db.dbNameDB = (String)db.get("database");
            Db.dbName = (String)db.get("user");
            Db.dbPass = (String)db.get("pass");
        }
        if (Db.dbServ.equalsIgnoreCase("localhost")) {
            Db.localSocketAddress = "127.0.0.1";
        }
        try {
            Connection testconn = Db.getConn();
            if (testconn == null) {
                this.error("errore in connessione mysql (test=null) a:" + Db.dbServ + " db:" + Db.dbNameDB + " user:" + Db.dbName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("errore in connessione mysql (exc:" + e.toString() + ") a: " + Db.dbServ + " db:" + Db.dbNameDB + " user:" + Db.dbName);
        }
        try {
            main.GLOB.put("dati_azienda", dbu.getListMap((Connection)Db.getConn(), (String)("select " + main.campiDatiAzienda + " from dati_azienda")).get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        main.utente = new Utente(1);
        MainBatch.initPlugins();
    }

    public Object getPdf(String tipo_documento, Integer id) throws Exception {
        String tipo_doc_inv = tipi_doc_inv.get(tipo_documento);
        try {
            InvoicexUtil.aggiornaTotaliRighe(tipo_doc_inv, id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map retnum = InvoicexUtil.getSerieNumeroAnno(tipo_doc_inv, id);
        String dbSerie = cu.s(retnum.get("serie"));
        int dbNumero = cu.i0(retnum.get("numero"));
        int dbAnno = cu.i0(retnum.get("anno"));
        Object ret = null;
        if (tipo_documento.equals(tipo_documento_fattura_vendita)) {
            String sql = "select tipo_fattura, descrizione_breve from test_fatt t join tipi_fatture tf on t.tipo_fattura = tf.tipo where id = " + id;
            sql = sql + " and tipo_fattura != 7";
            ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
            String tipofatt = cu.s(((Map)list.get(0)).get("descrizione_breve"));
            ret = frmElenFatt.stampa(tipofatt, dbSerie, dbNumero, dbAnno, true, true, true, id);
        } else if (tipo_documento.equals(tipo_documento_fattura_acquisto)) {
            String sql = "select tipo_fattura, descrizione_breve from test_fatt_acquisto t join tipi_fatture_acquisto tf on t.tipo_fattura = tf.tipo where id = " + id;
            ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
            String tipofatt = cu.s(((Map)list.get(0)).get("descrizione_breve"));
            ret = frmElenFattAcquisto.stampa(tipofatt, dbSerie, dbNumero, dbAnno, true, true, true, id);
        } else if (tipo_documento.equals(tipo_documento_ddt_vendita) || tipo_documento.equals(tipo_documento_ddt_acquisto)) {
            boolean acquisto = !tipo_documento.equals(tipo_documento_ddt_vendita);
            ret = frmElenDDT.stampa(tipo_documento, dbSerie, dbNumero, dbAnno, true, true, true, acquisto, id);
        } else if (tipo_documento.equals(tipo_documento_ordine_vendita) || tipo_documento.equals(tipo_documento_ordine_acquisto)) {
            boolean acquisto = !tipo_documento.equals(tipo_documento_ordine_vendita);
            ret = frmElenOrdini.stampa(tipo_documento, dbSerie, dbNumero, dbAnno, true, true, true, acquisto, id);
        }
        System.out.println("ret = " + ret);
        if (ret instanceof String) {
            return (String)ret;
        }
        return ret;
    }

    public Object convertiDoc(String da_tipo_documento, String a_tipo_documento, Integer id, List<Integer> id_righe_da_includere) throws Exception {
        Storico.scriviSeparati("batch convertiDoc inizio " + da_tipo_documento + " a " + a_tipo_documento + " id " + id + " id_righe " + id_righe_da_includere, null);
        String da_tipo_doc_inv = tipi_doc_inv.get(da_tipo_documento);
        String a_tipo_doc_inv = tipi_doc_inv.get(a_tipo_documento);
        JSONObject jp = this.json_param;
        dbOrdine doc = new dbOrdine();
        String sql = "select id, serie, numero, anno from test_ordi where id = " + id;
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        if (list.size() == 0) {
            return new Exception("Non trovato documento di origine " + da_tipo_documento + " id " + id);
        }
        Map rec = (Map)list.get(0);
        InvoicexUtil.aggiornaTotaliRighe(Db.TIPO_DOCUMENTO_ORDINE, id);
        doc.serie = cu.s(rec.get("serie"));
        doc.ids = new Integer[]{id};
        doc.acquisto = false;
        String ret = doc.converti("fatt", false);
        if (ret != null) {
            System.out.println("ret: " + ret);
            Integer id_new = cu.i((Object)ret);
            return id_new;
        }
        return "Errore in conversione documento, consultare il log";
    }

    public Object saveDocument(String tipo_documento) throws Exception {
        Storico.scriviSeparati("batch saveDocument inizio " + tipo_documento, null);
        String tipo_doc_inv = tipi_doc_inv.get(tipo_documento);
        JSONObject jp = this.json_param;
        JSONObject dati = (JSONObject)jp.get("dati_doc");
        JSONObject righe = (JSONObject)dati.get("righe");
        JSONObject altro = (JSONObject)dati.get("altro");
        String sql = null;
        String tabt = InvoicexUtil.getTabTestateFromTipoDoc(tipo_doc_inv);
        String tabr = InvoicexUtil.getTabRigheFromTipoDoc(tipo_doc_inv);
        boolean acquisto = false;
        if (tabt.endsWith("acquisto")) {
            acquisto = true;
        }
        String campoclifor = acquisto ? "fornitore" : "cliente";
        String serie = "";
        Integer numero = null;
        Integer anno = null;
        Date data = new Date();
        if (cu.toDate(jp.get("data")) != null) {
            data = cu.toDate(jp.get("data"));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        if (cu.s(jp.get("serie")) != null) {
            serie = cu.s(jp.get("serie"));
        }
        anno = cal.get(1);
        sql = "select numero from " + tabt;
        sql = sql + " where anno = " + anno;
        sql = sql + " and serie = " + Db.pcs(serie);
        if (tipo_documento.equals(tipo_documento_fattura_vendita)) {
            sql = sql + " and tipo_fattura != 7";
        }
        sql = sql + " order by numero desc limit 1";
        Object obj = DbUtils.getObject((Connection)Db.getConn(), (String)sql, (boolean)false);
        numero = cu.i0((Object)obj) + 1;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("serie", serie);
        m.put("numero", numero);
        m.put("anno", anno);
        Integer tipoFattura = null;
        if (tipo_documento.equals(tipo_documento_fattura_vendita)) {
            tipoFattura = 1;
            if (cu.s(jp.get("tipo_doc2")).equalsIgnoreCase("accompagnatoria")) {
                tipoFattura = 2;
            }
            m.put("tipo_fattura", tipoFattura);
        }
        if (dati.get("deposito") != null) {
            m.put("deposito", dati.get("deposito"));
        }
        m.put("data", data);
        m.put("pagamento", dati.get("tipo_pagamento"));
        m.put("sconto1", cu.i0(dati.get("sconto1")));
        m.put("sconto2", cu.i0(dati.get("sconto2")));
        m.put("sconto3", cu.i0(dati.get("sconto3")));
        if (cu.d0a(altro.get("sconto_livello")) != 0.0) {
            m.put("sconto1", cu.d0a(altro.get("sconto_livello")));
        }
        Map mcf = null;
        Map mdd = null;
        Map mtp = null;
        try {
            mcf = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)("select * from clie_forn where codice = '" + dati.get("clifor") + "'")).get(0);
        }
        catch (Exception e) {
            System.err.println("non trovato cliente");
        }
        try {
            mdd = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)("select * from clie_forn_dest where id = '" + dati.get("clifor_dest") + "'")).get(0);
        }
        catch (Exception e) {
            System.err.println("non trovata dest diversa");
        }
        String codicePagamento = cu.s(dati.get("tipo_pagamento"));
        try {
            mtp = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)("select * from pagamenti where codice = " + Db.pcs(codicePagamento))).get(0);
        }
        catch (Exception e) {
            System.err.println("non trovato tipo pagamentos");
        }
        m.put("banca_abi", mcf.get("banca_abi"));
        m.put("banca_cab", mcf.get("banca_cab"));
        m.put("banca_cc", mcf.get("banca_cc"));
        m.put("banca_iban", mcf.get("banca_iban"));
        String note = "";
        if (cu.s(mcf.get("note_automatiche")).equalsIgnoreCase("S")) {
            note = cu.s(mcf.get("note"));
        }
        m.put("note", note);
        if (mdd != null) {
            m.put("id_cliente_destinazione", dati.get("clifor_dest"));
            m.put("dest_ragione_sociale", mdd.get("ragione_sociale"));
            m.put("dest_indirizzo", mdd.get("indirizzo"));
            m.put("dest_cap", mdd.get("cap"));
            m.put("dest_localita", mdd.get("localita"));
            m.put("dest_provincia", mdd.get("provincia"));
            m.put("dest_telefono", mdd.get("telefono"));
            m.put("dest_cellulare", mdd.get("cellulare"));
            m.put("dest_paese", mdd.get("paese"));
        }
        m.put("spese_trasporto", cu.d0a(dati.get("spese_spedizione")));
        m.put("spese_incasso", cu.d0a(dati.get("spese_incasso")));
        m.put("riferimento", "");
        m.put("note_pagamento", mtp.get("note_su_documenti"));
        Integer codice_agente = cu.i(mcf.get("agente"));
        m.put("agente_codice", codice_agente);
        Double perc_provvigione = null;
        Double prov_agente = null;
        Double prov_clie = null;
        sql = "select provvigione_predefinita_cliente\n from clie_forn where codice = " + dati.get("clifor");
        prov_clie = cu.d((Object)DbUtils.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
        if (prov_clie != null) {
            perc_provvigione = prov_clie;
        } else {
            sql = "select percentuale \n from agenti where id = " + codice_agente;
            prov_agente = cu.d((Object)DbUtils.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
            if (prov_agente != null) {
                perc_provvigione = prov_agente;
            }
        }
        m.put("agente_percentuale", perc_provvigione);
        Double perc_provvigione_testata = perc_provvigione;
        m.put("giorno_pagamento", mcf.get("giorno_pagamento"));
        if (tipo_documento.equals(tipo_documento_ordine_vendita) || tipo_documento.equals(tipo_documento_ordine_acquisto)) {
            m.put("stato_ordine", "Ordine");
        }
        m.put(campoclifor, dati.get("clifor"));
        sql = "insert into " + tabt + " set " + DbUtils.prepareSqlFromMap(m);
        Integer id = Db.executeSqlRetIdDialogExc(Db.getConn(), sql, false, true);
        System.out.println("generato " + tabt + " = " + id);
        if (tipo_documento.equals(tipo_documento_fattura_vendita)) {
            dbu.tryExecQuery((Connection)Db.getConn(), (String)("delete from " + tabt + "_xmlpa where id_fattura = " + id));
            HashMap<String, Integer> mx = new HashMap<String, Integer>();
            mx.put("id_fattura", id);
            mx.put("dt_codice_dest", (Integer)mcf.get("xmlpa_codice_dest"));
            mx.put("dt_pec_dest", (Integer)mcf.get("email_pec"));
            sql = "insert into " + tabt + "_xmlpa set " + DbUtils.prepareSqlFromMap(mx);
            Integer idx = Db.executeSqlRetIdDialogExc(Db.getConn(), sql, false, true);
            System.out.println("idx = " + idx);
        }
        if (tipo_documento.equals(tipo_documento_ordine_vendita) || tipo_documento.equals(tipo_documento_ordine_acquisto)) {
            dbOrdine ordine = new dbOrdine();
            ordine.serie = serie;
            ordine.numero = numero;
            ordine.anno = anno;
            ordine.id = id;
        }
        Integer old_da_ordine = null;
        System.out.println("righe:");
        DebugUtils.dump((Object)righe);
        TreeSet keys = new TreeSet(righe.keySet());
        System.out.println("keys:");
        DebugUtils.dump(keys);
        int riga = 0;
        ArrayList<Integer> id_ordini_da_aggiornare_stato = new ArrayList<Integer>();
        for (String key : keys) {
            JSONObject jr = (JSONObject)righe.get(key);
            ++riga;
            Integer da_ordine = null;
            Integer da_riga = null;
            if (jr.get("da_ordine") != null && jr.get("da_riga") != null) {
                da_ordine = cu.i(jr.get("da_ordine"));
                da_riga = cu.i(jr.get("da_riga"));
                System.out.println("riga = " + riga);
                System.out.println("da_ordine = " + da_ordine);
                System.out.println("old_da_ordine = " + old_da_ordine);
                if (riga == 1 || !da_ordine.equals(old_da_ordine)) {
                    try {
                        Map ordi_prov = (Map)DbUtils.getListMap((Connection)Db.getConn(), (String)("select id, serie, numero, data, riferimento from test_ordi" + (acquisto ? "_acquisto" : "") + " where id = " + da_ordine)).get(0);
                        id_ordini_da_aggiornare_stato.add(cu.i(ordi_prov.get("id")));
                        HashMap<String, Object> r = new HashMap<String, Object>();
                        r.put("id_padre", id);
                        r.put("serie", serie);
                        r.put("numero", numero);
                        r.put("anno", anno);
                        r.put("riga", riga);
                        r.put("codice_articolo", "");
                        r.put("quantita", 0);
                        r.put("prezzo", 0);
                        r.put("prezzo_ivato", 0);
                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                        String descrizione = main.fileIni.getValue("altro", "da_ordine", "*** Da Ordine") + " numero " + iu.getSerieNumero(ordi_prov.get("serie"), ordi_prov.get("numero")) + " del " + sdf.format(cu.toDate(ordi_prov.get("data")));
                        if (!CastUtils.toString(ordi_prov.get("riferimento")).equals("")) {
                            descrizione = descrizione + " / Vostro rif. " + ordi_prov.get("riferimento");
                        }
                        r.put("descrizione", descrizione);
                        sql = "insert into " + tabr + " set " + DbUtils.prepareSqlFromMap(r);
                        DbUtils.tryExecQuery((Connection)Db.getConn(), (String)sql);
                        ++riga;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("id_padre", id);
            r.put("serie", serie);
            r.put("numero", numero);
            r.put("anno", anno);
            r.put("riga", riga);
            r.put("codice_articolo", jr.get("codice"));
            r.put("descrizione", jr.get("nome"));
            r.put("um", "pz");
            double qta = cu.d0a(jr.get("quantita"));
            r.put("quantita", qta);
            r.put("sconto1", 0);
            r.put("sconto2", 0);
            double prezzo_imponibile = 0.0;
            double prezzo_ivato = 0.0;
            if (key.startsWith("invx_")) {
                if (cu.d0a(jr.get("sconto1")) != 0.0) {
                    r.put("sconto1", cu.d0a(jr.get("sconto1")));
                }
                if (cu.d0a(jr.get("sconto2")) != 0.0) {
                    r.put("sconto2", cu.d0a(jr.get("sconto2")));
                }
                prezzo_imponibile = cu.d0a(jr.get("prezzo_pieno"));
                r.put("prezzo", prezzo_imponibile);
            } else {
                ArrayList<Double> sconti = new ArrayList<Double>();
                if (cu.d0a(jr.get("sconto_produttore")) != 0.0) {
                    sconti.add(cu.d0a(jr.get("sconto_produttore")));
                }
                if (cu.d0a(jr.get("sconto_sconto1")) != 0.0) {
                    sconti.add(cu.d0a(jr.get("sconto_sconto1")));
                }
                if (cu.d0a(jr.get("sconto_sconto2")) != 0.0) {
                    sconti.add(cu.d0a(jr.get("sconto_sconto2")));
                }
                if (cu.d0a(jr.get("sconto_coupon")) != 0.0) {
                    sconti.add(cu.d0a(jr.get("sconto_coupon")));
                }
                if (sconti.size() > 2) {
                    double prezzo_netto = cu.d0a(jr.get("prezzo"));
                    double prezzo_lordo = cu.d0a(jr.get("prezzo_pieno"));
                    double sconto = 100.0 - prezzo_netto * 100.0 / prezzo_lordo;
                    r.put("sconto1", sconto);
                } else if (sconti.size() == 2) {
                    r.put("sconto1", sconti.get(0));
                    r.put("sconto2", sconti.get(1));
                } else if (sconti.size() == 1) {
                    r.put("sconto1", sconti.get(0));
                }
                prezzo_imponibile = cu.d0a(jr.get("prezzo_pieno"));
                r.put("prezzo", prezzo_imponibile);
            }
            String codiceIva = InvoicexUtil.getIvaRigaArticolo(cu.i(dati.get("clifor")), cu.s(mcf.get("paese")), cu.s(jr.get("codice")));
            r.put("iva", codiceIva);
            boolean prezziIvati = false;
            r.put("flag_ritenuta", "");
            r.put("flag_rivalsa", "");
            perc_provvigione = perc_provvigione_testata;
            sql = "select c.provvigione_predefinita_fornitore\n from clie_forn c join articoli a on c.codice = a.fornitore and a.codice = " + Db.pcs(cu.s(jr.get("codice")));
            Double prov_forn = cu.d((Object)DbUtils.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
            if (prov_forn != null) {
                perc_provvigione = prov_forn;
            } else if (prov_clie != null) {
                perc_provvigione = prov_clie;
            } else if (prov_agente != null) {
                perc_provvigione = prov_agente;
            }
            if (main.pluginAttivi.contains("pluginToysforyou")) {
                try {
                    System.out.println("provvigione per articolo " + jr.get("codice"));
                    sql = "select * from articoli where codice = " + dbu.sql(jr.get("codice"));
                    Map articolo = (Map)dbu.getListMap((Connection)Db.getConn(), (String)sql).get(0);
                    Integer fornitore = cu.i(articolo.get("fornitore"));
                    Integer produttore = null;
                    try {
                        produttore = cu.i((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("select produttore_id from articoli where codice = " + dbu.sql(jr.get("codice")))));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (produttore != null) {
                        sql = "select c.codice, fp.cliente_id, fp.produttore_id, p.id, c.provvigione_predefinita_fornitore, c.ragione_sociale, l.ita    from clie_forn c   left join fornitori_produttori fp on c.codice = fp.cliente_id  left join produttori p on p.id = fp.produttore_id left join labels l on p.nome_lbl_id = l.id  where p.id = " + Db.pc(produttore, 4) + " and c.provvigione_predefinita_fornitore is not null";
                        System.out.println("sql = " + sql);
                        ArrayList listprods = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                        System.out.println("listprods = " + listprods);
                        Double provvigione = null;
                        if (listprods.size() != 0) {
                            if (listprods.size() == 1) {
                                provvigione = cu.toDouble(((Map)listprods.get(0)).get("provvigione_predefinita_fornitore"));
                            } else {
                                System.out.println("pi\u00f9 di un produttore, presa comunque la prima, siamo in batch...");
                                provvigione = cu.toDouble(((Map)listprods.get(0)).get("provvigione_predefinita_fornitore"));
                            }
                        }
                        if (provvigione != null) {
                            System.out.println("presa provvigione da fornitore/produttore");
                            perc_provvigione = provvigione;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            r.put("provvigione", perc_provvigione);
            if (!tipo_documento.equals(tipo_documento_fattura_vendita) && !tipo_documento.equals(tipo_documento_fattura_acquisto)) {
                r.put("quantita_evasa", 0);
            }
            r.put("arrotondamento_parametro", 0);
            r.put("arrotondamento_tipo", "Inf.");
            double iva_prezz = 100.0;
            try {
                iva_prezz = 100.0 + ((BigDecimal)DbUtils.getObject((Connection)Db.getConn(), (String)("select percentuale from codici_iva where codice = " + Db.pc((Object)codiceIva, 12)))).doubleValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!prezziIvati) {
                double new_prezz_lordo = 0.0;
                double prezz_netto = prezzo_imponibile;
                prezzo_ivato = new_prezz_lordo = prezz_netto / 100.0 * iva_prezz;
            } else {
                double new_prezz_netto = 0.0;
                double prezz_lordo = prezzo_ivato;
                prezzo_imponibile = new_prezz_netto = prezz_lordo * 100.0 / iva_prezz;
            }
            Map totali = InvoicexUtil.getTotaliRiga(qta, prezzo_imponibile, prezzo_ivato, cu.d0a(r.get("sconto1")), cu.d0a(r.get("sconto2")), codiceIva, prezziIvati);
            r.put("totale_ivato", totali.get("tot_con_iva"));
            r.put("totale_imponibile", totali.get("tot_senza_iva"));
            r.put("is_descrizione", "N");
            r.put("prezzo_ivato", prezzo_ivato);
            if (!tipo_documento.equals(tipo_documento_ordine_vendita) && !tipo_documento.equals(tipo_documento_ordine_acquisto) && jr.get("da_ordine") != null && jr.get("da_riga") != null) {
                sql = "update righ_ordi" + (acquisto ? "_acquisto" : "") + " set  quantita_evasa = IFNULL(quantita_evasa,0) + " + Db.pc(qta, 8) + " where id = " + da_riga;
                System.out.println("evasione: " + sql);
                DbUtils.tryExecQuery((Connection)Db.getConn(), (String)sql);
                r.put("da_ordi", da_ordine);
                r.put("da_ordi_riga", da_riga);
            }
            sql = "insert into " + tabr + " set " + DbUtils.prepareSqlFromMap(r);
            DbUtils.tryExecQuery((Connection)Db.getConn(), (String)sql);
            old_da_ordine = da_ordine;
        }
        Documento doc = new Documento();
        doc.load(gestioneFatture.Db.INSTANCE, numero, serie, anno, tipo_doc_inv, id);
        doc.calcolaTotali();
        HashMap<String, Object> t = new HashMap<String, Object>();
        if (!tipo_documento.equals(tipo_documento_fattura_vendita) && !tipo_documento.equals(tipo_documento_fattura_acquisto)) {
            t.put("evaso", "");
        }
        t.put("sconto", 0);
        t.put("totale_imponibile", doc.getTotaleImponibile());
        t.put("totale_iva", doc.getTotaleIva());
        t.put("totale", doc.getTotale());
        t.put("totale_imponibile_pre_sconto", doc.totaleImponibilePreSconto);
        t.put("totale_ivato_pre_sconto", doc.totaleIvatoPreSconto);
        if (tipo_documento.equals(tipo_documento_fattura_vendita) || tipo_documento.equals(tipo_documento_fattura_acquisto)) {
            t.put("totale_da_pagare", doc.getTotale_da_pagare());
        }
        t.put("totale_da_pagare_finale", doc.getTotale_da_pagare_finale());
        sql = "update " + tabt + " set " + DbUtils.prepareSqlFromMap(t) + " where id = " + id;
        DbUtils.tryExecQuery((Connection)Db.getConn(), (String)sql);
        InvoicexUtil.aggiornaPrezziNettiUnitari(Db.getConn(), tabr, tabt, id);
        try {
            for (Integer id_ordine : id_ordini_da_aggiornare_stato) {
                try {
                    InvoicexUtil.aggiornaStatoEvasione(acquisto ? gestioneFatture.Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO : gestioneFatture.Db.TIPO_DOCUMENTO_ORDINE, id_ordine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String test_ordi = acquisto ? "test_ordi_acquisto" : "test_ordi";
                try {
                    String convertito = CastUtils.toString((Object)DbUtils.getObject((Connection)gestioneFatture.Db.getConn(), (String)("select convertito from test_ordi t where id = " + id_ordine)));
                    convertito = convertito + (convertito.length() > 0 ? "\n" : "") + InvoicexUtil.getNumeroDaId(tipo_doc_inv, id);
                    sql = "update " + test_ordi + " t";
                    sql = sql + " set convertito = " + gestioneFatture.Db.pc(convertito, "VARCHAR");
                    sql = sql + " where id = " + id_ordine;
                    System.out.println("sql = " + sql);
                    DbUtils.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean generaScadenze = false;
        if (tipo_documento.equals(tipo_documento_ordine_vendita)) {
            if (main.fileIni.getValueBoolean("pref", "scadenzeOrdini", false).booleanValue()) {
                generaScadenze = true;
            }
        } else if (tipo_documento.equals(tipo_documento_fattura_vendita) || tipo_documento.equals(tipo_documento_fattura_acquisto)) {
            generaScadenze = true;
        }
        if (generaScadenze) {
            Scadenze tempScad = new Scadenze(tipo_doc_inv, id, codicePagamento, this);
            boolean scadenzeRigenerate = false;
            tempScad.generaScadenze();
        }
        if (tipo_documento.equals(tipo_documento_fattura_vendita) && codice_agente != null) {
            Double perc_agente = 0.0;
            ProvvigioniFattura provvigioni = new ProvvigioniFattura(id, codice_agente, perc_agente);
            double nuovoImportoTeoricoProvvigioni = provvigioni.getTotaleProvvigioni();
            boolean ret = provvigioni.generaProvvigioni();
            try {
                Storico.scrivi("Genera provvigioni", tipo_doc_inv + " " + serie + " " + numero + " " + anno + " " + codice_agente + " " + perc_agente);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("esito genera provvigioni:" + ret + " : " + provvigioni.ret);
        }
        dbDocumento dbdoc = null;
        boolean generaMovimenti = false;
        if (tipo_documento.equals(tipo_documento_ddt_vendita) || tipo_documento.equals(tipo_documento_ddt_acquisto)) {
            generaMovimenti = true;
            dbdoc = new dbDocumento();
        } else if (tipo_documento.equals(tipo_documento_fattura_vendita) || tipo_documento.equals(tipo_documento_fattura_acquisto)) {
            dbdoc = new dbFattura();
            if (acquisto) {
                dbdoc = new dbFatturaRicevuta();
            }
        }
        int conta = 0;
        if (dbdoc != null && id != null) {
            dbdoc.serie = serie;
            dbdoc.numero = numero;
            dbdoc.anno = anno;
            dbdoc.setId(id);
            if (tipo_documento.equals(tipo_documento_fattura_vendita) || tipo_documento.equals(tipo_documento_fattura_acquisto)) {
                dbdoc.tipoFattura = tipoFattura;
                try {
                    sql = "select count(*) from righ_ddt" + (acquisto ? "_acquisto" : "") + "  where in_fatt = " + id;
                    conta = cu.i0((Object)DbUtils.getObject((Connection)Db.getConn(), (String)sql));
                }
                catch (SQLException sqlerr) {
                    sqlerr.printStackTrace();
                }
            } else if (tipo_documento.equals(tipo_documento_ddt_vendita) || tipo_documento.equals(tipo_documento_ddt_acquisto)) {
                dbdoc.tipoDocumento = tipo_doc_inv;
            }
            boolean azzerare = false;
            boolean generare = false;
            if (conta == 0) {
                generare = true;
            } else {
                azzerare = true;
            }
            if (generare) {
                Storico.scriviSeparati("batch saveDocument generaMovimentiMagazzino id doc:" + id, "");
                if (!dbdoc.generaMovimentiMagazzino()) {
                    return new Exception("Errore nella generazione dei movimenti di magazzino");
                }
            }
            if (azzerare) {
                Storico.scriviSeparati("batch saveDocument azzeraMovimentiMagazzino id doc:" + id, "");
                if (!dbdoc.azzeraMovimentiMagazzino()) {
                    return new Exception("Errore nell'azzeramento dei movimenti di magazzino");
                }
            }
        }
        Storico.scriviSeparati("batch saveDocument fine " + tipo_documento + " id:" + id, "jp:\n" + MyDebugUtils.dumpAsString(jp));
        return id;
    }

    public Object calcolaTotali(String tipo_documento, Integer id) throws Exception {
        Storico.scriviSeparati("calcolaTotali inizio " + tipo_documento + " id " + id, null);
        String tipo_doc = tipi_doc_inv.get(tipo_documento);
        JSONObject jp = this.json_param;
        try {
            String tabt = Db.getNomeTabT(tipo_doc);
            String tabr = Db.getNomeTabR(tipo_doc);
            InvoicexUtil.aggiornaTotaliRighe(tipo_doc, id);
            InvoicexUtil.aggiornaPrezziNettiUnitari(tabr, tabt, id);
            Documento doc = new Documento();
            doc.load(gestioneFatture.Db.INSTANCE, tipo_doc, id);
            doc.calcolaTotali();
            HashMap<String, Double> m = new HashMap<String, Double>();
            m.put("totale", doc.getTotale());
            m.put("totale_iva", doc.getTotaleIva());
            m.put("totale_imponibile", doc.getTotaleImponibile());
            m.put("totale_imponibile_pre_sconto", doc.totaleImponibilePreSconto);
            m.put("totale_ivato_pre_sconto", doc.totaleIvatoPreSconto);
            System.out.println("tipo_doc:" + tipo_doc);
            if (tipo_doc.equals(Db.TIPO_DOCUMENTO_FATTURA) || tipo_doc.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                m.put("totale_ritenuta", doc.getTotale_ritenuta());
                m.put("totaleRivalsa", doc.getTotale_rivalsa());
                m.put("totale_da_pagare", doc.getTotale_da_pagare());
            }
            m.put("totale_da_pagare_finale", doc.getTotale_da_pagare_finale());
            String sql = "update " + Db.getNomeTabT(tipo_doc) + " set " + dbu.prepareSqlFromMap(m) + " where id = " + id;
            System.out.println("sql totali = " + sql);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Errore in calcola totali: " + e.toString();
        }
        return true;
    }

    private void output() {
        this.origerr.println(this.baoserr.toString());
        this.origout.println(this.baosout.toString());
    }

    private void error(String error) {
        this.output();
        this.origerr.println("errore:" + error);
        System.exit(2);
    }

    private void ok(String json) {
        this.output();
        this.origerr.println(json);
        System.exit(0);
    }

    static void initPlugins() throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public boolean isClientTrusted(X509Certificate[] xcs) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] xcs) {
                return true;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                System.out.println("verify = " + hostname + " sessione:" + session);
                return true;
            }
        });
        boolean pluginInvoicexCP = false;
        File fPluginInvoicex = new File("plugins/InvoicexPluginInvoicex.jar");
        if (fPluginInvoicex.exists()) {
            ClassPathHacker.addFile(fPluginInvoicex);
            pluginInvoicexCP = true;
        } else {
            System.out.println("!!! non presentte " + fPluginInvoicex);
        }
        main.pf = new PluginFactory();
        main.pf.loadPlugins(main.plugins_path);
        boolean pi = false;
        Collection plugcol = main.pf.getAllEntryDescriptor();
        if (plugcol != null) {
            for (EntryDescriptor pd : plugcol) {
                if (!pd.getName().equalsIgnoreCase("pluginInvoicex")) continue;
                pi = true;
            }
        }
        if (!pi) {
            try {
                HttpUtils.saveBigFile((String)(main.baseurlserver + "/" + InvoicexUtil.getDownloadDir() + "/plugins/InvoicexPluginInvoicex.jar"), (String)"plugins/InvoicexPluginInvoicex.jar");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            main.pf.loadPlugins(main.plugins_path);
            plugcol = main.pf.getAllEntryDescriptor();
        }
        main.pf = new PluginFactory();
        main.pf.loadPlugins(main.plugins_path);
        plugcol = main.pf.getAllEntryDescriptor();
        if (plugcol != null) {
            for (EntryDescriptor pd : plugcol) {
                if (pd.getName().equalsIgnoreCase("pluginInvoicex") || pd.getName().equalsIgnoreCase("pluginAutoUpdate") || pd.getName().equalsIgnoreCase("pluginBackupTnx") || pd.getName().equalsIgnoreCase("pluginToyforyou")) {
                    main.pluginPresenti.add(pd.getName());
                    main.plugins.put(pd.getName(), pd);
                    try {
                        MicroBench mb = new MicroBench();
                        mb.start();
                        if (!main.isBatch) {
                            main.getPadrePanel().lblInfoLoading2.setText("Caricamento plugin " + pd.getName() + "...");
                        }
                        PluginEntry pl = main.pf.getPluginEntry(pd.getId());
                        pl.initPluginEntry(null);
                        System.out.println(pd.getName() + " Init -> tempo: " + mb.getDiff("init"));
                        pl.startPluginEntry();
                        main.pluginsAvviati.put(pd.getName(), pl);
                        if (!main.isBatch) {
                            main.getPadrePanel().lblInfoLoading2.setText(pd.getName() + " Caricato");
                        }
                        System.out.println(pd.getName() + " Caricato -> tempo: " + mb.getDiff("caricamento"));
                    }
                    catch (NoSuchFieldError nofield) {
                        nofield.printStackTrace();
                    }
                    catch (NoClassDefFoundError noclass) {
                        noclass.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    catch (Throwable tr) {
                        tr.printStackTrace();
                    }
                    main.controllaFlagPlugin(pd.getName());
                    continue;
                }
                System.err.println("!!! ATTENZIONE !!! il " + pd.getName() + " non lo carico perch\u00e8 in modalit\u00e0 batch");
            }
        }
    }

    public Object generaProvvigioni(Integer id_fattura) {
        try {
            Map fattura = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("select tipo_fattura from test_fatt where id = " + id_fattura)).get(0);
            ProvvigioniFattura provvigioni = new ProvvigioniFattura(id_fattura);
            double nuovoImportoTeoricoProvvigioni = provvigioni.getTotaleProvvigioni();
            boolean ret = provvigioni.generaProvvigioni();
            try {
                Storico.scrivi("Genera provvigioni", Db.TIPO_DOCUMENTO_FATTURA + " " + fattura.get("serie") + " " + fattura.get("numero") + " " + fattura.get("anno") + " " + fattura.get("codice_agente") + " " + fattura.get("perc_agente") + " ret:" + ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("esito genera provvigioni:" + ret + " : " + provvigioni.ret);
            if (ret) {
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex;
        }
    }

    static {
        tipi_doc_inv.put(tipo_documento_fattura_vendita, Db.TIPO_DOCUMENTO_FATTURA);
        tipi_doc_inv.put(tipo_documento_fattura_acquisto, Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA);
        tipi_doc_inv.put(tipo_documento_ordine_vendita, Db.TIPO_DOCUMENTO_ORDINE);
        tipi_doc_inv.put(tipo_documento_ordine_acquisto, Db.TIPO_DOCUMENTO_ORDINE_ACQUISTO);
        tipi_doc_inv.put(tipo_documento_ddt_vendita, Db.TIPO_DOCUMENTO_DDT);
        tipi_doc_inv.put(tipo_documento_ddt_acquisto, Db.TIPO_DOCUMENTO_DDT_ACQUISTO);
    }
}

