/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import gestioneFatture.DbChanges;
import gestioneFatture.DbChanges2;
import gestioneFatture.Scadenze;
import gestioneFatture.Storico;
import gestioneFatture.dbDocumento;
import gestioneFatture.dbOrdine;
import gestioneFatture.frmElenDDT;
import gestioneFatture.frmElenFatt;
import gestioneFatture.frmElenFattAcquisto;
import gestioneFatture.frmElenOrdini;
import gestioneFatture.iniFileProp;
import gestioneFatture.logic.documenti.Documento;
import gestioneFatture.logic.provvigioni.ProvvigioniFattura;
import gestioneFatture.main;
import it.tnx.ClassPathHacker;
import it.tnx.Db;
import it.tnx.accessoUtenti.Utente;
import it.tnx.commons.CastUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.DebugUtils;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.MicroBench;
import it.tnx.commons.RunnableWithArgs;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.deb;
import it.tnx.invoicex.DbVersionChanges;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.LoggingOutputStream;
import it.tnx.invoicex.Main;
import it.tnx.invoicex.MainBatch;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mjpf.EntryDescriptor;
import mjpf.PluginEntry;
import mjpf.PluginFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.json.simple.JSONObject;

public class MainHttpServer {
    PrintStream origerr = null;
    PrintStream origout = null;
    ByteArrayOutputStream baoserr = new ByteArrayOutputStream();
    ByteArrayOutputStream baosout = new ByteArrayOutputStream();

    public MainHttpServer() throws IOException {
        System.out.println("a1");
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        RollingFileAppender rfa = new RollingFileAppender((Layout)new PatternLayout("%p | %d{dd/MM/yy HH:mm:ss,SSS} | %t | %c %x | %m%n"), "invoicex_" + InetAddress.getLocalHost().getHostName() + ".log");
        rfa.setMaxBackupIndex(10);
        rfa.setMaxFileSize("10MB");
        rfa.setName("FileLogger");
        rfa.setThreshold((Priority)Level.INFO);
        rfa.setAppend(true);
        rfa.activateOptions();
        Logger.getRootLogger().addAppender((Appender)rfa);
        this.origerr = new PrintStream(System.err);
        this.origout = new PrintStream(System.out);
        System.setErr(new PrintStream(new LoggingOutputStream(Category.getRoot(), Priority.WARN), true){

            @Override
            public void println(String x) {
                x = Db.dbNameDB + " | " + x;
                super.println(x);
            }
        });
        System.setOut(new PrintStream(new LoggingOutputStream(Category.getRoot(), Priority.INFO), true){

            @Override
            public void println(String x) {
                x = Db.dbNameDB + " | " + x;
                super.println(x);
            }
        });
        System.out.println("a2");
        Main.atomicMain.set(new main());
        System.out.println("a3");
    }

    public static void main(String[] args) throws Exception {
        MainHttpServer server = new MainHttpServer();
        server.start();
    }

    void start() {
        System.out.println("Invoicex (Server) ver. " + main.version + " " + main.build);
        System.out.println("disabilito cache db");
        DbUtils.forceDisableCache = true;
        System.out.flush();
        try {
            Server server = new Server(9090);
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath("keystore");
            sslContextFactory.setCertAlias("jetty");
            sslContextFactory.setTrustAll(true);
            sslContextFactory.setValidateCerts(false);
            sslContextFactory.setKeyStorePassword("OBF:1ku51mt71kfv1ku11san1kqt1kcj1mpv1kqp");
            sslContextFactory.setKeyManagerPassword("OBF:1ku51mt71kfv1ku11san1kqt1kcj1mpv1kqp");
            sslContextFactory.setTrustStorePassword("OBF:1ku51mt71kfv1ku11san1kqt1kcj1mpv1kqp");
            SslSelectChannelConnector sslconn = new SslSelectChannelConnector(sslContextFactory);
            sslconn.setPort(9443);
            sslconn.setMaxIdleTime(30000);
            server.addConnector((Connector)sslconn);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)new ApiServlet()), "/api/*");
            server.start();
            server.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static class ApiServlet
    extends HttpServlet {
        static Map<String, main> cacheMain = new HashMap<String, main>();

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.doGet(req, resp);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String qs = request.getQueryString();
            System.out.println("query string = " + qs);
            String path_info = request.getPathInfo();
            System.out.println("path_info = " + path_info);
            DebugUtils.dump((Object)path_info);
            String servlet_path = request.getServletPath();
            System.out.println("servlet_path = " + servlet_path);
            String uri = request.getRequestURL().toString();
            System.out.println("uri = " + uri);
            String[] parts = StringUtils.splitPreserveAllTokens((String)path_info.substring(1), (String)"/");
            deb.dump((Object)parts);
            if ("util".equals(parts[0]) && "calcolaTotali".equals(parts[1])) {
                String tipo_documento = parts[2];
                Integer id = cu.i((Object)parts[3]);
                System.out.println("calcola totali " + tipo_documento + " = " + id);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.calcolaTotali(inv, tipo_documento, id);
                    if (ret instanceof Boolean && ((Boolean)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response);
                }
                return;
            }
            if ("util".equals(parts[0]) && "generaMovimenti".equals(parts[1])) {
                String tipo_documento = parts[2];
                Integer id = cu.i((Object)parts[3]);
                System.out.println("genera Movimenti " + tipo_documento + " = " + id);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.generaMovimenti(inv, tipo_documento, id);
                    if (ret instanceof Boolean && ((Boolean)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response);
                }
                return;
            }
            if ("pdf".equals(parts[0])) {
                String tipo_documento = parts[1];
                Integer id = cu.i((Object)parts[2]);
                System.out.println("pdf " + tipo_documento + " = " + id);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.getPdf(inv, tipo_documento, id);
                    if (ret instanceof String) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        retj.put("file", ret);
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response);
                }
                return;
            }
            if ("util".equals(parts[0]) && "converti".equals(parts[1])) {
                String da_tipo_documento = parts[2];
                Integer da_id = cu.i((Object)parts[3]);
                String a_tipo_documento = parts[4];
                System.out.println("converti " + da_tipo_documento + " " + da_id + " a " + a_tipo_documento);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.convertiDoc(da_tipo_documento, a_tipo_documento, da_id, null);
                    System.out.println("dump ret convertiDoc");
                    DebugUtils.dump((Object)ret);
                    if (ret instanceof Integer) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        retj.put("id", ret);
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response, e);
                }
                return;
            }
            if ("util".equals(parts[0]) && "generaScadenze".equals(parts[1])) {
                Integer id = cu.i((Object)parts[2]);
                String tipo = parts[3];
                System.out.println("generaScadenze " + id);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.generaScadenze(id, tipo);
                    System.out.println("dump ret generaScadenze");
                    DebugUtils.dump((Object)ret);
                    if (cu.b((Object)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response, e);
                }
                return;
            }
            if ("util".equals(parts[0]) && "generaProvvigioni".equals(parts[1])) {
                Integer id_fattura = cu.i((Object)parts[2]);
                System.out.println("generaProvvigioni " + id_fattura);
                try {
                    main inv = this.getMain(request, response);
                    Object ret = this.generaProvvigioni(id_fattura);
                    System.out.println("dump ret generaProvvigioni");
                    DebugUtils.dump((Object)ret);
                    if (cu.b((Object)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    this.error(e.toString(), request, response, e);
                }
                return;
            }
            if ("util".equals(parts[0]) && "inviaSollecitoScadenza".equals(parts[1])) {
                Integer id = cu.i((Object)parts[2]);
                String email_cc = null;
                String email_ccn = null;
                if (parts.length >= 4) {
                    email_cc = cu.s((Object)parts[3]);
                }
                if (parts.length >= 5) {
                    email_ccn = cu.s((Object)parts[4]);
                }
                System.out.println("inviaSollecitoScadenza " + id);
                try {
                    main inv = this.getMain(request, response);
                    Object minst = Class.forName("invoicexpluginemail.Main2").newInstance();
                    System.out.println("minst = " + minst);
                    for (Method m : minst.getClass().getDeclaredMethods()) {
                        System.out.println("m = " + m);
                    }
                    Method minvio = minst.getClass().getDeclaredMethod("inviaSollecitoScadenza", Integer.class, String.class, String.class);
                    System.out.println("minvio = " + minvio);
                    Object ret = minvio.invoke(minst, id, email_cc, email_ccn);
                    System.out.println("ret = " + ret);
                    if (cu.b((Object)ret).booleanValue()) {
                        JSONObject retj = new JSONObject();
                        retj.put("esito", "ok");
                        this.ok(retj.toJSONString(), request, response);
                        return;
                    }
                    this.error(ret == null ? "ret = null" : ret.toString(), request, response);
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        this.error(e.getCause().toString(), request, response, e.getCause());
                    }
                    this.error(e.toString(), request, response, e);
                }
                return;
            }
        }

        private void error(String errore, HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.error(errore, request, response, null);
        }

        private void error(String errore, HttpServletRequest request, HttpServletResponse response, Throwable ex) throws IOException {
            if (ex != null) {
                ex.printStackTrace();
            }
            System.out.println("error = " + errore);
            response.setContentType("text/html");
            response.setStatus(500);
            response.getWriter().write(errore);
        }

        private void ok(String json, HttpServletRequest request, HttpServletResponse response) throws IOException {
            System.out.println("json:" + json);
            response.setContentType("application/json");
            response.setStatus(200);
            response.getWriter().write(json);
        }

        public Object generaScadenze(Integer id, String tipo_documento) {
            try {
                String tipo_doc_inv = MainBatch.tipi_doc_inv.get(tipo_documento);
                Map doc = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("select pagamento from " + Db.getNomeTabT(tipo_doc_inv) + " where id = " + id)).get(0);
                boolean generaScadenze = false;
                if (tipo_documento.equals("ordine_vendita")) {
                    if (main.fileIni.getValueBoolean("pref", "scadenzeOrdini", false).booleanValue()) {
                        generaScadenze = true;
                    }
                } else if (tipo_documento.equals("fattura_vendita") || tipo_documento.equals("fattura_acquisto")) {
                    generaScadenze = true;
                }
                boolean ret = false;
                if (generaScadenze) {
                    String codicePagamento = cu.s(doc.get("pagamento"));
                    Scadenze tempScad = new Scadenze(tipo_doc_inv, id, codicePagamento, (Object)this);
                    boolean scadenzeRigenerate = false;
                    ret = tempScad.generaScadenze(null, false, (Object)this);
                }
                if (ret) {
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "Errore in generaScadenze " + ex.getMessage() + ", consultare il log";
            }
        }

        public Object generaProvvigioni(Integer id_fattura) {
            try {
                Map fattura = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("select tipo_fattura from test_fatt where id = " + id_fattura)).get(0);
                ProvvigioniFattura provvigioni = new ProvvigioniFattura(id_fattura);
                double nuovoImportoTeoricoProvvigioni = provvigioni.getTotaleProvvigioni();
                boolean ret = provvigioni.generaProvvigioni();
                try {
                    Storico.scrivi("Genera provvigioni", Db.TIPO_DOCUMENTO_FATTURA + " " + fattura.get("serie") + " " + fattura.get("numero") + " " + fattura.get("anno") + " " + fattura.get("codice_agente") + " " + fattura.get("perc_agente") + " ret:" + ret);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("esito genera provvigioni:" + ret + " : " + provvigioni.ret);
                if (ret) {
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "Errore in generaProvvigioni " + ex.getMessage() + ", consultare il log";
            }
        }

        public Object convertiDoc(String da_tipo_documento, String a_tipo_documento, Integer id, List<Integer> id_righe_da_includere) throws Exception {
            Storico.scriviSeparati("http convertiDoc inizio " + da_tipo_documento + " a " + a_tipo_documento + " id " + id + " id_righe " + id_righe_da_includere, null);
            String da_tipo_doc_inv = MainBatch.tipi_doc_inv.get(da_tipo_documento);
            String a_tipo_doc_inv = MainBatch.tipi_doc_inv.get(a_tipo_documento);
            dbOrdine doc = new dbOrdine();
            String sql = "select id, serie, numero, anno from test_ordi where id = " + id;
            System.out.println("sql = " + sql);
            ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
            DebugUtils.dump((Object)list);
            if (list.isEmpty()) {
                return new Exception("Non trovato documento di origine " + da_tipo_documento + " id " + id);
            }
            Map rec = (Map)list.get(0);
            InvoicexUtil.aggiornaTotaliRighe(Db.TIPO_DOCUMENTO_ORDINE, id);
            doc.serie = cu.s(rec.get("serie"));
            doc.ids = new Integer[]{id};
            doc.acquisto = false;
            String ret = doc.converti("fatt", false);
            if (ret != null) {
                System.out.println("ret: " + ret);
                Integer id_new = cu.i((Object)ret);
                return id_new;
            }
            return "Errore in conversione documento, consultare il log";
        }

        public Object getPdf(main inv, String tipo_documento, Integer id) throws Exception {
            String tipo_doc_inv = MainBatch.tipi_doc_inv.get(tipo_documento);
            System.out.println("tipo_doc_inv = " + tipo_doc_inv);
            try {
                InvoicexUtil.aggiornaTotaliRighe(tipo_doc_inv, id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Map retnum = InvoicexUtil.getSerieNumeroAnno(tipo_doc_inv, id);
            String dbSerie = cu.s(retnum.get("serie"));
            int dbNumero = cu.i0(retnum.get("numero"));
            int dbAnno = cu.i0(retnum.get("anno"));
            Object ret = null;
            if (tipo_documento.equals("fattura_vendita")) {
                String sql = "select tipo_fattura, descrizione_breve from test_fatt t join tipi_fatture tf on t.tipo_fattura = tf.tipo where id = " + id;
                sql = sql + " and tipo_fattura != 7";
                ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                String tipofatt = cu.s(((Map)list.get(0)).get("descrizione_breve"));
                ret = frmElenFatt.stampa(tipofatt, dbSerie, dbNumero, dbAnno, true, true, true, id);
            } else if (tipo_documento.equals("fattura_acquisto")) {
                String sql = "select tipo_fattura, descrizione_breve from test_fatt_acquisto t join tipi_fatture_acquisto tf on t.tipo_fattura = tf.tipo where id = " + id;
                ArrayList list = DbUtils.getListMap((Connection)Db.getConn(), (String)sql);
                String tipofatt = cu.s(((Map)list.get(0)).get("descrizione_breve"));
                ret = frmElenFattAcquisto.stampa(tipofatt, dbSerie, dbNumero, dbAnno, true, true, true, id);
            } else if (tipo_documento.equals("ddt_vendita") || tipo_documento.equals("ddt_acquisto")) {
                boolean acquisto = !tipo_documento.equals("ddt_vendita");
                ret = frmElenDDT.stampa(tipo_documento, dbSerie, dbNumero, dbAnno, true, true, true, acquisto, id);
            } else if (tipo_documento.equals("ordine_vendita") || tipo_documento.equals("ordine_acquisto")) {
                boolean acquisto = !tipo_documento.equals("ordine_vendita");
                ret = frmElenOrdini.stampa(tipo_documento, dbSerie, dbNumero, dbAnno, true, true, true, acquisto, id);
            }
            System.out.println("ret = " + ret);
            if (ret instanceof String) {
                return (String)ret;
            }
            return ret;
        }

        public Object calcolaTotali(main inv, String tipo_documento, Integer id) throws Exception {
            Storico.scriviSeparati(inv.db3.getConn(), "calcolaTotali inizio " + tipo_documento + " id " + id, null);
            String tipo_doc = MainBatch.tipi_doc_inv.get(tipo_documento);
            try {
                String tabt = Db.getNomeTabT(tipo_doc);
                String tabr = Db.getNomeTabR(tipo_doc);
                InvoicexUtil.aggiornaTotaliRighe(tipo_doc, (int)id, inv.db3.getConn());
                InvoicexUtil.aggiornaPrezziNettiUnitari(tabr, tabt, id);
                InvoicexUtil.aggiornaPrezziNettiTotali(tabr, tabt, id);
                Documento doc = new Documento();
                doc.load(gestioneFatture.Db.INSTANCE, tipo_doc, id, inv.db3.getConn());
                doc.calcolaTotali();
                HashMap<String, Double> m = new HashMap<String, Double>();
                m.put("totale", doc.getTotale());
                m.put("totale_iva", doc.getTotaleIva());
                m.put("totale_imponibile", doc.getTotaleImponibile());
                m.put("totale_imponibile_pre_sconto", doc.totaleImponibilePreSconto);
                m.put("totale_ivato_pre_sconto", doc.totaleIvatoPreSconto);
                System.out.println("tipo_doc:" + tipo_doc);
                if (tipo_doc.equals(Db.TIPO_DOCUMENTO_FATTURA) || tipo_doc.equals(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA)) {
                    m.put("totale_ritenuta", doc.getTotale_ritenuta());
                    m.put("totaleRivalsa", doc.getTotale_rivalsa());
                    m.put("totale_da_pagare", doc.getTotale_da_pagare());
                }
                m.put("totale_da_pagare_finale", doc.getTotale_da_pagare_finale());
                String sql = "select id, totale, totale_imponibile from " + tabt + " where id = " + id;
                ArrayList listDebug = dbu.getListMap((Connection)inv.db3.getConn(), (String)sql);
                System.out.println("test_ordi pre calcolo totalie");
                DebugUtils.dump((Object)listDebug);
                sql = "update " + Db.getNomeTabT(tipo_doc) + " set " + dbu.prepareSqlFromMap(m) + " where id = " + id;
                System.out.println("sql totali = " + sql);
                boolean ret = dbu.tryExecQuery((Connection)inv.db3.getConn(), (String)sql);
                System.out.println("ret update = " + ret);
                ret = dbu.tryExecQuery((Connection)inv.db3.getConn(), (String)"COMMIT;");
                System.out.println("ret commit = " + ret);
                ArrayList restest1 = dbu.getListMap((Connection)inv.db3.getConn(), (String)"SELECT DATABASE()");
                DebugFastUtils.dump((Object)restest1);
                ArrayList restest2 = dbu.getListMap((Connection)inv.db3.getConn(), (String)"select @@hostname");
                DebugFastUtils.dump((Object)restest2);
                sql = "select id, totale, totale_imponibile from " + tabt + " where id = " + id;
                listDebug = dbu.getListMap((Connection)inv.db3.getConn(), (String)sql);
                DebugUtils.dump((Object)listDebug);
                System.out.println("test_ordi post calcolo totalie");
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Errore in calcola totali: " + e.toString();
            }
            return true;
        }

        public Object generaMovimenti(main inv, String tipo_documento, Integer id) throws Exception {
            Storico.scriviSeparati(inv.db3.getConn(), "generaMovimenti inizio " + tipo_documento + " id " + id, null);
            String tipo_doc = MainBatch.tipi_doc_inv.get(tipo_documento);
            System.out.println("tipo_doc = " + tipo_doc);
            try {
                String tabt = Db.getNomeTabT(tipo_doc);
                System.out.println("tabt = " + tabt);
                String tabr = Db.getNomeTabR(tipo_doc);
                dbDocumento dbdoc = new dbDocumento();
                dbdoc.tipoDocumento = tipo_doc;
                dbdoc.setId(id);
                if (!dbdoc.generaMovimentiMagazzinoExc(false)) {
                    return "Errore in generaMovimenti: return false da generaMovimentiMagazzinoExc()";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Errore in generaMovimenti: " + e.toString();
            }
            return true;
        }

        private main getMain(HttpServletRequest request, HttpServletResponse response) throws IOException, Exception {
            Iterator<Map.Entry<String, main>> iter = cacheMain.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, main> e = iter.next();
                long diff = (System.currentTimeMillis() - e.getValue().startms) / 1000L;
                System.out.println("startms = " + diff);
                if (diff <= 60L) continue;
                System.out.println("CACHE *** rimuovo " + e.getKey() + " perch\u00e8 partito da " + diff + " > 60 secondi");
                iter.remove();
            }
            main inv = null;
            boolean dacache = false;
            String dbserver = request.getParameter("param[db][server]");
            String dbname = request.getParameter("param[db][database]");
            String key = dbserver + "|" + dbname;
            System.out.println("CACHE *** key da trovare = " + key);
            for (String k : cacheMain.keySet()) {
                System.out.println("CACHE *** key = " + k);
            }
            if (cacheMain.containsKey(key)) {
                System.out.println("CACHE *** prendo main da cache");
                inv = cacheMain.get(key);
                inv.startms = System.currentTimeMillis();
                dacache = true;
            } else {
                System.out.println("CACHE *** prendo nuovo main");
                inv = new main();
                System.out.println("CACHE *** aggiungo " + inv + " in key " + key);
                cacheMain.put(key, inv);
                for (String k : cacheMain.keySet()) {
                    System.out.println("CACHE *** key = " + k);
                }
            }
            final HashMap<String, String> params = new HashMap<String, String>();
            params.put("pref_tipoStampa", "fattura_mod7_default.jrxml");
            params.put("pref_tipoStampaFA", "fattura_acc_mod7_default.jrxml");
            params.put("pref_tipoStampaDDT", "ddt_mod6_default.jrxml");
            params.put("pref_tipoStampaOrdine", "ordine_mod7_default.jrxml");
            params.put("plugin_email_smtp", "smtp.tnx.it");
            params.put("plugin_email_porta", "587");
            params.put("plugin_email_testi_param", "false");
            params.put("plugin_email_tipo_connessione", "STARTTLS");
            params.put("plugin_email_username", "invoicex_server_dev");
            params.put("plugin_email_password", "Z6bzdFrijWtI2WPiSuHd+A\\=\\=");
            params.put("plugin_email_password_crypted", "29/05/18 16.48");
            Enumeration ep = request.getParameterNames();
            while (ep.hasMoreElements()) {
                String pname = (String)ep.nextElement();
                if (!pname.startsWith("param[param_")) continue;
                System.out.println("pname     = " + pname);
                String k = StringUtils.removeStart((String)pname, (String)"param[param_");
                k = StringUtils.removeEnd((String)k, (String)"]");
                System.out.println("k         = " + k);
                params.put(k, request.getParameter(pname));
                System.out.println("imposto k = " + request.getParameter(pname));
            }
            main.isBatch = true;
            main.isServer = true;
            File fwd = new File("./");
            try {
                main.wd = fwd.getCanonicalPath() + File.separator;
                System.out.println("wd = " + main.wd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            main.fileIni = new iniFileProp(){

                @Override
                public String getValue(String subject, String variable) {
                    String key = subject + "_" + variable;
                    if (params.containsKey(key)) {
                        System.out.println("!!! getValue : " + subject + " : " + variable + " = " + cu.s(params.get(key)));
                        return cu.s(params.get(key));
                    }
                    System.out.println("!!! getValue : " + subject + " : " + variable + " NON TROVATA");
                    return cu.s((Object)"");
                }

                @Override
                public synchronized boolean setValue(String subject, String variable, String value) {
                    return true;
                }

                @Override
                public synchronized boolean existKey(String subject, String variable) {
                    String key = subject + "_" + variable;
                    if (params.containsKey(key)) {
                        return true;
                    }
                    System.out.println("!! existKey : " + subject + " : " + variable);
                    return false;
                }
            };
            Db.dbPort = 3306;
            inv.db3.dbPort = 3306;
            System.out.println("Imposto server: = " + request.getParameter("param[db][server]"));
            Db.dbServ = request.getParameter("param[db][server]");
            inv.db3.dbServ = request.getParameter("param[db][server]");
            System.out.println("Imposto db: = " + request.getParameter("param[db][database]"));
            Db.dbNameDB = request.getParameter("param[db][database]");
            inv.db3.dbNameDB = request.getParameter("param[db][database]");
            System.out.println("Imposto user: = " + request.getParameter("param[db][user]"));
            Db.dbName = request.getParameter("param[db][user]");
            inv.db3.dbName = request.getParameter("param[db][user]");
            System.out.println("Imposto pass: = " + StringUtils.substring((String)request.getParameter("param[db][pass]"), (int)0, (int)3) + "***");
            Db.dbPass = request.getParameter("param[db][pass]");
            inv.db3.dbPass = request.getParameter("param[db][pass]");
            if (SystemUtils.getHostname().equalsIgnoreCase("mceccarelli")) {
                Db.dbServ = "linux";
                Db.dbName = "root";
                Db.dbPass = "xxx";
                inv.db3.dbServ = "linux";
                inv.db3.dbName = "root";
                inv.db3.dbPass = "xxx";
            }
            if (Db.dbServ.equalsIgnoreCase("localhost")) {
                Db.localSocketAddress = "127.0.0.1";
            }
            if (inv.db3.dbServ.equalsIgnoreCase("localhost")) {
                inv.db3.localSocketAddress = "127.0.0.1";
            }
            try {
                Connection testconn = Db.getConn();
                if (testconn == null) {
                    this.error("errore in connessione mysql (test=null) a:" + Db.dbServ + " db:" + Db.dbNameDB + " user:" + Db.dbName, request, response);
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error("errore in connessione mysql (exc:" + e.toString() + ") a: " + Db.dbServ + " db:" + Db.dbNameDB + " user:" + Db.dbName, request, response);
                return null;
            }
            DbUtils.tryExecQuery((Connection)Db.getConn(), (String)("use " + Db.dbNameDB));
            DbUtils.tryExecQuery((Connection)inv.db3.getConn(), (String)("use " + Db.dbNameDB));
            String db = cu.s((Object)DbUtils.getObject((Connection)Db.getConn(), (String)"SELECT DATABASE()"));
            System.out.println("*** db = " + db);
            if (!dacache) {
                System.out.println("aggiornamentiStrutturaDb()");
                try {
                    this.aggiornamentiStrutturaDb();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                main.GLOB.put("dati_azienda", dbu.getListMap((Connection)Db.getConn(), (String)("select " + main.campiDatiAzienda + " from dati_azienda")).get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            main.utente = new Utente(1);
            if (!dacache) {
                System.out.println("initPlugins()");
                try {
                    ApiServlet.initPlugins();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return inv;
        }

        static void initPlugins() throws IOException {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                public boolean isClientTrusted(X509Certificate[] xcs) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] xcs) {
                    return true;
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception e) {
                System.out.println(e);
            }
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    System.out.println("verify = " + hostname + " sessione:" + session);
                    return true;
                }
            });
            boolean pluginInvoicexCP = false;
            File fPluginInvoicex = new File("plugins/InvoicexPluginInvoicex.jar");
            if (fPluginInvoicex.exists()) {
                ClassPathHacker.addFile(fPluginInvoicex);
                pluginInvoicexCP = true;
            } else {
                System.out.println("!!! non presentte " + fPluginInvoicex);
            }
            main.pf = new PluginFactory();
            main.pf.loadPlugins(main.plugins_path);
            boolean pi = false;
            Collection plugcol = main.pf.getAllEntryDescriptor();
            if (plugcol != null) {
                for (EntryDescriptor pd : plugcol) {
                    if (!pd.getName().equalsIgnoreCase("pluginInvoicex")) continue;
                    pi = true;
                }
            }
            if (!pi) {
                try {
                    HttpUtils.saveBigFile((String)(main.baseurlserver + "/" + InvoicexUtil.getDownloadDir() + "/plugins/InvoicexPluginInvoicex.jar"), (String)"plugins/InvoicexPluginInvoicex.jar");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                main.pf.loadPlugins(main.plugins_path);
                plugcol = main.pf.getAllEntryDescriptor();
            }
            main.pf = new PluginFactory();
            main.pf.loadPlugins(main.plugins_path);
            plugcol = main.pf.getAllEntryDescriptor();
            if (plugcol != null) {
                for (EntryDescriptor pd : plugcol) {
                    if (pd.getName().equalsIgnoreCase("pluginInvoicex") || pd.getName().equalsIgnoreCase("pluginEmail")) {
                        main.pluginPresenti.add(pd.getName());
                        main.plugins.put(pd.getName(), pd);
                        try {
                            MicroBench mb = new MicroBench();
                            mb.start();
                            if (!main.isBatch) {
                                main.getPadrePanel().lblInfoLoading2.setText("Caricamento plugin " + pd.getName() + "...");
                            }
                            PluginEntry pl = main.pf.getPluginEntry(pd.getId());
                            pl.initPluginEntry(null);
                            System.out.println(pd.getName() + " Init -> tempo: " + mb.getDiff("init"));
                            pl.startPluginEntry();
                            main.pluginsAvviati.put(pd.getName(), pl);
                            if (!main.isBatch) {
                                main.getPadrePanel().lblInfoLoading2.setText(pd.getName() + " Caricato");
                            }
                            System.out.println(pd.getName() + " Caricato -> tempo: " + mb.getDiff("caricamento"));
                        }
                        catch (NoSuchFieldError nofield) {
                            nofield.printStackTrace();
                        }
                        catch (NoClassDefFoundError noclass) {
                            noclass.printStackTrace();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        catch (Throwable tr) {
                            tr.printStackTrace();
                        }
                        main.controllaFlagPlugin(pd.getName());
                        continue;
                    }
                    System.err.println("!!! ATTENZIONE !!! il " + pd.getName() + " non lo carico perch\u00e8 in modalit\u00e0 batch");
                }
            }
        }

        private void aggiornamentiStrutturaDb() throws Exception {
            if (!dbu.existTable((Connection)Db.getConn(), (String)"db_version") || !dbu.containRows((Connection)Db.getConn(), (String)"select * from db_version where modulo = 'invoicex'")) {
                main.splash("aggiornamenti struttura database ... eseguo dbChanges2");
                try {
                    DbChanges dbchanges = new DbChanges();
                    dbchanges.splash = main.splash;
                    dbchanges.fileIni = main.fileIni;
                    dbchanges.esegui_aggiornamenti();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                DbChanges2 dbchanges2 = new DbChanges2(){

                    @Override
                    public void post_execute_ok(int id_log, String id_plugin, String id_email, String sql) {
                        super.post_execute_ok(id_log, id_plugin, id_email, sql);
                        if (id_log == 143 && id_plugin.equals("") && id_email.equals("m.ceccarelli@tnx.it")) {
                            try {
                                if (!CastUtils.toString((Object)DbUtils.getObject((Connection)Db.getConn(), (String)"select logo_in_db from dati_azienda", (boolean)false)).equalsIgnoreCase("S")) {
                                    System.out.println("*** salvo logo in db ***");
                                    main.splash("aggiornamenti struttura database ... salvataggio logo in db", 70);
                                    InvoicexUtil.salvaImgInDb(main.fileIni.getValue("varie", "percorso_logo_stampe"));
                                    InvoicexUtil.salvaImgInDb(main.fileIni.getValue("varie", "percorso_logo_stampe_pdf"), "logo_email");
                                    InvoicexUtil.salvaImgInDb(main.fileIni.getValue("varie", "percorso_sfondo_stampe"), "sfondo");
                                    InvoicexUtil.salvaImgInDb(main.fileIni.getValue("varie", "percorso_sfondo_stampe_pdf"), "sfondo_email");
                                    DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update dati_azienda set logo_in_db = 'S'");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void post_check_ok(int id_log, String id_plugin, String id_email) {
                        super.post_check_ok(id_log, id_plugin, id_email);
                        if (id_log == 141 && id_plugin.equals("") && id_email.equals("m.ceccarelli@tnx.it")) {
                            try {
                                if (!CastUtils.toString((Object)DbUtils.getObject((Connection)Db.getConn(), (String)"select logo_in_db from dati_azienda", (boolean)false)).equalsIgnoreCase("S")) {
                                    DbUtils.tryExecQuery((Connection)Db.getConn(), (String)"update dati_azienda set logo_in_db = 'S'");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                dbchanges2.esegui_aggiornamenti();
            } else {
                main.splash("aggiornamenti struttura database ... eseguo DbVersionChanges");
                try {
                    DbVersionChanges dbvc = new DbVersionChanges("invoicex", new RunnableWithArgs(){

                        public void run() {
                            main.splash(cu.s((Object)this.getArgs()[0]));
                        }
                    });
                    dbvc.esegui();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private String greeting = "Hello World";

        public HelloServlet() {
        }

        public HelloServlet(String greeting) {
            this.greeting = greeting;
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().println("<h1>" + this.greeting + "</h1>");
            response.getWriter().println("session=" + request.getSession(true).getId());
        }
    }
}

