/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class PlatformUtils {
    public static final int WINDOWS = 0;
    public static final int LINUX = 1;
    public static final int SOLARIS = 2;
    public static final int MAC = 3;
    public static final int OTHER = 4;
    public static final int NO_PLATFORM = -1;
    private static int iPlatform = -1;
    private static String sOsName;
    private static String sOsNameAbbr;

    public static boolean isWindows() {
        return PlatformUtils.getPlatform() == 0;
    }

    public static boolean isLinux() {
        return PlatformUtils.getPlatform() == 1;
    }

    public static boolean isSolaris() {
        return PlatformUtils.getPlatform() == 2;
    }

    public static boolean isMac() {
        return PlatformUtils.getPlatform() == 3;
    }

    public static boolean isOther() {
        return PlatformUtils.getPlatform() == 4;
    }

    public static int getPlatform() {
        PlatformUtils.fetchPlatform();
        return iPlatform;
    }

    public static String getPlatformName() {
        PlatformUtils.fetchPlatform();
        return sOsName;
    }

    public static String getPlatformNameAbbr() {
        PlatformUtils.fetchPlatform();
        return sOsNameAbbr;
    }

    private static void fetchPlatform() {
        if (iPlatform == -1) {
            sOsName = System.getProperty("os.name").toLowerCase();
            if (sOsName.indexOf("windows") != -1) {
                iPlatform = 0;
                sOsNameAbbr = "win";
            } else if (sOsName.indexOf("linux") != -1) {
                iPlatform = 1;
                sOsNameAbbr = "lin";
            } else if (sOsName.indexOf("solaris") != -1 || sOsName.indexOf("sunos") != -1) {
                iPlatform = 2;
                sOsNameAbbr = "sol";
            } else if (sOsName.indexOf("mac") != -1) {
                iPlatform = 3;
                sOsNameAbbr = "mac";
            }
        }
    }

    public static boolean isMacAarch64() {
        if (System.getProperty("os.arch").equalsIgnoreCase("aarch64")) {
            return true;
        }
        if (PlatformUtils.isMac()) {
            ProcessBuilder pb = new ProcessBuilder("sysctl", "-n", "machdep.cpu.brand_string");
            try {
                Process p = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String details = br.readLine();
                int status = p.waitFor();
                if (status == 0) {
                    // empty if block
                }
                System.out.println("details = " + details);
                if (details.toLowerCase().indexOf("intel") < 0) {
                    return true;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        return false;
    }
}

