/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import gestioneFatture.InvoicexEvent;
import gestioneFatture.SortedProperties;
import gestioneFatture.look.TnxSandTheme;
import gestioneFatture.main;
import it.tnx.commons.CastUtils;
import it.tnx.commons.HttpUtils;
import it.tnx.commons.JUtil;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.swing.JDialogFontChooser;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.PlatformUtils;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.InvoicexUtil2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXHyperlink;

public class JDialogAspetto
extends JDialog {
    boolean loading = false;
    Object oldComLook = null;
    Object oldFontFamily = null;
    Object oldFontSize = null;
    Object oldIcone = null;
    Object oldDimensione = null;
    Object oldScala = null;
    private Map<String, Icon> iconMap = new HashMap<String, Icon>();
    static ColorUIResource color_old = null;
    private Font font;
    public JButton annulla;
    public JComboBox comLook;
    public JButton conferma;
    public JComboBox dimensione;
    public JComboBox fattorediScala;
    public JComboBox icone;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel labAbilitareFattoreScala;
    public JLabel labFattoreDiScala;
    public JLabel labRiaprireFinestre;
    public JLabel labRiavviareInvoicex;
    public JXHyperlink linkJava10;
    public JButton pulsanteFont;

    public JDialogAspetto(Frame parent, boolean modal) {
        super(parent, modal);
        this.iconMap.put("Color", iu.getIcon("Medium_Icons", iu.icons_width, "icons8-color"));
        this.iconMap.put("Lines", iu.getIcon("Medium_Icons", iu.icons_width, "icons8-ios"));
        this.iconMap.put("Ultraviolet", iu.getIcon("Medium_Icons", iu.icons_width, "icons8-ultraviolet"));
        this.initComponents();
        try {
            String ver = HttpUtils.getUrlToStringUTF8((String)"https://server.invoicex.it/download/jre/ver.txt");
            this.linkJava10.setText("Aggiornamento Java ver." + ver + " (utile per monitor 4K)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final Color background = new Color(0, 100, 255, 15);
        final Color defaultBackground = (Color)UIManager.get("List.background");
        this.icone.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon((Icon)JDialogAspetto.this.iconMap.get(value));
                if (!isSelected) {
                    this.setBackground(index % 2 == 0 ? background : defaultBackground);
                }
                return this;
            }
        });
        this.loading = true;
        this.labRiaprireFinestre.setVisible(false);
        this.labRiavviareInvoicex.setVisible(false);
        this.labAbilitareFattoreScala.setVisible(false);
        this.linkJava10.setVisible(false);
        if (!JUtil.isJava10OrNewer() && !JUtil.is4k()) {
            this.labFattoreDiScala.setVisible(false);
            this.fattorediScala.setVisible(false);
            this.labRiavviareInvoicex.setVisible(false);
            this.labAbilitareFattoreScala.setVisible(false);
            this.linkJava10.setVisible(false);
        }
        this.linkJava10.setVisible(true);
        this.comLook.addItem("");
        this.comLook.addItem("System");
        this.comLook.addItem("FlatLaf Light");
        this.comLook.addItem("FlatLaf Dark");
        this.comLook.addItem("Simple");
        this.comLook.addItem("JGoodies Plastic XP");
        this.comLook.addItem("Substance Nebula");
        this.comLook.addItem("Substance BusinessBlackSteel");
        this.comLook.addItem("Substance Creme");
        if (PlatformUtils.isWindows()) {
            this.comLook.addItem("Office 2003");
            this.comLook.addItem("Office XP");
            this.comLook.addItem("Visual Studio 2005");
        }
        this.comLook.addItem("Nimbus");
        String tema = main.fileIni.getValue("varie", "look");
        if (tema == null || tema.length() == 0) {
            tema = PlatformUtils.isMac() ? "Substance Creme" : "JGoodies Plastic XP";
        }
        this.comLook.setSelectedItem(tema);
        this.oldComLook = this.comLook.getSelectedItem();
        try {
            String font_family = main.fileIni.getValue("pref", "font_family", main.def_font.getFamily());
            this.oldFontFamily = font_family;
            Integer font_size = cu.i0((Object)main.fileIni.getValue("pref", "font_size", CastUtils.toString((Object)main.def_font.getSize())));
            this.oldFontSize = font_size;
            if (!main.fileIni.existKey("pref", "font_family") && PlatformUtils.isMac()) {
                font_size = font_size - 3;
            }
            this.font = new Font(font_family, 0, font_size);
            this.setPulsanteFont(this.font);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.icone.setSelectedItem(main.fileIni.getValue("varie", "icone", "Color"));
        this.dimensione.setSelectedItem(main.fileIni.getValue("varie", "icone_dimensione", "Medie"));
        SortedProperties p = new SortedProperties();
        File finvoicex = new File(System.getProperty("user.home") + "/.invoicex/");
        String nomefile = System.getProperty("user.home") + "/.invoicex/finestre.txt";
        try {
            if (new File(nomefile).exists()) {
                p.load(new FileInputStream(nomefile));
            }
        }
        catch (IOException ex) {
            SwingUtils.showExceptionMessage(null, (Exception)ex);
        }
        this.fattorediScala.setSelectedItem(p.getProperty("default_screen_scale", JUtil.is4k() ? "2" : "1"));
        if (!JUtil.isJava10OrNewer()) {
            this.fattorediScala.setEnabled(false);
            this.labFattoreDiScala.setEnabled(false);
            if (this.fattorediScala.isVisible()) {
                this.labAbilitareFattoreScala.setVisible(true);
                this.linkJava10.setVisible(true);
            }
        }
        this.oldIcone = this.icone.getSelectedItem();
        this.oldDimensione = this.dimensione.getSelectedItem();
        this.oldScala = this.fattorediScala.getSelectedItem();
        this.loading = false;
    }

    public void setupIcons() {
        this.conferma.setIcon(iu.getIcon("conferma"));
        this.annulla.setIcon(iu.getIcon("annulla"));
        this.jLabel1.setIcon(iu.getIcon("aspetto"));
        this.jLabel2.setIcon(iu.getIcon("Medium_Icons"));
        this.jLabel3.setIcon(iu.getIcon("Font"));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.icone = new JComboBox();
        this.jLabel3 = new JLabel();
        this.annulla = new JButton();
        this.conferma = new JButton();
        this.comLook = new JComboBox();
        this.pulsanteFont = new JButton();
        this.labRiaprireFinestre = new JLabel();
        this.dimensione = new JComboBox();
        this.fattorediScala = new JComboBox();
        this.labFattoreDiScala = new JLabel();
        this.labRiavviareInvoicex = new JLabel();
        this.labAbilitareFattoreScala = new JLabel();
        this.linkJava10 = new JXHyperlink();
        this.setDefaultCloseOperation(2);
        this.setTitle("Aspetto grafico");
        this.jLabel1.setIcon(iu.getIcon("aspetto"));
        this.jLabel1.setText("Tema");
        this.jLabel2.setIcon(iu.getIcon("Medium_Icons"));
        this.jLabel2.setText("Icone");
        this.icone.setModel(new DefaultComboBoxModel<String>(new String[]{"Color", "Lines", "Ultraviolet"}));
        this.icone.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JDialogAspetto.this.iconeItemStateChanged(evt);
            }
        });
        this.icone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.iconeActionPerformed(evt);
            }
        });
        this.jLabel3.setIcon(iu.getIcon("Font"));
        this.jLabel3.setText("Carattere");
        this.annulla.setIcon(iu.getIcon("annulla"));
        this.annulla.setText("Annulla");
        this.annulla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.annullaActionPerformed(evt);
            }
        });
        this.conferma.setFont(this.conferma.getFont().deriveFont(this.conferma.getFont().getStyle() | 1));
        this.conferma.setIcon(iu.getIcon("conferma"));
        this.conferma.setText("Conferma");
        this.conferma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.confermaActionPerformed(evt);
            }
        });
        this.comLook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.comLookActionPerformed(evt);
            }
        });
        this.pulsanteFont.setText("font");
        this.pulsanteFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.pulsanteFontActionPerformed(evt);
            }
        });
        this.labRiaprireFinestre.setForeground(new Color(191, 0, 0));
        this.labRiaprireFinestre.setText("Per applicare il carattere si devono chiudere e riparire le eventuali finestre aperte");
        this.dimensione.setModel(new DefaultComboBoxModel<String>(new String[]{"Piccole", "Medie", "Grandi"}));
        this.dimensione.setSelectedIndex(1);
        this.dimensione.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.dimensioneActionPerformed(evt);
            }
        });
        this.fattorediScala.setModel(new DefaultComboBoxModel<String>(new String[]{"0.5", "0.75", "1", "1.5", "2", "2.5", "3"}));
        this.fattorediScala.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.fattorediScalaActionPerformed(evt);
            }
        });
        this.labFattoreDiScala.setIcon(iu.getIcon("Resize"));
        this.labFattoreDiScala.setText("Fattore di scala interfaccia (utile per monitor 4K)");
        this.labRiavviareInvoicex.setForeground(new Color(191, 0, 0));
        this.labRiavviareInvoicex.setText("riavviare Invoicex");
        this.labAbilitareFattoreScala.setForeground(new Color(191, 0, 0));
        this.labAbilitareFattoreScala.setText("per abilitare il fattore di scala devi avere Java 10 o superiore, clicca sul link sottostante per scaricarlo");
        this.linkJava10.setText("Aggiornamento Java (per monitor 4K)");
        this.linkJava10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogAspetto.this.linkJava10ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.annulla).add(18, 18, 18).add((Component)this.conferma)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.labFattoreDiScala).addPreferredGap(0).add((Component)this.fattorediScala, -2, -1, -2).addPreferredGap(0).add((Component)this.labRiavviareInvoicex)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.comLook, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.icone, -2, -1, -2).addPreferredGap(0).add((Component)this.dimensione, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.pulsanteFont)).add((Component)this.labRiaprireFinestre).add((Component)this.labAbilitareFattoreScala).add((Component)this.linkJava10, -2, -1, -2)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.comLook, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.icone, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.dimensione, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.pulsanteFont)).addPreferredGap(0).add((Component)this.labRiaprireFinestre).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, 93, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.conferma).add((Component)this.annulla)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fattorediScala, -2, -1, -2).add((Component)this.labFattoreDiScala).add((Component)this.labRiavviareInvoicex)).addPreferredGap(0).add((Component)this.labAbilitareFattoreScala).addPreferredGap(0).add((Component)this.linkJava10, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        this.pack();
    }

    private void iconeActionPerformed(ActionEvent evt) {
        iu.icons_pack = this.icone.getSelectedItem().equals("Color") ? "icons8-color" : (this.icone.getSelectedItem().equals("Lines") ? "icons8-ios" : "icons8-ultraviolet");
        this.setupIcons();
        main.getPadrePanel().setupIcons();
    }

    private void iconeItemStateChanged(ItemEvent evt) {
    }

    private void annullaActionPerformed(ActionEvent evt) {
        this.icone.setSelectedItem(this.oldIcone);
        if (!this.oldComLook.equals(this.comLook.getSelectedItem())) {
            this.comLook.setSelectedItem(this.oldComLook);
        }
        this.font = new Font((String)this.oldFontFamily, 0, (Integer)this.oldFontSize);
        this.setPulsanteFont(this.font);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confermaActionPerformed(ActionEvent evt) {
        main.fileIni.setValue("varie", "look", cu.s((Object)this.comLook.getSelectedItem()));
        main.fileIni.setValue("varie", "icone", cu.s((Object)this.icone.getSelectedItem()));
        main.fileIni.setValue("varie", "icone_dimensione", cu.s((Object)this.dimensione.getSelectedItem()));
        if (this.font != null) {
            main.fileIni.setValue("pref", "font_family", this.font.getFamily());
            main.fileIni.setValue("pref", "font_size", this.font.getSize());
        }
        SortedProperties p = new SortedProperties();
        File finvoicex = new File(System.getProperty("user.home") + "/.invoicex/");
        String nomefile = System.getProperty("user.home") + "/.invoicex/finestre.txt";
        try {
            if (new File(nomefile).exists()) {
                p.load(new FileInputStream(nomefile));
            }
        }
        catch (IOException ex) {
            SwingUtils.showExceptionMessage(null, (Exception)ex);
        }
        p.put("default_screen_scale", cu.s((Object)this.fattorediScala.getSelectedItem()));
        FileOutputStream fouts = null;
        try {
            fouts = new FileOutputStream(nomefile);
            p.store(fouts, "");
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage(null, (Exception)ex);
        }
        finally {
            if (fouts != null) {
                try {
                    fouts.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JDialogAspetto.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.dispose();
    }

    private void comLookActionPerformed(ActionEvent evt) {
        if (this.loading) {
            return;
        }
        String look = cu.s((Object)this.comLook.getSelectedItem());
        JDialogAspetto.impostaLAF(look, this);
    }

    public static void updateLAFRecursively(Window window) {
        for (Window childWindow : window.getOwnedWindows()) {
            JDialogAspetto.updateLAFRecursively(childWindow);
        }
        SwingUtilities.updateComponentTreeUI(window);
    }

    private void pulsanteFontActionPerformed(ActionEvent evt) {
        SwingUtils.mouse_wait((Component)this);
        JDialogFontChooser dialog = new JDialogFontChooser((Dialog)this, true);
        dialog.panel_font.setDefFont(main.def_font, !main.fileIni.existKey("pref", "font_family"));
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
        if (dialog.ok) {
            this.font = new Font((String)dialog.panel_font.font_names.getSelectedItem(), 0, (Integer)dialog.panel_font.font_size.getValue());
            this.setPulsanteFont(this.font);
        } else if (dialog.reimposta) {
            main.fileIni.removeKey("pref", "font_family");
            main.fileIni.removeKey("pref", "font_size");
            this.font = null;
            this.font = main.def_font;
            this.setPulsanteFont(main.def_font);
        }
        SwingUtils.mouse_def((Component)this);
    }

    private void dimensioneActionPerformed(ActionEvent evt) {
        iu.icons_width = this.dimensione.getSelectedItem().equals("Grandi") ? Integer.valueOf(36) : (this.dimensione.getSelectedItem().equals("Piccole") ? Integer.valueOf(16) : Integer.valueOf(24));
        this.setupIcons();
        main.getPadrePanel().setupIcons();
    }

    private void fattorediScalaActionPerformed(ActionEvent evt) {
        if (!this.loading) {
            this.labRiavviareInvoicex.setVisible(true);
        }
    }

    private void linkJava10ActionPerformed(ActionEvent evt) {
        try {
            if (SwingUtils.showYesNoMessage((Component)this, (String)"Procedere con l'aggiornamento di Java?")) {
                this.dispose();
                InvoicexUtil2.aggiornaJava();
            }
        }
        catch (Exception e) {
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
    }

    private void setPulsanteFont(Font font) {
        if (font == null) {
            this.pulsanteFont.setFont(main.def_font);
            this.pulsanteFont.setText(main.def_font.getFamily() + " " + main.def_font.getSize());
        } else {
            this.pulsanteFont.setFont(font);
            this.pulsanteFont.setText(font.getFamily() + " " + font.getSize());
        }
        if (!this.loading) {
            JInternalFrame[] frames;
            this.labRiaprireFinestre.setVisible(true);
            for (JInternalFrame frame : frames = main.getPadre().getDesktopPane().getAllFrames()) {
                if (!frame.getClass().getName().startsWith("invoicexpluginricerca")) continue;
                frame.dispose();
            }
            String font_family = font.getFamily();
            Integer font_size = cu.i0((Object)font.getSize());
            Font newf = new Font(font_family, 0, font_size);
            try {
                UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
                Enumeration e = uiDefaults.keys();
                while (e.hasMoreElements()) {
                    try {
                        Object item = e.nextElement();
                        if (item.toString().toLowerCase().indexOf("font") < 0) continue;
                        Font foc = (Font)uiDefaults.get(item);
                        uiDefaults.put(item, newf);
                    }
                    catch (Exception exception) {}
                }
                System.out.println("fine ui");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Component c : this.getContentPane().getComponents()) {
                if (c instanceof JButton) {
                    c.setFont(UIManager.getDefaults().getFont("Button.font"));
                    continue;
                }
                if (c instanceof JLabel) {
                    c.setFont(UIManager.getDefaults().getFont("Label.font"));
                    continue;
                }
                if (!(c instanceof JComboBox)) continue;
                c.setFont(UIManager.getDefaults().getFont("ComboBox.font"));
            }
            this.pack();
            main.getPadrePanel().setupFont();
            main.events.fireInvoicexEvent(new InvoicexEvent(this, 101));
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JDialogAspetto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JDialogAspetto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JDialogAspetto.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JDialogAspetto.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogAspetto dialog = new JDialogAspetto((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static void impostaLAF(String look, final Container parent) {
        try {
            JInternalFrame[] frames;
            for (JInternalFrame frame : frames = main.getPadre().getDesktopPane().getAllFrames()) {
                if (!frame.getClass().getName().startsWith("invoicexpluginricerca")) continue;
                frame.dispose();
            }
            boolean giaSettato = false;
            String laf = null;
            if (look.equalsIgnoreCase("Simple")) {
                System.out.println("Simple look and feel");
                color_old = (ColorUIResource)UIManager.get("ComboBox.selectionBackground");
                TnxSandTheme theme = new TnxSandTheme();
                MetalLookAndFeel.setCurrentTheme(theme);
                laf = "javax.swing.plaf.metal.MetalLookAndFeel";
                UIManager.put("ComboBox.selectionBackground", new ColorUIResource(Color.lightGray));
            } else if (look.equalsIgnoreCase("System")) {
                laf = UIManager.getSystemLookAndFeelClassName();
            } else if (look.equalsIgnoreCase("Substance Nebula")) {
                laf = "org.jvnet.substance.skin.SubstanceNebulaLookAndFeel";
            } else if (look.equalsIgnoreCase("Substance BusinessBlackSteel")) {
                laf = "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel";
            } else if (look.equalsIgnoreCase("Substance Creme")) {
                laf = "org.jvnet.substance.skin.SubstanceCremeLookAndFeel";
            } else if (look.equalsIgnoreCase("Tonic")) {
                laf = "com.digitprop.tonic.TonicLookAndFeel";
            } else if (look.equalsIgnoreCase("Office 2003")) {
                laf = "org.fife.plaf.Office2003.Office2003LookAndFeel";
            } else if (look.equalsIgnoreCase("Office XP")) {
                laf = "org.fife.plaf.OfficeXP.OfficeXPLookAndFeel";
            } else if (look.equalsIgnoreCase("Visual Studio 2005")) {
                laf = "org.fife.plaf.VisualStudio2005.VisualStudio2005LookAndFeel";
            } else if (look.equalsIgnoreCase("Nimbus")) {
                laf = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
            } else if (look.equalsIgnoreCase("FlatLaf Light")) {
                UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
                giaSettato = true;
            } else if (look.equalsIgnoreCase("FlatLaf Dark")) {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
                giaSettato = true;
            } else {
                laf = look.equalsIgnoreCase("JGoodies Plastic XP") ? (PlatformUtils.isMac() ? "com.jgoodies.looks.plastic.PlasticLookAndFeel" : "com.jgoodies.looks.plastic.PlasticXPLookAndFeel") : (PlatformUtils.isMac() ? "org.jvnet.substance.skin.SubstanceCremeLookAndFeel" : "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            }
            if (!giaSettato) {
                UIManager.setLookAndFeel(laf);
            }
            InvoicexUtil.impostaColoriDefault(look, color_old);
        }
        catch (Exception err) {
            SwingUtils.showExceptionMessage((Component)parent, (Exception)err);
        }
        if (UIManager.getLookAndFeel() instanceof PlasticLookAndFeel) {
            PlasticXPLookAndFeel l = new PlasticXPLookAndFeel();
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            try {
                UIManager.setLookAndFeel((LookAndFeel)l);
            }
            catch (UnsupportedLookAndFeelException ex) {
                SwingUtils.showExceptionMessage((Component)parent, (Exception)ex);
            }
        }
        main.substance = UIManager.getLookAndFeel().getName().toLowerCase().indexOf("substance") >= 0;
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Thread.sleep(10L);
                return true;
            }

            protected void done() {
                super.done();
                JDialogAspetto.updateLAFRecursively(main.getPadre());
                SwingUtilities.updateComponentTreeUI(main.getPadrePanel().popSfondo);
                main.events.fireInvoicexEvent(new InvoicexEvent(parent, 101));
            }
        };
        w.execute();
    }
}

