/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.dbu;
import it.tnx.commons.table.RendererUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;

public class JDialogPrezzi
extends JDialog {
    public boolean conIva;
    public boolean senzaIva;
    public JScrollPane jScrollPane1;
    public JTable prezzi;

    public JDialogPrezzi(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.prezzi.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new RendererUtils.CurrencyRenderer((NumberFormat)new DecimalFormat("0.00###")));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.prezzi = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Prezzi di Listino per l'articolo : ");
        this.prezzi.setModel(new DefaultTableModel(new Object[0][], new String[]{"Cod. Listino", "Listino", "Prezzo", "IVA inclusa"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.prezzi.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JDialogPrezzi.this.prezziMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.prezzi);
        this.prezzi.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.prezzi.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.prezzi.getColumnModel().getColumn(2).setPreferredWidth(100);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 462, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 294, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void prezziMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            String ivati = CastUtils.toString((Object)this.prezzi.getValueAt(this.prezzi.getSelectedRow(), this.prezzi.getColumn("IVA inclusa").getModelIndex()));
            if (ivati.equalsIgnoreCase("S") && this.senzaIva && !SwingUtils.showYesNoMessage((Component)this, (String)"Stai selezionando un prezzo con iva inclusa come prezzo senza iva,\nSicuro ?")) {
                return;
            }
            if (ivati.equalsIgnoreCase("N") && this.conIva && !SwingUtils.showYesNoMessage((Component)this, (String)"Stai selezionando un prezzo senza iva come prezzo iva inclusa,\nSicuro ?")) {
                return;
            }
            this.dispose();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDialogPrezzi dialog = new JDialogPrezzi((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void loadArticolo(String articolo, String codiceListino, Integer variante_id) {
        try {
            this.setTitle("Prezzi di listino per art.: " + articolo + (variante_id == null ? "" : " (var. " + variante_id + ")") + " / Listino cliente " + codiceListino);
            String sql = "select * from articoli";
            sql = sql + " where codice = " + Db.pc(articolo, "VARCHAR");
            ResultSet temp = Db.openResultSet(sql);
            temp.next();
            sql = "select ap.prezzo, tl.* ";
            sql = sql + " from articoli_prezzi ap ";
            sql = sql + " left join tipi_listino tl on ap.listino = tl.codice";
            sql = sql + " where articolo = " + Db.pc(articolo, "VARCHAR");
            if (variante_id != null) {
                sql = sql + " and variante_id = " + dbu.sql((Object)variante_id);
            }
            sql = sql + " order by tl.codice";
            ResultSet r_prezzi = Db.openResultSet(sql);
            String prezzo = "";
            double prezzod = 0.0;
            while (r_prezzi.next()) {
                try {
                    prezzo = Db.formatDecimal5(temp.getDouble("prezzo1"));
                    prezzod = temp.getDouble("prezzo1");
                    boolean non_applicare_percentuale = CastUtils.toBoolean((Object)temp.getString("non_applicare_percentuale"));
                    if (r_prezzi.getString("ricarico_flag") != null && r_prezzi.getString("ricarico_flag").equals("S")) {
                        double perc = r_prezzi.getDouble("ricarico_perc");
                        double nuovo_prezzo = 0.0;
                        sql = "select prezzo from articoli_prezzi";
                        sql = sql + " where articolo = " + Db.pc(articolo, "VARCHAR");
                        if (variante_id != null) {
                            sql = sql + " and variante_id = " + dbu.sql((Object)variante_id);
                        }
                        sql = sql + " and listino = " + Db.pc((Object)r_prezzi.getString("ricarico_listino"), 12);
                        ResultSet prezzi2 = Db.openResultSet(sql);
                        prezzi2.next();
                        nuovo_prezzo = non_applicare_percentuale ? prezzi2.getDouble("prezzo") : prezzi2.getDouble("prezzo") * ((perc + 100.0) / 100.0);
                        prezzo = Db.formatDecimal5(nuovo_prezzo);
                        prezzod = nuovo_prezzo;
                    } else {
                        prezzo = Db.formatDecimal5(r_prezzi.getDouble(1));
                        prezzod = r_prezzi.getDouble(1);
                    }
                    ((DefaultTableModel)this.prezzi.getModel()).addRow(new Object[]{r_prezzi.getString("tl.codice"), r_prezzi.getString("tl.descrizione"), prezzod, r_prezzi.getString("prezzi_ivati")});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

