/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex.gui;

import it.tnx.commons.cu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

class LineBreakPanelRenderer
extends JPanel
implements TableCellRenderer {
    private LineBreakMeasurer lineMeasurer;
    private int paragraphStart;
    private int paragraphEnd;
    private static final Hashtable<TextAttribute, Object> map = new Hashtable();
    private AttributedString text = null;
    private String textRaw = null;
    JTable table = null;
    Integer currentRow = null;
    Integer currentCol = null;
    Font f = null;
    boolean isSelected = false;
    private Color unselectedForeground;
    private Color unselectedBackground;
    boolean hasFocus = false;
    JLabel lab = new JLabel("");

    LineBreakPanelRenderer(Font f) {
        this.f = f;
        map.put(TextAttribute.FAMILY, f.getFamily());
        map.put(TextAttribute.SIZE, new Float(f.getSize()));
        this.lab.setOpaque(true);
        this.lab.setBackground(new Color(250, 250, 250));
    }

    public void setText(String text) {
        this.textRaw = text;
        this.text = text != null && text.length() > 0 ? new AttributedString(text, map) : null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Object fg = null;
        Object bg = null;
        if (this.hasFocus && !this.isSelected && this.table.isCellEditable(this.currentRow, this.currentCol)) {
            Color col = UIManager.getColor("Table.focusCellForeground");
            if (col != null) {
                super.setForeground(col);
            }
            if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                super.setBackground(col);
            }
        }
        super.paintComponent(g);
        g.setColor(this.getForeground());
        if (this.text == null) {
            int h = 28;
            if (this.table.getRowHeight(this.currentRow) != h) {
                this.table.setRowHeight(this.currentRow, h);
            }
            return;
        }
        this.setBackground(Color.white);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AttributedCharacterIterator paragraph = this.text.getIterator();
        this.paragraphStart = paragraph.getBeginIndex();
        this.paragraphEnd = paragraph.getEndIndex();
        FontRenderContext frc = g2d.getFontRenderContext();
        this.lineMeasurer = new LineBreakMeasurer(paragraph, frc);
        float breakWidth = this.table.getColumnModel().getColumn(this.currentCol).getWidth();
        float drawPosY = 0.0f;
        this.lineMeasurer.setPosition(this.paragraphStart);
        int lines = 0;
        TextLayout layout = null;
        while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
            int limit;
            block15: {
                int next;
                ++lines;
                limit = next = this.lineMeasurer.nextOffset(breakWidth);
                try {
                    if (limit > this.paragraphEnd) break block15;
                    for (int i = this.lineMeasurer.getPosition(); i < next; ++i) {
                        char c = this.textRaw.charAt(i);
                        if (c != '\n') continue;
                        limit = i;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            layout = this.lineMeasurer.nextLayout(breakWidth - 3.0f, limit + 1, false);
            float drawPosX = layout.isLeftToRight() ? 0.0f : breakWidth - layout.getAdvance();
            drawPosX += 3.0f;
            drawPosY += layout.getAscent();
            if (this.lineMeasurer.getPosition() >= this.paragraphEnd && lines == 1) {
                int h = (int)((float)lines * (layout.getAscent() + layout.getDescent() + layout.getLeading()));
                if (h < 25) {
                    h = 25;
                }
                float hdraw = (float)(h += 3) / 2.0f + (float)this.f.getSize() / 2.0f - 3.0f;
                layout.draw(g2d, drawPosX, hdraw);
            } else {
                layout.draw(g2d, drawPosX, drawPosY);
            }
            drawPosY += layout.getDescent() + layout.getLeading();
        }
        if (this.table != null && this.currentRow != null) {
            int h = (int)((float)lines * (layout.getAscent() + layout.getDescent() + layout.getLeading()));
            if (h < 25) {
                h = 25;
            }
            if (this.table.getRowHeight(this.currentRow) != (h += 3)) {
                this.table.setRowHeight(this.currentRow, h);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.currentRow = row;
        this.currentCol = column;
        this.table = table;
        this.isSelected = isSelected;
        this.hasFocus = hasFocus;
        this.setText((String)value);
        if (table.getValueAt(row, 0) == null) {
            this.lab.setText(cu.s((Object)value));
            this.lab.setFont(this.f.deriveFont(2));
            this.lab.setForeground(Color.GRAY);
            return this.lab;
        }
        return this;
    }
}

