/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe;

import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import gestioneFatture.JDialogManutenzione;
import gestioneFatture.JDialogSelezionaSerie;
import gestioneFatture.Scadenze;
import gestioneFatture.dbFatturaRicevuta;
import gestioneFatture.logic.documenti.Documento2;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.FileUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.ReflectUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.data.DatiAzienda;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.JDialogImportForn;
import it.tnx.invoicex2.fe.impl.FolderSdi;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jdesktop.swingworker.SwingWorker;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Sdi {
    static Map iva_desc_natura = new HashMap();
    static Map iva_desc_breve_natura = new HashMap();
    public static String MODO_IMORT_FORN_USAOLD = "usaold";
    public static String MODO_IMORT_FORN_CREA = "crea";
    public static String MODO_IMORT_FORN_CHIEDI = "chiedi";
    public static String SERIE_IMPORT_SPECIFICA = "specifica";
    public static String SERIE_IMPORT_NO = "no";
    public static String SERIE_IMPORT_CHIEDI = "chiedi";
    public static String GENERA_MOVIMENTI_SI = "si";
    public static String GENERA_MOVIMENTI_NO = "no";
    public static String GENERA_MOVIMENTI_CHIEDI = "chiedi";
    private SwingWorker currentWorker = null;
    public Map param = null;
    private Map cacheIvaPerc = null;
    private Map cacheIvaNatura = null;
    public static String STATO_INVIATA;
    public static String STATO_CONSEGNATA;
    public static String STATO_MANCATA_CONSEGNA;
    public static String STATO_RICEVUTA;
    public static String STATO_SCARTATA;
    public static String STATO_NON_GESTITO;
    public static String STATO_AZZERA;
    public static String STATO_AZZERA_TUTTO;
    public static String STATO_NOTIFICA_ACCETTATA;
    public static String STATO_NOTIFICA_RIFIUTATA;
    public static String STATO_DECORRENZA_TERMINI;
    public static String STATO_ATT_TRASM;
    public static String STATO_CONSEGNATA_PA;
    public static String METODO_INVIO_PEC;
    public static String METODO_INVIO_PORTALE_FATT_CORR;
    public static String METODO_INVIO_ESTERNO_MANUALE;
    public static String METODO_INVIO_ESTERNO_INTEGRATO;

    public SwingWorker getCurrentWorker() {
        return this.currentWorker;
    }

    public void setCurrentWorker(SwingWorker currentWorker) {
        this.currentWorker = currentWorker;
    }

    public static Sdi getNew() {
        try {
            Sdi sdi = new Sdi();
            return sdi;
        }
        catch (Exception ex) {
            SwingUtils.showExceptionMessage((Component)main.getPadreFrame(), (Exception)ex);
            return null;
        }
    }

    public static String getDescrizioneStatoProvider(String stato, String provider) {
        HashMap<String, String> stati = new HashMap<String, String>();
        stati.put("sdi_RC", "Consegnata");
        stati.put("sdi_NS", "Scartata");
        stati.put("sdi_MC", "Emessa ma mancata consegna");
        stati.put("sdi_NE", "Notifica di esito cedente/prestatore");
        stati.put("sdi_EC", "Consegnata e ricevuta");
        stati.put("sdi_SE", "Scartata da cessionario/committente");
        stati.put("sdi_DT", "Decorrenza termini");
        stati.put("sdi_AT", "Emessa ma impossibilit\u00e0 di recapito");
        if (provider.equalsIgnoreCase("ArubaSdi")) {
            String k = "sdi_" + stato;
            if (stati.containsKey(k)) {
                return (String)stati.get(k);
            }
            return stato;
        }
        return stato;
    }

    public static String getXslDoc() {
        String fe_tipo_vis_fattura = "I";
        try {
            fe_tipo_vis_fattura = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select fe_tipo_vis_fattura from export_xml_pa_parametri", (boolean)false));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (fe_tipo_vis_fattura.equalsIgnoreCase("I")) {
            return "/invoicexplugininvoicex/xmlpa/xsl/FoglioStileAssoSoftware.xsl";
        }
        return "/invoicexplugininvoicex/xmlpa/xsl/Foglio_di_stile_fatturaordinaria_v1.2.1.xsl";
    }

    public static String getDescrizioneStato(String stato) {
        if (stato.equals(STATO_INVIATA)) {
            return "Inviata";
        }
        if (stato.equals(STATO_CONSEGNATA)) {
            return "Consegnata";
        }
        if (stato.equals(STATO_MANCATA_CONSEGNA)) {
            return "Emessa ma mancata consegna";
        }
        if (stato.equals(STATO_RICEVUTA)) {
            return "Consegnata e ricevuta";
        }
        if (stato.equals(STATO_SCARTATA)) {
            return "Scartata";
        }
        if (stato.equals(STATO_NOTIFICA_ACCETTATA)) {
            return "Notifica di Accettatazione";
        }
        if (stato.equals(STATO_NOTIFICA_RIFIUTATA)) {
            return "Notifica di Rifiuto";
        }
        if (stato.equals(STATO_DECORRENZA_TERMINI)) {
            return "Decorrenza termini";
        }
        if (stato.equals(STATO_ATT_TRASM)) {
            return "Attestazione trasmissione";
        }
        return "???";
    }

    public Sdi() throws Exception {
        this.caricaParam();
    }

    public void caricaParam() throws Exception {
        this.param = (Map)dbu.getListMap((Connection)Db.getConn(), (String)"select * from export_xml_pa_parametri").get(0);
    }

    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return false;
    }

    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        return false;
    }

    public byte[] riceviDaSdi(String id) throws Exception {
        return null;
    }

    public EsitoRicezione riceviElencoDaSdi(Date dal, Date al) throws Exception {
        return null;
    }

    private void rendiObsoleto(Connection conn, Integer clifor, String piva, String cfiscale) throws Exception {
        String sql = "update clie_forn set obsoleto = '1' where codice = " + dbu.sql((Object)clifor);
        dbu.tryExecQuery((Connection)conn, (String)sql);
        if (!cu.sIsBlank((Object)piva)) {
            sql = "update clie_forn set obsoleto = '1' where piva_cfiscale like " + dbu.sql((Object)("%" + piva)) + " or piva_cfiscale like " + dbu.sql((Object)("%IT" + piva));
            System.out.println("sql = " + sql);
            dbu.tryExecQuery((Connection)conn, (String)sql);
        }
        if (!cu.sIsBlank((Object)cfiscale)) {
            sql = "update clie_forn set obsoleto = '1' where cfiscale like " + dbu.sql((Object)("%" + cfiscale));
            System.out.println("sql = " + sql);
            dbu.tryExecQuery((Connection)conn, (String)sql);
        }
    }

    private String trovaPagamento(Map dati) {
        Date dataFattura = cu.toDate(((Map)dati.get("fattura")).get("data_doc"));
        ArrayList giorniScadenze = new ArrayList();
        List scadenze = (List)dati.get("scadenze");
        System.out.println("scadenze = " + scadenze);
        ArrayList<Integer> mgiorni = new ArrayList<Integer>();
        Boolean isFineMese = null;
        Date testDataScadenza = null;
        for (Map m : scadenze) {
            Date dataScadenza = cu.toDate(m.get("DataScadenzaPagamento"));
            if (dataScadenza == null) continue;
            testDataScadenza = dataScadenza;
            long giorniDiff = DateUtils.daysDifference((Date)dataFattura, (Date)dataScadenza);
            System.out.println("giorniDiff = " + giorniDiff);
            if (isFineMese == null || !isFineMese.booleanValue()) {
                isFineMese = DateUtils.isFineMese((Date)dataScadenza);
            }
            System.out.println("isFineMese = " + isFineMese);
            for (int i = 1; i <= 12; ++i) {
                boolean isXgg = Sdi.checkXGiorni(dataFattura, dataScadenza, 30 * i, false);
                boolean isXggFM = Sdi.checkXGiorni(dataFattura, dataScadenza, 30 * i, true);
                if (!isXgg && !isXggFM) continue;
                mgiorni.add(i * 30);
            }
        }
        if (testDataScadenza != null) {
            ArrayList<String> sqlGiorni = new ArrayList<String>();
            for (int i = 1; i <= 12; ++i) {
                boolean b = false;
                if (mgiorni.indexOf(i * 30) >= 0) {
                    b = true;
                }
                sqlGiorni.add("IFNULL(`" + i * 30 + "`, 'N') " + (b ? "= 'S'" : " != 'S'"));
            }
            String sql = "select * from pagamenti where " + StringUtils.join(sqlGiorni, (String)" and ") + " and IFNULL(FINEMESE,'N') " + (isFineMese != false ? " = 'S'" : " != 'S'") + " and codice_xmlpa = " + dbu.sql(((Map)dati.get("fattura_extra")).get("modalita_pagamento"));
            try {
                System.out.println("sql = " + sql);
                ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                System.out.println("list = " + list);
                if (list.size() > 0) {
                    for (Map m : list) {
                        Scadenze scad = new Scadenze(Db.getConn(), Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, null, cu.s(m.get("codice")), dataFattura, false, cu.d0e(((Map)dati.get("fattura")).get("importo")), this);
                        Map mscad = scad.generaScadenzeGetScadenze(Db.getConn());
                        System.out.println("mscad = " + mscad);
                        String scadenzeGenerate = "";
                        for (Object k : mscad.keySet()) {
                            Map ms = (Map)mscad.get(k);
                            scadenzeGenerate = scadenzeGenerate + DateUtils.formatDateIta((Date)cu.toDate(ms.get("data"))) + ":" + FormatUtils.formatEuroIta((double)cu.d0e(ms.get("importo"))) + "|";
                        }
                        String scadenzeFile = "";
                        for (Map ms : scadenze) {
                            Date dataScadenza = cu.toDate(ms.get("DataScadenzaPagamento"));
                            scadenzeFile = scadenzeFile + DateUtils.formatDateIta((Date)dataScadenza) + ":" + FormatUtils.formatEuroIta((double)cu.d0e(ms.get("ImportoPagamento"))) + "|";
                        }
                        System.out.println(scadenzeGenerate);
                        System.out.println(scadenzeFile);
                        if (!scadenzeGenerate.equals(scadenzeFile)) continue;
                        return cu.s(m.get("codice"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Db.PAGAMENTO_LIBERO;
    }

    public static boolean checkXGiorni(Date dataFattura, Date dataScadenza, int giorni, boolean fineMese) {
        int mesi = giorni / 30;
        Date dataScadenzaCalcolata = Scadenze.calcolaData(dataFattura, mesi, fineMese, null).getTime();
        return DateUtils.isSameDate((Date)dataScadenza, (Date)dataScadenzaCalcolata);
    }

    private Map getAvviso(Map dati, String msg) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("dati", dati);
        m.put("messaggio", msg);
        return m;
    }

    private void addAvviso(Map ret, Map avviso) {
        if (ret.get("avvisi") == null) {
            ret.put("avvisi", new ArrayList());
        }
        ((List)ret.get("avvisi")).add(avviso);
    }

    private void trovaRitenuta(Map fattura, Map fatturaN) throws Exception {
        System.out.println("fattura = " + fattura);
        String tipo_ritenuta = cu.s(((Map)fatturaN.get("fattura_extra")).get("tipo_ritenuta"));
        double aliquota_ritenuta = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("aliquota_ritenuta"));
        double importo_ritenuta = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("importo_ritenuta"));
        String causale_pagamento_ritenuta = cu.s(((Map)fatturaN.get("fattura_extra")).get("causale_pagamento_ritenuta"));
        if (StringUtils.isBlank((String)tipo_ritenuta)) {
            return;
        }
        String sql = "select * from tipi_ritenuta where percentuale = " + dbu.sql((Object)aliquota_ritenuta) + " and dg_dr_tipo_ritenuta = " + dbu.sql((Object)tipo_ritenuta) + " and dg_dr_causale_pagamento = " + dbu.sql((Object)causale_pagamento_ritenuta);
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        Integer id_ritenuta = null;
        if (list != null && list.size() > 0) {
            id_ritenuta = cu.i(((Map)list.get(0)).get("id"));
        } else {
            sql = "insert into tipi_ritenuta set descrizione = " + dbu.sql((Object)(Sdi.getDescTipoRitenuta(tipo_ritenuta) + " - causale " + causale_pagamento_ritenuta)) + ", percentuale = " + dbu.sql((Object)aliquota_ritenuta) + ", dg_dr_tipo_ritenuta = " + dbu.sql((Object)tipo_ritenuta) + ", dg_dr_causale_pagamento = " + dbu.sql((Object)causale_pagamento_ritenuta);
            Connection conn = Db.getConn();
            dbu.tryExecQuery((Connection)conn, (String)sql);
            id_ritenuta = dbu.getLastInsertId((Connection)conn);
        }
        fattura.put("percentuale_ritenuta", aliquota_ritenuta);
        fattura.put("ritenuta", id_ritenuta);
    }

    public static String getDescTipoRitenuta(String key) {
        HashMap<String, String> tipi = new HashMap<String, String>();
        tipi.put("RT01", "Ritenuta persone fisiche");
        tipi.put("RT02", "Ritenuta persone giuridiche");
        return (String)tipi.get(key);
    }

    public static String getDescTipoCassa(String key) {
        HashMap<String, String> tipi = new HashMap<String, String>();
        tipi.put("TC01", "Cassa nazionale previdenza e assistenza avvocati e procuratori legali");
        tipi.put("TC02", "Cassa previdenza dottori commercialisti");
        tipi.put("TC03", "Cassa previdenza e assistenza geometri");
        tipi.put("TC04", "Cassa nazionale previdenza e assistenza ingegneri e architetti liberi professionisti");
        tipi.put("TC05", "Cassa nazionale del notariato");
        tipi.put("TC06", "Cassa nazionale previdenza e assistenza ragionieri e periti commerciali");
        tipi.put("TC07", "Ente nazionale assistenza agenti e rappresentanti di commercio (ENASARCO)");
        tipi.put("TC08", "Ente nazionale previdenza e assistenza consulenti del lavoro (ENPACL)");
        tipi.put("TC09", "Ente nazionale previdenza e assistenza medici (ENPAM)");
        tipi.put("TC10", "Ente nazionale previdenza e assistenza farmacisti (ENPAF)");
        tipi.put("TC11", "Ente nazionale previdenza e assistenza veterinari (ENPAV)");
        tipi.put("TC12", "Ente nazionale previdenza e assistenza impiegati dell'agricoltura (ENPAIA)");
        tipi.put("TC13", "Fondo previdenza impiegati imprese di spedizione e agenzie marittime");
        tipi.put("TC14", "Istituto nazionale previdenza giornalisti italiani (INPGI)");
        tipi.put("TC15", "Opera nazionale assistenza orfani sanitari italiani (ONAOSI)");
        tipi.put("TC16", "Cassa autonoma assistenza integrativa giornalisti italiani (CASAGIT)");
        tipi.put("TC17", "Ente previdenza periti industriali e periti industriali laureati (EPPI)");
        tipi.put("TC18", "Ente previdenza e assistenza pluricategoriale (EPAP)");
        tipi.put("TC19", "Ente nazionale previdenza e assistenza biologi (ENPAB)");
        tipi.put("TC20", "Ente nazionale previdenza e assistenza professione infermieristica (ENPAPI)");
        tipi.put("TC21", "Ente nazionale previdenza e assistenza psicologi (ENPAP)");
        tipi.put("TC22", "INPS");
        return (String)tipi.get(key);
    }

    public static String getDescTipoIva(String key) {
        HashMap<String, String> tipi = new HashMap<String, String>();
        tipi.put("N1", "escluse ex art. 15");
        tipi.put("N2", "non soggette");
        tipi.put("N3", "non imponibili");
        tipi.put("N4", "esenti");
        tipi.put("N5", "regime del margine");
        tipi.put("N6", "inversione contabile (reverse charge)");
        tipi.put("N7", "IVA assolta in altro stato UE");
        return (String)tipi.get(key);
    }

    private void trovaRivalsa(Map fattura, Map fatturaN) throws Exception {
        System.out.println("fattura = " + fattura);
        double aliquota_cassa = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("aliquota_cassa"));
        String tipo_cassa = cu.s(((Map)fatturaN.get("fattura_extra")).get("tipo_cassa"));
        double importo_cassa = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("importo_contributo_cassa"));
        double imponibile_cassa = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("imponibile_cassa"));
        double aliquota_iva_cassa = cu.d0e(((Map)fatturaN.get("fattura_extra")).get("aliquota_iva_cassa"));
        String natura_cassa = cu.s(((Map)fatturaN.get("fattura_extra")).get("natura_cassa"));
        String ritenuta_cassa = cu.s(((Map)fatturaN.get("fattura_extra")).get("ritenuta_cassa"));
        if (StringUtils.isBlank((String)tipo_cassa)) {
            return;
        }
        String sql = "select * from tipi_rivalsa where percentuale = " + dbu.sql((Object)aliquota_cassa) + " and dg_dcp_tipo_cassa = " + dbu.sql((Object)tipo_cassa);
        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        Integer id_rivalsa = null;
        if (list != null && list.size() > 0) {
            id_rivalsa = cu.i(((Map)list.get(0)).get("id"));
        } else {
            sql = "insert into tipi_rivalsa set descrizione = " + dbu.sql((Object)Sdi.getDescTipoCassa(tipo_cassa)) + ", percentuale = " + dbu.sql((Object)aliquota_cassa) + ", dg_dcp_tipo_cassa = " + dbu.sql((Object)tipo_cassa);
            Connection conn = Db.getConn();
            dbu.tryExecQuery((Connection)conn, (String)sql);
            id_rivalsa = dbu.getLastInsertId((Connection)conn);
        }
        fattura.put("rivalsaInpsPerc", aliquota_cassa);
        fattura.put("rivalsaInpsTesto", Sdi.getDescTipoCassa(tipo_cassa));
        fattura.put("rivalsa", id_rivalsa);
        fattura.put("totaleRivalsa", importo_cassa);
        fattura.put("imponibile_rivalsa", imponibile_cassa);
        sql = "select * from codici_iva where percentuale = " + dbu.sql((Object)aliquota_iva_cassa) + " and codice_natura_xmlpa = " + dbu.sql((Object)natura_cassa);
        list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
        String id_iva = null;
        if (list != null && list.size() > 0) {
            id_iva = cu.s(((Map)list.get(0)).get("codice"));
        } else {
            sql = "insert into codici_iva set codice = " + dbu.sql((Object)natura_cassa) + ", percentuale = " + dbu.sql((Object)aliquota_iva_cassa) + ", descrizione = " + dbu.sql((Object)Sdi.getDescTipoIva(natura_cassa)) + ", descrizione_breve = " + dbu.sql((Object)Sdi.getDescTipoIva(natura_cassa)) + ", codice_natura_xmlpa = " + dbu.sql((Object)natura_cassa);
            try {
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
                id_iva = natura_cassa;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        fattura.put("codiceIvaSpeseRivalsa", id_iva);
        fattura.put("includi_rivalsa_in_imp_ritenuta", ritenuta_cassa.equalsIgnoreCase("SI") ? "S" : "N");
        fattura.put("includi_rivalsa_in_iva", "S");
        fattura.put("sottrai_rivalsa", "N");
    }

    public EsitoImportDaSdi riceviDaSdiImporta(List<FatturaSdi> fatture, Component parent, boolean batch, boolean generaMovimenti, boolean generaContab, String serie, String dataRegistrazione, SwingWorker worker) throws Exception {
        EsitoImportDaSdi esito = new EsitoImportDaSdi();
        esito.fatture_ricevute = fatture.size();
        if (fatture != null && fatture.size() == 0) {
            esito.esito = true;
            esito.fatture_importate = 0;
            return esito;
        }
        int i = 0;
        int tot = fatture.size();
        for (FatturaSdi f : fatture) {
            worker.publish(new Object[]{"Importazione in corso " + ++i + " di " + tot});
            try {
                String xml = null;
                byte[] xml_bb = null;
                if (f.xml != null) {
                    xml = f.xml;
                } else {
                    String key = f.id;
                    System.out.println("key = " + key);
                    if (!(this instanceof FolderSdi) && cu.s(this.param.get("provider")).equals("FatturaPA")) {
                        key = cu.s(f.dati.get("URI"));
                    }
                    xml_bb = this.riceviDaSdi(key);
                }
                try {
                    if (main.debug) {
                        FileOutputStream fw = new FileOutputStream("c:\\temp\\ricevuto-" + f.id);
                        IOUtils.write((byte[])xml_bb, (OutputStream)fw);
                        fw.close();
                    }
                    byte[] buffer = null;
                    buffer = xml_bb != null ? xml_bb : xml.getBytes();
                    CMSSignedData signature = null;
                    try {
                        signature = new CMSSignedData(buffer);
                    }
                    catch (CMSException e) {
                        buffer = Base64.decodeBase64((byte[])buffer);
                        signature = new CMSSignedData(buffer);
                    }
                    Store cs = signature.getCertificates();
                    SignerInformationStore signers = signature.getSignerInfos();
                    Collection c = signers.getSigners();
                    Iterator it = c.iterator();
                    byte[] data = null;
                    int conta = 0;
                    while (it.hasNext()) {
                        SignerInformation signer = (SignerInformation)it.next();
                        Collection certCollection = cs.getMatches((Selector)signer.getSID());
                        Iterator certIt = certCollection.iterator();
                        X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                        CMSTypedData sc = signature.getSignedContent();
                        data = (byte[])sc.getContent();
                        xml = new String(data);
                        ++conta;
                    }
                }
                catch (Exception buffer) {
                    // empty catch block
                }
                if (xml_bb != null && xml == null) {
                    xml = new String(xml_bb);
                }
                Map dati = this.getFromXml(xml);
                boolean importa = true;
                List<String> avv = Sdi.importFattureSdiCheckAvvisi(dati, batch);
                if (avv != null && avv.size() > 0) {
                    if (!batch) {
                        if (!SwingUtils.showYesNoMessage((Component)parent, (String)(StringUtils.join(avv, (String)"\n") + "\nSicuro di continuare ?"))) {
                            importa = false;
                        }
                    } else {
                        esito.avvisi.add(this.getAvviso(f.dati, StringUtils.join(avv, (String)"\n")));
                    }
                }
                if (!importa) continue;
                Map esitoCrea = this.creaFatturaAcquistoDaMap(dati, null, xml, f.id, batch, generaMovimenti, generaContab, serie, dataRegistrazione, f);
                esito.esiti.add(esitoCrea);
                System.out.println("esito = " + esitoCrea);
                ++esito.fatture_importate;
                if (batch) continue;
                SwingUtils.showInfoMessage((Component)parent, (String)("Creato il documento " + esitoCrea.get("serie_fattura") + esitoCrea.get("numero_fattura")));
            }
            catch (Exception e) {
                if (batch) {
                    e.printStackTrace();
                    esito.avvisi.add(this.getAvviso(f.dati, e.toString()));
                    continue;
                }
                throw e;
            }
        }
        return esito;
    }

    public static List<String> importFattureSdiCheckAvvisi(Map dati, boolean batch) {
        ArrayList<String> ret = new ArrayList<String>();
        DatiAzienda az = main.attivazione.getDatiAzienda();
        Map dest = (Map)dati.get("dest");
        if (!(cu.sIsBlank(dest.get("piva_cfiscale")) || StringUtils.trim((String)cu.s(dest.get("piva_cfiscale"))).equalsIgnoreCase(StringUtils.trim((String)az.getPartita_iva())) || StringUtils.trim((String)("IT" + cu.s(dest.get("piva_cfiscale")))).equalsIgnoreCase(StringUtils.trim((String)az.getPartita_iva())))) {
            ret.add("La Partita IVA nella fattura (" + cu.s(dest.get("piva_cfiscale")) + ") non corrisponde alla tua Partita IVA (" + az.getPartita_iva() + ")");
        }
        if (!cu.sIsBlank(dest.get("cfiscale")) && !StringUtils.trim((String)cu.s(dest.get("cfiscale"))).equalsIgnoreCase(StringUtils.trim((String)az.getCodice_fiscale()))) {
            ret.add("Il Codice Fiscale nella fattura (" + cu.s(dest.get("cfiscale")) + ") non corrisponde al tuo Codice Fiscale (" + az.getCodice_fiscale() + ")");
        }
        if (ret.size() > 0) {
            ret.add("Ragione sociale nella fattura: " + cu.s(dest.get("ragione_sociale")));
        }
        return ret;
    }

    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        return false;
    }

    public Map getFromXml(File fXmlFile) throws ParserConfigurationException, SAXException, IOException, Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = null;
        try {
            doc = dBuilder.parse(fXmlFile);
        }
        catch (MalformedByteSequenceException e) {
            FileInputStream fin = new FileInputStream(fXmlFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fin, "UTF-8");
            InputSource is = new InputSource(isr);
            is.setEncoding("UTF-8");
            doc = dBuilder.parse(is);
        }
        return this.getFromXmlParse(doc);
    }

    public Map getFromXml(String content) throws ParserConfigurationException, SAXException, IOException, Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(new ByteArrayInputStream(content.getBytes()));
        return this.getFromXmlParse(doc);
    }

    public Map getFromXmlParse(Document doc) throws ParserConfigurationException, SAXException, IOException, Exception {
        doc.getDocumentElement().normalize();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        String root = doc.getDocumentElement().getNodeName();
        if (root.indexOf(":") >= 0) {
            root = StringUtils.substringAfterLast((String)root, (String)":");
        }
        if (!root.equalsIgnoreCase("FatturaElettronica")) {
            throw new Exception("Il file non contiene una fattura elettronica (root=" + root + ")");
        }
        System.out.println("----------------------------");
        HashMap<String, Cloneable> ret = new HashMap<String, Cloneable>();
        HashMap clifor = new HashMap();
        Element cedente = (Element)((NodeList)xpath.evaluate("//FatturaElettronicaHeader/CedentePrestatore", doc, XPathConstants.NODESET)).item(0);
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/IdFiscaleIVA/IdPaese", "paese");
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/IdFiscaleIVA/IdCodice", "piva_cfiscale");
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/CodiceFiscale", "cfiscale");
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/Anagrafica/Denominazione", "ragione_sociale");
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/Anagrafica/Cognome", "cognome");
        Sdi.get(xpath, clifor, cedente, "DatiAnagrafici/Anagrafica/Nome", "nome");
        Sdi.get(xpath, clifor, cedente, "Sede/Indirizzo", "indirizzo");
        Sdi.get(xpath, clifor, cedente, "Sede/CAP", "cap");
        Sdi.get(xpath, clifor, cedente, "Sede/Comune", "localita");
        Sdi.get(xpath, clifor, cedente, "Sede/Provincia", "provincia");
        Sdi.get(xpath, clifor, cedente, "Sede/Nazione", "paese");
        ret.put("clifor", clifor);
        HashMap dest = new HashMap();
        Element cessionario = (Element)((NodeList)xpath.evaluate("//FatturaElettronicaHeader/CessionarioCommittente", doc, XPathConstants.NODESET)).item(0);
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/IdFiscaleIVA/IdPaese", "paese");
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/IdFiscaleIVA/IdCodice", "piva_cfiscale");
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/CodiceFiscale", "cfiscale");
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/Anagrafica/Denominazione", "ragione_sociale");
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/Anagrafica/Cognome", "cognome");
        Sdi.get(xpath, dest, cessionario, "DatiAnagrafici/Anagrafica/Nome", "nome");
        Sdi.get(xpath, dest, cessionario, "Sede/Indirizzo", "indirizzo");
        Sdi.get(xpath, dest, cessionario, "Sede/CAP", "cap");
        Sdi.get(xpath, dest, cessionario, "Sede/Comune", "localita");
        Sdi.get(xpath, dest, cessionario, "Sede/Provincia", "provincia");
        Sdi.get(xpath, dest, cessionario, "Sede/Nazione", "paese");
        ret.put("dest", dest);
        ArrayList list_fatture = new ArrayList();
        NodeList list = (NodeList)xpath.evaluate("//FatturaElettronicaBody", doc, XPathConstants.NODESET);
        for (int i = 0; i < list.getLength(); ++i) {
            Element body = (Element)list.item(i);
            HashMap<String, Cloneable> dati_fattura = new HashMap<String, Cloneable>();
            HashMap fattura = new HashMap();
            HashMap<String, Double> fattura_extra = new HashMap<String, Double>();
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/TipoDocumento", "tipo_documento");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/Divisa", "divisa");
            Sdi.get(xpath, fattura, body, "DatiGenerali/DatiGeneraliDocumento/Data", "data");
            Sdi.get(xpath, fattura, body, "DatiGenerali/DatiGeneraliDocumento/Numero", "numero");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/TipoRitenuta", "tipo_ritenuta");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/AliquotaRitenuta", "aliquota_ritenuta");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/ImportoRitenuta", "importo_ritenuta");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiRitenuta/CausalePagamento", "causale_pagamento_ritenuta");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/TipoCassa", "tipo_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/AlCassa", "aliquota_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/AliquotaIVA", "aliquota_iva_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/ImportoContributoCassa", "importo_contributo_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/ImponibileCassa", "imponibile_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/Ritenuta", "ritenuta_cassa");
            Sdi.get(xpath, fattura_extra, body, "DatiGenerali/DatiGeneraliDocumento/DatiCassaPrevidenziale/Natura", "natura_cassa");
            ArrayList<Double> sconti_testata = new ArrayList<Double>();
            try {
                NodeList listSconti = (NodeList)xpath.evaluate("DatiGenerali/DatiGeneraliDocumento/ScontoMaggiorazione", body, XPathConstants.NODESET);
                for (int isconti = 0; isconti < listSconti.getLength(); ++isconti) {
                    Element sconto = (Element)listSconti.item(isconti);
                    String tipo = cu.s((Object)xpath.evaluate("Tipo", sconto, XPathConstants.STRING));
                    double perc = cu.d0e((Object)xpath.evaluate("Percentuale", sconto, XPathConstants.STRING));
                    if (perc == 0.0) continue;
                    sconti_testata.add(tipo.equalsIgnoreCase("SC") ? perc : -perc);
                }
            }
            catch (Exception listSconti) {
                // empty catch block
            }
            Sdi.get(xpath, fattura, body, "DatiGenerali/DatiGeneraliDocumento/ImportoTotaleDocumento", "importo");
            ArrayList righe = new ArrayList();
            NodeList list_linee = (NodeList)xpath.evaluate("DatiBeniServizi/DettaglioLinee", body, XPathConstants.NODESET);
            for (int i2 = 0; i2 < list_linee.getLength(); ++i2) {
                Element linea = (Element)list_linee.item(i2);
                HashMap<String, Object> riga = new HashMap<String, Object>();
                Sdi.get(xpath, riga, linea, "NumeroLinea", "riga");
                String desc_codici_articoli = "";
                String codice_articolo_interno = null;
                NodeList list_articoli = (NodeList)xpath.evaluate("CodiceArticolo", linea, XPathConstants.NODESET);
                for (int i3 = 0; i3 < list_articoli.getLength(); ++i3) {
                    Element articolo = (Element)list_articoli.item(i3);
                    String articolo_tipo = articolo.getElementsByTagName("CodiceTipo").item(0).getTextContent();
                    String articolo_valore = articolo.getElementsByTagName("CodiceValore").item(0).getTextContent();
                    articolo_valore = StringUtils.trim((String)articolo_valore);
                    desc_codici_articoli = desc_codici_articoli + articolo_tipo + ": " + articolo_valore + "\n";
                }
                String codart = null;
                String codartforn = null;
                for (int i3 = 0; i3 < list_articoli.getLength(); ++i3) {
                    String sql;
                    Element articolo = (Element)list_articoli.item(i3);
                    String articolo_tipo = articolo.getElementsByTagName("CodiceTipo").item(0).getTextContent();
                    String articolo_valore = articolo.getElementsByTagName("CodiceValore").item(0).getTextContent();
                    articolo_valore = StringUtils.trim((String)articolo_valore);
                    if (StringUtils.isBlank(codice_articolo_interno)) {
                        codice_articolo_interno = articolo_valore;
                    }
                    if (StringUtils.isNotBlank((String)articolo_valore)) {
                        sql = "select codice from articoli where codice like " + dbu.sql((Object)articolo_valore);
                        codart = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
                    }
                    if (StringUtils.isBlank((String)codartforn)) {
                        sql = "select codice from articoli  where codice_fornitore like " + dbu.sql((Object)articolo_valore) + "  or codice_fornitore2 like " + dbu.sql((Object)articolo_valore) + " or codice_fornitore3 like " + dbu.sql((Object)articolo_valore) + " or codice_fornitore4 like " + dbu.sql((Object)articolo_valore) + " or codice_fornitore5 like " + dbu.sql((Object)articolo_valore) + " or codice_fornitore6 like " + dbu.sql((Object)articolo_valore);
                        codartforn = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)sql, (boolean)false));
                    }
                    if (StringUtils.isNotBlank((String)codart) && StringUtils.isNotBlank((String)codartforn)) break;
                }
                if (StringUtils.isNotBlank(codartforn)) {
                    codice_articolo_interno = codartforn;
                }
                if (StringUtils.isNotBlank(codart)) {
                    codice_articolo_interno = codart;
                }
                riga.put("codice_articolo", codice_articolo_interno);
                Sdi.get(xpath, riga, linea, "Descrizione", "descrizione");
                if (list_articoli.getLength() > 1 && StringUtils.isNotBlank((String)desc_codici_articoli) && StringUtils.isBlank(codice_articolo_interno)) {
                    riga.put("descrizione", cu.s(riga.get("descrizione")) + "\n\nCodici articolo:\n" + StringUtils.chomp((String)desc_codici_articoli));
                }
                Sdi.get(xpath, riga, linea, "Quantita", "quantita");
                Sdi.get(xpath, riga, linea, "UnitaMisura", "um");
                Sdi.get(xpath, riga, linea, "PrezzoUnitario", "prezzo");
                Sdi.get(xpath, riga, linea, "PrezzoTotale", "totale_imponibile");
                ArrayList<Double> sconti_riga = new ArrayList<Double>();
                try {
                    NodeList listSconti = (NodeList)xpath.evaluate("ScontoMaggiorazione", linea, XPathConstants.NODESET);
                    boolean tipi_uguali = true;
                    String old_tipo = null;
                    for (int isconti = 0; isconti < listSconti.getLength(); ++isconti) {
                        Element sconto = (Element)listSconti.item(isconti);
                        String tipo = cu.s((Object)xpath.evaluate("Tipo", sconto, XPathConstants.STRING));
                        double perc = cu.d0e((Object)xpath.evaluate("Percentuale", sconto, XPathConstants.STRING));
                        if (perc != 0.0) {
                            sconti_riga.add(tipo.equalsIgnoreCase("SC") ? perc : -perc);
                        }
                        if (old_tipo != null && !cu.s(old_tipo).equalsIgnoreCase(tipo)) {
                            tipi_uguali = false;
                        }
                        old_tipo = tipo;
                    }
                    if (sconti_riga.size() > 2 && tipi_uguali) {
                        double prezzo_totale = cu.d0e(riga.get("totale_imponibile"));
                        double prezzo_unitario = cu.d0e(riga.get("prezzo"));
                        double quantita = cu.d0e(riga.get("quantita"));
                        double sconto = 100.0 - 100.0 * prezzo_totale / (quantita * prezzo_unitario);
                        sconti_riga.clear();
                        sconti_riga.add(old_tipo.equalsIgnoreCase("SC") ? sconto : -sconto);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                riga.put("sconti_riga", sconti_riga);
                Sdi.get(xpath, riga, linea, "AliquotaIVA", "AliquotaIVA");
                Sdi.get(xpath, riga, linea, "Natura", "Natura");
                Sdi.get(xpath, riga, linea, "Ritenuta", "flag_ritenuta");
                righe.add(riga);
            }
            Sdi.get(xpath, fattura_extra, body, "DatiPagamento/CondizioniPagamento", "condizioni_pagamento");
            Sdi.get(xpath, fattura_extra, body, "DatiPagamento/DettaglioPagamento/ModalitaPagamento", "modalita_pagamento");
            Sdi.get(xpath, fattura_extra, body, "DatiPagamento/DettaglioPagamento/ModalitaPagamento", "modalita_pagamento");
            double totale_scadenze = 0.0;
            ArrayList scadenze = new ArrayList();
            NodeList list_scadenze = (NodeList)xpath.evaluate("DatiPagamento/DettaglioPagamento", body, XPathConstants.NODESET);
            for (int i3 = 0; i3 < list_scadenze.getLength(); ++i3) {
                Element scadenza_el = (Element)list_scadenze.item(i3);
                HashMap scadenza = new HashMap();
                Sdi.get(xpath, scadenza, scadenza_el, "ModalitaPagamento", "ModalitaPagamento");
                Sdi.get(xpath, scadenza, scadenza_el, "DataScadenzaPagamento", "DataScadenzaPagamento");
                Sdi.get(xpath, scadenza, scadenza_el, "ImportoPagamento", "ImportoPagamento");
                Sdi.get(xpath, scadenza, scadenza_el, "IstitutoFinanziario", "IstitutoFinanziario");
                Sdi.get(xpath, scadenza, scadenza_el, "IBAN", "IBAN");
                totale_scadenze += cu.d0e(scadenza.get("ImportoPagamento")).doubleValue();
                scadenze.add(scadenza);
            }
            fattura_extra.put("totale_scadenze", totale_scadenze);
            dati_fattura.put("fattura", fattura);
            dati_fattura.put("sconti_testata", sconti_testata);
            dati_fattura.put("righe", righe);
            dati_fattura.put("fattura_extra", fattura_extra);
            dati_fattura.put("scadenze", scadenze);
            list_fatture.add(dati_fattura);
        }
        ret.put("fatture", list_fatture);
        return ret;
    }

    public Map creaFatturaAcquistoDaMap(Map dati, File fileXml, String xml, String id, boolean batch, Boolean generaMovimenti, Boolean generaContab, String serie, String dataRegistrazione, FatturaSdi datiSdi) throws Exception {
        this.checkCacheIva();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Connection conn = Db.getConn();
        Map clifor = (Map)dati.get("clifor");
        for (Object fatturaO : (List)dati.get("fatture")) {
            Map fatturaN = (Map)fatturaO;
            Map fattura = (Map)fatturaN.get("fattura");
            String whereclifor = "";
            if (!cu.sIsBlank(clifor.get("piva_cfiscale")) && !cu.sIsBlank(clifor.get("cfiscale"))) {
                whereclifor = " and (cf.piva_cfiscale like " + dbu.sql((Object)("%" + clifor.get("piva_cfiscale") + "%")) + "    or cf.cfiscale like " + dbu.sql(clifor.get("cfiscale")) + ")";
            } else if (!cu.sIsBlank(clifor.get("piva_cfiscale"))) {
                whereclifor = " and (cf.piva_cfiscale like " + dbu.sql((Object)("%" + clifor.get("piva_cfiscale") + "%")) + ")";
            } else if (!cu.sIsBlank(clifor.get("cfiscale"))) {
                whereclifor = " and (cf.cfiscale like " + dbu.sql(clifor.get("cfiscale")) + ")";
            }
            if (whereclifor.length() == 0) continue;
            String sql = "select tf.id, tf.numero, tf.serie, tf.anno, tf.data, cf.codice, cf.piva_cfiscale, cf.cfiscale, cf.ragione_sociale from test_fatt_acquisto tf  join clie_forn cf on tf.fornitore = cf.codice  where ltrim(rtrim(numero_doc)) like " + dbu.sql((Object)StringUtils.trim((String)cu.s(fattura.get("numero")))) + " and data_doc = " + dbu.sql((Object)cu.toDate(fattura.get("data"))) + "" + whereclifor;
            ArrayList test = dbu.getListMap((Connection)conn, (String)sql);
            if (batch || test.size() <= 0) continue;
            Map t = (Map)test.get(0);
            throw new Exception("La fattura " + fattura.get("numero") + " del " + DateUtils.formatDateIta((Date)cu.toDate(fattura.get("data"))) + "\ndel fornitore " + t.get("ragione_sociale") + " \u00e8 gi\u00e0 presente in archivio\nRegistrata con il tuo numero " + t.get("serie") + t.get("numero") + " in data " + DateUtils.formatDateIta((Date)cu.toDate(t.get("data"))));
        }
        boolean clifornew = false;
        Map cliforpre = null;
        String sql = null;
        if (StringUtils.isNotBlank((String)cu.s(clifor.get("piva_cfiscale"))) || StringUtils.isNotBlank((String)cu.s(clifor.get("cfiscale")))) {
            if (!cu.sIsBlank(clifor.get("piva_cfiscale"))) {
                sql = "select * from clie_forn where (piva_cfiscale like " + dbu.sql((Object)("%" + clifor.get("piva_cfiscale"))) + " or piva_cfiscale like " + dbu.sql((Object)("%IT" + clifor.get("piva_cfiscale"))) + ") and ifnull(obsoleto,'0') != '1'";
                System.out.println("sql = " + sql);
                cliforpre = Sdi.getMap(conn, sql);
            }
            if (cliforpre == null && !cu.sIsBlank(clifor.get("cfiscale"))) {
                cliforpre = Sdi.getMap(conn, "select * from clie_forn where cfiscale like " + dbu.sql((Object)("%" + clifor.get("cfiscale"))) + " and ifnull(obsoleto,'0') != '1'");
            }
            Integer codiceClifor = null;
            if (cliforpre != null) {
                System.out.println("trovato clifor precedente tramite cod fiscale o piva, codice " + cliforpre.get("codice"));
                String fe_modo_import_fornitori = cu.s(this.param.get("fe_modo_import_fornitori"));
                if (StringUtils.isBlank((String)fe_modo_import_fornitori)) {
                    fe_modo_import_fornitori = MODO_IMORT_FORN_USAOLD;
                }
                String datipre = "";
                String datinew = "";
                double simNome = 0.0;
                double simIndirizzo = 0.0;
                double simLoc = 0.0;
                HashMap<String, String> mdatipre = new HashMap<String, String>();
                HashMap<String, String> mdatinew = new HashMap<String, String>();
                mdatipre.put("indirizzo", cu.s(cliforpre.get("indirizzo")));
                mdatipre.put("localita", cu.s(cliforpre.get("localita")));
                mdatinew.put("indirizzo", cu.s(clifor.get("indirizzo")));
                mdatinew.put("localita", cu.s(clifor.get("localita")));
                if (cu.sIsBlank(clifor.get("ragione_sociale"))) {
                    datipre = cu.s(cliforpre.get("cognome")) + "|" + cu.s(cliforpre.get("nome")) + "|" + cu.s(cliforpre.get("indirizzo")) + "|" + cu.s(cliforpre.get("localita"));
                    mdatipre.put("denominazione", cu.s(cliforpre.get("cognome")) + " " + cu.s(cliforpre.get("nome")));
                    datinew = cu.s(clifor.get("cognome")) + "|" + cu.s(clifor.get("nome")) + "|" + cu.s(clifor.get("indirizzo")) + "|" + cu.s(clifor.get("localita"));
                    mdatinew.put("denominazione", cu.s(clifor.get("cognome")) + " " + cu.s(cliforpre.get("nome")));
                    double simNome1 = org.apache.commons.lang3.StringUtils.getJaroWinklerDistance((CharSequence)(cu.s(cliforpre.get("cognome")) + " " + cu.s(cliforpre.get("nome"))), (CharSequence)(cu.s(clifor.get("cognome")) + " " + cu.s(clifor.get("nome"))));
                    double simNome2 = org.apache.commons.lang3.StringUtils.getJaroWinklerDistance((CharSequence)(cu.s(cliforpre.get("nome")) + " " + cu.s(cliforpre.get("cognome"))), (CharSequence)(cu.s(clifor.get("cognome")) + " " + cu.s(clifor.get("nome"))));
                    simNome = Math.max(simNome1, simNome2);
                    if (simNome2 > simNome1) {
                        datipre = cu.s(cliforpre.get("nome")) + "|" + cu.s(cliforpre.get("cognome")) + "|" + cu.s(cliforpre.get("indirizzo")) + "|" + cu.s(cliforpre.get("localita"));
                        mdatipre.put("denominazione", cu.s(cliforpre.get("nome")) + " " + cu.s(cliforpre.get("cognome")));
                    }
                } else {
                    datipre = cu.s(cliforpre.get("ragione_sociale")) + "|" + cu.s(cliforpre.get("indirizzo")) + "|" + cu.s(cliforpre.get("localita"));
                    mdatipre.put("denominazione", cu.s(cliforpre.get("ragione_sociale")));
                    datinew = cu.s(clifor.get("ragione_sociale")) + "|" + cu.s(clifor.get("indirizzo")) + "|" + cu.s(clifor.get("localita"));
                    mdatinew.put("denominazione", cu.s(clifor.get("ragione_sociale")));
                    simNome = org.apache.commons.lang3.StringUtils.getJaroWinklerDistance((CharSequence)cu.s(cliforpre.get("ragione_sociale")), (CharSequence)cu.s(clifor.get("ragione_sociale")));
                }
                simIndirizzo = org.apache.commons.lang3.StringUtils.getJaroWinklerDistance((CharSequence)cu.s(cliforpre.get("indirizzo")), (CharSequence)cu.s(clifor.get("indirizzo")));
                simLoc = org.apache.commons.lang3.StringUtils.getJaroWinklerDistance((CharSequence)cu.s(cliforpre.get("localita")), (CharSequence)cu.s(clifor.get("localita")));
                double media = (simNome + simIndirizzo + simLoc) / 3.0;
                System.out.println("media = " + media);
                if (fe_modo_import_fornitori.equals(MODO_IMORT_FORN_CREA)) {
                    if (media < 0.75 || simNome < 0.75 || simIndirizzo < 0.75 || simLoc < 0.75) {
                        System.out.println("datipre != datinew");
                        System.out.println("datipre " + datipre);
                        System.out.println("datinew " + datinew);
                        System.out.println("simNome = " + simNome);
                        System.out.println("simIndirizzo = " + simIndirizzo);
                        System.out.println("simLoc = " + simLoc);
                        this.rendiObsoleto(conn, cu.i(cliforpre.get("codice")), cu.s(clifor.get("piva_cfiscale")), cu.s(clifor.get("cfiscale")));
                        clifornew = true;
                    } else {
                        codiceClifor = cu.i(cliforpre.get("codice"));
                    }
                } else if (fe_modo_import_fornitori.equals(MODO_IMORT_FORN_USAOLD)) {
                    codiceClifor = cu.i(cliforpre.get("codice"));
                } else if (fe_modo_import_fornitori.equals(MODO_IMORT_FORN_CHIEDI)) {
                    if (media < 0.75 || simNome < 0.75 || simIndirizzo < 0.75 || simLoc < 0.75) {
                        JDialogImportForn dialog = new JDialogImportForn((Frame)main.getPadreFrame(), true);
                        dialog.setLocationRelativeTo(null);
                        dialog.init(mdatipre, mdatinew);
                        dialog.setVisible(true);
                        if (dialog.ret.equals("annulla")) {
                            throw new Exception("Import annullato");
                        }
                        if (dialog.ret.equals("old")) {
                            codiceClifor = cu.i(cliforpre.get("codice"));
                        } else if (dialog.ret.equals("new")) {
                            this.rendiObsoleto(conn, cu.i(cliforpre.get("codice")), cu.s(clifor.get("piva_cfiscale")), cu.s(clifor.get("cfiscale")));
                            clifornew = true;
                        }
                    } else {
                        codiceClifor = cu.i(cliforpre.get("codice"));
                    }
                }
            } else {
                System.out.println("non trovato clifor precedente per piva o cfiscale");
                clifornew = true;
            }
            if (clifornew) {
                clifor.put("tipo", "F");
                if (cu.sIsBlank(clifor.get("ragione_sociale"))) {
                    clifor.put("persona_fisica", "S");
                    clifor.put("ragione_sociale", clifor.get("cognome") + " " + clifor.get("nome"));
                }
                sql = "insert into clie_forn set " + dbu.prepareSqlFromMap((Map)clifor);
                System.out.println("sql = " + sql);
                try {
                    dbu.tryExecQuery((Connection)conn, (String)sql, (boolean)false, (boolean)true);
                    codiceClifor = dbu.getLastInsertId((Connection)conn);
                    ret.put("clifornew", codiceClifor);
                    ret.put("clifor_rs", clifor.get("ragione_sociale"));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                ret.put("cliforpre", codiceClifor);
                ret.put("clifor_rs", cliforpre.get("ragione_sociale"));
            }
            if (codiceClifor == null) {
                throw new Exception("Problema nella creazione o aggiornamento dell'anagrafica fornitore (codiceClifor = null)");
            }
            clifor = null;
            try {
                clifor = dbu.getMap((Connection)Db.getConn(), (String)("select codice, ragione_sociale, flag_update_listino, codice_listino from clie_forn where codice = " + dbu.sql(codiceClifor)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (Object fatturaO : (List)dati.get("fatture")) {
                Map m3;
                Double totale_scadenze;
                String codiceListino;
                Map fatturaN = (Map)fatturaO;
                Map fattura = (Map)fatturaN.get("fattura");
                Map fattura_extra = (Map)fatturaN.get("fattura_extra");
                fattura.put("fornitore", codiceClifor);
                fattura.put("serie_doc", null);
                fattura.put("numero_doc", fattura.get("numero"));
                fattura.put("data_doc", cu.toDate(fattura.get("data")));
                Date dataReg = new Date();
                if (dataRegistrazione != null && dataRegistrazione.equalsIgnoreCase("Data ricezione")) {
                    dataReg = cu.toDate(datiSdi.dati.get("data_ricezione"));
                }
                if (!batch) {
                    serie = cu.s(this.param.get("serie_fatt_acq")).trim();
                    String fe_serie_import = cu.s(this.param.get("fe_serie_import"));
                    if (StringUtils.isBlank((String)fe_serie_import)) {
                        fe_serie_import = SERIE_IMPORT_SPECIFICA;
                    }
                    if (fe_serie_import.equals(SERIE_IMPORT_NO)) {
                        serie = "";
                    } else if (fe_serie_import.equals(SERIE_IMPORT_CHIEDI)) {
                        JDialogSelezionaSerie diaSerie = new JDialogSelezionaSerie((Frame)main.getPadreFrame(), true);
                        diaSerie.labTitolo.setText("Inserisci la serie del documento da creare");
                        diaSerie.texSerie.setText(serie);
                        diaSerie.pack();
                        diaSerie.setLocationRelativeTo(null);
                        diaSerie.setVisible(true);
                        if (diaSerie.serie == null) {
                            throw new Exception("Import annullato");
                        }
                        serie = diaSerie.serie;
                    }
                }
                Integer anno = DateUtils.getYear((Date)dataReg);
                Integer numero = cu.i0((Object)dbu.getObject((Connection)Db.getConn(), (String)("select max(numero) from test_fatt_acquisto where serie = " + dbu.sql((Object)serie) + " and anno = " + dbu.sql((Object)anno)))) + 1;
                fattura.put("serie", serie);
                fattura.put("numero", numero);
                fattura.put("data", dataReg);
                fattura.put("anno", anno);
                fattura.put("tipo_fattura", 7);
                if (cu.s(fattura_extra.get("tipo_documento")).equals("TD04")) {
                    fattura.put("tipo_fattura", 9);
                }
                if (fatturaN.get("sconti_testata") != null) {
                    List sconti_testata = (List)fatturaN.get("sconti_testata");
                    for (int i = 0; i < sconti_testata.size(); ++i) {
                        if (i >= 3) {
                            System.out.println("ignoro altri sconti di testata " + sconti_testata.get(i));
                            continue;
                        }
                        fattura.put("sconto" + (i + 1), sconti_testata.get(i));
                    }
                }
                this.trovaRitenuta(fattura, fatturaN);
                this.trovaRivalsa(fattura, fatturaN);
                fattura.put("deposito", cu.i0((Object)main.fileIni.getValue("depositi", "predefinito", "0")));
                String pagamento = this.trovaPagamento(fatturaN);
                fattura.put("pagamento", pagamento);
                if (main.pluginContabilita && main.isPluginContabilitaAttivo()) {
                    try {
                        sql = "select conto_acq from clie_forn where codice = " + dbu.sql((Object)codiceClifor);
                        String conto_clifor = dbu.getString((Connection)Db.getConn(), (String)sql);
                        if (StringUtils.isNotEmpty((String)conto_clifor)) {
                            fattura.put("conto", conto_clifor);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sql = "insert into test_fatt_acquisto set " + dbu.prepareSqlFromMap((Map)fattura);
                System.out.println("sql = " + sql);
                try {
                    dbu.tryExecQuery((Connection)conn, (String)sql, (boolean)false, (boolean)true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                Integer id_fatt = dbu.getLastInsertId((Connection)conn);
                ret.put("id_fattura", id_fatt);
                ret.put("serie_fattura", serie);
                ret.put("numero_fattura", numero);
                boolean listino_prezzi_ivati = false;
                if (cu.b(clifor.get("flag_update_listino")).booleanValue() && StringUtils.isNotBlank((String)(codiceListino = cu.s(clifor.get("codice_listino"))))) {
                    listino_prezzi_ivati = cu.toBoolean((Object)dbu.getObject((Connection)Db.getConn(), (String)("select prezzi_ivati from tipi_listino where codice = " + dbu.sql((Object)codiceListino))));
                }
                List righe = (List)((Map)((List)dati.get("fatture")).get(0)).get("righe");
                int riga = 0;
                for (Map r : righe) {
                    String codiceListino2;
                    Map m2;
                    ++riga;
                    r.put("id_padre", id_fatt);
                    r.put("serie", serie);
                    r.put("numero", numero);
                    r.put("anno", anno);
                    String desc = cu.s(r.get("descrizione"));
                    if (desc.toLowerCase().startsWith("bollo ") || desc.toLowerCase().indexOf(" bollo ") >= 0 || desc.toLowerCase().endsWith(" bollo")) {
                        r.put("flag_rivalsa", "N");
                    }
                    String codice_articolo_interno = cu.s(r.get("codice_articolo"));
                    if (main.pluginContabilita && main.isPluginContabilitaAttivo()) {
                        try {
                            String conto = cu.s((Object)ReflectUtils.runMethod((String)"it.tnx.invoicex.pnota.PNUtil", (String)"getContoArticolo", (Object[])new Object[]{true, codiceClifor, codice_articolo_interno}));
                            if (StringUtils.isNotBlank((String)conto)) {
                                r.put("conto", conto);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (StringUtils.isBlank((String)cu.s(r.get("quantita")))) {
                        r.put("quantita", 1);
                    }
                    if (r.get("sconti_riga") != null) {
                        List sconti_riga = (List)r.get("sconti_riga");
                        for (int i = 0; i < sconti_riga.size(); ++i) {
                            if (i >= 2) {
                                System.out.println("ignoro altri sconti di riga " + sconti_riga.get(i));
                                continue;
                            }
                            r.put("sconto" + (i + 1), sconti_riga.get(i));
                        }
                    }
                    double aliquota_iva = cu.d0e(r.get("AliquotaIVA"));
                    String codiceIva = null;
                    if (cu.d0e(r.get("AliquotaIVA")) != 0.0) {
                        m2 = (Map)this.cacheIvaPerc.get(FormatUtils.formatEngNum22Dec((double)cu.d0e(r.get("AliquotaIVA"))));
                        if (m2 != null) {
                            codiceIva = cu.s(m2.get("codice"));
                        }
                    } else if (StringUtils.isNotBlank((String)cu.s(r.get("Natura"))) && (m2 = (Map)this.cacheIvaNatura.get(cu.s(r.get("Natura")))) != null) {
                        codiceIva = cu.s(m2.get("codice"));
                    }
                    if (StringUtils.isBlank(codiceIva)) {
                        if (ret.get("iva_new") == null) {
                            ret.put("iva_new", new ArrayList());
                        }
                        HashMap<String, Object> ivanew = new HashMap<String, Object>();
                        String newCodice = cu.s(cu.sIsBlank(r.get("Natura")) ? cu.i(r.get("AliquotaIVA")) : r.get("Natura"));
                        newCodice = StringUtils.replace((String)newCodice, (String)".", (String)"");
                        ivanew.put("codice", newCodice);
                        ivanew.put("percentuale", r.get("AliquotaIVA"));
                        ivanew.put("descrizione", cu.sIsBlank(iva_desc_natura.get(r.get("Natura"))) ? cu.i(r.get("AliquotaIVA")) : iva_desc_natura.get(r.get("Natura")));
                        ivanew.put("descrizione_breve", cu.sIsBlank(iva_desc_breve_natura.get(r.get("Natura"))) ? cu.i(r.get("AliquotaIVA")) : iva_desc_natura.get(r.get("Natura")));
                        ivanew.put("codice_natura_xmlpa", r.get("Natura"));
                        System.out.println("ivanew = " + ivanew);
                        DebugFastUtils.dump(ivanew);
                        sql = "insert into codici_iva set " + dbu.prepareSqlFromMap(ivanew);
                        try {
                            dbu.tryExecQuery((Connection)conn, (String)sql);
                            this.checkCacheIva(true);
                            System.out.println("aggiunta nuova iva = " + ivanew);
                            ((List)ret.get("iva_new")).add(ivanew);
                            codiceIva = cu.s(cu.sIsBlank(r.get("Natura")) ? cu.i(r.get("AliquotaIVA")) : r.get("Natura"));
                        }
                        catch (Exception e) {
                            dbu.tryExecQuery((Connection)conn, (String)("delete from test_fatt_acquisto where id = " + id_fatt));
                            throw new Exception("Non trovato codice iva corrispondente alla riga " + riga + " (AliquotaIVA:" + r.get("AliquotaIVA") + " Natura:" + r.get("Natura") + ")\nCrea il codice Iva necessario e riprova l'importazione");
                        }
                    }
                    r.put("iva", codiceIva);
                    r.remove("AliquotaIVA");
                    r.remove("Natura");
                    r.remove("sconti_riga");
                    sql = "insert into righ_fatt_acquisto set " + dbu.prepareSqlFromMap((Map)r);
                    System.out.println("sql = " + sql);
                    try {
                        dbu.tryExecQuery((Connection)conn, (String)sql, (boolean)false, (boolean)true);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (!cu.b(clifor.get("flag_update_listino")).booleanValue() || !StringUtils.isNotBlank((String)codice_articolo_interno) || !StringUtils.isNotBlank((String)(codiceListino2 = cu.s(clifor.get("codice_listino"))))) continue;
                    sql = "";
                    Boolean prezzi_ivati = false;
                    Double prezzo = cu.d0e(r.get("prezzo"));
                    Double sconto1 = cu.d(r.get("sconto1"));
                    Double sconto2 = cu.d(r.get("sconto2"));
                    System.out.println("Codice Listino: " + codiceListino2);
                    System.out.println("Nuovo prezzo: " + prezzo);
                    System.out.println("prevvi iva inclusa: " + prezzi_ivati);
                    System.out.println("Codice Articolo: " + codice_articolo_interno);
                    System.out.println("Sconto1: " + sconto1);
                    System.out.println("Sconto2: " + sconto2);
                    if (listino_prezzi_ivati) {
                        prezzo = prezzo * (1.0 + aliquota_iva / 100.0);
                    }
                    String sqlControllo = "SELECT * FROM articoli_prezzi";
                    sqlControllo = sqlControllo + " WHERE articolo = " + dbu.sql((Object)codice_articolo_interno) + " AND listino = " + dbu.sql((Object)codiceListino2);
                    try {
                        ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sqlControllo);
                        if (list.size() > 0) {
                            sql = "UPDATE articoli_prezzi SET ";
                            sql = sql + "prezzo = " + dbu.sql((Object)prezzo) + ", ";
                            sql = sql + "sconto1 = " + dbu.sql((Object)sconto1) + ", ";
                            sql = sql + "sconto2 = " + dbu.sql((Object)sconto2) + " ";
                            sql = sql + "WHERE articolo = " + dbu.sql((Object)codice_articolo_interno) + " ";
                            sql = sql + "AND listino = " + dbu.sql((Object)codiceListino2);
                        } else {
                            sqlControllo = "SELECT * FROM articoli WHERE codice = " + dbu.sql((Object)codice_articolo_interno);
                            list = dbu.getListMap((Connection)Db.getConn(), (String)sqlControllo);
                            if (list.size() > 0) {
                                sql = "INSERT INTO articoli_prezzi SET ";
                                sql = sql + "prezzo = " + dbu.sql((Object)prezzo) + ", ";
                                sql = sql + "sconto1 = " + dbu.sql((Object)sconto1) + ", ";
                                sql = sql + "sconto2 = " + dbu.sql((Object)sconto2) + " ";
                                sql = sql + "articolo = " + dbu.sql((Object)codice_articolo_interno) + ", ";
                                sql = sql + "listino = " + dbu.sql((Object)codiceListino2);
                            }
                        }
                        if (sql.equals("")) continue;
                        Db.executeSql(sql);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Map testa = (Map)dbu.getListMap((Connection)conn, (String)("select * from test_fatt_acquisto where id = " + id_fatt)).get(0);
                righe = dbu.getListMap((Connection)conn, (String)("select * from righ_fatt_acquisto where id_padre = " + id_fatt));
                Documento2 doc = new Documento2(testa, righe);
                doc.calcolaTotali();
                sql = "update test_fatt_acquisto set  importo = " + dbu.sql((Object)doc.getTotale()) + ", imponibile = " + dbu.sql((Object)doc.getTotaleImponibile()) + ", iva = " + dbu.sql((Object)doc.getTotaleIva()) + ", totale_da_pagare = " + dbu.sql((Object)doc.getTotale_da_pagare()) + ", totale_da_pagare_finale = " + dbu.sql((Object)doc.getTotale_da_pagare_finale()) + ", totale_imponibile_pre_sconto = " + dbu.sql((Object)doc.totaleImponibilePreSconto) + ", totale_ivato_pre_sconto = " + dbu.sql((Object)doc.totaleIvatoPreSconto) + ", totale_ritenuta = " + dbu.sql((Object)doc.getTotale_ritenuta()) + ", totaleRivalsa = " + dbu.sql((Object)doc.getTotale_rivalsa()) + " where id = " + id_fatt;
                dbu.tryExecQuery((Connection)conn, (String)sql);
                Map dati_fattura = (Map)((Map)((List)dati.get("fatture")).get(0)).get("fattura");
                Map dati_fattura_extra = (Map)((Map)((List)dati.get("fatture")).get(0)).get("fattura_extra");
                Double totale_xml = Util.round(cu.d0e(dati_fattura.get("importo")), 2);
                if (totale_xml != Util.round(doc.getTotale(), 2)) {
                    this.addAvviso(ret, this.getAvviso(datiSdi == null ? null : datiSdi.dati, "Totale diverso, totale su fattura ricevuta " + FormatUtils.formatEuroItaMax5((double)totale_xml) + " \u20ac, su fattura importata " + FormatUtils.formatEuroItaMax5((double)doc.getTotale()) + " \u20ac"));
                }
                if ((totale_scadenze = Double.valueOf(Util.round(cu.d0e(dati_fattura_extra.get("totale_scadenze")), 2))) != 0.0 && totale_scadenze != Util.round(doc.getTotale_da_pagare(), 2)) {
                    this.addAvviso(ret, this.getAvviso(datiSdi == null ? null : datiSdi.dati, "Totale da pagare diverso, totale su fattura ricevuta " + FormatUtils.formatEuroItaMax5((double)totale_scadenze) + " \u20ac, su fattura importata " + FormatUtils.formatEuroItaMax5((double)doc.getTotale_da_pagare()) + " \u20ac"));
                }
                Scadenze tempScad = new Scadenze(Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, id_fatt, pagamento, cu.toDate(fattura.get("data_doc")), (Object)this);
                if (pagamento.equals(Db.PAGAMENTO_LIBERO)) {
                    List scadenze = (List)fatturaN.get("scadenze");
                    tempScad.numero = 1;
                    for (Map m3 : scadenze) {
                        Date dataScadenza = cu.toDate(m3.get("DataScadenzaPagamento"));
                        double importo = cu.d0e(m3.get("ImportoPagamento"));
                        tempScad.inserisciScadenza(importo, dataScadenza == null ? cu.toDate(fattura.get("data_doc")) : dataScadenza);
                        ++tempScad.numero;
                    }
                } else {
                    tempScad.generaScadenze(Db.getConn(), true, this);
                }
                InvoicexUtil.ricalcolaTotaleScadenze(Db.getConn(), Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA, id_fatt);
                if (!batch) {
                    generaMovimenti = false;
                    String movimenti = cu.s(this.param.get("fe_genera_movimenti"));
                    if (!StringUtils.isBlank((String)movimenti) && !movimenti.equals(GENERA_MOVIMENTI_NO)) {
                        if (movimenti.equals(GENERA_MOVIMENTI_SI)) {
                            generaMovimenti = true;
                        } else if (SwingUtils.showYesNoMessage((Component)main.getPadreFrame(), (String)"Vuoi generare i movimenti di magazzino ?")) {
                            generaMovimenti = true;
                        }
                    }
                }
                if (generaMovimenti.booleanValue()) {
                    dbFatturaRicevuta dbdoc = new dbFatturaRicevuta();
                    dbdoc.serie = serie;
                    dbdoc.numero = numero;
                    dbdoc.anno = anno;
                    dbdoc.setId(id_fatt);
                    dbdoc.tipoFattura = cu.i0(fattura.get("tipo_documento"));
                    dbdoc.tipoDocumento = Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA;
                    dbdoc.generaMovimentiMagazzino();
                }
                if (generaContab == null) {
                    generaContab = false;
                    if (main.pluginContabilita && main.isPluginContabilitaAttivo()) {
                        String gen = cu.s(((Map)main.GLOB.get("dati_azienda")).get("con_gen_fat"));
                        if (gen.equalsIgnoreCase("") || gen.equalsIgnoreCase("C")) {
                            if (SwingUtils.showYesNoMessage((Component)main.getPadreFrame(), (String)"Vuoi generare le scritture in prima nota ?")) {
                                generaContab = true;
                            }
                        } else if (gen.equalsIgnoreCase("S")) {
                            generaContab = true;
                        }
                    }
                }
                if (generaContab.booleanValue()) {
                    ReflectUtils.runMethod((String)"it.tnx.invoicex.pnota.PNUtil", (String)"generaPrimaNotaFattura", (Object[])new Object[]{id_fatt, new Boolean(true), new Boolean(true)});
                    sql = "select id from scadenze";
                    sql = sql + " where documento_tipo = " + dbu.sql((Object)Db.TIPO_DOCUMENTO_FATTURA_RICEVUTA);
                    sql = sql + " and id_doc = " + id_fatt;
                    ArrayList id_scadenze = dbu.getListInt((Connection)conn, (String)sql);
                    ReflectUtils.runMethod((String)"it.tnx.invoicex.pnota.PNUtil", (String)"generaPrimaNotaScadenze", (Object[])new Object[]{id_scadenze});
                }
                HashMap<String, Object> xmlm = new HashMap<String, Object>();
                xmlm.put("id_fattura", id_fatt);
                if (xml != null) {
                    xmlm.put("file_xml", xml);
                } else {
                    xmlm.put("file_xml", FileUtils.readContent((File)fileXml));
                }
                if (fileXml != null) {
                    xmlm.put("file_xml_ts", fileXml.lastModified());
                }
                xmlm.put("file_xml_nome", id);
                xmlm.put("fe_provider_invio", this.getClass().getSimpleName());
                sql = "delete from test_fatt_acquisto_xmlpa where id_fattura = " + dbu.sql((Object)id_fatt);
                dbu.tryExecQuery((Connection)conn, (String)sql);
                sql = "insert into test_fatt_acquisto_xmlpa set " + dbu.prepareSqlFromMap(xmlm);
                dbu.tryExecQuery((Connection)conn, (String)sql);
                sql = "select x.id_fattura, x.file_xml from test_fatt_acquisto_xmlpa x where id_fattura = " + id_fatt;
                ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
                if (list.size() == 0) continue;
                m3 = (Map)list.get(0);
                JDialogManutenzione.compattaXml(m3, "test_fatt_acquisto", null);
            }
        } else {
            throw new Exception("Problema nella lettura della fattura\nPartita IVA e Codice fiscale del fornitore vuoti");
        }
        return ret;
    }

    private static void get(XPath xpath, Map m, Element element, String expr, String campo) throws XPathExpressionException {
        String val = cu.s((Object)xpath.evaluate(expr, element, XPathConstants.STRING));
        m.put(campo, val);
    }

    private static Map getMap(Connection conn, String sql) throws Exception {
        ArrayList list = dbu.getListMap((Connection)conn, (String)sql);
        if (list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    private void checkCacheIva() throws Exception {
        this.checkCacheIva(false);
    }

    private void checkCacheIva(boolean forza) throws Exception {
        if (this.cacheIvaPerc == null || forza) {
            this.cacheIvaPerc = dbu.getListMapMap((Connection)Db.getConn(), (String)"select min(codice) as codice, percentuale from codici_iva where percentuale != 0 and codice != '' group by percentuale order by codice", (String)"percentuale", (boolean)false, (boolean)true);
        }
        if (this.cacheIvaNatura == null || forza) {
            this.cacheIvaNatura = dbu.getListMapMap((Connection)Db.getConn(), (String)"select min(codice) as codice, codice_natura_xmlpa from codici_iva where ifnull(codice_natura_xmlpa,'') != '' and codice != '' group by codice_natura_xmlpa order by codice", (String)"codice_natura_xmlpa");
        }
    }

    public void aggiornaStatoFattura(String tipo, Integer id, String stato) throws Exception {
        String sql = "update " + FEUtils.getTabTestate(tipo) + " set fe_stato = " + dbu.sql((Object)stato) + " where id = " + dbu.sql((Object)id);
        dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
        if (stato.equals(STATO_INVIATA)) {
            sql = "select x.id_fattura, x.file_xml from " + FEUtils.getTabTestate(tipo) + "_xmlpa x  where id_fattura = " + id;
            ArrayList list = dbu.getListMap((Connection)Db.getConn(), (String)sql);
            if (list.size() != 0) {
                Map m = (Map)list.get(0);
                JDialogManutenzione.compattaXml(m, FEUtils.getTabTestate(tipo), null);
            }
        }
    }

    public static HttpResp doRequest(HttpURLConnection con, String method) throws UnsupportedEncodingException, ProtocolException, IOException {
        return Sdi.doRequest(con, method, null, null, null, null);
    }

    public static HttpResp doRequest(HttpURLConnection con, String method, ContentType type, Map<String, String> data) throws UnsupportedEncodingException, ProtocolException, IOException {
        return Sdi.doRequest(con, method, type, data, null, null);
    }

    public static HttpResp doRequest(HttpURLConnection con, String method, ContentType type, Map<String, String> data, Map<String, String> add_headers) throws UnsupportedEncodingException, ProtocolException, IOException {
        return Sdi.doRequest(con, method, type, data, null, add_headers);
    }

    public static HttpResp doRequest(HttpURLConnection con, String method, ContentType type, Map<String, String> data, String raw) throws UnsupportedEncodingException, ProtocolException, IOException {
        return Sdi.doRequest(con, method, type, data, raw, null);
    }

    public static HttpResp doRequest(HttpURLConnection con, String method, ContentType type, Map<String, String> data, String raw, Map<String, String> add_headers) throws UnsupportedEncodingException, ProtocolException, IOException {
        HttpResp resp = new HttpResp();
        String postString = null;
        byte[] postData = null;
        int postDataLength = 0;
        if (method.equals("POST")) {
            postString = type == ContentType.raw ? raw : Sdi.getDataString(type, data);
            postData = postString.getBytes("UTF-8");
            postDataLength = postData.length;
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            if (type == ContentType.www_form_urlenc) {
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else if (type == ContentType.json) {
                con.setRequestProperty("Content-Type", "application/json");
            }
            con.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        } else {
            con.setRequestMethod(method);
        }
        con.setInstanceFollowRedirects(false);
        if (add_headers != null && add_headers.size() > 0) {
            for (Map.Entry<String, String> entry : add_headers.entrySet()) {
                con.setRequestProperty(cu.s((Object)entry.getKey()), cu.s((Object)entry.getValue()));
            }
        }
        con.setUseCaches(false);
        if (method.equals("POST")) {
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(postData);
            wr.close();
        }
        resp.http_status_code = con.getResponseCode();
        System.out.println("resp.http_status_code " + resp.http_status_code);
        resp.http_status_msg = con.getResponseMessage();
        System.out.println("resp.http_status_msg " + resp.http_status_msg);
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            resp.output = response.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                resp.output = response.toString();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return resp;
    }

    public static HttpResp sendFileMSAzureBlob(HttpURLConnection con, File file) throws ProtocolException, IOException {
        HttpResp resp = new HttpResp();
        Object postString = null;
        Object postData = null;
        boolean postDataLength = false;
        con.setDoOutput(true);
        con.setRequestMethod("PUT");
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d HH:mm:ss -Z yyyy", Locale.ENGLISH);
        System.out.println("sdf = " + sdf.format(new Date()));
        con.setRequestProperty("x-ms-date", sdf.format(new Date()));
        con.setRequestProperty("x-ms-blob-type", "BlockBlob");
        con.setRequestProperty("Content-Length", cu.s((Object)file.length()));
        con.setUseCaches(false);
        OutputStream out = con.getOutputStream();
        FileInputStream fin = new FileInputStream(file);
        IOUtils.copy((InputStream)fin, (OutputStream)out);
        out.close();
        fin.close();
        resp.http_status_code = con.getResponseCode();
        System.out.println("resp.http_status_code " + resp.http_status_code);
        resp.http_status_msg = con.getResponseMessage();
        System.out.println("resp.http_status_msg " + resp.http_status_msg);
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            resp.output = response.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                resp.output = response.toString();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return resp;
    }

    public static String getDataString(ContentType type, Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (params == null) {
            return null;
        }
        if (type == ContentType.www_form_urlenc) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            return result.toString();
        }
        if (type == ContentType.json) {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                json.put(entry.getKey(), entry.getValue());
            }
            return json.toJSONString();
        }
        return null;
    }

    public static String getQueryString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(cu.s((Object)entry.getKey()), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(cu.s((Object)entry.getValue()), "UTF-8"));
        }
        return result.toString();
    }

    static {
        iva_desc_natura.put("N1", "Escluse (es. ex artt. 2, 3, 5, 13,15, del DPR n. 633/72)");
        iva_desc_natura.put("N2", "Non soggette (es. ex art.7-bis, 7-ter, 7-quater, 7- quinquies, ecc. del DPR n. 633/72)");
        iva_desc_natura.put("N3", "Non imponibile (es. ex artt.8, 8-bis, 9, 71, 72, del DPR n. 633/72 e artt.41 e 58 del D.L. n. 331/793)");
        iva_desc_natura.put("N4", "Esente (ex art.10 del DPR n.633/72)");
        iva_desc_natura.put("N5", "Regime del margine per i beni usati /editoria/ agenzie di viaggio e turismo");
        iva_desc_natura.put("N6", "Inversione contabile (reverse charge) (es. ex art.74 commi 7 e 8, art.17, commi 2 e 6 del DPR n. 633/72, artt.38 e 40 del D.L. n. 331/93)");
        iva_desc_natura.put("N7", "IVA assolta in altro Stato UE (vendite a distanza sopra la soglia, commercio elettronico diretto verso privati)");
        iva_desc_breve_natura.put("N1", "Escluse");
        iva_desc_breve_natura.put("N2", "Non soggette");
        iva_desc_breve_natura.put("N3", "Non imponibile");
        iva_desc_breve_natura.put("N4", "Esente");
        iva_desc_breve_natura.put("N5", "Regime del marg");
        iva_desc_breve_natura.put("N6", "Reverse charge");
        iva_desc_breve_natura.put("N7", "altro Stato UE");
        STATO_INVIATA = "I";
        STATO_CONSEGNATA = "C";
        STATO_MANCATA_CONSEGNA = "M";
        STATO_RICEVUTA = "R";
        STATO_SCARTATA = "S";
        STATO_NON_GESTITO = "?";
        STATO_AZZERA = "X";
        STATO_AZZERA_TUTTO = "Y";
        STATO_NOTIFICA_ACCETTATA = "NE_A";
        STATO_NOTIFICA_RIFIUTATA = "NE_R";
        STATO_DECORRENZA_TERMINI = "DT";
        STATO_ATT_TRASM = "AT";
        STATO_CONSEGNATA_PA = "C_PA";
        METODO_INVIO_PEC = "Tramite PEC";
        METODO_INVIO_PORTALE_FATT_CORR = "Portale Fatture e Corrispettivi";
        METODO_INVIO_ESTERNO_MANUALE = "Servizio esterno manuale";
        METODO_INVIO_ESTERNO_INTEGRATO = "Servizio esterno integrato";
    }

    public static class HttpResp {
        public Integer http_status_code;
        public String output;
        public String http_status_msg;
    }

    public static enum ContentType {
        www_form_urlenc,
        json,
        raw;

    }

    public static class EsitoImportDaSdi {
        public boolean esito;
        public int fatture_importate;
        public int fatture_ricevute;
        List<Map> avvisi = new ArrayList<Map>();
        List<Map> esiti = new ArrayList<Map>();
    }

    public static class FatturaSdi {
        public String id;
        public String xml;
        public Map dati;
    }
}

