/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import com.caucho.util.Hex;
import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.CastUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.JUtil;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.InvoicexUtil;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.Base64Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AgyoSdiRest
extends Sdi {
    static String appname = "VR330";
    static String url_ws_auth = "https://b2b-auth-service.agyo.io/api/v3";
    static String url_ws_write = "https://b2bwrite-api.agyo.io/api";
    static String url_ws_read = "https://b2bread-api.agyo.io/api";
    String login_id = null;
    String login_secret = null;
    String login_token = null;
    private Map datiStatus;
    String access_token = null;

    public AgyoSdiRest() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password, key1, key2);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            String piva_transimetter = cu.s(this.param.get("tras_cod_fiscale"));
            String piva_sender = cu.s(this.param.get("cede_p_iva"));
            String cfiscale_sender = cu.s(this.param.get("cede_c_fiscale"));
            HashMap<String, String> data = new HashMap<String, String>();
            Map cliente = (Map)dbu.getListMap((Connection)Db.getConn(), (String)("select if(trim(ifnull(cfiscale,'')) = '', piva_cfiscale, cfiscale) as idfiscale, cf.paese, cf.ragione_sociale, cf.nome, cf.cognome, cf.xmlpa_flag_pa from test_fatt tf join clie_forn cf on tf.cliente = cf.codice where tf.id = " + id)).get(0);
            String cfiscale_piva_recipient = cu.s(cliente.get("idfiscale"));
            String paese = cu.s(cliente.get("paese"));
            if (StringUtils.isBlank((String)cfiscale_piva_recipient) && !InvoicexUtil.isIta(paese)) {
                cfiscale_piva_recipient = !cu.sIsBlank(cliente.get("ragione_sociale")) ? StringUtils.left((String)cu.s((Object)("@" + cliente.get("ragione_sociale"))).toUpperCase(), (int)28) : StringUtils.left((String)cu.s((Object)("@" + cu.s(cliente.get("cognome")) + "_" + cu.s(cliente.get("nome")))).toUpperCase(), (int)28);
            }
            cfiscale_piva_recipient = Normalizer.normalize(cfiscale_piva_recipient, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            String type = "SDI";
            data.put("transmitterId", piva_transimetter);
            data.put("senderId", cfiscale_sender);
            if (cfiscale_sender.length() == 0) {
                data.put("senderId", piva_sender);
            }
            if (cu.toBoolean(cliente.get("xmlpa_flag_pa"))) {
                data.put("flowType", "SDIPA");
            } else {
                data.put("flowType", "SDIPR");
            }
            File ff = new File(file);
            data.put("fileName", ff.getName());
            byte[] buffer = new byte[(int)ff.length()];
            IOUtils.readFully((InputStream)new FileInputStream(file), (byte[])buffer);
            data.put("content", Base64Utils.base64Encode(buffer));
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws_write + "/v2/invoices").openConnection();
            Map hdrs = this.getHdrs(this.login_id, this.login_token);
            Sdi.HttpResp rresp = AgyoSdiRest.doRequest(con, "POST", Sdi.ContentType.json, data, hdrs);
            System.out.println(rresp.http_status_code);
            System.out.println(rresp.output);
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(rresp.output);
            System.out.println("jo.hubid:" + jo.get("hubId"));
            String fe_upload_filename = cu.s(jo.get("hubId"));
            if (StringUtils.isBlank((String)fe_upload_filename)) {
                throw new Exception("Errore AgyoSdi: hubId vuoto");
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)fe_upload_filename) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        Map ultimoStatusFattura;
        HashMap<String, String> ultimoStatusFattura2;
        String filename;
        String name = filename = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select fe_upload_filename from " + FEUtils.getTabXml(tipo_fattura) + " where id_fattura = " + dbu.sql((Object)id))));
        if (StringUtils.isBlank((String)filename)) {
            return null;
        }
        if (this.login()) {
            this.datiStatus = new HashMap();
            ultimoStatusFattura2 = new HashMap<String, String>();
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws_read + "/v2/invoices/" + filename).openConnection();
            Sdi.HttpResp rresp = AgyoSdiRest.doRequest(con, "GET", null, null, this.getHdrs(this.login_id, this.login_token));
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(rresp.output);
            JSONArray list = (JSONArray)((JSONObject)jo.get("status")).get("HUB");
            JSONArray list_msg = (JSONArray)jo.get("messages");
            list.addAll(list_msg);
            for (Object o : list) {
                JSONObject jos = (JSONObject)o;
                boolean msg = false;
                if (!cu.sIsBlank(jos.get("notificationId"))) {
                    msg = true;
                }
                String tipo = cu.s(jos.get("name"));
                if (msg) {
                    tipo = cu.s(jos.get("description"));
                }
                long ts = cu.l(jos.get("timestamp"));
                Date dts = new Date(ts);
                ArrayList listPerFattura = (ArrayList)this.datiStatus.get(name);
                int numeroNotifica = 0;
                if (listPerFattura == null) {
                    listPerFattura = new ArrayList();
                    numeroNotifica = 1;
                } else {
                    numeroNotifica = listPerFattura.size() + 1;
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("numero_notifica", numeroNotifica);
                m.put("name", name);
                m.put("ts", ts);
                m.put("dts", dts);
                m.put("tipo", tipo);
                listPerFattura.add(m);
                this.datiStatus.put(name, listPerFattura);
                String stato = null;
                if (tipo.startsWith("CARICATO") || tipo.startsWith("REGISTRATO") || tipo.startsWith("CONTROLLATO") || tipo.startsWith("VALIDATO") || tipo.startsWith("FIRMATO")) {
                    stato = STATO_INVIATA;
                } else if (tipo.equalsIgnoreCase("SCARTATO") || tipo.startsWith("IN_GESTIONE") && (tipo.toLowerCase().indexOf("scartat") >= 0 || tipo.toLowerCase().indexOf("rifiutato") >= 0 || tipo.toLowerCase().indexOf("nessuna_risposta") >= 0 || tipo.toLowerCase().indexOf("non_recapitato") >= 0)) {
                    stato = STATO_SCARTATA;
                } else if (tipo.startsWith("INVIATO") && tipo.toLowerCase().indexOf("mancata") >= 0) {
                    stato = STATO_MANCATA_CONSEGNA;
                } else if (tipo.toLowerCase().indexOf("notifica mancata consegna") >= 0) {
                    stato = STATO_MANCATA_CONSEGNA;
                } else if (tipo.startsWith("INVIATO") && tipo.toLowerCase().indexOf("consegnata") >= 0) {
                    stato = STATO_CONSEGNATA;
                } else if (tipo.startsWith("IN_GESTIONE") && tipo.toLowerCase().indexOf("consegnata") >= 0 || tipo.startsWith("INVIATO") || tipo.startsWith("Consegnata")) {
                    stato = STATO_CONSEGNATA;
                } else if (tipo.toLowerCase().indexOf("notifica ricevuta consegna") >= 0) {
                    stato = STATO_CONSEGNATA;
                } else if (tipo.startsWith("IN_GESTIONE") && (tipo.toLowerCase().indexOf("mancataconsegna") >= 0 || tipo.toLowerCase().indexOf("mancata_consegna") >= 0 || tipo.toLowerCase().indexOf("mancata consegna") >= 0)) {
                    stato = STATO_MANCATA_CONSEGNA;
                } else if (tipo.toLowerCase().indexOf("mancataconsegna") >= 0 || tipo.toLowerCase().indexOf("mancata_consegna") >= 0 || tipo.toLowerCase().indexOf("mancata consegna") >= 0) {
                    stato = STATO_MANCATA_CONSEGNA;
                } else if (tipo.startsWith("IN_GESTIONE") && tipo.toLowerCase().indexOf("accettat") >= 0) {
                    stato = STATO_RICEVUTA;
                } else if (name.equals(filename)) {
                    System.out.println("tipo NON GESTITO: " + tipo);
                }
                if (name.equals(filename)) {
                    System.out.println("ultimoStatusFattura stato = " + stato);
                }
                ultimoStatusFattura2.put(name, stato);
            }
        } else {
            throw new Exception("Agyo : Errore in fase di login");
        }
        this.datiStatus.put("ultimoStatusFattura", ultimoStatusFattura2);
        List list = (List)this.datiStatus.get(filename);
        if (list != null) {
            for (Map m : list) {
                HashMap<String, Object> dati = new HashMap<String, Object>();
                dati.put("id_fattura", id);
                dati.put("numero_notifica", m.get("numero_notifica"));
                dati.put("ts_notifica", new Timestamp(cu.l(m.get("ts"))));
                Timestamp ts = new Timestamp(cu.l(m.get("ts")));
                dati.put("stato_provider", m.get("tipo"));
                dati.put("provider", this.getClass().getSimpleName());
                if (main.utente != null) {
                    dati.put("utente_invoicex", main.utente.getNomeUtente());
                }
                dati.put("utente_so", main.utente.getNomeUtente());
                String sqltest = "select id from " + FEUtils.getTabXml(tipo_fattura) + "_status where id_fattura = " + dbu.sql((Object)id) + " and ts_notifica = " + dbu.sql((Object)ts) + " and stato_provider = " + dbu.sql(m.get("tipo"));
                System.out.println("sqltest = " + sqltest);
                if (dbu.containRows((Connection)Db.getConn(), (String)sqltest)) continue;
                String sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                try {
                    dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((ultimoStatusFattura = (Map)this.datiStatus.get("ultimoStatusFattura")) != null && ultimoStatusFattura.get(filename) != null) {
            String statusFattura = (String)ultimoStatusFattura.get(filename);
            this.aggiornaStatoFattura(tipo_fattura, id, statusFattura);
        }
        return true;
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))), cu.s(this.param.get("provider_key1")), cu.s(this.param.get("provider_key2")));
    }

    private boolean login(String username, String password, String key1, String key2) throws Exception {
        if (JUtil.getJavaMajor() <= 6) {
            throw new Exception("Necessario Java 1.7 o superiore");
        }
        this.login_id = key1;
        this.login_secret = key2;
        if (this.login_id.equals("cd5eddaa-05d4-4632-b2be-03423a70cf01")) {
            url_ws_auth = "https://b2b-auth-service-test.agyo.io/api/v3";
            url_ws_write = "https://b2bwrite-api-test.agyo.io/api";
            url_ws_read = "https://b2bread-api-test.agyo.io/api";
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url_ws_auth + "/nonces").openConnection();
        System.out.println("AgyoRest login = " + this.login_id);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", this.login_id);
        Map hdrs = this.getHdrs(this.login_id, this.login_token);
        Sdi.HttpResp rresp = AgyoSdiRest.doRequest(con, "POST", Sdi.ContentType.json, data, hdrs);
        System.out.println(rresp.http_status_code);
        System.out.println(rresp.output);
        JSONParser jp = new JSONParser();
        JSONObject jo = (JSONObject)jp.parse(rresp.output);
        String rnonce = cu.s(jo.get("nonce"));
        con.disconnect();
        con = (HttpURLConnection)new URL(url_ws_auth + "/tokens").openConnection();
        data = new HashMap();
        data.put("id", this.login_id);
        MessageDigest rdigest = MessageDigest.getInstance("SHA-256");
        String hash = Hex.toHex((byte[])rdigest.digest((this.login_id + this.login_secret).getBytes()));
        hash = hash + rnonce;
        String hash2 = Hex.toHex((byte[])rdigest.digest(hash.getBytes()));
        System.out.println("hash2 = " + hash2);
        data.put("digest", hash2);
        rresp = AgyoSdiRest.doRequest(con, "POST", Sdi.ContentType.json, data, hdrs);
        System.out.println(rresp.http_status_code);
        System.out.println(rresp.output);
        if (rresp.http_status_code != 200) {
            throw new Exception(rresp.output);
        }
        jo = (JSONObject)jp.parse(rresp.output);
        String auth = cu.s(jo.get("accessToken"));
        hdrs.put("Authorization", "Bearer " + auth);
        this.login_token = auth;
        return true;
    }

    private Map getHdrs(String login_id, String login_token) {
        String piva_sender = cu.s(this.param.get("cede_p_iva"));
        String cfiscale_sender = cu.s(this.param.get("cede_c_fiscale"));
        if (StringUtils.isBlank((String)piva_sender)) {
            piva_sender = cfiscale_sender;
        }
        HashMap<String, Object> hdrs = new HashMap<String, Object>();
        hdrs.put("X-App-Name", appname);
        hdrs.put("X-User-Agent", "Invoicex " + main.version + " " + main.build);
        hdrs.put("X-App-Version", main.version + " " + main.build);
        hdrs.put("X-Request-ID", System.currentTimeMillis());
        hdrs.put("X-Correlation-ID", "");
        hdrs.put("X-Item-ID", piva_sender);
        hdrs.put("X-User-ID", login_id);
        if (login_token != null) {
            hdrs.put("Authorization", "Bearer " + login_token);
        }
        return hdrs;
    }

    @Override
    public EsitoRicezione riceviElencoDaSdi(Date dalDate, Date alDate) throws Exception {
        EsitoRicezione esito = new EsitoRicezione();
        if (this.login()) {
            String dal = FormatUtils.formatMysqlDate((Object)dalDate);
            String al = FormatUtils.formatMysqlDate((Object)alDate);
            ArrayList<Map> l = new ArrayList<Map>();
            String contoken = this.getElenco(null, dalDate, alDate, this.login_id, this.login_token, l);
            System.out.println("contoken = " + contoken);
            while (StringUtils.isNotEmpty((String)contoken)) {
                contoken = this.getElenco(contoken, dalDate, alDate, this.login_id, this.login_token, l);
                System.out.println("contoken = " + contoken);
            }
            esito.fatture = l;
            return esito;
        }
        return null;
    }

    private String getElenco(String contoken, Date dalDate, Date alDate, String login_id, String login_token, List<Map> l) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("continuationToken", contoken);
        String piva_transimetter = cu.s(this.param.get("tras_cod_fiscale"));
        String piva_sender = cu.s(this.param.get("cede_p_iva"));
        data.put("ownerId", piva_transimetter);
        data.put("active", "false");
        data.put("lastTimestampFrom", (String)((Object)Long.valueOf(dalDate.getTime())));
        data.put("size", (String)((Object)Integer.valueOf(50)));
        HttpURLConnection con = null;
        con = (HttpURLConnection)new URL(url_ws_read + "/v2/invoices/?" + AgyoSdiRest.getQueryString(data)).openConnection();
        Sdi.HttpResp rresp = null;
        rresp = AgyoSdiRest.doRequest(con, "GET", null, null, this.getHdrs(login_id, login_token));
        if (rresp.http_status_code == 403) {
            data.put("ownerId", piva_sender);
            try {
                con.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            con = (HttpURLConnection)new URL(url_ws_read + "/v2/invoices/?" + AgyoSdiRest.getQueryString(data)).openConnection();
            rresp = AgyoSdiRest.doRequest(con, "GET", null, null, this.getHdrs(login_id, login_token));
        }
        JSONParser jp = new JSONParser();
        JSONObject jo = (JSONObject)jp.parse(rresp.output);
        JSONArray lr = (JSONArray)((JSONObject)jo.get("_embedded")).get("invoiceList");
        this.addFatture(l, lr, dalDate, alDate);
        contoken = cu.s(((JSONObject)jo.get("page")).get("continuationToken"));
        return contoken;
    }

    private void addFatture(List<Map> l, JSONArray lr, Date dalDate, Date alDate) throws ParseException {
        Date dalDateMeno1 = DateUtils.addDays((Date)dalDate, (int)-1);
        Date alDatePiu1 = DateUtils.addDays((Date)alDate, (int)1);
        for (Object o : lr) {
            JSONObject jof = (JSONObject)o;
            Date data = CastUtils.toDate(jof.get("docDate"));
            Date data_ricezione = null;
            data_ricezione = this.getIsoDate(cu.s(jof.get("receiptDate")));
            System.out.println("data_ricezione = " + data_ricezione);
            Date dataCheck = data_ricezione;
            if (dataCheck == null) {
                dataCheck = data;
            }
            if (!dataCheck.after(dalDateMeno1) || !dataCheck.before(alDatePiu1)) continue;
            boolean passiva = true;
            try {
                boolean active = CastUtils.toBoolean(jof.get("active"));
                if (active) {
                    passiva = false;
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!passiva) continue;
            HashMap f = new HashMap();
            f.put("fornitore", jof.get("senderName"));
            f.put("partita_iva", jof.get("senderId"));
            f.put("data", data);
            f.put("data_ricezione", data_ricezione);
            f.put("numero", jof.get("docId"));
            f.put("id", jof.get("hubId"));
            l.add(f);
        }
    }

    private Date getDate(XMLGregorianCalendar data) {
        if (data == null) {
            return null;
        }
        return data.toGregorianCalendar().getTime();
    }

    @Override
    public byte[] riceviDaSdi(String id) throws Exception {
        if (this.login()) {
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(url_ws_read + "/v2/invoices/" + id + "/download?format=XML").openConnection();
                Sdi.HttpResp rresp = AgyoSdiRest.doRequest(con, "GET", null, null, this.getHdrs(this.login_id, this.login_token));
                return rresp.output.getBytes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Date getIsoDate(String s) throws ParseException {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(s);
    }
}

