/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import com.google.gson.Gson;
import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.commons.su;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.Base64Utils;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArubaSdi
extends Sdi {
    static String url_auth = "https://auth.fatturazioneelettronica.aruba.it/";
    static String url_ws = "https://ws.fatturazioneelettronica.aruba.it/";
    static JSONObject lastLogin = null;
    static String access_token = null;

    public ArubaSdi() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/upload").openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + access_token);
            HashMap<String, String> data = new HashMap<String, String>();
            String dataFile = IOUtils.toString((Reader)new FileReader(file));
            String dataFile64 = new String(Base64.encodeBase64((byte[])dataFile.getBytes()));
            System.out.println("dataFile64 = " + dataFile64);
            data.put("dataFile", dataFile64);
            data.put("credential", "");
            data.put("domain", "");
            Sdi.HttpResp resp = ArubaSdi.doRequest(con, "POST", Sdi.ContentType.json, data, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = (JSONObject)p.parse(resp.output);
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            String fe_upload_filename = cu.s(jo.get("uploadFileName"));
            if (StringUtils.isBlank((String)fe_upload_filename)) {
                throw new Exception("Errore ArubaSdi: uploadFileName vuoto");
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)fe_upload_filename) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        String filename = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select fe_upload_filename from " + FEUtils.getTabXml(tipo_fattura) + " where id_fattura = " + dbu.sql((Object)id))));
        if (this.login()) {
            String sql;
            String sqltest;
            SimpleDateFormat sdf;
            Timestamp ts;
            HashMap<String, Object> dati;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("filename", filename);
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/out/getByFilename?" + ArubaSdi.getQueryString(data)).openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + access_token);
            Sdi.HttpResp resp = ArubaSdi.doRequest(con, "GET", null, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            if (resp.http_status_code != 200) {
                if (resp.http_status_code == 401) {
                    throw new Exception("Hai verificato che la delega con TNX nel pannello di Aruba sia attivata ?\nAruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
                }
                throw new Exception("Aruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
            }
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = null;
            try {
                jo = (JSONObject)p.parse(resp.output);
            }
            catch (ParseException e) {
                throw new Exception("Errore nell'analisi della risposta\n\n" + su.html2text((String)resp.output));
            }
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            String ultimoStatus = "";
            String ultimoEsito = "";
            String status = null;
            String statusDescription = null;
            boolean giaEliminateNotifiche = false;
            JSONArray list = (JSONArray)jo.get("invoices");
            if (list != null && list.size() >= 0) {
                JSONObject jinv = (JSONObject)list.get(0);
                status = cu.s(jinv.get("status"));
                statusDescription = cu.s(jinv.get("statusDescription"));
                if (StringUtils.isNotBlank((String)statusDescription)) {
                    String statoProvider = "NS";
                    String sqldel = "delete from " + FEUtils.getTabXml(tipo_fattura) + "_status where id_fattura = " + dbu.sql((Object)id) + " and stato_provider is not null and provider = " + dbu.sql((Object)this.getClass().getSimpleName());
                    dbu.tryExecQuery((Connection)Db.getConn(), (String)sqldel);
                    giaEliminateNotifiche = true;
                    dati = new HashMap<String, Object>();
                    dati.put("id_fattura", id);
                    ts = null;
                    try {
                        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                        ts = new Timestamp(sdf.parse(cu.s(jo.get("lastUpdate"))).getTime());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dati.put("ts_notifica", ts);
                    dati.put("rif_fattura", jo.get("id"));
                    dati.put("file_xml_nome_notifica", jo.get("filename"));
                    dati.put("stato_provider", statoProvider);
                    ultimoStatus = statoProvider;
                    JSONArray arrErrDesc = new JSONArray();
                    JSONObject objErrDesc = new JSONObject();
                    objErrDesc.put("errore", statusDescription);
                    arrErrDesc.add(objErrDesc);
                    dati.put("esito_errore", arrErrDesc.toJSONString());
                    dati.put("provider", this.getClass().getSimpleName());
                    if (main.utente != null) {
                        dati.put("utente_invoicex", main.utente.getNomeUtente());
                    }
                    dati.put("utente_so", main.utente.getNomeUtente());
                    sqltest = "select id from " + FEUtils.getTabXml(tipo_fattura) + "_status where id_fattura = " + dbu.sql((Object)id) + " and ts_notifica = " + dbu.sql((Object)ts) + " and stato_provider = " + dbu.sql((Object)statoProvider) + " and ifnull(esito_errore,'') = " + dbu.sql((Object)cu.s((Object)statusDescription));
                    System.out.println("sqltest = " + sqltest);
                    if (!dbu.containRows((Connection)Db.getConn(), (String)sqltest)) {
                        sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                        try {
                            dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    sql = null;
                }
            }
            data = new HashMap();
            data.put("invoiceFilename", filename);
            con = (HttpURLConnection)new URL(url_ws + "/services/notification/out/getByInvoiceFilename?" + ArubaSdi.getQueryString(data)).openConnection();
            add_headers = new HashMap();
            add_headers.put("Authorization", "Bearer " + access_token);
            resp = ArubaSdi.doRequest(con, "GET", null, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            if (resp.http_status_code != 200) {
                if (resp.http_status_code == 401) {
                    throw new Exception("Hai verificato che la delega con TNX nel pannello di Aruba sia attivata ?\nAruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
                }
                throw new Exception("Aruba : Errore in fase getStatus: " + resp.http_status_code + " " + resp.http_status_msg);
            }
            con.disconnect();
            p = new JSONParser();
            jo = null;
            try {
                jo = (JSONObject)p.parse(resp.output);
            }
            catch (ParseException e) {
                throw new Exception("Errore nell'analisi della risposta\n\n" + su.html2text((String)resp.output));
            }
            error = (String)jo.get("errorCode");
            error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            list = (JSONArray)jo.get("notifications");
            if (list.size() > 0 && !giaEliminateNotifiche) {
                String sqldel = "delete from " + FEUtils.getTabXml(tipo_fattura) + "_status where id_fattura = " + dbu.sql((Object)id) + " and stato_provider is not null and provider = " + dbu.sql((Object)this.getClass().getSimpleName());
                dbu.tryExecQuery((Connection)Db.getConn(), (String)sqldel);
            }
            for (Object o : list) {
                JSONArray jsa;
                String root;
                XPath xpath;
                XPathFactory xPathfactory;
                Document doc;
                DocumentBuilder dBuilder;
                DocumentBuilderFactory dbFactory;
                JSONObject jon = (JSONObject)o;
                dati = new HashMap();
                dati.put("id_fattura", id);
                ts = null;
                try {
                    sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    ts = new Timestamp(sdf.parse(cu.s(jon.get("date"))).getTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dati.put("ts_notifica", ts);
                dati.put("rif_fattura", jon.get("invoiceId"));
                dati.put("file_xml_nome_notifica", jon.get("filename"));
                String fileNotifica = new String(Base64Utils.base64Decode(cu.s(jon.get("file"))));
                dati.put("stato_provider", jon.get("docType"));
                ultimoStatus = cu.s(jon.get("docType"));
                dati.put("numero_notifica", jon.get("number"));
                dati.put("esito", jon.get("result"));
                ultimoEsito = cu.s(jon.get("result"));
                String errore = null;
                if (ultimoEsito.equalsIgnoreCase("EC02")) {
                    dbFactory = DocumentBuilderFactory.newInstance();
                    dBuilder = dbFactory.newDocumentBuilder();
                    doc = dBuilder.parse(new ByteArrayInputStream(fileNotifica.getBytes()));
                    doc.getDocumentElement().normalize();
                    xPathfactory = XPathFactory.newInstance();
                    xpath = xPathfactory.newXPath();
                    root = doc.getDocumentElement().getNodeName();
                    NodeList listErrore = (NodeList)xpath.evaluate("//EsitoCommittente/Descrizione", doc, XPathConstants.NODESET);
                    if (listErrore != null && listErrore.getLength() > 0) {
                        jsa = new JSONArray();
                        JSONObject jso = new JSONObject();
                        errore = cu.s((Object)listErrore.item(0).getTextContent());
                        jso.put("errore", errore);
                        jsa.add(jso);
                        System.out.println("errore esito = " + jsa.toJSONString());
                        dati.put("esito_errore", jsa.toJSONString());
                    }
                } else if (ultimoStatus.equalsIgnoreCase("NS")) {
                    dbFactory = DocumentBuilderFactory.newInstance();
                    dBuilder = dbFactory.newDocumentBuilder();
                    doc = dBuilder.parse(new ByteArrayInputStream(fileNotifica.getBytes()));
                    doc.getDocumentElement().normalize();
                    xPathfactory = XPathFactory.newInstance();
                    xpath = xPathfactory.newXPath();
                    root = doc.getDocumentElement().getNodeName();
                    NodeList listErrori = (NodeList)xpath.evaluate("//ListaErrori/Errore", doc, XPathConstants.NODESET);
                    jsa = new JSONArray();
                    if (listErrori != null && listErrori.getLength() > 0) {
                        for (int i = 0; i < listErrori.getLength(); ++i) {
                            JSONObject jso = new JSONObject();
                            NodeList childs = listErrori.item(i).getChildNodes();
                            for (int i2 = 0; i2 < childs.getLength(); ++i2) {
                                Node n = childs.item(i2);
                                if (n.getNodeName().equalsIgnoreCase("Descrizione")) {
                                    jso.put("errore", n.getTextContent());
                                    continue;
                                }
                                if (!n.getNodeName().equalsIgnoreCase("Suggerimento")) continue;
                                jso.put("suggerimento", n.getTextContent());
                            }
                            jsa.add(jso);
                        }
                        System.out.println("errore esito = " + jsa.toJSONString());
                        dati.put("esito_errore", jsa.toJSONString());
                    }
                }
                dati.put("provider", this.getClass().getSimpleName());
                if (main.utente != null) {
                    dati.put("utente_invoicex", main.utente.getNomeUtente());
                }
                dati.put("utente_so", main.utente.getNomeUtente());
                sqltest = "select id from " + FEUtils.getTabXml(tipo_fattura) + "_status where id_fattura = " + dbu.sql((Object)id) + " and ts_notifica = " + dbu.sql((Object)ts) + " and stato_provider = " + dbu.sql(jon.get("docType")) + " and ifnull(esito_errore,'') = " + dbu.sql((Object)cu.s(errore));
                System.out.println("sqltest = " + sqltest);
                if (dbu.containRows((Connection)Db.getConn(), (String)sqltest)) continue;
                sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                try {
                    dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String statusFattura = null;
            if (ultimoStatus.equalsIgnoreCase("RC")) {
                statusFattura = STATO_CONSEGNATA;
            } else if (ultimoStatus.equalsIgnoreCase("MC") || ultimoStatus.equalsIgnoreCase("NMC")) {
                statusFattura = STATO_MANCATA_CONSEGNA;
            } else if (ultimoStatus.equalsIgnoreCase("NS")) {
                statusFattura = STATO_SCARTATA;
            } else if (ultimoStatus.equalsIgnoreCase("NE") && ultimoEsito.equalsIgnoreCase("EC01")) {
                statusFattura = STATO_NOTIFICA_ACCETTATA;
            } else if (ultimoStatus.equalsIgnoreCase("NE") && ultimoEsito.equalsIgnoreCase("EC02")) {
                statusFattura = STATO_NOTIFICA_RIFIUTATA;
            } else if (ultimoStatus.equalsIgnoreCase("DT")) {
                statusFattura = STATO_DECORRENZA_TERMINI;
            } else if (ultimoStatus.equalsIgnoreCase("AT")) {
                statusFattura = STATO_ATT_TRASM;
            }
            if (statusFattura != null) {
                this.aggiornaStatoFattura(tipo_fattura, id, statusFattura);
            }
            return true;
        }
        throw new Exception("ArubaSdi : Errore in fase di login");
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))));
    }

    private boolean login(String username, String password) throws Exception {
        if (lastLogin != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
            System.out.println(sdf.format(new Date()));
            Date expire = sdf.parse(cu.s(lastLogin.get(".expires")));
            System.out.println("expire         = " + expire);
            Date expire_refresh = sdf.parse(cu.s(lastLogin.get(".expires_refresh")));
            System.out.println("expire_refresh = " + expire_refresh);
            Date d = new Date();
            if (d.before(expire)) {
                return true;
            }
            if (d.before(expire_refresh)) {
                HttpURLConnection con = (HttpURLConnection)new URL(url_auth + "/auth/signin").openConnection();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("grant_type", "refresh_token");
                data.put("refresh_token", (String)lastLogin.get("refresh_token"));
                Sdi.HttpResp resp = ArubaSdi.doRequest(con, "POST", Sdi.ContentType.www_form_urlenc, data);
                System.out.println(resp.http_status_code);
                System.out.println(resp.output);
                JSONParser p = new JSONParser();
                JSONObject jo = (JSONObject)p.parse(resp.output);
                String error = (String)jo.get("error");
                String error_desc = (String)jo.get("error_description");
                if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                    throw new Exception(error + ": " + error_desc);
                }
                access_token = (String)jo.get("access_token");
                System.out.println("access_token = " + access_token);
                lastLogin = jo;
                return true;
            }
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url_auth + "/auth/signin").openConnection();
        username = StringUtils.trim((String)username);
        System.out.println("ArubaSdi login = '" + username + "'");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", "password");
        data.put("username", username);
        data.put("password", password);
        Sdi.HttpResp resp = ArubaSdi.doRequest(con, "POST", Sdi.ContentType.www_form_urlenc, data);
        System.out.println(resp.http_status_code);
        System.out.println(resp.output);
        JSONParser p = new JSONParser();
        JSONObject jo = (JSONObject)p.parse(resp.output);
        String error = (String)jo.get("error");
        String error_desc = (String)jo.get("error_description");
        if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
            throw new Exception(error + ": " + error_desc);
        }
        access_token = (String)jo.get("access_token");
        System.out.println("access_token = " + access_token);
        lastLogin = jo;
        return true;
    }

    @Override
    public EsitoRicezione riceviElencoDaSdi(Date dalDate, Date alDate) throws Exception {
        EsitoRicezione esito = new EsitoRicezione();
        if (this.login()) {
            String dal = FormatUtils.formatMysqlDate((Object)dalDate);
            String al = FormatUtils.formatMysqlDate((Object)alDate);
            String paese = cu.s(this.param.get("cede_id_paese"));
            String username = StringUtils.trim((String)cu.s(this.param.get("provider_username")));
            String piva = StringUtils.trim((String)cu.s(this.param.get("cede_p_iva")));
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/in/findByUsername?username=" + username + "&startDate=" + dal + "&endDate=" + al + "&size=10").openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + access_token);
            Sdi.HttpResp resp = ArubaSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            if (resp.output == null && resp.http_status_code != null && resp.http_status_code != 200) {
                throw new Exception("Errore http status " + resp.http_status_code + "\nAttendere qualche minuto e riprovare");
            }
            if (main.debug) {
                IOUtils.write((String)resp.output, (OutputStream)new FileOutputStream("c:\\temp\\findByUsername1.txt.json"));
            }
            con.disconnect();
            ArrayList<Map> l = new ArrayList<Map>();
            Gson gson = new Gson();
            Map jo = (Map)gson.fromJson(resp.output, Map.class);
            boolean utentePremium = false;
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                if (error_desc.toLowerCase().indexOf("parametro obbligatorio") >= 0) {
                    utentePremium = true;
                    con = (HttpURLConnection)new URL(url_ws + "/services/invoice/in/findByUsername?username=" + username + "&countryReceiver=" + paese + "&vatcodeReceiver=" + piva + "&startDate=" + dal + "&endDate=" + al + "&size=10").openConnection();
                    resp = ArubaSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
                    System.out.println("resp = " + resp.http_status_code);
                    System.out.println("resp = " + resp.http_status_msg);
                    System.out.println("resp = " + resp.output);
                    if (resp.output == null && resp.http_status_code != null && resp.http_status_code != 200) {
                        throw new Exception("Errore http status " + resp.http_status_code + "\nAttendere qualche minuto e riprovare");
                    }
                    con.disconnect();
                    jo = (Map)gson.fromJson(resp.output, Map.class);
                    error = (String)jo.get("errorCode");
                    error_desc = (String)jo.get("errorDescription");
                    if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                        throw new Exception(error + ": " + error_desc);
                    }
                } else {
                    throw new Exception(error + ": " + error_desc);
                }
            }
            System.out.println("totalElements = " + jo.get("totalElements"));
            Integer totalPages = cu.i0(jo.get("totalPages"));
            this.addFatture(l, jo);
            for (int pag = 2; pag <= totalPages; ++pag) {
                if (this.getCurrentWorker() != null) {
                    this.getCurrentWorker().publish(new Object[]{"Ricezione elenco fatture " + pag + "/" + totalPages});
                }
                con = utentePremium ? (HttpURLConnection)new URL(url_ws + "/services/invoice/in/findByUsername?username=" + username + "&countryReceiver=" + paese + "&vatcodeReceiver=" + piva + "&startDate=" + dal + "&endDate=" + al + "&size=10&page=" + pag).openConnection() : (HttpURLConnection)new URL(url_ws + "/services/invoice/in/findByUsername?username=" + username + "&startDate=" + dal + "&endDate=" + al + "&size=10&page=" + pag).openConnection();
                resp = ArubaSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
                System.out.println("resp = " + resp.http_status_code);
                System.out.println("resp = " + resp.http_status_msg);
                System.out.println("resp = " + resp.output);
                con.disconnect();
                if (main.debug) {
                    IOUtils.write((String)resp.output, (OutputStream)new FileOutputStream("c:\\temp\\findByUsername" + pag + ".txt.json"));
                }
                jo = (Map)gson.fromJson(resp.output, Map.class);
                error = (String)jo.get("errorCode");
                error_desc = (String)jo.get("errorDescription");
                if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                    throw new Exception(error + ": " + error_desc);
                }
                this.addFatture(l, jo);
            }
            System.out.println("l.size = " + l.size());
            esito.fatture = l;
            return esito;
        }
        return null;
    }

    private void addFatture(List<Map> l, Map jo) {
        List list = (List)jo.get("content");
        for (Object o : list) {
            Map m = (Map)o;
            HashMap f = new HashMap();
            f.put("fornitore", ((Map)m.get("sender")).get("description"));
            f.put("partita_iva", ((Map)m.get("sender")).get("vatCode"));
            f.put("codice_fiscale", ((Map)m.get("sender")).get("fiscalCode"));
            f.put("data_ricezione", this.getDateCreation(StringUtils.removeEnd((String)cu.s(m.get("creationDate")), (String)"+0000")));
            Map inv = (Map)((List)m.get("invoices")).get(0);
            f.put("data", this.getDate(inv.get("invoiceDate")));
            f.put("numero", inv.get("number"));
            f.put("id", m.get("filename"));
            l.add(f);
        }
    }

    @Override
    public byte[] riceviDaSdi(String id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/in/getByFilename?filename=" + id).openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + access_token);
            Sdi.HttpResp resp = ArubaSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            Gson gson = new Gson();
            Map jo = (Map)gson.fromJson(resp.output, Map.class);
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            String xml = cu.s(jo.get("file"));
            return Base64Utils.base64Decode(xml);
        }
        return null;
    }

    private Date getDateCreation(Object data) {
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getDate(Object data) {
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

