/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex2.fe.impl;

import com.google.gson.Gson;
import gestioneFatture.iniFileProp;
import gestioneFatture.main;
import it.tnx.Db;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import it.tnx.invoicex.iu;
import it.tnx.invoicex2.fe.EsitoRicezione;
import it.tnx.invoicex2.fe.FEUtils;
import it.tnx.invoicex2.fe.Sdi;
import it.tnx.invoicex2.fe.impl.Base64Utils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Bill4MeSdi
extends Sdi {
    static String url_ws = "https://api-gw.bill4me.it";
    private Map datiStatus;
    String access_token = null;

    public Bill4MeSdi() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    @Override
    public boolean testConnessione(String username, String password, String key1, String key2) throws Exception {
        return this.login(username, password);
    }

    @Override
    public boolean inviaASdi(String file, String tipo, Integer id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/import").openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + this.access_token);
            HashMap<String, String> data = new HashMap<String, String>();
            String dataFile = IOUtils.toString((Reader)new FileReader(file));
            String dataFile64 = new String(Base64.encodeBase64((byte[])dataFile.getBytes()));
            System.out.println("dataFile64 = " + dataFile64);
            File ffile = new File(file);
            data.put("FileName", ffile.getName());
            data.put("InvoiceContent", dataFile64);
            data.put("Flow", "Active");
            data.put("TransmitInvoice", "true");
            Sdi.HttpResp resp = Bill4MeSdi.doRequest(con, "POST", Sdi.ContentType.json, data, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            JSONParser p = new JSONParser();
            JSONObject jo = (JSONObject)p.parse(resp.output);
            String error = "";
            String success = "";
            String filename = "";
            try {
                error = cu.s(((JSONObject)((JSONArray)((JSONObject)jo.get("ResultData")).get("ImportResults")).get(0)).get("Error"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                success = cu.s(((JSONObject)((JSONArray)((JSONObject)jo.get("ResultData")).get("ImportResults")).get(0)).get("Success"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                filename = cu.s(((JSONObject)((JSONArray)((JSONObject)jo.get("ResultData")).get("ImportResults")).get(0)).get("FileName"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!StringUtils.isBlank((String)error)) {
                throw new Exception(error);
            }
            String fe_upload_filename = filename;
            if (StringUtils.isBlank((String)fe_upload_filename)) {
                throw new Exception("Errore Bill4MeSdi: uploadFileName vuoto");
            }
            String sql = "update " + FEUtils.getTabXml(tipo) + " set fe_upload_filename = " + dbu.sql((Object)fe_upload_filename) + ", fe_inviata_ts = CURRENT_TIMESTAMP, fe_provider_invio = " + dbu.sql((Object)this.getClass().getSimpleName()) + " where id_fattura = " + dbu.sql((Object)id);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            this.aggiornaStatoFattura("V", id, STATO_INVIATA);
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id_fattura", id);
            m.put("stato", STATO_INVIATA);
            m.put("provider", this.getClass().getSimpleName());
            if (main.utente != null) {
                m.put("utente_invoicex", main.utente.getNomeUtente());
            }
            m.put("utente_so", main.utente.getNomeUtente());
            sql = "insert into test_fatt_xmlpa_status set " + dbu.prepareSqlFromMap(m);
            dbu.tryExecQuery((Connection)Db.getConn(), (String)sql);
            iu.aggiornaElenchiFattureRefreshSelected();
        }
        return true;
    }

    @Override
    public Object getStatus(String tipo_fattura, Integer id) throws Exception {
        Map ultimoStatusFattura;
        List list;
        String filename = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)("select fe_upload_filename from " + FEUtils.getTabXml(tipo_fattura) + " where id_fattura = " + dbu.sql((Object)id))));
        if (this.datiStatus == null) {
            if (this.login()) {
                this.datiStatus = new HashMap();
                HashMap<String, String> ultimoStatusFattura2 = new HashMap<String, String>();
                HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/invoice?pageSize=100").openConnection();
                HashMap<String, String> add_headers = new HashMap<String, String>();
                add_headers.put("Authorization", "Bearer " + this.access_token);
                Sdi.HttpResp resp = Bill4MeSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
                System.out.println("resp = " + resp.http_status_code);
                System.out.println("resp = " + resp.http_status_msg);
                System.out.println("resp = " + resp.output);
                con.disconnect();
                JSONParser p = new JSONParser();
                JSONObject jo = (JSONObject)p.parse(resp.output);
                HashMap ret = new HashMap();
                JSONArray resultset = (JSONArray)((JSONObject)jo.get("ResultData")).get("ResultSet");
                for (Object o : resultset) {
                    JSONObject xml;
                    JSONObject jon = (JSONObject)o;
                    JSONObject fatturapa = (JSONObject)jon.get("FatturaPA");
                    if (fatturapa == null || (xml = (JSONObject)fatturapa.get("XML")) == null) continue;
                    String name = cu.s(xml.get("Filename"));
                    String tipo = cu.s(fatturapa.get("TransmissionStatus"));
                    String ts_tra = cu.s(fatturapa.get("TransmissionDate"));
                    String ts_rec = cu.s(fatturapa.get("ReceiptDate"));
                    Date d_tra = this.getDate(ts_tra);
                    Date d_rec = this.getDate(ts_rec);
                    ArrayList listPerFattura = (ArrayList)this.datiStatus.get(name);
                    int numeroNotifica = 0;
                    if (listPerFattura == null) {
                        listPerFattura = new ArrayList();
                        numeroNotifica = 1;
                    } else {
                        numeroNotifica = listPerFattura.size() + 1;
                    }
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("numero_notifica", numeroNotifica);
                    m.put("name", name);
                    if (d_rec != null) {
                        m.put("ts", d_rec);
                    } else if (d_tra != null) {
                        m.put("ts", d_tra);
                    }
                    m.put("tipo", tipo);
                    listPerFattura.add(m);
                    this.datiStatus.put(name, listPerFattura);
                    String stato = null;
                    if (tipo.equalsIgnoreCase("Sent") || tipo.equalsIgnoreCase("DeliveredToSDI")) {
                        stato = STATO_INVIATA;
                    } else if (tipo.equalsIgnoreCase("Rejected") || tipo.equalsIgnoreCase("DeliveryFailure") || tipo.equalsIgnoreCase("Refused")) {
                        stato = STATO_SCARTATA;
                    } else if (tipo.equalsIgnoreCase("Delivered")) {
                        stato = STATO_CONSEGNATA;
                    } else if (tipo.equalsIgnoreCase("Unanwered")) {
                        stato = STATO_MANCATA_CONSEGNA;
                    } else if (tipo.equalsIgnoreCase("Accepted") || tipo.equalsIgnoreCase("CertifiedDelivery")) {
                        stato = STATO_RICEVUTA;
                    }
                    ultimoStatusFattura2.put(name, stato);
                }
                this.datiStatus.put("ultimoStatusFattura", ultimoStatusFattura2);
            } else {
                throw new Exception("Bill4Me : Errore in fase di login");
            }
        }
        if ((list = (List)this.datiStatus.get(filename)) != null) {
            for (Map m : list) {
                HashMap<String, Object> dati = new HashMap<String, Object>();
                dati.put("id_fattura", id);
                dati.put("numero_notifica", m.get("numero_notifica"));
                dati.put("ts_notifica", m.get("ts"));
                dati.put("stato_provider", m.get("tipo"));
                dati.put("provider", this.getClass().getSimpleName());
                if (main.utente != null) {
                    dati.put("utente_invoicex", main.utente.getNomeUtente());
                }
                dati.put("utente_so", main.utente.getNomeUtente());
                String sql = "insert into " + FEUtils.getTabXml(tipo_fattura) + "_status set " + dbu.prepareSqlFromMap(dati);
                try {
                    dbu.tryExecQuery((Connection)gestioneFatture.Db.getConn(), (String)sql);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((ultimoStatusFattura = (Map)this.datiStatus.get("ultimoStatusFattura")) != null && ultimoStatusFattura.get(filename) != null) {
            String statusFattura = (String)ultimoStatusFattura.get(filename);
            this.aggiornaStatoFattura(tipo_fattura, id, statusFattura);
        }
        return true;
    }

    private boolean login() throws Exception {
        return this.login(cu.s(this.param.get("provider_username")), iniFileProp.decrypt(cu.s(this.param.get("provider_password"))));
    }

    private boolean login(String username, String password) throws Exception {
        HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/authentication").openConnection();
        System.out.println("Bill4MeSdi login = " + username);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("User", username);
        data.put("Password", password);
        Sdi.HttpResp resp = Bill4MeSdi.doRequest(con, "POST", Sdi.ContentType.www_form_urlenc, data);
        System.out.println(resp.http_status_code);
        System.out.println(resp.output);
        JSONParser p = new JSONParser();
        JSONObject jo = (JSONObject)p.parse(resp.output);
        if (resp.http_status_code != 200) {
            throw new Exception(cu.s(jo.get("Message")));
        }
        this.access_token = (String)jo.get("access_token");
        System.out.println("access_token = " + this.access_token);
        return true;
    }

    @Override
    public EsitoRicezione riceviElencoDaSdi(Date dalDate, Date alDate) throws Exception {
        throw new Exception("non disponibile");
    }

    private void addFatture(List<Map> l, Map jo) {
        List list = (List)jo.get("content");
        for (Object o : list) {
            Map m = (Map)o;
            HashMap f = new HashMap();
            f.put("fornitore", ((Map)m.get("sender")).get("description"));
            f.put("partita_iva", ((Map)m.get("sender")).get("vatCode"));
            f.put("codice_fiscale", ((Map)m.get("sender")).get("fiscalCode"));
            f.put("data_ricezione", this.getDateCreation(StringUtils.removeEnd((String)cu.s(m.get("creationDate")), (String)"+0000")));
            Map inv = (Map)((List)m.get("invoices")).get(0);
            f.put("data", this.getDate(inv.get("invoiceDate")));
            f.put("numero", inv.get("number"));
            f.put("id", m.get("filename"));
            l.add(f);
        }
    }

    @Override
    public byte[] riceviDaSdi(String id) throws Exception {
        if (this.login()) {
            HttpURLConnection con = (HttpURLConnection)new URL(url_ws + "/services/invoice/in/getByFilename?filename=" + id).openConnection();
            HashMap<String, String> add_headers = new HashMap<String, String>();
            add_headers.put("Authorization", "Bearer " + this.access_token);
            Sdi.HttpResp resp = Bill4MeSdi.doRequest(con, "GET", Sdi.ContentType.json, null, add_headers);
            System.out.println("resp = " + resp.http_status_code);
            System.out.println("resp = " + resp.http_status_msg);
            System.out.println("resp = " + resp.output);
            con.disconnect();
            Gson gson = new Gson();
            Map jo = (Map)gson.fromJson(resp.output, Map.class);
            String error = (String)jo.get("errorCode");
            String error_desc = (String)jo.get("errorDescription");
            if (!StringUtils.isBlank((String)error) && !cu.s((Object)error).equalsIgnoreCase("0000")) {
                throw new Exception(error + ": " + error_desc);
            }
            String xml = cu.s(jo.get("file"));
            return Base64Utils.base64Decode(xml);
        }
        return null;
    }

    private Date getDateCreation(Object data) {
        if (cu.sIsBlank((Object)data)) {
            return null;
        }
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Date getDate(Object data) {
        if (cu.sIsBlank((Object)data)) {
            return null;
        }
        Timestamp ts = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            ts = new Timestamp(sdf.parse(cu.s((Object)data)).getTime());
            return new Date(ts.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

