/*
 * Decompiled with CFR 0.152.
 */
package mjpf;

import gestioneFatture.main;
import it.tnx.ClassPathHacker;
import it.tnx.commons.SwingUtils;
import it.tnx.invoicex.Plugin;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mjpf.EntryDescriptor;
import mjpf.PluginEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginFactory {
    private Hashtable plugins = null;
    public URLClassLoader classloader = null;
    private Vector idNotAvailable = new Vector();

    public PluginFactory(String pluginsPath) {
        this.loadPlugins(pluginsPath);
    }

    public PluginFactory() {
    }

    public PluginEntry getPluginEntry(Integer id) {
        if (this.plugins == null) {
            return null;
        }
        EntryDescriptor pd = (EntryDescriptor)this.plugins.get(id);
        PluginEntry obj = null;
        try {
            ClassPathHacker.addFile("plugins/" + pd.getNomeFileJar());
            Class<?> cl = Class.forName(pd.getMain());
            Object o = cl.newInstance();
            obj = (PluginEntry)o;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public PluginEntry getPluginEntryByName(String name) {
        Object key;
        if (this.plugins == null) {
            return null;
        }
        Enumeration e = this.plugins.keys();
        EntryDescriptor pd = null;
        while (e.hasMoreElements() && !(pd = (EntryDescriptor)this.plugins.get(key = e.nextElement())).getName().equals(name)) {
        }
        PluginEntry obj = null;
        try {
            ClassPathHacker.addFile("plugins/" + pd.getNomeFileJar());
            Class<?> cl = Class.forName(pd.getMain());
            Object o = cl.newInstance();
            obj = (PluginEntry)o;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public Collection getAllEntryDescriptor() {
        if (this.plugins == null) {
            return null;
        }
        return this.plugins.values();
    }

    public Vector getEntryDescriptorsByName(String name) {
        Iterator pluginsIterator = this.plugins.values().iterator();
        Vector<EntryDescriptor> pluginsbyname = new Vector<EntryDescriptor>();
        while (pluginsIterator.hasNext()) {
            EntryDescriptor pd = (EntryDescriptor)pluginsIterator.next();
            if (!pd.getName().equals(name)) continue;
            pluginsbyname.add(pd);
        }
        return pluginsbyname;
    }

    private EntryDescriptor loadPlugin(String pluginsPath, String jar_i) throws IOException, ParserConfigurationException, SAXException {
        EntryDescriptor pd = null;
        JarFile jarFile = new JarFile(pluginsPath + jar_i);
        ZipEntry xmldescriptor = this.getPluginPathFileDescriptor(pluginsPath + jar_i);
        if (xmldescriptor != null) {
            InputStream is = jarFile.getInputStream(xmldescriptor);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                jarFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            NodeList plugs = null;
            try {
                plugs = doc.getElementsByTagName("entry");
            }
            catch (Exception e) {
                System.out.println("    Warning: There are not entry tags in descriptor.xml!");
            }
            if (plugs.getLength() == 0) {
                System.out.println("    Warning: There are not entry tags in descriptor.xml!");
            }
            for (int j = 0; j < plugs.getLength(); ++j) {
                Element entrypoint = (Element)plugs.item(j);
                pd = new EntryDescriptor();
                Integer chiave = this.getNewEntryID();
                pd.setNomeFileJar(jar_i);
                pd.setId(chiave);
                try {
                    pd.setType(entrypoint.getElementsByTagName("type").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    System.out.println("    Warning: type tag not present");
                    System.out.println("    It is not possibile to load this Entry Point");
                    break;
                }
                try {
                    pd.setName(entrypoint.getElementsByTagName("name").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    System.out.println("    Warning: name tag not present");
                    System.out.println("    It is not possibile to load this Entry Point");
                    break;
                }
                try {
                    pd.setMain(entrypoint.getElementsByTagName("main").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    System.out.println("    Warning: main tag not present");
                    System.out.println("    It is not possibile to load this Entry Point");
                    break;
                }
                try {
                    pd.setIcon(entrypoint.getElementsByTagName("icon").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    System.out.println("    icon tag not present...");
                }
                try {
                    pd.setTips(entrypoint.getElementsByTagName("tips").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    System.out.println("    tips tag not present...");
                }
                try {
                    pd.setVer(entrypoint.getElementsByTagName("ver").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    pd.setData_string(entrypoint.getElementsByTagName("data").item(0).getFirstChild().getNodeValue());
                    SimpleDateFormat f1 = new SimpleDateFormat("dd/MM/yy");
                    pd.setData(f1.parse(entrypoint.getElementsByTagName("data").item(0).getFirstChild().getNodeValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.plugins.put(chiave, pd);
            }
        } else {
            System.out.println("Warning: " + jar_i + " does not contain descriptor.xml ");
            System.out.println("it's impossible to load its entry points");
        }
        return pd;
    }

    public EntryDescriptor loadPluginByFileName(String pluginsPath, String fileName) {
        try {
            String[] jar = new String[]{fileName};
            if (jar.length == 0) {
                return null;
            }
            if (this.plugins == null) {
                this.plugins = new Hashtable();
            }
            URL[] url = new URL[jar.length];
            for (int i = 0; i < jar.length; ++i) {
                String pi = "file:" + pluginsPath + jar[i];
                url[i] = new URL(pi);
            }
            this.classloader = new URLClassLoader(url);
            return this.loadPlugin(pluginsPath, jar[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void loadPlugins(String pluginsPath) {
        try {
            int i;
            String[] jar = new File(pluginsPath).list(new pluginFileFilter());
            if (jar.length == 0) {
                return;
            }
            if (this.plugins == null) {
                this.plugins = new Hashtable();
            }
            URL[] url = new URL[jar.length + 1];
            for (i = 0; i < jar.length; ++i) {
                String pi = "file:" + pluginsPath + jar[i];
                url[i] = new URL(pi);
            }
            url[jar.length] = new URL("file:plugins/lib/InvoicexPluginUtil.jar");
            this.classloader = new URLClassLoader(url);
            for (i = 0; i < jar.length; ++i) {
                try {
                    this.loadPlugin(pluginsPath, jar[i]);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    File fplugin = new File(pluginsPath + jar[i]);
                    if (fplugin.delete()) {
                        Plugin po = new Plugin();
                        EntryDescriptor pd = new EntryDescriptor();
                        pd.setNomeFileJar(jar[i]);
                        main.scaricaAggiornamentoPlugin(po, pd);
                        try {
                            this.loadPlugin(pluginsPath, jar[i]);
                        }
                        catch (Exception e) {
                            System.out.println("!!! errore 2 su ricarca plugin");
                            e.printStackTrace();
                        }
                        continue;
                    }
                    SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)("Impossibile caricare il plugin " + jar[i]));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipEntry getPluginPathFileDescriptor(String fileName) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(fileName);
            Enumeration<JarEntry> e = jarFile.entries();
            while (true) {
                if (e.hasMoreElements()) {
                    JarEntry jarEntry = e.nextElement();
                    String file = jarEntry.getName();
                    if (!file.endsWith("descriptor.xml")) continue;
                    ZipEntry zipEntry = jarFile.getEntry(file);
                    return zipEntry;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private Integer getNewEntryID() {
        int id = this.idNotAvailable.size() + 1;
        Integer ris = new Integer(id);
        this.idNotAvailable.add(ris);
        return ris;
    }

    class pluginFileFilter
    implements FilenameFilter {
        pluginFileFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.endsWith(".jar");
        }
    }
}

