/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class EdgedBalloonStyle
extends BalloonTipStyle {
    private final Color borderColor;
    private final Color fillColor;

    public EdgedBalloonStyle(Color fillColor, Color borderColor) {
        this.borderColor = borderColor;
        this.fillColor = fillColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + 1, 1, 1, 1);
        }
        return new Insets(1, 1, this.verticalOffset + 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yBottom;
        int yTop;
        Graphics2D g2d = (Graphics2D)g;
        --width;
        --height;
        if (this.flipY) {
            yTop = y + this.verticalOffset;
            yBottom = y + height;
        } else {
            yTop = y;
            yBottom = y + height - this.verticalOffset;
        }
        GeneralPath outline = new GeneralPath();
        outline.moveTo(x, yTop);
        outline.lineTo(x, yBottom);
        if (!this.flipX && !this.flipY) {
            outline.lineTo(x + this.horizontalOffset, yBottom);
            outline.lineTo(x + this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yBottom);
        } else if (this.flipX && !this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yBottom);
            outline.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset, yBottom);
        }
        outline.lineTo(x + width, yBottom);
        outline.lineTo(x + width, yTop);
        if (!this.flipX && this.flipY) {
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            outline.lineTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset, yTop);
        } else if (this.flipX && this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset, yTop);
            outline.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yTop);
        }
        outline.closePath();
        g2d.setPaint(this.fillColor);
        g2d.fill(outline);
        g2d.setPaint(this.borderColor);
        g2d.draw(outline);
    }
}

