/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.Top;

public class PlainSelect
implements SelectBody {
    private Distinct distinct = null;
    private List selectItems;
    private Table into;
    private FromItem fromItem;
    private List joins;
    private Expression where;
    private List groupByColumnReferences;
    private List orderByElements;
    private Expression having;
    private Limit limit;
    private Top top;

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public Table getInto() {
        return this.into;
    }

    public List getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setInto(Table table) {
        this.into = table;
    }

    public void setSelectItems(List list) {
        this.selectItems = list;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List getJoins() {
        return this.joins;
    }

    public void setJoins(List list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public List getGroupByColumnReferences() {
        return this.groupByColumnReferences;
    }

    public void setGroupByColumnReferences(List list) {
        this.groupByColumnReferences = list;
    }

    public String toString() {
        String sql = "";
        sql = "SELECT ";
        sql = sql + (this.distinct != null ? "" + this.distinct + " " : "");
        sql = sql + (this.top != null ? "" + this.top + " " : "");
        sql = sql + PlainSelect.getStringList(this.selectItems);
        sql = sql + " FROM " + this.fromItem;
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    sql = sql + ", " + join;
                    continue;
                }
                sql = sql + " " + join;
            }
        }
        sql = sql + (this.where != null ? " WHERE " + this.where : "");
        sql = sql + PlainSelect.getFormatedList(this.groupByColumnReferences, "GROUP BY");
        sql = sql + (this.having != null ? " HAVING " + this.having : "");
        sql = sql + PlainSelect.orderByToString(this.orderByElements);
        sql = sql + (this.limit != null ? this.limit + "" : "");
        return sql;
    }

    public static String orderByToString(List orderByElements) {
        return PlainSelect.getFormatedList(orderByElements, "ORDER BY");
    }

    public static String getFormatedList(List list, String expression) {
        return PlainSelect.getFormatedList(list, expression, true, false);
    }

    public static String getFormatedList(List list, String expression, boolean useComma, boolean useBrackets) {
        String sql = PlainSelect.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List list, boolean useComma, boolean useBrackets) {
        String ans = "";
        String comma = ",";
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                ans = ans + "(";
            }
            for (int i = 0; i < list.size(); ++i) {
                ans = ans + "" + list.get(i) + (i < list.size() - 1 ? comma + " " : "");
            }
            if (useBrackets) {
                ans = ans + ")";
            }
        }
        return ans;
    }
}

