/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.demo;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.demo.util.LafMenu;
import org.jdesktop.jxlayer_old.plaf.AbstractLayerUI;

public class FlashButtonDemo {
    private static void createGui() {
        JFrame frame = new JFrame("FlashButtonDemo");
        frame.setJMenuBar(LafMenu.createMenuBar());
        frame.setDefaultCloseOperation(3);
        frame.add((Component)new JLabel("Move mouse over the button", 0), "South");
        JPanel panel = new JPanel(new GridBagLayout());
        JXLayer<JButton> l = new JXLayer<JButton>(new JButton("Hello"));
        panel.add(l);
        l.setSize(200, 200);
        l.setUI(new FlashButtonUI());
        frame.add(panel);
        frame.setSize(250, 200);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlashButtonDemo.createGui();
            }
        });
    }

    public static class FlashButtonUI
    extends AbstractLayerUI<AbstractButton> {
        private Timer timer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlashButtonUI.this.scale > 3.0) {
                    FlashButtonUI.this.timer.stop();
                    FlashButtonUI.this.scale = 1.0;
                } else {
                    FlashButtonUI.this.scale = FlashButtonUI.this.scale + 0.2;
                }
                FlashButtonUI.this.setDirty(true);
            }
        });
        private double scale = 1.0;
        private boolean rollover;

        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends AbstractButton> l) {
            l.paint(g2);
            boolean currRollover = l.getView().getModel().isRollover();
            if (currRollover && !this.rollover && !this.timer.isRunning()) {
                this.timer.start();
            }
            this.rollover = currRollover;
            if (this.timer.isRunning()) {
                g2.transform(this.getCenteredScaleTransform(l));
                g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                l.paint(g2);
            }
        }

        private AffineTransform getCenteredScaleTransform(JComponent c) {
            AffineTransform t = AffineTransform.getScaleInstance(this.scale, this.scale);
            int width = c.getWidth();
            double xt = ((double)width * this.scale - (double)width) / (2.0 * this.scale);
            int height = c.getHeight();
            double yt = ((double)height * this.scale - (double)height) / (2.0 * this.scale);
            t.translate(-xt, -yt);
            return t;
        }
    }
}

