/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.plaf.AbstractLayerUI;

public class MouseDrawingDemo {
    private static void createGui() {
        JFrame frame = new JFrame("MouseDrawingDemo");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        for (int i = 0; i < 3; ++i) {
            panel.add(new JButton("JButton"));
            panel.add(new JCheckBox("JCheckBox"));
            panel.add(new JTextField("JTextField"));
        }
        JXLayer<JPanel> l = new JXLayer<JPanel>(panel);
        final MouseDrawingUI mouseDrawingUI = new MouseDrawingUI();
        l.setUI(mouseDrawingUI);
        frame.add(l);
        JMenuBar bar = new JMenuBar();
        JMenu options = new JMenu("Options");
        JMenuItem clearMenu = new JMenuItem("Clear");
        clearMenu.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        clearMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mouseDrawingUI.clear();
            }
        });
        options.add(clearMenu);
        bar.add(options);
        frame.setJMenuBar(bar);
        frame.setSize(300, 200);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MouseDrawingDemo.createGui();
            }
        });
    }

    public static class MouseDrawingUI<V extends JComponent>
    extends AbstractLayerUI<V> {
        private List<List<Point>> pathList = new ArrayList<List<Point>>();
        private List<Point> currentPath;

        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends V> l) {
            super.paintLayer(g2, l);
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(2.0f));
            for (List<Point> points : this.pathList) {
                Point oldPoint = null;
                for (Point point : points) {
                    if (oldPoint != null) {
                        g2.drawLine(oldPoint.x, oldPoint.y, point.x, point.y);
                    }
                    oldPoint = point;
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends V> l) {
            super.processMouseMotionEvent(e, l);
            if (e.getID() == 506) {
                Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), l);
                if (this.currentPath == null) {
                    this.currentPath = new ArrayList<Point>();
                    this.pathList.add(this.currentPath);
                }
                this.currentPath.add(point);
                this.setDirty(true);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e, JXLayer<? extends V> l) {
            super.processMouseEvent(e, l);
            if (e.getID() == 502) {
                this.currentPath = null;
                this.setDirty(true);
            }
        }

        public void clear() {
            this.pathList.clear();
            this.setDirty(true);
        }
    }
}

