/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.demo;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.demo.util.LafMenu;
import org.jdesktop.jxlayer_old.plaf.ext.MouseScrollableUI;

public class MouseScrollableDemo
extends JFrame {
    private MouseScrollableUI mouseScrollableUI = new MouseScrollableUI();

    public MouseScrollableDemo() {
        super("JXLayer MouseScrollableDemo");
        this.setDefaultCloseOperation(3);
        JMenuBar bar = new JMenuBar();
        bar.add(new LafMenu());
        this.setJMenuBar(bar);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(new JXLayer<JScrollPane>(this.createLeftScrollPane(), this.mouseScrollableUI));
        splitPane.setRightComponent(new JXLayer<JScrollPane>(this.createRightScrollPane(), this.mouseScrollableUI));
        splitPane.setDividerLocation(330);
        this.add(splitPane);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
    }

    private JScrollPane createLeftScrollPane() {
        JPanel panel = new JPanel(new GridLayout(0, 3));
        for (int i = 0; i < 25; ++i) {
            panel.add(new JTextField(8));
            panel.add(new JPanel());
            panel.add(new JCheckBox("JCheckBox"));
            panel.add(new JRadioButton("JRadioButton"));
        }
        return new JScrollPane(panel);
    }

    private JScrollPane createRightScrollPane() {
        JTable table = new JTable(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return 50;
            }

            @Override
            public int getColumnCount() {
                return 20;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return "" + rowIndex + " " + columnIndex;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        table.setAutoResizeMode(0);
        return new JScrollPane(table);
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MouseScrollableDemo().setVisible(true);
            }
        });
    }
}

