/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer_old.plaf;

import java.awt.AWTEvent;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.jxlayer_old.JXLayer;
import org.jdesktop.jxlayer_old.plaf.LayerUI;

public class AbstractLayerUI<V extends JComponent>
extends LayerUI<V> {
    private static final Map<RenderingHints.Key, Object> emptyRenderingHintMap = Collections.unmodifiableMap(new HashMap(0));
    private boolean isDirty;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        ((JXLayer)c).setLayerEventMask(this.getLayerEventMask());
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        ((JXLayer)c).setLayerEventMask(0L);
    }

    @Override
    public void handlePropertyChangeEvent(PropertyChangeEvent evt, JXLayer<? extends V> l) {
        if (!"dirty".equals(evt.getPropertyName()) || evt.getNewValue() == Boolean.TRUE) {
            l.repaint();
        }
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        boolean oldDirty = this.isDirty;
        this.isDirty = isDirty;
        this.firePropertyChange("dirty", oldDirty, isDirty);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            JXLayer l = (JXLayer)c;
            this.configureGraphics(g2, l);
            this.paintLayer(g2, l);
            g2.dispose();
            this.setDirty(false);
        }
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends V> l) {
        l.paint(g2);
    }

    protected void configureGraphics(Graphics2D g2, JXLayer<? extends V> l) {
        Map<RenderingHints.Key, Object> hints;
        AffineTransform transform;
        Shape clip;
        Composite composite = this.getComposite(l);
        if (composite != null) {
            g2.setComposite(composite);
        }
        if ((clip = this.getClip(l)) != null) {
            g2.clip(clip);
        }
        if ((transform = this.getTransform(l)) != null) {
            g2.transform(transform);
        }
        if ((hints = this.getRenderingHints(l)) != null) {
            for (RenderingHints.Key key : hints.keySet()) {
                Object value = hints.get(key);
                if (value == null) continue;
                g2.setRenderingHint(key, hints.get(key));
            }
        }
    }

    protected Composite getComposite(JXLayer<? extends V> l) {
        return null;
    }

    protected AffineTransform getTransform(JXLayer<? extends V> l) {
        return null;
    }

    protected Shape getClip(JXLayer<? extends V> l) {
        return null;
    }

    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<? extends V> l) {
        return emptyRenderingHintMap;
    }

    public long getLayerEventMask() {
        return 131132L;
    }

    @Override
    public void eventDispatched(AWTEvent e, JXLayer<? extends V> l) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e, l);
        } else if (e instanceof MouseEvent) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)e, l);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)e, l);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)e, l);
                }
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e, l);
        }
    }

    protected void processFocusEvent(FocusEvent e, JXLayer<? extends V> l) {
    }

    protected void processMouseEvent(MouseEvent e, JXLayer<? extends V> l) {
    }

    protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends V> l) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent e, JXLayer<? extends V> l) {
    }

    protected void processKeyEvent(KeyEvent e, JXLayer<? extends V> l) {
    }
}

