/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.logtailer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jibble.logtailer.HighlightRule;

public class HighlightRuleDialog
extends JDialog {
    private JTextField _textField;
    private JTextField _colorField;
    private JTextField _ruleField;
    private JCheckBox _bold = new JCheckBox("Highlight in bold");
    private JCheckBox _underlined = new JCheckBox("Underline the text");
    private JCheckBox _filtered = new JCheckBox("Do not display the line");
    private JCheckBox _beep = new JCheckBox("Make a beep sound");
    private JButton _okay = new JButton("Okay");
    private JButton _cancel = new JButton("Cancel");
    private HighlightRule _rule = null;

    public HighlightRuleDialog(Dialog owner, HighlightRule rule) {
        super(owner);
        this._ruleField = new JTextField(rule.getName());
        this._textField = new JTextField(rule.getRegexp());
        this._bold.setSelected(rule.getBold());
        this._underlined.setSelected(rule.getUnderlined());
        this._filtered.setSelected(rule.getFiltered());
        this._beep.setSelected(rule.getBeep());
        this._colorField = new JTextField("#" + Integer.toHexString(rule.getColor().getRGB()).substring(2));
        Container pane = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(12, 1));
        pane.add((Component)panel, "Center");
        panel.add(this._ruleField);
        panel.add(new JLabel("If the line matches this regular expression:"));
        panel.add(this._textField);
        panel.add(new JLabel("then:"));
        panel.add(this._bold);
        panel.add(this._underlined);
        panel.add(this._filtered);
        panel.add(this._beep);
        panel.add(new JLabel("and color the text with:"));
        panel.add(this._colorField);
        panel.add(this._okay);
        panel.add(this._cancel);
        this._okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    HighlightRuleDialog.this._rule = new HighlightRule(HighlightRuleDialog.this._ruleField.getText(), HighlightRuleDialog.this._textField.getText(), HighlightRuleDialog.this._underlined.isSelected(), HighlightRuleDialog.this._bold.isSelected(), HighlightRuleDialog.this._filtered.isSelected(), HighlightRuleDialog.this._beep.isSelected(), Color.decode(HighlightRuleDialog.this._colorField.getText()));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(HighlightRuleDialog.this, "Your regular expression syntax is not valid, please try again.", "Regexp failed", 0);
                    return;
                }
                HighlightRuleDialog.this.dispose();
            }
        });
        this._cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HighlightRuleDialog.this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setTitle("Rule specification");
        this.setModal(true);
        this.setResizable(false);
        this.setVisible(true);
    }

    public HighlightRule getRule() {
        return this._rule;
    }
}

