/*
 * Decompiled with CFR 0.152.
 */
package reports;

import gestioneFatture.main;
import it.tnx.commons.CastUtils;
import it.tnx.commons.SwingUtils;
import java.awt.Component;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import reports.JRDSBase;

public class JRDSBarcode
extends JRDSBase
implements JRDataSource {
    private int conta = 0;
    ArrayList<ArrayList<String>> valori = new ArrayList();
    ArrayList<String> current = new ArrayList();
    String testoLibero = main.fileIni.getValue("barcode", "testo_libero", "");
    boolean articoloSopra = main.fileIni.getValueBoolean("barcode", "articolo_sopra", true);

    public JRDSBarcode(ArrayList<ArrayList> barcode) {
        this.init(barcode, true);
    }

    public JRDSBarcode(ArrayList<ArrayList> barcode, boolean perQuantita) {
        this.init(barcode, perQuantita);
    }

    private void init(ArrayList<ArrayList> barcode, boolean perQuantita) {
        for (int i = 0; i < barcode.size(); ++i) {
            ArrayList riga = barcode.get(i);
            String codiceArti = CastUtils.toString(riga.get(0));
            String codiceBarre = CastUtils.toString(riga.get(1));
            int quantita = CastUtils.toInteger(riga.get(2));
            if (perQuantita) {
                for (int j = 1; j <= quantita; ++j) {
                    ArrayList<String> temp = new ArrayList<String>();
                    temp.add(0, codiceArti);
                    temp.add(1, codiceBarre);
                    this.valori.add(temp);
                }
                continue;
            }
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(0, codiceArti);
            temp.add(1, codiceBarre);
            this.valori.add(temp);
        }
    }

    @Override
    public Object getFieldValue(JRField jRField) throws JRException {
        try {
            if (jRField.getName().equalsIgnoreCase("codice_a_barre")) {
                return this.current.get(1);
            }
            if (jRField.getName().equalsIgnoreCase("codice_articolo")) {
                return this.current.get(0);
            }
            if (jRField.getName().equalsIgnoreCase("testo_libero")) {
                return this.testoLibero;
            }
        }
        catch (Exception e) {
            SwingUtils.showErrorMessage((Component)main.getPadreWindow(), (String)"Impossibile leggere alcuni dei dati", (String)"Errore lettura dati");
        }
        return null;
    }

    public boolean next() throws JRException {
        if (this.conta < this.valori.size()) {
            this.current = this.valori.get(this.conta);
            ++this.conta;
            return true;
        }
        return false;
    }
}

