/*
 * Decompiled with CFR 0.152.
 */
package testsX.detailed;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;

public class BrowserFrame
extends JFrame {
    private boolean isClosed_ = false;
    private CefBrowser browser_ = null;
    private static int browserCount_ = 0;
    private Runnable afterParentChangedAction_ = null;

    public BrowserFrame() {
        this((String)null);
    }

    public BrowserFrame(String title) {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (BrowserFrame.this.browser_ == null) {
                    BrowserFrame.this.isClosed_ = true;
                    System.out.println("BrowserFrame.windowClosing Frame.dispose");
                    BrowserFrame.this.dispose();
                    return;
                }
                boolean isClosed = BrowserFrame.this.isClosed_;
                if (isClosed) {
                    BrowserFrame.this.browser_.setCloseAllowed();
                }
                System.out.println("BrowserFrame.windowClosing CefBrowser.close(" + isClosed + ")");
                BrowserFrame.this.browser_.close(isClosed);
                if (!BrowserFrame.this.isClosed_) {
                    BrowserFrame.this.isClosed_ = true;
                }
                if (isClosed) {
                    System.out.println("BrowserFrame.windowClosing Frame.dispose");
                    BrowserFrame.this.dispose();
                }
            }
        });
    }

    public void setBrowser(CefBrowser browser) {
        if (this.browser_ == null) {
            this.browser_ = browser;
        }
        this.browser_.getClient().removeLifeSpanHandler();
        this.browser_.getClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser browser) {
                System.out.println("BrowserFrame.onAfterCreated id=" + browser.getIdentifier());
                browserCount_++;
            }

            public void onAfterParentChanged(CefBrowser browser) {
                System.out.println("BrowserFrame.onAfterParentChanged id=" + browser.getIdentifier());
                if (BrowserFrame.this.afterParentChangedAction_ != null) {
                    SwingUtilities.invokeLater(BrowserFrame.this.afterParentChangedAction_);
                    BrowserFrame.this.afterParentChangedAction_ = null;
                }
            }

            public boolean doClose(CefBrowser browser) {
                boolean result = browser.doClose();
                System.out.println("BrowserFrame.doClose id=" + browser.getIdentifier() + " CefBrowser.doClose=" + result);
                return result;
            }

            public void onBeforeClose(CefBrowser browser) {
                System.out.println("BrowserFrame.onBeforeClose id=" + browser.getIdentifier());
                if (--browserCount_ == 0) {
                    System.out.println("BrowserFrame.onBeforeClose CefApp.dispose");
                    CefApp.getInstance().dispose();
                }
            }
        });
    }

    public void removeBrowser(Runnable r) {
        System.out.println("BrowserFrame.removeBrowser");
        this.afterParentChangedAction_ = r;
        this.remove(this.browser_.getUIComponent());
        this.browser_.getUIComponent().removeNotify();
        this.browser_ = null;
    }

    public CefBrowser getBrowser() {
        return this.browser_;
    }
}

