/*
 * Decompiled with CFR 0.152.
 */
package testsX.detailed.handler;

import java.awt.Frame;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import testsX.detailed.dialog.CertErrorDialog;
import testsX.detailed.dialog.PasswordDialog;
import testsX.detailed.handler.ResourceHandler;
import testsX.detailed.handler.ResourceSetErrorHandler;

public class RequestHandler
extends CefResourceRequestHandlerAdapter
implements CefRequestHandler {
    private final Frame owner_;

    public RequestHandler(Frame owner) {
        this.owner_ = owner;
    }

    public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
        CefPostData postData = request.getPostData();
        if (postData != null) {
            Vector elements = new Vector();
            postData.getElements(elements);
            for (CefPostDataElement el : elements) {
                String readString;
                byte[] readBytes;
                int numBytes = el.getBytesCount();
                if (numBytes <= 0 || el.getBytes(numBytes, readBytes = new byte[numBytes]) <= 0 || (readString = new String(readBytes)).indexOf("ignore") <= -1) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(RequestHandler.this.owner_, "The request was rejected because you've entered \"ignore\" into the form.");
                    }
                });
                return true;
            }
        }
        return false;
    }

    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
        return this;
    }

    public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request) {
        if (request.getMethod().equalsIgnoreCase("POST") && request.getURL().equals("http://www.google.com/")) {
            String forwardTo = "http://www.google.com/#q=";
            CefPostData postData = request.getPostData();
            boolean sendAsGet = false;
            if (postData != null) {
                Vector elements = new Vector();
                postData.getElements(elements);
                for (CefPostDataElement el : elements) {
                    String[] stringPairs;
                    byte[] readBytes;
                    int numBytes = el.getBytesCount();
                    if (numBytes <= 0 || el.getBytes(numBytes, readBytes = new byte[numBytes]) <= 0) continue;
                    String readString = new String(readBytes).trim();
                    for (String s : stringPairs = readString.split("&")) {
                        int startPos = s.indexOf(61);
                        if (s.startsWith("searchFor")) {
                            forwardTo = forwardTo + s.substring(startPos + 1);
                            continue;
                        }
                        if (!s.startsWith("sendAsGet")) continue;
                        sendAsGet = true;
                    }
                }
                if (sendAsGet) {
                    postData.removeElements();
                }
            }
            if (sendAsGet) {
                request.setFlags(0);
                request.setMethod("GET");
                request.setURL(forwardTo);
                request.setFirstPartyForCookies(forwardTo);
                HashMap headerMap = new HashMap();
                request.getHeaderMap(headerMap);
                headerMap.remove("Content-Type");
                headerMap.remove("Origin");
                request.setHeaderMap(headerMap);
            }
        }
        return false;
    }

    public CefResourceHandler getResourceHandler(CefBrowser browser, CefFrame frame, CefRequest request) {
        if (request.getURL().endsWith("foo.bar/")) {
            return new ResourceHandler();
        }
        if (request.getURL().endsWith("seterror.test/")) {
            return new ResourceSetErrorHandler();
        }
        return null;
    }

    public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        SwingUtilities.invokeLater(new PasswordDialog(this.owner_, callback));
        return true;
    }

    public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefRequestCallback callback) {
        return false;
    }

    public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefRequestCallback callback) {
        SwingUtilities.invokeLater(new CertErrorDialog(this.owner_, cert_error, request_url, callback));
        return true;
    }

    public void onPluginCrashed(CefBrowser browser, String pluginPath) {
        System.out.println("Plugin " + pluginPath + "CRASHED");
    }

    public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
        System.out.println("render process terminated: " + status);
    }
}

